/*
 * Decompiled with CFR 0.152.
 */
package cz.dd4j.agents.monsters;

import cz.dd4j.agents.MonsterAgentBase;
import cz.dd4j.agents.commands.Command;
import cz.dd4j.domain.EElement;
import cz.dd4j.domain.EFeature;
import cz.dd4j.simulation.actions.EAction;
import cz.dd4j.simulation.data.dungeon.Element;
import cz.dd4j.simulation.data.dungeon.elements.places.Room;
import cz.dd4j.utils.astar.AStar;
import cz.dd4j.utils.astar.IAStarHeuristic;
import cz.dd4j.utils.astar.IAStarView;
import cz.dd4j.utils.astar.Path;
import cz.dd4j.utils.astar.graph.INode;
import cz.dd4j.utils.config.AutoConfig;
import cz.dd4j.utils.config.Configurable;

@AutoConfig
public class KillerMonsterAgent
extends MonsterAgentBase {
    @Configurable
    private double movementProbability;

    public Command act() {
        Path path;
        if (this.monster.atRoom.hero != null) {
            return new Command(EAction.ATTACK, (Element)this.monster.atRoom.hero);
        }
        if (this.random.nextDouble() > this.movementProbability) {
            return null;
        }
        AStar astar = new AStar((IAStarHeuristic)new IAStarHeuristic<Room>(){

            public int getEstimate(Room n1, Room n2) {
                return 0;
            }
        });
        Room heroRoom = null;
        for (Room room : this.dungeon.rooms.values()) {
            if (room.hero == null) continue;
            heroRoom = room;
            break;
        }
        if (heroRoom != null && (path = astar.findPath((INode)this.monster.atRoom, (INode)heroRoom, (IAStarView)new IAStarView<Room>(){

            public boolean isOpened(Room node) {
                return !node.feature.isA((EElement)EFeature.TRAP);
            }
        })) != null && path.path.size() > 1) {
            return new Command(EAction.MOVE, (Element)path.path.get(1));
        }
        return null;
    }

    public String toString() {
        return "KillerMonsterAgent[moveProb=" + this.movementProbability + "]";
    }
}

