/*
 * Decompiled with CFR 0.152.
 */
package cz.dd4j.generator;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import cz.dd4j.generator.GeneratorConfig;
import cz.dd4j.loader.LoaderXML;
import cz.dd4j.loader.meta.MetaInfo;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;

public abstract class GeneratorBase<CONFIG extends GeneratorConfig> {
    protected Class classToSave;
    protected CONFIG config;
    protected XStream xstream;

    public GeneratorBase(Class classToSave, CONFIG config) {
        this.classToSave = classToSave;
        this.config = config;
        this.xstream = this.init();
    }

    protected XStream init() {
        XStream xstream = new XStream((HierarchicalStreamDriver)new DomDriver());
        xstream.autodetectAnnotations(true);
        xstream.alias(this.classToSave.getAnnotation(XStreamAlias.class).value(), this.classToSave);
        LoaderXML.registerXStreamExtensions((XStream)xstream);
        return xstream;
    }

    public abstract void generate();

    protected void ensureDirsForFile(File targetFile) {
        if (targetFile.getParentFile() != null) {
            targetFile.getParentFile().mkdirs();
        }
    }

    protected void write(File targetFile, Object data, Class loaderClass) {
        this.ensureDirsForFile(targetFile);
        ((GeneratorConfig)this.config).log.info(this.getClass().getSimpleName() + ".write(): writing file " + targetFile.getAbsolutePath());
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(targetFile);
            this.xstream.toXML(data, (OutputStream)out);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to save data into: " + targetFile.getAbsolutePath());
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception exception) {}
            }
        }
        this.writeLoaderMeta(targetFile, loaderClass);
    }

    protected void writeLoaderMeta(File forFile, Class loaderClass) {
        if (forFile == null) {
            throw new RuntimeException("forFile is NULL");
        }
        if (loaderClass == null) {
            throw new RuntimeException("loaderClass is NULL");
        }
        this.ensureDirsForFile(forFile);
        File targetFile = new File(forFile.getAbsolutePath() + ".meta");
        ((GeneratorConfig)this.config).log.info(this.getClass().getSimpleName() + ".writeLoaderMeta(): writing file " + targetFile.getAbsolutePath());
        MetaInfo info = new MetaInfo();
        info.loaderFQCN = loaderClass.getName();
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(targetFile);
            this.xstream.toXML((Object)info, (OutputStream)out);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to save meta information into: " + targetFile.getAbsolutePath());
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

