/*
 * Decompiled with CFR 0.152.
 */
package cz.dd4j.generator.dungeon;

import cz.dd4j.generator.GeneratorBase;
import cz.dd4j.generator.dungeon.GeneratorUtils;
import cz.dd4j.generator.dungeon.GridCorridorsGeneratorConfig;
import cz.dd4j.loader.dungeon.impl.xml.DungeonLoaderXML;
import cz.dd4j.loader.dungeon.impl.xml.DungeonXML;
import java.io.File;
import java.util.ArrayList;

public class GridCorridorsGenerator
extends GeneratorBase<GridCorridorsGeneratorConfig> {
    public GridCorridorsGenerator(GridCorridorsGeneratorConfig config) {
        super(DungeonXML.class, config);
    }

    @Override
    public void generate() {
        ((GridCorridorsGeneratorConfig)this.config).log.info("GridCorridorsGenerator.generate()");
        for (int i = ((GridCorridorsGeneratorConfig)this.config).roomsCountFrom; i <= ((GridCorridorsGeneratorConfig)this.config).roomsCountTo; ++i) {
            this.generate(i);
        }
        ((GridCorridorsGeneratorConfig)this.config).log.info("GridCorridorsGenerator.generate(): DONE!");
    }

    private void generate(int roomCount) {
        File targetFile = ((GridCorridorsGeneratorConfig)this.config).getTargetFile("/corridors/grid", "Grid" + roomCount + ".xml");
        ((GridCorridorsGeneratorConfig)this.config).log.info("GridCorridorsGenerator.generate(" + roomCount + "): generating...");
        DungeonXML dungeon = new DungeonXML();
        dungeon.corridors = new ArrayList();
        int width = (int)Math.ceil(Math.sqrt(roomCount));
        int height = roomCount % width == 0 ? roomCount / width : roomCount / width + 1;
        int currRoom = 1;
        for (int j = 1; j <= height && currRoom <= roomCount; ++j) {
            for (int i = 1; i <= width && currRoom <= roomCount; ++currRoom, ++i) {
                int roomDown;
                int roomRight;
                int n = roomRight = i == width ? -1 : currRoom + 1;
                if (this.isValidRoom(roomRight, roomCount)) {
                    dungeon.corridors.add(GeneratorUtils.generateCorridor(currRoom, roomRight, GeneratorUtils.roomId((int)currRoom).name + " == [" + i + "," + j + "] -- link RIGHT -- [" + (i + 1) + "," + j + "] == " + GeneratorUtils.roomId((int)roomRight).name));
                }
                if (!this.isValidRoom(roomDown = currRoom + width, roomCount)) continue;
                dungeon.corridors.add(GeneratorUtils.generateCorridor(currRoom, roomDown, GeneratorUtils.roomId((int)currRoom).name + " == [" + i + "," + j + "] -- link DOWN -- [" + i + "," + (j + 1) + "] == " + GeneratorUtils.roomId((int)roomDown).name));
            }
        }
        this.write(targetFile, dungeon, DungeonLoaderXML.class);
    }

    private boolean isValidRoom(int room, int roomCount) {
        return room >= 1 && room <= roomCount;
    }
}

