/*
 * Decompiled with CFR 0.152.
 */
package cz.dd4j.generator.dungeon;

import cz.dd4j.generator.GeneratorBase;
import cz.dd4j.generator.dungeon.GeneratorUtils;
import cz.dd4j.generator.dungeon.RoomsGeneratorConfig;
import cz.dd4j.loader.dungeon.impl.xml.DungeonLoaderXML;
import cz.dd4j.loader.dungeon.impl.xml.DungeonXML;
import java.io.File;
import java.util.ArrayList;

public class RoomsGenerator
extends GeneratorBase<RoomsGeneratorConfig> {
    public RoomsGenerator(RoomsGeneratorConfig config) {
        super(DungeonXML.class, config);
    }

    @Override
    public void generate() {
        ((RoomsGeneratorConfig)this.config).log.info("RoomsGenerator.generate()");
        for (int i = ((RoomsGeneratorConfig)this.config).roomsCountFrom; i <= ((RoomsGeneratorConfig)this.config).roomsCountTo; ++i) {
            this.generate(i);
        }
        ((RoomsGeneratorConfig)this.config).log.info("RoomsGenerator.generate(): DONE!");
    }

    private void generate(int roomCount) {
        File targetFile = ((RoomsGeneratorConfig)this.config).getTargetFile("/rooms", "Rooms" + roomCount + ".xml");
        ((RoomsGeneratorConfig)this.config).log.info("RoomsGenerator.generate(" + roomCount + "): generating...");
        DungeonXML dungeon = new DungeonXML();
        dungeon.rooms = new ArrayList(roomCount);
        for (int i = 1; i <= roomCount; ++i) {
            dungeon.rooms.add(GeneratorUtils.generateRoom(i));
        }
        this.write(targetFile, dungeon, DungeonLoaderXML.class);
    }
}

