/*
 * Decompiled with CFR 0.152.
 */
package cz.dd4j.loader.dungeon.impl.xml;

import cz.cuni.amis.utils.eh4j.shortcut.EH;
import cz.dd4j.domain.EDungeonLabel;
import cz.dd4j.domain.EEntity;
import cz.dd4j.domain.EFeature;
import cz.dd4j.loader.LoaderXML;
import cz.dd4j.loader.dungeon.IDungeonLoaderImpl;
import cz.dd4j.loader.dungeon.impl.xml.CorridorXML;
import cz.dd4j.loader.dungeon.impl.xml.DungeonXML;
import cz.dd4j.loader.dungeon.impl.xml.ItemXML;
import cz.dd4j.loader.dungeon.impl.xml.MonsterXML;
import cz.dd4j.loader.dungeon.impl.xml.RoomXML;
import cz.dd4j.simulation.data.dungeon.Dungeon;
import cz.dd4j.simulation.data.dungeon.elements.entities.Feature;
import cz.dd4j.simulation.data.dungeon.elements.entities.Hero;
import cz.dd4j.simulation.data.dungeon.elements.entities.Monster;
import cz.dd4j.simulation.data.dungeon.elements.entities.features.Trap;
import cz.dd4j.simulation.data.dungeon.elements.items.Item;
import cz.dd4j.simulation.data.dungeon.elements.places.Corridor;
import cz.dd4j.simulation.data.dungeon.elements.places.Room;
import cz.dd4j.utils.Id;
import cz.dd4j.utils.config.ConfigXML;
import java.io.File;
import java.util.HashMap;

public class DungeonLoaderXML
extends LoaderXML<DungeonXML>
implements IDungeonLoaderImpl {
    public DungeonLoaderXML() {
        super(DungeonXML.class);
    }

    public Dungeon loadDungeon(File xmlFile) {
        DungeonXML dungeonXML = (DungeonXML)this.load(xmlFile);
        return this.loadDungeon(dungeonXML);
    }

    public Dungeon loadDungeon(DungeonXML dungeonXML) {
        Dungeon result = new Dungeon();
        result.rooms = new HashMap();
        if (dungeonXML.rooms != null) {
            for (RoomXML room : dungeonXML.rooms) {
                this.createRoom(result, room);
            }
        }
        if (dungeonXML.corridors != null) {
            for (CorridorXML corridor : dungeonXML.corridors) {
                this.createCorridor(result, corridor);
            }
        }
        if (dungeonXML.labels != null) {
            for (ConfigXML config : dungeonXML.labels) {
                EDungeonLabel label = (EDungeonLabel)EH.getAsForName((String)config.key, EDungeonLabel.class);
                if (label == null) {
                    throw new RuntimeException("Invalid EDungeonLabel id '" + config.key + "', misspelling? See EDungeonLabel entries.");
                }
                result.labels.put((Object)config.key, (Object)config.value);
            }
        }
        return result;
    }

    protected Room createEmptyRoom(Dungeon dungeon, Id roomId) {
        Room result = new Room();
        result.id = roomId;
        dungeon.rooms.put(result.id, result);
        return result;
    }

    protected void createRoom(Dungeon dungeon, RoomXML room) {
        Room result = new Room();
        result.id = room.id;
        result.label = room.label;
        result.feature = this.createFeatureInRoom(room);
        result.hero = this.createHeroInRoom(room);
        result.item = this.createItemInRoom(room);
        result.monster = this.createMonsterInRoom(room);
        dungeon.rooms.put(result.id, result);
    }

    private Monster createMonsterInRoom(RoomXML room) {
        if (room.monster == null) {
            return null;
        }
        Monster result = this.createMonster(room.monster);
        return result;
    }

    private Monster createMonster(MonsterXML monster) {
        if (monster.type == null) {
            return null;
        }
        if (monster.type == EEntity.MONSTER) {
            Monster result = new Monster();
            result.id = monster.id;
            result.name = monster.name;
            return result;
        }
        throw new RuntimeException("Unhandled monster type: " + monster.type);
    }

    private Item createItemInRoom(RoomXML room) {
        if (room.item == null) {
            return null;
        }
        Item result = this.createItem(room.item);
        return result;
    }

    private Item createItem(ItemXML item) {
        if (item.type == null) {
            return null;
        }
        Item result = new Item(item.type);
        result.id = item.id;
        result.name = item.name;
        return result;
    }

    private Hero createHeroInRoom(RoomXML room) {
        if (room.hero == null) {
            return null;
        }
        Hero result = new Hero();
        result.id = room.hero.id;
        result.name = room.hero.name;
        if (room.hero.inventory != null) {
            for (ItemXML inventory : room.hero.inventory) {
                Item item = this.createItem(inventory);
                if (item == null) continue;
                result.inventory.add(item);
            }
        }
        if (room.hero.hand != null) {
            result.hand = this.createItem(room.hero.hand);
        }
        return result;
    }

    private Feature createFeatureInRoom(RoomXML room) {
        if (room.feature == null) {
            return null;
        }
        if (room.feature.type == EFeature.TRAP) {
            Trap trap = new Trap();
            trap.id = room.feature.id;
            trap.name = room.feature.name;
            return trap;
        }
        throw new RuntimeException("Unhandled Room[id=" + room.id + "] feature: " + room.feature);
    }

    protected void createCorridor(Dungeon dungeon, CorridorXML corridor) {
        Room room2;
        Room room1 = (Room)dungeon.rooms.get(corridor.room1Id);
        if (room1 == null) {
            room1 = this.createEmptyRoom(dungeon, corridor.room1Id);
        }
        if ((room2 = (Room)dungeon.rooms.get(corridor.room2Id)) == null) {
            room2 = this.createEmptyRoom(dungeon, corridor.room2Id);
        }
        Corridor result = new Corridor(room1, room2);
        room1.corridors.add(result);
        room2.corridors.add(result);
    }
}

