/*
 * Decompiled with CFR 0.152.
 */
package cz.dd4j.loader.dungeon.impl.xml.graph;

import cz.dd4j.loader.dungeon.impl.xml.CorridorXML;
import cz.dd4j.loader.dungeon.impl.xml.RoomXML;
import cz.dd4j.utils.Id;
import cz.dd4j.utils.astar.graph.ILink;
import cz.dd4j.utils.astar.graph.INode;
import cz.dd4j.utils.astar.graph.Link;
import cz.dd4j.utils.astar.graph.LinkType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DungeonXMLGraphAdapter {
    private Map<Id, RoomXMLNode> rooms = new HashMap<Id, RoomXMLNode>();

    public DungeonXMLGraphAdapter(List<RoomXML> rooms, List<CorridorXML> corridors) {
        for (RoomXML room : rooms) {
            this.rooms.put(room.id, new RoomXMLNode(room));
        }
        for (CorridorXML corridor : corridors) {
            if (!rooms.contains(corridor.room1Id)) {
                throw new RuntimeException("Invalid dungeon, data contains corridor that is referencing non-existing room: " + corridor.room1Id);
            }
            if (!rooms.contains(corridor.room2Id)) {
                throw new RuntimeException("Invalid dungeon, data contains corridor that is referencing non-existing room: " + corridor.room2Id);
            }
            RoomXMLNode n1 = this.rooms.get(corridor.room1Id);
            RoomXMLNode n2 = this.rooms.get(corridor.room2Id);
            Link link = new Link((Object)n1, (Object)n2, LinkType.BOTH_WAYS, 1);
            n1.links.add((ILink<RoomXMLNode>)link);
            n2.links.add((ILink<RoomXMLNode>)link);
        }
    }

    public RoomXMLNode getRoom(String id) {
        return this.rooms.get(Id.get((String)id));
    }

    public RoomXMLNode getRoom(Id id) {
        return this.rooms.get(id);
    }

    public RoomXMLNode getRoom(RoomXML room) {
        return this.rooms.get(room.id);
    }

    private static class RoomXMLNode
    implements INode<RoomXMLNode> {
        public List<ILink<RoomXMLNode>> links = new ArrayList<ILink<RoomXMLNode>>();
        public RoomXML room;

        public RoomXMLNode(RoomXML room) {
            this.room = room;
        }

        public Collection<ILink<RoomXMLNode>> getLinks() {
            return this.links;
        }
    }
}

