/*
 * Decompiled with CFR 0.152.
 */
package cz.dd4j.loader.simstate.impl.xml;

import cz.dd4j.agents.IFeatureAgent;
import cz.dd4j.agents.IMonsterAgent;
import cz.dd4j.loader.LoaderXML;
import cz.dd4j.loader.agents.AgentsLoader;
import cz.dd4j.loader.dungeon.DungeonLoader;
import cz.dd4j.loader.simstate.ISimStateLoaderImpl;
import cz.dd4j.loader.simstate.impl.xml.FileXML;
import cz.dd4j.loader.simstate.impl.xml.SimStateXML;
import cz.dd4j.simulation.data.agents.AgentMindBody;
import cz.dd4j.simulation.data.agents.Agents;
import cz.dd4j.simulation.data.dungeon.Dungeon;
import cz.dd4j.simulation.data.dungeon.elements.entities.Feature;
import cz.dd4j.simulation.data.dungeon.elements.entities.Hero;
import cz.dd4j.simulation.data.dungeon.elements.entities.Monster;
import cz.dd4j.simulation.data.dungeon.elements.items.Item;
import cz.dd4j.simulation.data.dungeon.elements.places.Corridor;
import cz.dd4j.simulation.data.dungeon.elements.places.Room;
import cz.dd4j.simulation.data.state.SimState;
import cz.dd4j.utils.Const;
import cz.dd4j.utils.Id;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class SimStateLoaderXML
extends LoaderXML<SimStateXML>
implements ISimStateLoaderImpl {
    public SimStateLoaderXML() {
        super(SimStateXML.class);
    }

    public SimState loadSimState(File xmlFile, boolean loadAgents) {
        SimStateXML simStateXML = (SimStateXML)this.load(xmlFile);
        if (simStateXML.dungeons.size() == 0) {
            throw new RuntimeException("SimState does not contain any dungeon definition! File: " + xmlFile.getAbsolutePath());
        }
        return this.loadSimState(new File(xmlFile.getParent()), simStateXML, loadAgents);
    }

    public SimState loadSimState(File xmlFileDir, SimStateXML simStateXML, boolean loadAgents) {
        ArrayList<File> dungeonXMLFiles = new ArrayList<File>(simStateXML.dungeons == null ? 0 : simStateXML.dungeons.size());
        ArrayList<File> agentsXMLFiles = new ArrayList<File>(simStateXML.agents == null ? 0 : simStateXML.agents.size());
        if (simStateXML.dungeons != null) {
            for (FileXML dungeon : simStateXML.dungeons) {
                dungeonXMLFiles.add(new File(xmlFileDir, dungeon.path));
            }
        }
        if (loadAgents && simStateXML.agents != null) {
            for (FileXML agents : simStateXML.agents) {
                agentsXMLFiles.add(new File(xmlFileDir, agents.path));
            }
        }
        return this.loadSimState(dungeonXMLFiles, agentsXMLFiles, loadAgents);
    }

    public SimState loadSimState(List<File> dungeonXMLFiles, List<File> agentsXMLFiles, boolean loadAgents) {
        Dungeon dungeon = new Dungeon();
        Agents monsters = new Agents();
        Agents features = new Agents();
        DungeonLoader dungeonLoader = new DungeonLoader();
        for (File dungeonXMLFile : dungeonXMLFiles) {
            Dungeon append = null;
            try {
                append = dungeonLoader.loadDungeon(dungeonXMLFile.getCanonicalFile());
            }
            catch (Exception e) {
                File cf = null;
                try {
                    cf = dungeonXMLFile.getCanonicalFile();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
                throw new RuntimeException("Failed to load: " + dungeonXMLFile.getAbsolutePath() + Const.NEW_LINE + "Canonical path: " + (cf == null ? "null" : cf.getAbsolutePath()), e);
            }
            try {
                SimStateLoaderXML.blend(dungeon, append);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to blend: " + dungeonXMLFile.getAbsolutePath(), e);
            }
        }
        AgentsLoader agentsLoader = new AgentsLoader();
        for (File agentsXMLFile : agentsXMLFiles) {
            Agents append = null;
            try {
                append = agentsLoader.loadAgents(agentsXMLFile.getCanonicalFile());
            }
            catch (Exception e) {
                File cf = null;
                try {
                    cf = agentsXMLFile.getCanonicalFile();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
                throw new RuntimeException("Failed to load: " + agentsXMLFile.getAbsolutePath() + Const.NEW_LINE + "Canonical path: " + (cf == null ? "null" : cf.getAbsolutePath()), e);
            }
            try {
                SimStateLoaderXML.blend((Agents<IMonsterAgent>)monsters, (Agents<IFeatureAgent>)features, append);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to blend: " + agentsXMLFile.getAbsolutePath(), e);
            }
        }
        SimState state = new SimState();
        state.dungeon = dungeon;
        for (Room room : state.dungeon.rooms.values()) {
            if (room.hero != null) {
                if (state.heroes.containsKey(room.hero.id)) {
                    throw new RuntimeException("There are more than one Hero[id=" + room.hero.id + "] within the state!");
                }
                AgentMindBody hero = new AgentMindBody();
                hero.body = room.hero;
                ((Hero)hero.body).atRoom = room;
                state.heroes.put(((Hero)hero.body).id, hero);
            }
            if (room.monster != null) {
                if (state.monsters.containsKey(room.monster.id)) {
                    throw new RuntimeException("There are more than one Monster[id=" + room.monster.id + "] within the state!");
                }
                AgentMindBody monster = new AgentMindBody();
                monster.body = room.monster;
                ((Monster)monster.body).atRoom = room;
                monster.mind = (IMonsterAgent)monsters.agents.get(((Monster)monster.body).id);
                if (loadAgents && monster.mind == null) {
                    throw new RuntimeException("Monster agent not specified for the Monster[id=" + ((Monster)monster.body).id + "].");
                }
                state.monsters.put(((Monster)monster.body).id, monster);
            }
            if (room.feature == null) continue;
            if (state.features.containsKey(room.feature.id)) {
                throw new RuntimeException("There are more than one Feature[id=" + room.feature.id + "] within the state!");
            }
            AgentMindBody feature = new AgentMindBody();
            feature.body = room.feature;
            ((Feature)feature.body).atRoom = room;
            feature.mind = (IFeatureAgent)features.agents.get(((Feature)feature.body).id);
            if (loadAgents && feature.mind == null) {
                throw new RuntimeException("Feature agent not specified for the Feature[id=" + ((Feature)feature.body).id + "].");
            }
            state.features.put(((Feature)feature.body).id, feature);
        }
        return state;
    }

    public static void blend(Dungeon target, Dungeon append) {
        for (Map.Entry entry : append.rooms.entrySet()) {
            Room targetRoom = (Room)target.rooms.get(entry.getKey());
            if (targetRoom == null) {
                target.rooms.put((Id)entry.getKey(), (Room)entry.getValue());
                continue;
            }
            SimStateLoaderXML.blend(target, targetRoom, (Room)entry.getValue());
        }
        for (Map.Entry entry : append.labels.entrySet()) {
            target.labels.put((Object)((String)entry.getKey()), entry.getValue());
        }
    }

    private static void blend(Dungeon dungeon, Room targetRoom, Room append) {
        if (append.corridors != null) {
            for (Corridor corridor : append.corridors) {
                SimStateLoaderXML.blend(dungeon, corridor);
            }
        }
        if (append.label != null) {
            targetRoom.label = append.label;
        }
        if (targetRoom.monster == null) {
            targetRoom.monster = append.monster;
        } else if (append.monster != null) {
            SimStateLoaderXML.blend(targetRoom.monster, append.monster);
        }
        if (targetRoom.feature == null) {
            targetRoom.feature = append.feature;
        } else if (append.feature != null) {
            SimStateLoaderXML.blend(targetRoom.feature, append.feature);
        }
        if (targetRoom.hero == null) {
            targetRoom.hero = append.hero;
        } else if (append.hero != null) {
            SimStateLoaderXML.blend(targetRoom.hero, append.hero);
        }
        if (targetRoom.item == null) {
            targetRoom.item = append.item;
        } else if (append.item != null) {
            SimStateLoaderXML.blend(targetRoom.item, append.item);
        }
    }

    private static void blend(Dungeon targetDungeon, Corridor corridor) {
        Room targetRoom1 = (Room)targetDungeon.rooms.get(corridor.room1.id);
        Room targetRoom2 = (Room)targetDungeon.rooms.get(corridor.room2.id);
        corridor.room1 = targetRoom1;
        corridor.room2 = targetRoom2;
        if (targetRoom1.corridors == null) {
            targetRoom1.corridors = new ArrayList();
        }
        boolean add = true;
        for (Corridor other : targetRoom1.corridors) {
            if (!other.equals((Object)corridor)) continue;
            add = false;
            break;
        }
        if (add) {
            targetRoom1.corridors.add(corridor);
        }
        if (targetRoom2.corridors == null) {
            targetRoom2.corridors = new ArrayList();
        }
        add = true;
        for (Corridor other : targetRoom2.corridors) {
            if (!other.equals((Object)corridor)) continue;
            add = false;
            break;
        }
        if (add) {
            targetRoom2.corridors.add(corridor);
        }
    }

    private static void blend(Item target, Item append) {
        if (append.type != null) {
            throw new RuntimeException("Cannot overwrite existing item! " + target + " <- " + append);
        }
    }

    private static void blend(Hero target, Hero append) {
        if (target.hand == null) {
            target.hand = append.hand;
        } else if (append.hand != null) {
            SimStateLoaderXML.blend(target.hand, append.hand);
        }
        for (Map.Entry entry : append.inventory.getData().entrySet()) {
            Item targetItem = target.inventory.get((Id)entry.getKey());
            if (targetItem == null) {
                target.inventory.add((Item)entry.getValue());
                continue;
            }
            if (entry.getValue() == null) continue;
            SimStateLoaderXML.blend(targetItem, (Item)entry.getValue());
        }
    }

    private static void blend(Feature target, Feature append) {
    }

    private static void blend(Monster target, Monster append) {
    }

    public static void blend(Agents<IMonsterAgent> monsters, Agents<IFeatureAgent> features, Agents append) {
        for (Map.Entry entryObj : append.agents.entrySet()) {
            Map.Entry entry = entryObj;
            if (entry.getValue() instanceof IMonsterAgent) {
                monsters.agents.put((Id)entry.getKey(), (IMonsterAgent)entry.getValue());
            }
            if (!(entry.getValue() instanceof IFeatureAgent)) continue;
            features.agents.put((Id)entry.getKey(), (IFeatureAgent)entry.getValue());
        }
    }
}

