/*
 * Decompiled with CFR 0.152.
 */
package cz.dd4j.ui.gui;

import cz.cuni.amis.clear2d.Clear2D;
import cz.cuni.amis.clear2d.engine.tween.pos.TweenPos;
import cz.dd4j.agents.commands.Command;
import cz.dd4j.domain.EElement;
import cz.dd4j.domain.EEntity;
import cz.dd4j.domain.EFeature;
import cz.dd4j.domain.EPlace;
import cz.dd4j.simulation.SimStaticStats;
import cz.dd4j.simulation.actions.EAction;
import cz.dd4j.simulation.data.agents.AgentMindBody;
import cz.dd4j.simulation.data.dungeon.Element;
import cz.dd4j.simulation.data.dungeon.elements.entities.Feature;
import cz.dd4j.simulation.data.dungeon.elements.entities.Hero;
import cz.dd4j.simulation.data.dungeon.elements.entities.Monster;
import cz.dd4j.simulation.data.dungeon.elements.entities.features.Trap;
import cz.dd4j.simulation.data.state.SimState;
import cz.dd4j.simulation.events.ISimEvents;
import cz.dd4j.simulation.result.SimResult;
import cz.dd4j.ui.gui.DD4JVis;
import cz.dd4j.ui.gui.c2d.Ctx;
import cz.dd4j.ui.gui.utils.BusyWait;
import cz.dd4j.ui.gui.utils.IWaiting;
import cz.dd4j.ui.gui.view.HeroView;
import cz.dd4j.ui.gui.view.MonsterView;
import cz.dd4j.ui.gui.view.RoomView;
import cz.dd4j.ui.gui.view.TrapView;
import cz.dd4j.utils.Const;
import cz.dd4j.utils.ExceptionToString;
import java.io.PrintStream;

public class VisGUI
implements ISimEvents {
    public final String WHO_SIMULATOR = "Simulator";
    protected final PrintStream out;
    protected long frameNumber;
    protected int frameLength = 3;
    protected int whoLength = 9;
    protected int whatLength = 15;
    public String outputPrefix = "";
    protected DD4JVis vis;
    protected boolean autoCloseOnSimulationEnd = true;

    public VisGUI() {
        this(true);
    }

    public VisGUI(boolean autoCloseOnSimulationEnd) {
        this.out = null;
        this.autoCloseOnSimulationEnd = true;
    }

    public VisGUI(PrintStream out) {
        this.out = out;
    }

    protected void log(String who, String what, String description) {
        if ((double)this.frameNumber > Math.pow(10.0, this.frameLength)) {
            this.frameLength = (int)Math.ceil(Math.log10(this.frameNumber));
        }
        if (who.length() > this.whoLength) {
            this.whoLength = who.length();
        }
        if (what.length() > this.whatLength) {
            this.whatLength = what.length();
        }
        String msg = String.format(String.valueOf(this.outputPrefix) + "[%" + this.frameLength + "d] {%" + this.whoLength + "s} (%" + this.whatLength + "s) %s", this.frameNumber, who, what, description);
        if (this.out != null) {
            this.out.printf(msg, new Object[0]);
            this.out.println();
        }
        this.vis.frame.log(msg);
    }

    protected void initFrame(SimState state, SimStaticStats stats) {
        if (Ctx.engine == null) {
            Ctx.init();
        }
        if (this.vis != null) {
            this.vis.die();
        }
        this.vis = new DD4JVis(state, stats);
        this.vis.frame.setVisible(true);
    }

    public void simulationBegin(SimState state, SimStaticStats stats) {
        this.frameNumber = 0L;
        this.initFrame(state, stats);
        this.log("Simulator", "SimBegin", "Simulation begins.");
        this.log("Simulator", "SimBegin", "ID:   " + state.config.id);
        this.log("Simulator", "SimBegin", "DESC: " + state.config.description);
    }

    public void simulationFrameBegin(SimState state, SimStaticStats stats) {
        this.frameNumber = stats.frameNumber;
        this.log("Simulator", "SimFrameBegin", "Simulation frame " + this.frameNumber + " begun, sim time " + stats.simMillis() + "ms.");
        for (AgentMindBody agent : state.heroes.values()) {
            if (!((Hero)agent.body).alive) continue;
            this.log("Simulator", "SimFrameBegin", "  +-- HERO    at " + ((Hero)agent.body).atRoom + (((Hero)agent.body).hand != null ? " with " + ((Hero)agent.body).hand : "") + ": " + agent.mind + ", " + agent.body);
        }
        for (AgentMindBody agent : state.monsters.values()) {
            if (!((Monster)agent.body).alive) continue;
            this.log("Simulator", "SimFrameBegin", "  +-- MONSTER at " + ((Monster)agent.body).atRoom + ": " + agent.mind + ", " + agent.body);
        }
        for (AgentMindBody agent : state.features.values()) {
            if (!((Feature)agent.body).alive) continue;
            this.log("Simulator", "SimFrameBegin", "  +-- FEATURE at " + ((Feature)agent.body).atRoom + ": " + agent.mind + ", " + agent.body);
        }
    }

    public String getName(Element who) {
        String result = who.getDescription();
        if (result != null) {
            return result;
        }
        if (who.name == null) {
            return String.valueOf(who.getClass().getSimpleName()) + "-" + who.id;
        }
        return String.valueOf(who.name) + "-" + who.id;
    }

    protected void actionPerforming(String state, Element who, Command what) {
        String description = "";
        description = what != null ? String.valueOf(description) + what : "NO-ACTION";
        this.log(this.getName(who), state, description);
    }

    public void actionSelected(Element who, Command what) {
        if (what == null) {
            return;
        }
        this.actionPerforming("ACTION-SELECTED", who, what);
    }

    public void actionStarted(Element who, Command what) {
        this.actionPerforming("ACTION-STARTED", who, what);
    }

    public void actionEnded(Element who, final Command what) {
        this.actionPerforming("ACTION-ENDED", who, what);
        if (what.isType(EAction.MOVE)) {
            if (who.isA((EElement)EEntity.HERO)) {
                final Hero heroBody = (Hero)((AgentMindBody)this.vis.simState.heroes.values().iterator().next()).body;
                final HeroView heroView = this.vis.heroViews.get(heroBody);
                if (what.target.isA((EElement)EPlace.CORRIDOR)) {
                    new BusyWait(new IWaiting(){

                        @Override
                        public boolean isWaiting() {
                            return heroView.movementCtrl.currentCorridor != what.target;
                        }
                    }).busyWait();
                } else if (what.target.isA(EPlace.PLACE)) {
                    new BusyWait(new IWaiting(){

                        @Override
                        public boolean isWaiting() {
                            return heroView.movementCtrl.currentRoom != what.target && heroView.movementCtrl.currentCorridor != heroBody.atCorridor;
                        }
                    }).busyWait();
                }
            } else if (who.isA((EElement)EEntity.MONSTER)) {
                final Monster monsterBody = (Monster)((AgentMindBody)this.vis.simState.monsters.values().iterator().next()).body;
                final MonsterView monsterView = this.vis.monsterViews.get(monsterBody);
                if (what.target.isA((EElement)EPlace.CORRIDOR)) {
                    new BusyWait(new IWaiting(){

                        @Override
                        public boolean isWaiting() {
                            return monsterView.movementCtrl.currentCorridor != what.target;
                        }
                    }).busyWait();
                } else if (what.target.isA(EPlace.PLACE)) {
                    new BusyWait(new IWaiting(){

                        @Override
                        public boolean isWaiting() {
                            return monsterView.movementCtrl.currentRoom != what.target && monsterView.movementCtrl.currentCorridor != monsterBody.atCorridor;
                        }
                    }).busyWait();
                }
            }
        } else if (what.isType(EAction.ATTACK)) {
            if (who.isA((EElement)EEntity.HERO)) {
                Hero heroBody = (Hero)((AgentMindBody)this.vis.simState.heroes.values().iterator().next()).body;
                HeroView heroView = this.vis.heroViews.get(heroBody);
                Monster monsterBody = (Monster)((AgentMindBody)this.vis.simState.monsters.get((Object)what.target.id)).body;
                MonsterView monsterView = this.vis.monsterViews.get(monsterBody);
                final TweenPos tween = heroView.attack(monsterView);
                new BusyWait(new IWaiting(){

                    @Override
                    public boolean isWaiting() {
                        return tween.isTweening();
                    }
                }).busyWait();
            } else if (who.isA((EElement)EEntity.MONSTER)) {
                Hero heroBody = (Hero)((AgentMindBody)this.vis.simState.heroes.values().iterator().next()).body;
                HeroView heroView = this.vis.heroViews.get(heroBody);
                Monster monsterBody = (Monster)((AgentMindBody)this.vis.simState.monsters.get((Object)who.id)).body;
                MonsterView monsterView = this.vis.monsterViews.get(monsterBody);
                final TweenPos tween = monsterView.attack(heroView);
                new BusyWait(new IWaiting(){

                    @Override
                    public boolean isWaiting() {
                        return tween.isTweening();
                    }
                }).busyWait();
            } else if (who.isA((EElement)EFeature.TRAP)) {
                Trap trapBody = (Trap)((AgentMindBody)this.vis.simState.features.get((Object)who.id)).body;
                RoomView roomView = this.vis.roomsView.getRoomView(trapBody.atRoom);
                TrapView trapView = roomView.trap;
                if (what.target.isA((EElement)EEntity.HERO)) {
                    Hero heroBody = (Hero)((AgentMindBody)this.vis.simState.heroes.values().iterator().next()).body;
                    HeroView heroView = this.vis.heroViews.get(heroBody);
                    final TweenPos tween = trapView.attack(heroView);
                    new BusyWait(new IWaiting(){

                        @Override
                        public boolean isWaiting() {
                            return tween.isTweening();
                        }
                    }).busyWait();
                } else if (what.target.isA((EElement)EEntity.MONSTER)) {
                    Monster monsterBody = (Monster)((AgentMindBody)this.vis.simState.monsters.get((Object)what.target.id)).body;
                    MonsterView monsterView = this.vis.monsterViews.get(monsterBody);
                    final TweenPos tween = trapView.attack(monsterView);
                    new BusyWait(new IWaiting(){

                        @Override
                        public boolean isWaiting() {
                            return tween.isTweening();
                        }
                    }).busyWait();
                }
            }
        } else if (what.isType(EAction.DROP)) {
            Hero heroBody = (Hero)((AgentMindBody)this.vis.simState.heroes.values().iterator().next()).body;
            HeroView heroView = this.vis.heroViews.get(heroBody);
            RoomView roomView = this.vis.roomsView.getRoomView(heroBody.atRoom);
            final TweenPos tween = heroView.dropSword(roomView);
            new BusyWait(new IWaiting(){

                @Override
                public boolean isWaiting() {
                    return tween.isTweening();
                }
            }).busyWait();
        } else if (what.isType(EAction.PICKUP)) {
            Hero heroBody = (Hero)((AgentMindBody)this.vis.simState.heroes.values().iterator().next()).body;
            HeroView heroView = this.vis.heroViews.get(heroBody);
            RoomView roomView = this.vis.roomsView.getRoomView(heroBody.atRoom);
            final TweenPos tween = heroView.pickupSword(roomView);
            new BusyWait(new IWaiting(){

                @Override
                public boolean isWaiting() {
                    return tween.isTweening();
                }
            }).busyWait();
        } else if (what.isType(EAction.DISARM)) {
            Hero heroBody = (Hero)((AgentMindBody)this.vis.simState.heroes.values().iterator().next()).body;
            HeroView heroView = this.vis.heroViews.get(heroBody);
            RoomView roomView = this.vis.roomsView.getRoomView(heroBody.atRoom);
            final TweenPos tween = heroView.attackTrap(roomView);
            new BusyWait(new IWaiting(){

                @Override
                public boolean isWaiting() {
                    return tween.isTweening();
                }
            }).busyWait();
        }
    }

    public void actionInvalid(Element who, Command what) {
        this.actionPerforming("ACTION-INVALID", who, what);
    }

    public void elementCreated(Element element) {
        this.log(this.getName(element), "CREATED", "");
    }

    public void elementDead(Element element) {
        this.log(this.getName(element), "DESTROYED", "");
    }

    public void simulationFrameEnd(SimStaticStats stats) {
        this.log("Simulator", "SimFrameEnd", "Simulation frame " + stats.frameNumber + " ended.");
    }

    public void simulationEnd(SimResult result, SimStaticStats stats) {
        this.log("Simulator", "SimEnd", "Simulation ended in frame " + result.frameNumber + ", time " + result.simTimeMillis + "ms.");
        this.log("Simulator", "SimEndResult", this.getResultDescription(result));
        if (this.autoCloseOnSimulationEnd) {
            this.vis.die();
            Clear2D.engine.stop();
        }
    }

    private String getResultDescription(SimResult result) {
        switch (result.resultType) {
            case AGENT_EXCEPTION: {
                return result.resultType + "[Agent code exception.]" + Const.NEW_LINE + ExceptionToString.process((Throwable)result.exception);
            }
            case HERO_WIN: {
                return result.resultType + "[" + this.getName((Element)result.winner.body) + "]";
            }
            case HEROES_LOSE: {
                return result.resultType + "[All heroes are dead.]";
            }
            case SIMULATION_EXCEPTION: {
                return result.resultType + "[Simulation code exception.]";
            }
        }
        return result.resultType + "[UNKNOWN RESULT]";
    }
}

