/*
 * Decompiled with CFR 0.152.
 */
package cz.dd4j.ui.gui.view;

import cz.cuni.amis.clear2d.engine.iface.IDrawable;
import cz.cuni.amis.clear2d.engine.prefabs.Entity;
import cz.cuni.amis.clear2d.engine.textures.Texture;
import cz.cuni.amis.clear2d.engine.time.C2DTime;
import cz.cuni.amis.clear2d.engine.tween.TweenEase;
import cz.cuni.amis.clear2d.engine.tween.pos.ITweenPosCallback;
import cz.cuni.amis.clear2d.engine.tween.pos.TweenPos;
import cz.cuni.amis.clear2d.engine.tween.pos.TweenPosType;
import cz.dd4j.agents.IMonsterAgent;
import cz.dd4j.simulation.data.agents.AgentMindBody;
import cz.dd4j.simulation.data.dungeon.elements.entities.Monster;
import cz.dd4j.ui.gui.c2d.Ctx;
import cz.dd4j.ui.gui.view.CDeath;
import cz.dd4j.ui.gui.view.CMovement;
import cz.dd4j.ui.gui.view.CMovementCtrl;
import cz.dd4j.ui.gui.view.HeroView;
import cz.dd4j.ui.gui.view.RoomsView;

public class MonsterView
extends Entity<Texture> {
    private Texture texMonster;
    private CMovement movement;
    public CMovementCtrl movementCtrl;
    public AgentMindBody<Monster, IMonsterAgent> monster;
    public CDeath deathAnim;

    public MonsterView(AgentMindBody<Monster, IMonsterAgent> monster, RoomsView roomsView) {
        this(monster, Ctx.texMonster, roomsView);
    }

    public MonsterView(AgentMindBody<Monster, IMonsterAgent> monster, Texture texMonster, RoomsView roomsView) {
        super((IDrawable)texMonster);
        this.monster = monster;
        this.texMonster = texMonster;
        this.movement = new CMovement(this);
        this.movementCtrl = new CMovementCtrl(this, monster.body, roomsView, this.movement);
        this.movementCtrl.roomViewX = 48;
        this.movementCtrl.roomViewY = 8;
        this.movementCtrl.corridorViewX = 0;
        this.movementCtrl.corridorViewY = 0;
        this.deathAnim = new CDeath(this);
    }

    public TweenPos attack(final HeroView entity) {
        TweenPos tween = new TweenPos(this.pos, entity.pos, TweenPosType.TIME, 0.3f, TweenEase.LINEAR);
        tween.play();
        tween.onPlayed = new ITweenPosCallback(){

            public void run(TweenPos tween) {
                entity.animateDeath();
                tween.reverse();
            }
        };
        return tween;
    }

    public void animateDeath() {
        this.deathAnim.doIt();
    }

    public void tick(C2DTime time) {
    }
}

