/*
 * Decompiled with CFR 0.152.
 */
package cz.dd4j.ui.gui;

import cz.cuni.amis.clear2d.engine.SceneElement;
import cz.dd4j.agents.IHeroAgent;
import cz.dd4j.agents.IMonsterAgent;
import cz.dd4j.simulation.SimStaticStats;
import cz.dd4j.simulation.data.agents.AgentMindBody;
import cz.dd4j.simulation.data.dungeon.elements.entities.Hero;
import cz.dd4j.simulation.data.dungeon.elements.entities.Monster;
import cz.dd4j.simulation.data.state.SimState;
import cz.dd4j.ui.gui.DD4JFrame;
import cz.dd4j.ui.gui.view.HeroView;
import cz.dd4j.ui.gui.view.MonsterView;
import cz.dd4j.ui.gui.view.RoomsView;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.SwingUtilities;

public class DD4JVis {
    public SimState simState;
    public SimStaticStats stats;
    public DD4JFrame frame;
    public RoomsView roomsView;
    public Map<Monster, MonsterView> monsterViews;
    public Map<Hero, HeroView> heroViews;

    public DD4JVis(SimState state, SimStaticStats stats) {
        this.simState = state;
        this.stats = stats;
        this.init();
    }

    private void init() {
        this.roomsView = new RoomsView(this.simState);
        this.roomsView.pos.x = 10.0f;
        this.roomsView.pos.y = 10.0f;
        this.frame = new DD4JFrame(this.roomsView.getTotalWidth() + 20, this.roomsView.getTotalWidth() + 20);
        this.frame.dungeon.scene.root.addChild((SceneElement)this.roomsView);
        this.monsterViews = new HashMap<Monster, MonsterView>();
        for (AgentMindBody monster : this.simState.monsters.values()) {
            MonsterView monsterView = new MonsterView((AgentMindBody<Monster, IMonsterAgent>)monster, this.roomsView);
            this.roomsView.addChild((SceneElement)monsterView);
            this.monsterViews.put((Monster)monster.body, monsterView);
        }
        this.heroViews = new HashMap<Hero, HeroView>();
        for (AgentMindBody hero : this.simState.heroes.values()) {
            HeroView heroView = new HeroView((AgentMindBody<Hero, IHeroAgent>)hero, this.roomsView);
            this.roomsView.addChild((SceneElement)heroView);
            this.heroViews.put((Hero)hero.body, heroView);
        }
    }

    public void die() {
        if (this.frame != null) {
            this.frame.die();
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        DD4JVis.this.frame.dispatchEvent(new WindowEvent(DD4JVis.this.frame, 201));
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.frame = null;
        }
    }
}

