/*
 * Decompiled with CFR 0.152.
 */
package cz.minesweeper4j.agents;

import alice.tuprolog.Prolog;
import cz.minesweeper4j.agents.ArtificialAgent;
import cz.minesweeper4j.simulation.actions.Action;
import cz.minesweeper4j.simulation.board.oop.Board;
import cz.minesweeper4j.simulation.board.oop.Pos;

public abstract class PrologAgentBase
extends ArtificialAgent {
    protected Prolog prolog;
    private boolean newBoard;

    public void newBoard() {
        if (this.prolog == null) {
            this.prolog = new Prolog();
        } else {
            this.prolog.clearTheory();
        }
        this.newBoard = true;
        this.prepareProlog(this.prolog);
    }

    public void observe(Board board) {
        super.observe(board);
        if (this.newBoard) {
            this.prologNewBoard(this.prolog, board);
        } else {
            this.prologUpdateBoard(this.prolog, board, this.previousBoard);
        }
    }

    protected abstract void prepareProlog(Prolog var1);

    protected abstract void prologNewBoard(Prolog var1, Board var2);

    protected abstract void prologUpdateBoard(Prolog var1, Board var2, Board var3);

    protected abstract Action prologThink(Prolog var1, Board var2, Board var3);

    protected Action prologReasoningFailed(Board board, Board previousBoard) {
        if (board.safeTilePos != null && !board.tile((Pos)board.safeTilePos).visible) {
            return this.actions.open(board.safeTilePos);
        }
        return this.actions.advice();
    }

    protected Action thinkImpl(Board board, Board previousBoard) {
        Action action = this.prologThink(this.prolog, board, previousBoard);
        if (action == null) {
            action = this.prologReasoningFailed(board, previousBoard);
        }
        return action;
    }
}

