/*
 * Decompiled with CFR 0.152.
 */
package cz.minesweeper4j.agents;

import cz.minesweeper4j.agents.ArtificialAgent;
import cz.minesweeper4j.simulation.actions.Action;
import cz.minesweeper4j.simulation.board.oop.Board;
import cz.minesweeper4j.simulation.board.oop.Pos;
import org.sat4j.minisat.SolverFactory;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.TimeoutException;
import org.sat4j.tools.ModelIterator;

public abstract class SATAgentBase
extends ArtificialAgent {
    protected Action thinkImpl(Board board, Board previousBoard) {
        Action action;
        ModelIterator solver = this.satNewSolver(board, previousBoard);
        this.satEncodeProblem((ISolver)solver, board, previousBoard);
        if (solver.nVars() <= 0) {
            return this.satFailed(board, previousBoard);
        }
        boolean satisfiable = false;
        try {
            satisfiable = solver.isSatisfiable();
        }
        catch (TimeoutException e) {
            e.printStackTrace();
        }
        if (satisfiable && (action = this.satProblemSatisfiable(solver, board, previousBoard)) != null) {
            return action;
        }
        return this.satFailed(board, previousBoard);
    }

    protected ModelIterator satNewSolver(Board board, Board previousBoard) {
        ISolver satSolver = SolverFactory.newDefault();
        satSolver.setTimeout(3600);
        return new ModelIterator(satSolver);
    }

    protected abstract void satEncodeProblem(ISolver var1, Board var2, Board var3);

    protected abstract Action satProblemSatisfiable(ModelIterator var1, Board var2, Board var3);

    protected Action satFailed(Board board, Board previousBoard) {
        if (board.safeTilePos != null && !board.tile((Pos)board.safeTilePos).visible) {
            return this.actions.open(board.safeTilePos);
        }
        return this.actions.advice();
    }
}

