/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.goal.unreal.actions;

import cz.cuni.amis.utils.exception.PogamutException;
import java.util.Collection;
import nl.tudelft.goal.unreal.actions.Action;
import nl.tudelft.goal.unreal.actions.ActionQueue;
import nl.tudelft.goal.unreal.actions.BlockedAction;
import nl.tudelft.goal.unreal.actions.ReplaceAction;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ActionQueueTest {
    ActionQueue queue;

    @Before
    public void setUp() throws Exception {
        this.queue = new ActionQueue(5);
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void putReplaceActions() throws InterruptedException {
        this.queue.put((Action)new ReplaceAction(0));
        this.queue.put((Action)new ReplaceAction(1));
        this.queue.put((Action)new ReplaceAction(2));
        this.queue.put((Action)new ReplaceAction(3));
        this.queue.put((Action)new ReplaceAction(4));
        Collection actions = this.queue.drain();
        Assert.assertTrue((actions.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)actions.contains((Object)new ReplaceAction(4)));
    }

    @Test
    public void putBlockedActions() throws InterruptedException {
        this.queue.put((Action)new BlockedAction(0));
        this.queue.put((Action)new BlockedAction(1));
        this.queue.put((Action)new BlockedAction(2));
        this.queue.put((Action)new BlockedAction(3));
        this.queue.put((Action)new BlockedAction(4));
        Collection actions = this.queue.drain();
        Assert.assertTrue((actions.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)actions.contains((Object)new BlockedAction(0)));
    }

    @Test
    public void putReplaceAndBlockedActions() throws InterruptedException {
        this.queue.put((Action)new BlockedAction(0));
        this.queue.put((Action)new ReplaceAction(0));
        this.queue.put((Action)new BlockedAction(1));
        this.queue.put((Action)new ReplaceAction(1));
        this.queue.put((Action)new BlockedAction(2));
        this.queue.put((Action)new ReplaceAction(2));
        this.queue.put((Action)new BlockedAction(3));
        this.queue.put((Action)new ReplaceAction(3));
        this.queue.put((Action)new BlockedAction(4));
        this.queue.put((Action)new ReplaceAction(4));
        Collection actions = this.queue.drain();
        Assert.assertTrue((actions.size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)actions.contains((Object)new BlockedAction(0)));
        Assert.assertTrue((boolean)actions.contains((Object)new ReplaceAction(4)));
    }

    @Test
    public void putAnonClassReplaceAction() throws InterruptedException {
        ReplaceAction action0 = new ReplaceAction(0){

            @Override
            public void execute() throws PogamutException {
                super.execute();
            }
        };
        this.queue.put((Action)action0);
        this.queue.put((Action)new ReplaceAction(1));
        this.queue.put((Action)new ReplaceAction(2));
        this.queue.put((Action)new ReplaceAction(3));
        ReplaceAction action4 = new ReplaceAction(4){

            @Override
            public void execute() throws PogamutException {
                super.execute();
            }
        };
        this.queue.put((Action)action4);
        Collection actions = this.queue.drain();
        Assert.assertTrue((actions.size() == 1 ? 1 : 0) != 0);
        Assert.assertFalse((boolean)actions.contains((Object)action0));
        Assert.assertTrue((boolean)actions.contains((Object)action4));
    }

    @Test
    public void putAnonClassBlockedAction() throws InterruptedException {
        BlockedAction action0 = new BlockedAction(0){

            @Override
            public void execute() throws PogamutException {
                super.execute();
            }
        };
        this.queue.put((Action)action0);
        this.queue.put((Action)new BlockedAction(1));
        this.queue.put((Action)new BlockedAction(2));
        this.queue.put((Action)new BlockedAction(3));
        BlockedAction action4 = new BlockedAction(4){

            @Override
            public void execute() throws PogamutException {
                super.execute();
            }
        };
        this.queue.put((Action)action4);
        Collection actions = this.queue.drain();
        Assert.assertTrue((actions.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)actions.contains((Object)action0));
        Assert.assertFalse((boolean)actions.contains((Object)action4));
    }
}

