/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.goal.unreal.messages;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import nl.tudelft.goal.unreal.messages.BotParameters;

public class Configuration {
    public static final Level DEFAULT_LOG_LEVEL = Level.WARNING;
    public static final String DEFAULT_BOT_NAME = "UnrealGOALBot";
    public static final String LOCAL_HOST = "127.0.0.1";
    public static final int CONTROL_SERVER_PORT = 3001;
    public static final int BOT_SERVER_PORT = 3000;
    public static final String CONTROL_SERVER = "127.0.0.1:3001";
    public static final String BOT_SERVER = "127.0.0.1:3000";
    private static final URI VISUALIZER_SERVER = null;
    private List<BotParameters> bots;
    private URI visualizer;
    private URI botServer;
    private URI controlServer;
    private Level logLevel;

    public List<BotParameters> getBots() {
        return this.bots == null ? new ArrayList() : this.bots;
    }

    public void setBots(List<BotParameters> bots) {
        this.bots = bots;
    }

    public URI getVisualizer() {
        return this.visualizer;
    }

    public void setVisualizer(URI visualizer) {
        this.visualizer = visualizer;
    }

    public URI getBotServer() {
        return this.botServer;
    }

    public void setBotServer(URI botServer) {
        this.botServer = botServer;
    }

    public URI getControlServer() {
        return this.controlServer;
    }

    public void setControlServer(URI controlServer) {
        this.controlServer = controlServer;
    }

    public Configuration setLogLevel(Level level) {
        assert (level != null);
        this.logLevel = level;
        return this;
    }

    public Level getLogLevel() {
        return this.logLevel;
    }

    public String getDefaultBotName() {
        return DEFAULT_BOT_NAME;
    }

    public int getBotServerPort() {
        return this.botServer == null ? -1 : this.botServer.getPort();
    }

    public String getBotServerHost() {
        return this.botServer == null ? null : this.botServer.getHost();
    }

    public static Configuration getDefaults() {
        Configuration configuration = new Configuration();
        configuration.setBots(new ArrayList<BotParameters>());
        configuration.setVisualizer(VISUALIZER_SERVER);
        try {
            configuration.setBotServer(new URI(BOT_SERVER));
            configuration.setControlServer(new URI(CONTROL_SERVER));
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        configuration.setLogLevel(DEFAULT_LOG_LEVEL);
        return configuration;
    }

    public void assignDefaults(Configuration configuration) {
        if (this.bots == null) {
            this.bots = configuration.bots;
        }
        if (this.visualizer == null) {
            this.visualizer = configuration.visualizer;
        }
        if (this.botServer == null) {
            this.botServer = configuration.botServer;
        }
        if (this.controlServer == null) {
            this.controlServer = configuration.controlServer;
        }
        if (this.logLevel == null) {
            this.logLevel = configuration.logLevel;
        }
    }

    public int getControlServerPort() {
        return this.controlServer == null ? -1 : this.controlServer.getPort();
    }

    public String getControlServerHost() {
        return this.controlServer == null ? null : this.controlServer.getHost();
    }
}

