/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.goal.unreal.translators;

import eis.eis2java.exception.TranslationException;
import eis.eis2java.translation.Parameter2Java;
import eis.iilang.Identifier;
import eis.iilang.Parameter;
import eis.iilang.ParameterList;
import nl.tudelft.goal.unreal.messages.ParameterMap;

public class ParameterMapTranslator
implements Parameter2Java<ParameterMap> {
    private static final int ENTRY_SIZE = 2;

    public ParameterMap translate(Parameter parameter) throws TranslationException {
        if (!(parameter instanceof ParameterList)) {
            String message = String.format("%s is not a parameter list.", parameter);
            throw new TranslationException(message);
        }
        return this.translateEntries((ParameterList)parameter);
    }

    private ParameterMap translateEntries(ParameterList parameterList) throws TranslationException {
        ParameterMap map = new ParameterMap();
        for (Parameter entry : parameterList) {
            if (!(entry instanceof ParameterList)) {
                String message = String.format("%s is not a parameter list.", entry);
                throw new TranslationException(message);
            }
            ParameterList entryList = (ParameterList)entry;
            if (entryList.size() != 2) {
                String message = String.format("Expected a parameter list with 2 elements but received %s.", entryList);
                throw new TranslationException(message);
            }
            Parameter key = entryList.get(0);
            Parameter value = entryList.get(1);
            if (!(key instanceof Identifier)) {
                String message = String.format("Expected an identifier but received %s.", key);
                throw new TranslationException(message);
            }
            map.put((Identifier)key, value);
        }
        return map;
    }

    public Class<ParameterMap> translatesTo() {
        return ParameterMap.class;
    }
}

