/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.sposh.elements;

import cz.cuni.amis.pogamut.sposh.elements.DriveCollection;
import cz.cuni.amis.pogamut.sposh.elements.Freq;
import cz.cuni.amis.pogamut.sposh.elements.LapElementsFactory;
import cz.cuni.amis.pogamut.sposh.elements.LapType;
import cz.cuni.amis.pogamut.sposh.elements.NamedLapElement;
import cz.cuni.amis.pogamut.sposh.elements.PoshElement;
import cz.cuni.amis.pogamut.sposh.elements.PrimitiveCall;
import cz.cuni.amis.pogamut.sposh.elements.Sense;
import cz.cuni.amis.pogamut.sposh.elements.Trigger;
import cz.cuni.amis.pogamut.sposh.elements.TriggeredAction;
import cz.cuni.amis.pogamut.sposh.exceptions.DuplicateNameException;
import cz.cuni.amis.pogamut.sposh.exceptions.InvalidNameException;
import java.awt.datatransfer.DataFlavor;
import java.util.ArrayList;
import java.util.List;

public final class DriveElement
extends NamedLapElement<DriveElement, DriveCollection> {
    private String name;
    private final Trigger<DriveElement> trigger = new Trigger<DriveElement>(this);
    private final TriggeredAction action;
    @Deprecated
    private Freq freq;
    @Deprecated
    private String comment;
    public static final String deName = "deName";
    public static final DataFlavor dataFlavor = new DataFlavor(DriveElement.class, "drive-element");

    DriveElement(String name, List<Sense> triggerSenses, PrimitiveCall actionCall, Freq freq, String comment) {
        assert (name != null);
        this.name = name;
        assert (freq != null);
        this.freq = freq;
        assert (comment != null);
        this.comment = comment;
        for (Sense triggerSense : triggerSenses) {
            assert (!triggerSense.isChildOfParent());
            this.trigger.add(triggerSense);
        }
        this.action = LapElementsFactory.createAction(actionCall);
        this.action.setParent(this);
    }

    public Trigger<DriveElement> getTrigger() {
        return this.trigger;
    }

    public TriggeredAction getAction() {
        return this.action;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('(');
        sb.append(this.name);
        if (!this.trigger.isEmpty()) {
            sb.append(" (trigger ");
            sb.append(this.trigger.toString());
            sb.append(')');
        }
        sb.append(' ');
        sb.append(this.action.toString());
        sb.append(')');
        return sb.toString();
    }

    @Override
    public List<PoshElement> getChildDataNodes() {
        ArrayList<PoshElement> children = new ArrayList<PoshElement>();
        children.addAll(this.trigger);
        children.add(this.action);
        return children;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setDriveName(String newName) throws InvalidNameException, DuplicateNameException {
        if (!(newName = newName.trim()).matches("([a-zA-Z][_\\-a-zA-Z0-9]*\\.)*[a-zA-Z][_\\-a-zA-Z0-9]*")) {
            throw InvalidNameException.create(newName);
        }
        DriveCollection dc = (DriveCollection)this.getParent();
        for (DriveElement drive : dc.getDrives()) {
            if (!drive.getName().equals(newName) || drive == this) continue;
            throw new DuplicateNameException("There already is a drive with name " + newName);
        }
        String oldName = this.name;
        this.name = newName;
        this.firePropertyChange(deName, oldName, newName);
    }

    @Override
    public boolean moveChild(int newIndex, PoshElement child) {
        throw new UnsupportedOperationException();
    }

    @Override
    public DataFlavor getDataFlavor() {
        return dataFlavor;
    }

    @Override
    public LapType getType() {
        return LapType.DRIVE_ELEMENT;
    }

    @Deprecated
    public Freq getFreq() {
        return this.freq;
    }

    @Deprecated
    public String getComment() {
        return this.comment;
    }
}

