/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.sposh.engine;

import cz.cuni.amis.pogamut.sposh.elements.DriveElement;
import cz.cuni.amis.pogamut.sposh.elements.Freq;
import cz.cuni.amis.pogamut.sposh.elements.PoshPlan;
import cz.cuni.amis.pogamut.sposh.elements.PrimitiveCall;
import cz.cuni.amis.pogamut.sposh.engine.ADExecutor;
import cz.cuni.amis.pogamut.sposh.engine.AbstractExecutor;
import cz.cuni.amis.pogamut.sposh.engine.CExecutor;
import cz.cuni.amis.pogamut.sposh.engine.ElementExecutor;
import cz.cuni.amis.pogamut.sposh.engine.ElementStackTrace;
import cz.cuni.amis.pogamut.sposh.engine.FireResult;
import cz.cuni.amis.pogamut.sposh.engine.SenseListExecutor;
import cz.cuni.amis.pogamut.sposh.engine.StackElement;
import cz.cuni.amis.pogamut.sposh.engine.TriggerResult;
import cz.cuni.amis.pogamut.sposh.engine.VariableContext;
import cz.cuni.amis.pogamut.sposh.engine.timer.ITimer;
import cz.cuni.amis.pogamut.sposh.executor.IWorkExecutor;
import java.util.ArrayList;
import java.util.logging.Logger;

class DEExecutor
extends AbstractExecutor {
    private String name;
    private PoshPlan plan;
    private PrimitiveCall actionCall;
    private SenseListExecutor<DriveElement> trigger;
    private Freq freq;
    private long lastFired = Integer.MAX_VALUE;
    private ElementStackTrace stackTrace = new ElementStackTrace();
    private TriggerResult triggerResult;

    DEExecutor(PoshPlan plan, DriveElement de, VariableContext ctx, Logger log) {
        super(ctx, log);
        this.trigger = new SenseListExecutor<DriveElement>(de.getTrigger(), ctx, log);
        this.freq = de.getFreq();
        this.name = de.getName();
        this.plan = plan;
        this.actionCall = de.getAction().getActionCall();
    }

    private StackElement createInitialStackElement(PoshPlan plan, PrimitiveCall actionCall) {
        return this.getElement(plan, actionCall, FireResult.Type.SURFACE_CONTINUE, FireResult.Type.SURFACE, FireResult.Type.SURFACE, FireResult.Type.SURFACE);
    }

    public synchronized boolean isReady(long timestamp, IWorkExecutor workExecuter) {
        long passed = timestamp - this.lastFired;
        if (Freq.compare(this.freq.tick(), passed) > 0) {
            this.info("Max.firing frequency exceeded, has to be at least " + this.freq.tick() + "ms, but was only " + passed);
            return false;
        }
        this.triggerResult = this.trigger.fire(workExecuter, true);
        return this.triggerResult.wasSuccess();
    }

    public synchronized FireResult.Type fire(IWorkExecutor workExecuter, ITimer timer) {
        int i;
        ArrayList<CExecutor> competences = new ArrayList<CExecutor>();
        for (i = this.stackTrace.size() - 1; i >= 0; --i) {
            StackElement element = (StackElement)this.stackTrace.get(i);
            if (element.getExecutor() instanceof CExecutor) {
                competences.add((CExecutor)element.getExecutor());
                continue;
            }
            if (!(element.getExecutor() instanceof ADExecutor)) continue;
            if (!((ADExecutor)element.getExecutor()).isExit(workExecuter)) break;
            this.stackTrace.cutDownToIncluding((ElementExecutor)element.getExecutor());
            competences.clear();
        }
        for (i = competences.size() - 1; i >= 0; --i) {
            CExecutor competence = (CExecutor)competences.get(i);
            if (!competence.isGoalSatisfied(workExecuter)) continue;
            this.stackTrace.cutDownToIncluding(competence);
            break;
        }
        if (this.stackTrace.isEmpty()) {
            this.stackTrace.add(this.createInitialStackElement(this.plan, this.actionCall));
            return FireResult.Type.CONTINUE;
        }
        FireResult result = this.stackTrace.peek().getExecutor().fire(workExecuter);
        this.lastFired = timer.getTime();
        this.info("The fired element returned: " + (Object)((Object)result.getType()));
        switch (result.getType()) {
            case FULFILLED: {
                this.stackTrace.removeAllElements();
                break;
            }
            case FAILED: {
                this.stackTrace.removeAllElements();
                break;
            }
            case FOLLOW: {
                this.stackTrace.push(result.getNextElement());
                break;
            }
            case CONTINUE: {
                break;
            }
            case SURFACE: 
            case SURFACE_CONTINUE: {
                this.stackTrace.pop();
                break;
            }
            default: {
                throw new IllegalStateException("State \"" + (Object)((Object)result.getType()) + "\" not expected. Serious error.");
            }
        }
        return result.getType();
    }

    ElementStackTrace getStackTrace() {
        return this.stackTrace;
    }

    public String getName() {
        return this.name;
    }

    public TriggerResult getTriggerResult() {
        return this.triggerResult;
    }

    public void clearTriggerResult() {
        this.triggerResult = null;
    }

    public void driveInterrupted() {
        while (this.stackTrace.size() > 0 && !(this.stackTrace.peek().getExecutor() instanceof ADExecutor)) {
            this.stackTrace.pop();
        }
    }
}

