/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.utils.concurrency;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLongArray;

public class AtomicLongList {
    private List<AtomicLongArray> arrays = new ArrayList<AtomicLongArray>();
    private int capacityStep;
    private int size = 0;

    public AtomicLongList(int initialCapacity, int capacityStep) {
        this.capacityStep = capacityStep;
        if (initialCapacity > 0) {
            this.getArray(initialCapacity - 1);
        }
    }

    private int arrayIndex(int index) {
        return index / this.capacityStep;
    }

    private int trueIndex(int index) {
        return index - this.capacityStep * (index / this.capacityStep);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AtomicLongArray getArray(int index) {
        List<AtomicLongArray> list;
        int arrayIndex = this.arrayIndex(index);
        if (this.size <= index) {
            list = this.arrays;
            synchronized (list) {
                if (this.size <= index) {
                    this.size = index + 1;
                }
            }
        }
        if (arrayIndex < this.arrays.size()) {
            return this.arrays.get(arrayIndex);
        }
        list = this.arrays;
        synchronized (list) {
            while (this.arrays.size() <= arrayIndex) {
                this.arrays.add(new AtomicLongArray(this.capacityStep));
            }
        }
        return this.arrays.get(arrayIndex);
    }

    public long addAndGet(int i, long delta) {
        return this.getArray(i).addAndGet(this.trueIndex(i), delta);
    }

    public boolean compareAndSet(int i, long expect, long update) {
        return this.getArray(i).compareAndSet(this.trueIndex(i), expect, update);
    }

    public long decrementAndGet(int i) {
        return this.getArray(i).decrementAndGet(this.trueIndex(i));
    }

    public long get(int i) {
        return this.getArray(i).get(this.trueIndex(i));
    }

    public long getAndAdd(int i, long delta) {
        return this.getArray(i).getAndAdd(this.trueIndex(i), delta);
    }

    public long getAndDecrement(int i) {
        return this.getArray(i).getAndDecrement(this.trueIndex(i));
    }

    public long getAndIncrement(int i) {
        return this.getArray(i).getAndIncrement(this.trueIndex(i));
    }

    public long getAndSet(int i, long newValue) {
        return this.getArray(i).getAndSet(this.trueIndex(i), newValue);
    }

    public long incrementAndGet(int i) {
        return this.getArray(i).incrementAndGet(this.trueIndex(i));
    }

    public int size() {
        return this.size;
    }

    public int capacity() {
        return this.arrays.size() * this.capacityStep;
    }

    public void set(int i, long newValue) {
        this.getArray(i).set(this.trueIndex(i), newValue);
    }

    public boolean weakCompareAndSet(int i, long expect, long update) {
        return this.getArray(i).weakCompareAndSet(this.trueIndex(i), expect, update);
    }
}

