/*
 * Decompiled with CFR 0.152.
 */
package SteeringProperties;

import SteeringProperties.Force_packet;
import SteeringProperties.SteeringProperties;
import SteeringProperties.Target_packet;
import SteeringStuff.SteeringType;
import XMLSteeringProperties.XMLTargetApproachingProperties;
import XMLSteeringProperties.XMLTarget_packet;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import java.util.ArrayList;

public class TargetApproachingProperties
extends SteeringProperties {
    private ArrayList<Target_packet> targets = new ArrayList();

    public TargetApproachingProperties() {
        super(SteeringType.TARGET_APPROACHING);
        this.targets.add(new Target_packet());
    }

    public TargetApproachingProperties(SteeringProperties.BehaviorType behaviorType) {
        super(SteeringType.TARGET_APPROACHING, behaviorType);
        this.targets.add(new Target_packet());
        this.setNewBehaviorType(behaviorType);
    }

    public TargetApproachingProperties(XMLTargetApproachingProperties xml) {
        super(SteeringType.TARGET_APPROACHING, xml.active, xml.weight, xml.behavior);
        for (XMLTarget_packet tp : xml.targets) {
            this.targets.add(new Target_packet(tp));
        }
    }

    public TargetApproachingProperties(int attractiveForce, Location endLocation) {
        super(SteeringType.TARGET_APPROACHING);
        this.targets.add(new Target_packet(endLocation, new Force_packet(attractiveForce)));
    }

    @Override
    protected void setNewBehaviorType(SteeringProperties.BehaviorType behaviorType) {
        if (behaviorType.equals((Object)SteeringProperties.BehaviorType.BASIC)) {
            Target_packet first = this.targets.get(0);
            first.setForce_packet(new Force_packet(first.getAttractiveForce()));
            this.targets.clear();
            this.targets.add(new Target_packet(first.getTargetLocation(), first.getForce_packet()));
        }
    }

    public int getAttractiveForce() {
        if (!this.targets.isEmpty() && !this.targets.get(0).getForce_packet().getForcePoints().isEmpty()) {
            return this.targets.get((int)0).getForce_packet().getForcePoints().get((int)0).forceValue;
        }
        return 100;
    }

    public void setAttractiveForce(int attractiveForce) {
        if (!this.targets.isEmpty() && !this.targets.get(0).getForce_packet().getForcePoints().isEmpty()) {
            this.targets.get((int)0).getForce_packet().getForcePoints().get((int)0).forceValue = attractiveForce;
        }
    }

    public ArrayList<Target_packet> getTargets() {
        return this.targets;
    }

    public void setTargets(ArrayList<Target_packet> targets) {
        this.targets = targets;
    }

    public Target_packet getTarget_packet(int index) {
        return this.targets.get(index);
    }

    public void setTarget_packet(int index, Target_packet tp) {
        if (index >= 0 && index < this.targets.size()) {
            this.targets.get(index).setTarget_Packet(tp);
        }
    }

    public void removeTarget_packet(int index) {
        if (index >= 0 && index < this.targets.size()) {
            this.targets.remove(index);
        }
    }

    public void setTargetLocation(int index, Location loc) {
        if (index >= 0 && index < this.targets.size()) {
            this.targets.get(index).setTargetLocation(loc);
        }
    }

    public void addTarget_packet(Target_packet tp) {
        this.targets.add(tp);
    }

    @Override
    public String getSpecialText() {
        String text = "";
        int index = 0;
        for (Target_packet t : this.targets) {
            text = text + "  * Target Number " + index + ":\n" + t.getSpecialText();
            ++index;
        }
        return text;
    }

    @Override
    public void setProperties(SteeringProperties newProperties) {
        this.targets = ((TargetApproachingProperties)newProperties).getTargets();
    }

    public XMLTargetApproachingProperties getXMLProperties() {
        XMLTargetApproachingProperties xmlProp = new XMLTargetApproachingProperties();
        xmlProp.targets = new ArrayList();
        for (Target_packet t : this.targets) {
            xmlProp.targets.add(t.getXMLProperties());
        }
        xmlProp.active = this.active;
        xmlProp.weight = this.weight;
        xmlProp.behavior = this.behaviorType;
        return xmlProp;
    }
}

