/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base3d.worldview.impl;

import com.google.inject.name.Named;
import cz.cuni.amis.pogamut.base.communication.translator.event.IWorldObjectUpdateResult;
import cz.cuni.amis.pogamut.base.communication.translator.event.IWorldObjectUpdatedEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.impl.EventDrivenWorldView;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObject;
import cz.cuni.amis.pogamut.base.communication.worldview.object.WorldObjectId;
import cz.cuni.amis.pogamut.base.communication.worldview.object.event.WorldObjectDestroyedEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.object.event.WorldObjectFirstEncounteredEvent;
import cz.cuni.amis.pogamut.base.component.bus.IComponentBus;
import cz.cuni.amis.pogamut.base.component.controller.ComponentDependencies;
import cz.cuni.amis.pogamut.base.utils.logging.IAgentLogger;
import cz.cuni.amis.pogamut.base3d.worldview.IVisionWorldView;
import cz.cuni.amis.pogamut.base3d.worldview.object.IViewable;
import cz.cuni.amis.pogamut.base3d.worldview.object.event.WorldObjectAppearedEvent;
import cz.cuni.amis.pogamut.base3d.worldview.object.event.WorldObjectDisappearedEvent;
import cz.cuni.amis.utils.ClassUtils;
import cz.cuni.amis.utils.exception.PogamutException;
import cz.cuni.amis.utils.maps.HashMapMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class VisionWorldView
extends EventDrivenWorldView
implements IVisionWorldView {
    public static final String WORLDVIEW_DEPENDENCY = "VisionWorldViewDependency";
    private HashMapMap<Class, WorldObjectId, IViewable> worldVisibleObjects = new HashMapMap();
    private Map<Class, Map<WorldObjectId, IViewable>> syncWorldVisibleObjects = Collections.synchronizedMap(this.worldVisibleObjects);
    private Map<WorldObjectId, IViewable> visibleObjects = Collections.synchronizedMap(new HashMap());

    public VisionWorldView(@Named(value="VisionWorldViewDependency") ComponentDependencies dependencies, IComponentBus bus, IAgentLogger log) {
        super(dependencies, bus, log);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void cleanUp() {
        super.cleanUp();
        Object object = this.worldVisibleObjects;
        synchronized (object) {
            this.worldVisibleObjects.clear();
        }
        object = this.visibleObjects;
        synchronized (object) {
            this.visibleObjects.clear();
        }
        object = this.notifyEventsList;
        synchronized (object) {
            this.notifyEventsList.clear();
        }
    }

    @Override
    public Map<Class, Map<WorldObjectId, IViewable>> getAllVisible() {
        return this.syncWorldVisibleObjects;
    }

    @Override
    public <T extends IViewable> Map<WorldObjectId, T> getAllVisible(Class<T> type) {
        return this.syncWorldVisibleObjects.get(type);
    }

    @Override
    public Map<WorldObjectId, IViewable> getVisible() {
        return this.visibleObjects;
    }

    @Override
    public IViewable getVisible(WorldObjectId id) {
        return this.visibleObjects.get(id);
    }

    protected synchronized void addVisibleObject(IViewable worldObject) {
        this.visibleObjects.put(worldObject.getId(), worldObject);
        for (Class cls : ClassUtils.getSubclasses(worldObject.getClass())) {
            this.syncWorldVisibleObjects.get(cls).put(worldObject.getId(), worldObject);
        }
    }

    protected synchronized void removeVisibleObject(IViewable worldObject) {
        this.visibleObjects.remove(worldObject.getId());
        for (Class cls : ClassUtils.getSubclasses(worldObject.getClass())) {
            this.syncWorldVisibleObjects.get(cls).remove(worldObject.getId());
        }
    }

    @Override
    protected void objectUpdatedEvent(IWorldObjectUpdatedEvent updateEvent) {
        IWorldObject obj = this.get(updateEvent.getId());
        boolean wasVisible = obj != null && obj instanceof IViewable && ((IViewable)obj).isVisible();
        IWorldObjectUpdateResult<IWorldObject> updateResult = updateEvent.update(obj);
        if (updateResult == null) {
            throw new PogamutException("Update result is null (updateEvent.update(obj) == null)! Cannot update object of ID " + updateEvent.getId() + "!", (Object)this);
        }
        switch (updateResult.getResult()) {
            case CREATED: {
                this.objectCreated(updateResult.getObject());
                return;
            }
            case UPDATED: {
                if (updateResult.getObject() != obj) {
                    throw new PogamutException("Update event " + updateEvent + " does not returned the same instance of the object (result UPDATED).", (Object)this);
                }
                if (obj instanceof IViewable) {
                    boolean isVisible = ((IViewable)obj).isVisible();
                    if (wasVisible) {
                        this.objectUpdated(obj);
                        if (!isVisible) {
                            this.objectDisappeared((IViewable)obj);
                        }
                    } else {
                        if (isVisible) {
                            this.objectAppeared((IViewable)obj);
                        }
                        this.objectUpdated(obj);
                    }
                } else {
                    this.objectUpdated(obj);
                }
                return;
            }
            case SAME: {
                return;
            }
            case DESTROYED: {
                this.objectDestroyed(obj);
                return;
            }
        }
        throw new PogamutException("Unhandled object update result " + (Object)((Object)updateResult.getResult()) + " for the object " + obj + ".", (Object)this);
    }

    @Override
    protected void objectCreated(IWorldObject obj) {
        IViewable viewable;
        this.addWorldObject(obj);
        this.raiseEvent(new WorldObjectFirstEncounteredEvent<IWorldObject>(obj, obj.getSimTime()));
        if (obj instanceof IViewable && (viewable = (IViewable)obj).isVisible()) {
            this.objectAppeared(viewable);
        }
        this.objectUpdated(obj);
    }

    protected void objectAppeared(IViewable obj) {
        this.addVisibleObject(obj);
        this.raiseEvent(new WorldObjectAppearedEvent<IViewable>(obj, obj.getSimTime()));
    }

    protected void objectDisappeared(IViewable obj) {
        this.removeVisibleObject(obj);
        this.raiseEvent(new WorldObjectDisappearedEvent<IViewable>(obj, obj.getSimTime()));
    }

    @Override
    protected void objectDestroyed(IWorldObject obj) {
        IViewable viewable;
        if (obj instanceof IViewable && (viewable = (IViewable)obj).isVisible()) {
            this.objectDisappeared(viewable);
        }
        this.removeWorldObject(obj);
        this.raiseEvent(new WorldObjectDestroyedEvent<IWorldObject>(obj, obj.getSimTime()));
    }
}

