/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.utils;

import cz.cuni.amis.pogamut.base.agent.impl.AgentId;
import cz.cuni.amis.pogamut.base.communication.connection.impl.socket.SocketConnectionAddress;
import cz.cuni.amis.pogamut.base.utils.Pogamut;
import cz.cuni.amis.pogamut.base.utils.logging.LogCategory;
import cz.cuni.amis.pogamut.base.utils.logging.LogPublisher;
import cz.cuni.amis.pogamut.ut2004.factory.direct.remoteagent.UT2004ServerFactory;
import cz.cuni.amis.pogamut.ut2004.server.IUT2004Server;
import cz.cuni.amis.pogamut.ut2004.server.exception.UCCStartException;
import cz.cuni.amis.pogamut.ut2004.utils.PogamutUT2004Property;
import cz.cuni.amis.pogamut.ut2004.utils.UCCWrapperConf;
import cz.cuni.amis.pogamut.ut2004.utils.UT2004ServerRunner;
import cz.cuni.amis.utils.exception.PogamutException;
import cz.cuni.amis.utils.flag.Flag;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;

public class UCCWrapper {
    protected LogCategory uccLog;
    protected static int fileCounter = 0;
    Process uccProcess = null;
    protected int gbPort = -1;
    protected int controlPort = -1;
    protected int observerPort = -1;
    protected IUT2004Server utServer = null;
    protected static final int basePort = 39782;
    protected static Integer nextUccWrapperUID = 0;
    protected int uccWrapperUID = 0;
    protected UCCWrapperConf conf = null;
    protected Flag<Boolean> gameEnding = new Flag<Boolean>(false);
    Thread shutDownHook = new Thread("UCC wrapper finalizer"){

        @Override
        public void run() {
            if (UCCWrapper.this.uccProcess != null) {
                UCCWrapper.this.uccProcess.destroy();
            }
        }
    };
    public static long stamp = System.currentTimeMillis();
    protected boolean stopped = false;

    public Logger getLogger() {
        return this.uccLog;
    }

    public UCCWrapperConf getConfiguration() {
        return this.conf;
    }

    public IUT2004Server getUTServer() {
        this.stopCheck();
        if (this.utServer == null) {
            UT2004ServerFactory factory = new UT2004ServerFactory();
            UT2004ServerRunner serverRunner = new UT2004ServerRunner(factory, "NBUTServer", "localhost", this.controlPort);
            this.utServer = serverRunner.startAgent();
        }
        return this.utServer;
    }

    protected String getUnrealHome() {
        if (this.conf.getUnrealHome() == null) {
            return Pogamut.getPlatform().getProperty(PogamutUT2004Property.POGAMUT_UNREAL_HOME.getKey());
        }
        return this.conf.getUnrealHome();
    }

    public UCCWrapper(UCCWrapperConf configuration) throws UCCStartException {
        this.uccLog = new LogCategory("Wrapper");
        this.uccLog.addHandler(new LogPublisher.ConsolePublisher(new AgentId("UCC")));
        if (configuration.log != null) {
            this.uccLog.setParent(configuration.log);
        }
        this.conf = configuration;
        Integer n = nextUccWrapperUID;
        Integer n2 = nextUccWrapperUID = Integer.valueOf(nextUccWrapperUID + 1);
        this.uccWrapperUID = n;
        this.initUCCWrapper();
        Runtime.getRuntime().addShutdownHook(this.shutDownHook);
    }

    protected void initUCCWrapper() throws UCCStartException {
        boolean exception = false;
        try {
            String id = System.currentTimeMillis() + "a" + fileCounter++;
            String fileWithPorts = "GBports" + id;
            String uccHomePath = this.getUnrealHome();
            String systemDirPath = uccHomePath + File.separator + "System" + File.separator;
            String uccFile = "ucc.exe";
            String options = "";
            if (!System.getProperty("os.name").contains("Windows")) {
                options = " -nohomedir";
                uccFile = "ucc";
                if (System.getProperty("os.name").toLowerCase().contains("linux")) {
                    uccFile = "ucc-bin";
                    if (System.getProperty("os.arch").toLowerCase().contains("amd64")) {
                        Logger.getLogger("UCCWrapper").info("64bit arch detected (os.arch property contains keyword amd64). Using 64bit binarry.");
                        uccFile = uccFile + "-linux-amd64";
                    }
                }
            }
            String execStr = systemDirPath + uccFile;
            String portsSetting = this.conf.startOnUnusedPort ? "?PortsLog=" + fileWithPorts + "?bRandomPorts=true" : "";
            String playerPortSetting = this.conf.playerPort != -1 ? "-port=" + this.conf.playerPort : "";
            String parameter = this.conf.mapName + "?game=" + this.conf.gameBotsPack + "." + this.conf.gameType + portsSetting + this.conf.options + options;
            ProcessBuilder procBuilder = new ProcessBuilder(execStr, "server", parameter, playerPortSetting);
            procBuilder.directory(new File(systemDirPath));
            this.uccProcess = procBuilder.start();
            ScannerSink scanner = new ScannerSink(this.uccProcess.getInputStream());
            scanner.start();
            new StreamSink(this.uccProcess.getErrorStream()).start();
            scanner.portsBindedLatch.await(3L, TimeUnit.MINUTES);
            if (scanner.exception != null) {
                try {
                    this.uccProcess.destroy();
                }
                catch (Exception e) {
                    // empty catch block
                }
                this.uccProcess = null;
                throw scanner.exception;
            }
            if (scanner.portsBindedLatch.getCount() > 0L) {
                scanner.interrupt();
                try {
                    this.uccProcess.destroy();
                }
                catch (Exception e) {
                    // empty catch block
                }
                this.uccProcess = null;
                throw new UCCStartException("UCC did not start in 3 minutes, timeout.", (Object)this);
            }
            this.controlPort = scanner.controlPort;
            this.gbPort = scanner.botsPort;
        }
        catch (InterruptedException ex1) {
            exception = true;
            throw new UCCStartException("Interrupted.", (Object)ex1);
        }
        catch (IOException ex2) {
            exception = true;
            throw new UCCStartException("IO Exception.", (Object)ex2);
        }
        catch (UCCStartException ex3) {
            exception = true;
            throw ex3;
        }
        catch (Exception ex3) {
            exception = true;
            throw new UCCStartException("Exception.", (Object)ex3);
        }
        finally {
            if (exception) {
                try {
                    this.stop();
                }
                catch (Exception e) {}
            }
        }
    }

    public Process getProcess() {
        return this.uccProcess;
    }

    public synchronized void stop() {
        this.stopped = true;
        if (this.uccProcess != null) {
            this.uccProcess.destroy();
            Runtime.getRuntime().removeShutdownHook(this.shutDownHook);
            this.uccProcess = null;
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public int getBotPort() {
        this.stopCheck();
        return this.gbPort;
    }

    public int getObserverPort() {
        this.stopCheck();
        return this.observerPort;
    }

    public int getControlPort() {
        this.stopCheck();
        return this.controlPort;
    }

    protected void stopCheck() {
        if (this.stopped) {
            throw new PogamutException("UCC already stopped.", (Object)this);
        }
    }

    public String getHost() {
        return "localhost";
    }

    public SocketConnectionAddress getBotAddress() {
        if (this.getBotPort() <= 0) {
            throw new RuntimeException("Bot port is unavailable, wrong bot-port matching pattern?");
        }
        return new SocketConnectionAddress(this.getHost(), this.getBotPort());
    }

    public SocketConnectionAddress getServerAddress() {
        if (this.getControlPort() <= 0) {
            throw new RuntimeException("Control port is unavailable, wrong control-port matching pattern?");
        }
        return new SocketConnectionAddress(this.getHost(), this.getControlPort());
    }

    public SocketConnectionAddress getObserverAddress() {
        if (this.getObserverPort() <= 0) {
            throw new RuntimeException("Observer port is unavailable, wrong observer-port matching pattern?");
        }
        return new SocketConnectionAddress(this.getHost(), this.getObserverPort());
    }

    public Flag<Boolean> getGameEnding() {
        return this.gameEnding;
    }

    public class ScannerSink
    extends StreamSink {
        public long startingTimeout;
        public UCCStartException exception;
        public CountDownLatch portsBindedLatch;
        public int controlPort;
        public int botsPort;
        Timer timer;
        TimerTask task;
        Matcher matcher;

        public ScannerSink(InputStream is) {
            super(is);
            this.startingTimeout = 120000L;
            this.exception = null;
            this.portsBindedLatch = new CountDownLatch(1);
            this.controlPort = -1;
            this.botsPort = -1;
            this.timer = new Timer("UCC start timeout");
            this.task = null;
            this.task = new TimerTask(){

                @Override
                public void run() {
                    ScannerSink.this.exception = new UCCStartException("Starting timed out. Ports weren't bound in the required time (" + ScannerSink.this.startingTimeout + " ms).", (Object)this);
                    ScannerSink.this.timer.cancel();
                    ScannerSink.this.portsBindedLatch.countDown();
                }
            };
            this.timer.schedule(this.task, this.startingTimeout);
        }

        @Override
        protected void handleInput(String str) {
            super.handleInput(str);
            if (this.portsBindedLatch.getCount() != 0L) {
                if (UCCWrapper.this.conf.getPatterns().getObserverPortPattern() != null) {
                    this.matcher = UCCWrapper.this.conf.getPatterns().getObserverPortPattern().matcher(str);
                    if (this.matcher.find()) {
                        UCCWrapper.this.observerPort = Integer.parseInt(this.matcher.group(1));
                    }
                }
                if (UCCWrapper.this.conf.getPatterns().getControlPortPattern() != null) {
                    this.matcher = UCCWrapper.this.conf.getPatterns().getControlPortPattern().matcher(str);
                    if (this.matcher.find()) {
                        this.controlPort = Integer.parseInt(this.matcher.group(1));
                    }
                }
                if (UCCWrapper.this.conf.getPatterns().getBotPortPattern() != null) {
                    this.matcher = UCCWrapper.this.conf.getPatterns().getBotPortPattern().matcher(str);
                    if (this.matcher.find()) {
                        this.botsPort = Integer.parseInt(this.matcher.group(1));
                        this.raiseLatch();
                    }
                }
                if (UCCWrapper.this.conf.getPatterns().getCommandletNotFoundPattern() != null) {
                    this.matcher = UCCWrapper.this.conf.getPatterns().getCommandletNotFoundPattern().matcher(str);
                    if (this.matcher.find()) {
                        this.exception = new UCCStartException("UCC failed to start due to: Commandlet server not found.", (Object)this);
                        this.raiseLatch();
                    }
                }
                if (UCCWrapper.this.conf.getPatterns().getMapNotFoundPattern() != null) {
                    this.matcher = UCCWrapper.this.conf.getPatterns().getMapNotFoundPattern().matcher(str);
                    if (this.matcher.find()) {
                        this.exception = new UCCStartException("UCC failed to start due to: Map not found.", (Object)this);
                        this.raiseLatch();
                    }
                }
                if (UCCWrapper.this.conf.getPatterns().getExitingErrorPattern() != null) {
                    this.matcher = UCCWrapper.this.conf.getPatterns().getExitingErrorPattern().matcher(str);
                    if (this.matcher.find()) {
                        this.exception = new UCCStartException("UCC failed to start to due to some error.", (Object)this);
                        this.raiseLatch();
                    }
                }
                if (UCCWrapper.this.conf.getPatterns().getMatchStartedPattern() != null) {
                    this.matcher = UCCWrapper.this.conf.getPatterns().getMatchStartedPattern().matcher(str);
                    if (this.matcher.find()) {
                        this.raiseLatch();
                    }
                } else {
                    this.exception = new UCCStartException("conf.getPatterns().getMatchStartedPattern() is NULL, there is no way how to recognize successful UCC startup.", (Object)this);
                    this.raiseLatch();
                }
            } else if (UCCWrapper.this.conf.getPatterns().getGameEndingPattern() != null) {
                this.matcher = UCCWrapper.this.conf.getPatterns().getGameEndingPattern().matcher(str);
                if (this.matcher.find()) {
                    UCCWrapper.this.gameEnding.setFlag(true);
                }
            }
        }

        protected void raiseLatch() {
            this.timer.cancel();
            this.task.cancel();
            this.portsBindedLatch.countDown();
        }
    }

    protected class StreamSink
    extends Thread {
        protected InputStream os = null;

        public StreamSink(InputStream os2) {
            this.setName("UCC Stream handler");
            this.os = os2;
        }

        protected void handleInput(String str) {
            if (UCCWrapper.this.uccLog.isLoggable(Level.INFO)) {
                UCCWrapper.this.uccLog.info("ID" + UCCWrapper.this.uccWrapperUID + " " + str);
            }
        }

        @Override
        public void run() {
            BufferedReader stdInput = new BufferedReader(new InputStreamReader(this.os));
            String s = null;
            try {
                while ((s = stdInput.readLine()) != null) {
                    this.handleInput(s);
                }
                this.os.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

