/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.AugmentedSource;
import net.sf.saxon.CollectionURIResolver;
import net.sf.saxon.Controller;
import net.sf.saxon.OutputURIResolver;
import net.sf.saxon.Platform;
import net.sf.saxon.SourceResolver;
import net.sf.saxon.StandardErrorListener;
import net.sf.saxon.StandardURIResolver;
import net.sf.saxon.Version;
import net.sf.saxon.event.Builder;
import net.sf.saxon.event.ContentHandlerProxy;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.Sender;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.event.SerializerFactory;
import net.sf.saxon.event.StandardOutputResolver;
import net.sf.saxon.evpull.PullEventSource;
import net.sf.saxon.expr.Optimizer;
import net.sf.saxon.expr.PathMap;
import net.sf.saxon.expr.PendingUpdateList;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.ExtensionFunctionFactory;
import net.sf.saxon.functions.FunctionLibrary;
import net.sf.saxon.functions.StandardCollectionURIResolver;
import net.sf.saxon.functions.VendorFunctionLibrary;
import net.sf.saxon.instruct.Debugger;
import net.sf.saxon.instruct.SlotManager;
import net.sf.saxon.java.JavaPlatform;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.DocumentNumberAllocator;
import net.sf.saxon.om.DocumentPool;
import net.sf.saxon.om.ExternalObjectModel;
import net.sf.saxon.om.Name10Checker;
import net.sf.saxon.om.Name11Checker;
import net.sf.saxon.om.NameChecker;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Validation;
import net.sf.saxon.pull.PullProvider;
import net.sf.saxon.pull.PullSource;
import net.sf.saxon.query.ModuleURIResolver;
import net.sf.saxon.query.QueryParser;
import net.sf.saxon.query.StandardModuleURIResolver;
import net.sf.saxon.sort.CollationURIResolver;
import net.sf.saxon.sort.StandardCollationURIResolver;
import net.sf.saxon.sort.StringCollator;
import net.sf.saxon.sxpath.IndependentContext;
import net.sf.saxon.tinytree.TinyBuilder;
import net.sf.saxon.trace.TraceListener;
import net.sf.saxon.trans.DynamicLoader;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.TreeBuilder;
import net.sf.saxon.type.BuiltInType;
import net.sf.saxon.type.ExternalObjectType;
import net.sf.saxon.type.SchemaDeclaration;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SchemaURIResolver;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.ValidationException;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.DefaultHandler2;
import org.xml.sax.ext.LexicalHandler;

public class Configuration
implements Serializable,
SourceResolver {
    private static Platform platform;
    private transient URIResolver uriResolver;
    private StandardURIResolver systemURIResolver = new StandardURIResolver(this);
    protected transient ErrorListener listener;
    private int xmlVersion = 10;
    protected int xsdlVersion = XSD10;
    private int treeModel = 1;
    private boolean lineNumbering = false;
    private boolean tracing = false;
    private boolean traceOptimizations = false;
    private transient TraceListener traceListener = null;
    private String traceListenerClass = null;
    private FunctionLibrary javaExtensionBinder;
    private FunctionLibrary dotNetExtensionBinder;
    private transient ExtensionFunctionFactory javaExtensionFunctionFactory;
    private transient ExtensionFunctionFactory dotNetExtensionFunctionFactory;
    private CollationURIResolver collationResolver = StandardCollationURIResolver.getInstance();
    private CollectionURIResolver collectionResolver = new StandardCollectionURIResolver();
    private ModuleURIResolver moduleURIResolver = null;
    private ModuleURIResolver standardModuleURIResolver = StandardModuleURIResolver.getInstance();
    private SchemaURIResolver schemaURIResolver = null;
    private transient SourceResolver sourceResolver = this;
    protected VendorFunctionLibrary vendorFunctionLibrary;
    protected int recoveryPolicy = 1;
    private String messageEmitterClass = "net.sf.saxon.event.MessageEmitter";
    private String sourceParserClass;
    private String styleParserClass;
    private boolean preferJaxpParser;
    private transient OutputURIResolver outputURIResolver;
    private boolean timing = false;
    private boolean versionWarning = false;
    private boolean allowExternalFunctions = true;
    private boolean traceExternalFunctions = false;
    private boolean validation = false;
    private boolean allNodesUntyped = false;
    private boolean lazyConstructionMode = false;
    private boolean allowMultiThreading = false;
    private boolean preEvaluateDocFunction = false;
    private boolean useXsiSchemaLocation = true;
    private int stripsWhiteSpace = 1;
    private boolean xIncludeAware = false;
    private boolean useDisableOutputEscaping = false;
    private NamePool namePool = null;
    private DocumentNumberAllocator documentNumberAllocator = new DocumentNumberAllocator();
    private DocumentPool globalDocumentPool = new DocumentPool();
    private transient XPathContext conversionContext = null;
    private transient TypeHierarchy typeHierarchy;
    private int hostLanguage = 50;
    private int schemaValidationMode = 3;
    private boolean validationWarnings = false;
    private boolean expandDefaultAttributes = true;
    private boolean retainDTDattributeTypes = false;
    private transient Debugger debugger = null;
    protected Optimizer optimizer = null;
    private transient DynamicLoader dynamicLoader = new DynamicLoader();
    private SerializerFactory serializerFactory = new SerializerFactory();
    private transient List sourceParserPool = new ArrayList(5);
    private transient List styleParserPool = new ArrayList(5);
    private static List sharedExternalObjectModels;
    private List externalObjectModels = null;
    private int domLevel = 3;
    public static final int RECOVER_SILENTLY = 0;
    public static final int RECOVER_WITH_WARNINGS = 1;
    public static final int DO_NOT_RECOVER = 2;
    public static final int XML10 = 10;
    public static final int XML11 = 11;
    public static final int XSLT = 50;
    public static final int XQUERY = 51;
    public static final int XML_SCHEMA = 52;
    public static final int JAVA_APPLICATION = 53;
    public static final int XPATH = 54;
    public static int XSD10;
    public static int XSD11;
    private static LexicalHandler dummyLexicalHandler;

    public Configuration() {
        this.init();
    }

    public static Configuration makeConfiguration(ClassLoader classLoader, String className) {
        try {
            Configuration c = Configuration.makeSchemaAwareConfiguration(classLoader, className);
            if (c.isSchemaAware(52)) {
                return c;
            }
            return new Configuration();
        }
        catch (RuntimeException err) {
            return new Configuration();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void init() {
        platform.initialize(this);
        if (platform.isDotNet()) {
            this.externalObjectModels = new ArrayList(3);
        } else {
            Class clazz = Configuration.class;
            synchronized (clazz) {
                if (sharedExternalObjectModels == null) {
                    this.registerStandardObjectModels();
                }
                this.externalObjectModels = new ArrayList(sharedExternalObjectModels);
            }
        }
        this.namePool = new NamePool();
        platform.makeExtensionLibrary(this);
    }

    public static Configuration makeSchemaAwareConfiguration(ClassLoader classLoader, String className) throws RuntimeException {
        if (className == null) {
            className = "com.saxonica.validate.SchemaAwareConfiguration";
        }
        try {
            Class<?> theClass;
            ClassLoader loader = classLoader;
            if (loader == null) {
                try {
                    loader = Thread.currentThread().getContextClassLoader();
                }
                catch (Exception err) {
                    System.err.println("Failed to getContextClassLoader() - continuing");
                }
            }
            if (loader != null) {
                try {
                    theClass = loader.loadClass(className);
                }
                catch (Exception ex) {
                    theClass = Class.forName(className);
                }
            } else {
                theClass = Class.forName(className);
            }
            return (Configuration)theClass.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public Configuration copy() {
        Configuration c = new Configuration();
        this.copyTo(c);
        return c;
    }

    protected void copyTo(Configuration c) {
        c.uriResolver = this.uriResolver;
        c.systemURIResolver = this.systemURIResolver;
        c.listener = this.listener;
        c.xmlVersion = this.xmlVersion;
        c.treeModel = this.treeModel;
        c.lineNumbering = this.lineNumbering;
        c.tracing = this.tracing;
        c.traceOptimizations = this.traceOptimizations;
        c.traceListener = this.traceListener;
        c.javaExtensionBinder = this.javaExtensionBinder;
        c.dotNetExtensionBinder = this.dotNetExtensionBinder;
        c.javaExtensionFunctionFactory = this.javaExtensionFunctionFactory;
        c.dotNetExtensionFunctionFactory = this.dotNetExtensionFunctionFactory;
        c.collationResolver = this.collationResolver;
        c.collectionResolver = this.collectionResolver;
        c.moduleURIResolver = this.moduleURIResolver;
        c.standardModuleURIResolver = this.standardModuleURIResolver;
        c.schemaURIResolver = this.schemaURIResolver;
        c.sourceResolver = this.sourceResolver;
        c.vendorFunctionLibrary = this.vendorFunctionLibrary;
        c.recoveryPolicy = this.recoveryPolicy;
        c.messageEmitterClass = this.messageEmitterClass;
        c.sourceParserClass = this.sourceParserClass;
        c.styleParserClass = this.styleParserClass;
        c.outputURIResolver = this.outputURIResolver;
        c.timing = this.timing;
        c.versionWarning = this.versionWarning;
        c.allowExternalFunctions = this.allowExternalFunctions;
        c.validation = this.validation;
        c.allNodesUntyped = this.allNodesUntyped;
        c.lazyConstructionMode = this.lazyConstructionMode;
        c.allowMultiThreading = this.allowMultiThreading;
        c.preEvaluateDocFunction = this.preEvaluateDocFunction;
        c.stripsWhiteSpace = this.stripsWhiteSpace;
        c.xIncludeAware = this.xIncludeAware;
        c.namePool = this.namePool;
        c.documentNumberAllocator = this.documentNumberAllocator;
        c.conversionContext = this.conversionContext;
        c.typeHierarchy = this.typeHierarchy;
        c.hostLanguage = this.hostLanguage;
        c.schemaValidationMode = this.schemaValidationMode;
        c.validationWarnings = this.validationWarnings;
        c.expandDefaultAttributes = this.expandDefaultAttributes;
        c.retainDTDattributeTypes = this.retainDTDattributeTypes;
        c.debugger = this.debugger;
        c.optimizer = this.optimizer;
        c.serializerFactory = this.serializerFactory;
        c.dynamicLoader = this.dynamicLoader;
        c.sourceParserPool = this.sourceParserPool;
        c.externalObjectModels = this.externalObjectModels;
        c.domLevel = this.domLevel;
    }

    public String getProductTitle() {
        return "Saxon " + Version.getProductVersion() + platform.getPlatformSuffix() + " from Saxonica";
    }

    public boolean isSchemaAware(int language) {
        return false;
    }

    public void displayLicenseMessage() {
    }

    public int getHostLanguage() {
        return this.hostLanguage;
    }

    public void setHostLanguage(int hostLanguage) {
        this.hostLanguage = hostLanguage;
    }

    public static Platform getPlatform() {
        return platform;
    }

    public void setDynamicLoader(DynamicLoader dynamicLoader) {
        this.dynamicLoader = dynamicLoader;
    }

    public DynamicLoader getDynamicLoader() {
        return this.dynamicLoader;
    }

    public Class getClass(String className, boolean tracing, ClassLoader classLoader) throws XPathException {
        return this.dynamicLoader.getClass(className, tracing, classLoader);
    }

    public Object getInstance(String className, ClassLoader classLoader) throws XPathException {
        return this.dynamicLoader.getInstance(className, this.isTiming(), classLoader);
    }

    public URIResolver getURIResolver() {
        if (this.uriResolver == null) {
            return this.systemURIResolver;
        }
        return this.uriResolver;
    }

    public void setURIResolver(URIResolver resolver) {
        this.uriResolver = resolver;
        if (resolver instanceof StandardURIResolver) {
            ((StandardURIResolver)resolver).setConfiguration(this);
        }
    }

    public void setParameterizedURIResolver() {
        this.getSystemURIResolver().setRecognizeQueryParameters(true);
    }

    public StandardURIResolver getSystemURIResolver() {
        return this.systemURIResolver;
    }

    public URIResolver makeURIResolver(String className) throws TransformerException {
        Object obj = this.dynamicLoader.getInstance(className, null);
        if (obj instanceof StandardURIResolver) {
            ((StandardURIResolver)obj).setConfiguration(this);
        }
        if (obj instanceof URIResolver) {
            return (URIResolver)obj;
        }
        throw new XPathException("Class " + className + " is not a URIResolver");
    }

    public ErrorListener getErrorListener() {
        if (this.listener == null) {
            this.listener = new StandardErrorListener();
            ((StandardErrorListener)this.listener).setRecoveryPolicy(this.recoveryPolicy);
        }
        return this.listener;
    }

    public void setErrorListener(ErrorListener listener) {
        this.listener = listener;
    }

    public void reportFatalError(XPathException err) {
        if (!err.hasBeenReported()) {
            try {
                this.getErrorListener().fatalError(err);
            }
            catch (TransformerException transformerException) {
                // empty catch block
            }
            err.setHasBeenReported();
        }
    }

    public void setMultiThreading(boolean multithreading) {
        this.allowMultiThreading = multithreading;
    }

    public boolean isMultiThreading() {
        return this.allowMultiThreading;
    }

    public void setXMLVersion(int version) {
        this.xmlVersion = version;
    }

    public int getXMLVersion() {
        return this.xmlVersion;
    }

    public NameChecker getNameChecker() {
        return this.xmlVersion == 10 ? Name10Checker.getInstance() : Name11Checker.getInstance();
    }

    public XPathContext getConversionContext() {
        if (this.conversionContext == null) {
            this.conversionContext = new IndependentContext(this).makeEarlyEvaluationContext();
        }
        return this.conversionContext;
    }

    public int getTreeModel() {
        return this.treeModel;
    }

    public void setTreeModel(int treeModel) {
        this.treeModel = treeModel;
    }

    public boolean isLineNumbering() {
        return this.lineNumbering;
    }

    public void setLineNumbering(boolean lineNumbering) {
        this.lineNumbering = lineNumbering;
    }

    public void setXIncludeAware(boolean state) {
        this.xIncludeAware = state;
    }

    public boolean isXIncludeAware() {
        return this.xIncludeAware;
    }

    public TraceListener getTraceListener() {
        return this.traceListener;
    }

    public TraceListener makeTraceListener() throws XPathException {
        if (this.traceListener != null) {
            return this.traceListener;
        }
        if (this.traceListenerClass != null) {
            try {
                return this.makeTraceListener(this.traceListenerClass);
            }
            catch (ClassCastException e) {
                throw new XPathException(e);
            }
        }
        return null;
    }

    public void setTraceListener(TraceListener traceListener) {
        this.traceListener = traceListener;
        this.setCompileWithTracing(true);
        this.setMultiThreading(false);
    }

    public void setTraceListenerClass(String className) {
        try {
            this.makeTraceListener(className);
        }
        catch (XPathException err) {
            throw new IllegalArgumentException(className + ": " + err.getMessage());
        }
        this.traceListenerClass = className;
        this.setCompileWithTracing(true);
    }

    public String getTraceListenerClass() {
        return this.traceListenerClass;
    }

    public boolean isCompileWithTracing() {
        return this.tracing;
    }

    public void setCompileWithTracing(boolean trace) {
        this.tracing = trace;
    }

    public void setOptimizerTracing(boolean trace) {
        this.traceOptimizations = trace;
    }

    public boolean isOptimizerTracing() {
        return this.traceOptimizations;
    }

    public TraceListener makeTraceListener(String className) throws XPathException {
        Object obj = this.dynamicLoader.getInstance(className, null);
        if (obj instanceof TraceListener) {
            return (TraceListener)obj;
        }
        throw new XPathException("Class " + className + " is not a TraceListener");
    }

    public void setExtensionBinder(String scheme, FunctionLibrary binder) {
        if (scheme.equals("java")) {
            this.javaExtensionBinder = binder;
        } else if (scheme.equals("clitype")) {
            this.dotNetExtensionBinder = binder;
        } else {
            throw new IllegalArgumentException("Unknown scheme " + scheme + " - must be java or clitype");
        }
    }

    public FunctionLibrary getExtensionBinder(String scheme) {
        if (scheme.equals("java")) {
            return this.javaExtensionBinder;
        }
        if (scheme.equals("clitype")) {
            return this.dotNetExtensionBinder;
        }
        throw new IllegalArgumentException("Unknown scheme " + scheme + " - must be java or clitype");
    }

    public VendorFunctionLibrary getVendorFunctionLibrary() {
        if (this.vendorFunctionLibrary == null) {
            this.vendorFunctionLibrary = new VendorFunctionLibrary();
        }
        return this.vendorFunctionLibrary;
    }

    public void setCollationURIResolver(CollationURIResolver resolver) {
        this.collationResolver = resolver;
    }

    public CollationURIResolver getCollationURIResolver() {
        return this.collationResolver;
    }

    public void setCollectionURIResolver(CollectionURIResolver resolver) {
        this.collectionResolver = resolver;
    }

    public CollectionURIResolver getCollectionURIResolver() {
        return this.collectionResolver;
    }

    public void setModuleURIResolver(ModuleURIResolver resolver) {
        this.moduleURIResolver = resolver;
    }

    public void setModuleURIResolver(String className) throws TransformerException {
        Object obj = this.dynamicLoader.getInstance(className, null);
        if (!(obj instanceof ModuleURIResolver)) {
            throw new XPathException("Class " + className + " is not a LocationHintResolver");
        }
        this.setModuleURIResolver((ModuleURIResolver)obj);
    }

    public ModuleURIResolver getModuleURIResolver() {
        return this.moduleURIResolver;
    }

    public ModuleURIResolver getStandardModuleURIResolver() {
        return this.standardModuleURIResolver;
    }

    public void setSchemaURIResolver(SchemaURIResolver resolver) {
        this.schemaURIResolver = resolver;
    }

    public SchemaURIResolver getSchemaURIResolver() {
        return this.schemaURIResolver;
    }

    public int getRecoveryPolicy() {
        return this.recoveryPolicy;
    }

    public void setRecoveryPolicy(int recoveryPolicy) {
        this.recoveryPolicy = recoveryPolicy;
    }

    public String getMessageEmitterClass() {
        return this.messageEmitterClass;
    }

    public void setMessageEmitterClass(String messageEmitterClass) {
        this.messageEmitterClass = messageEmitterClass;
    }

    public String getSourceParserClass() {
        return this.sourceParserClass;
    }

    public void setSourceParserClass(String sourceParserClass) {
        this.sourceParserClass = sourceParserClass;
    }

    public String getStyleParserClass() {
        return this.styleParserClass;
    }

    public void setStyleParserClass(String styleParserClass) {
        this.styleParserClass = styleParserClass;
    }

    public OutputURIResolver getOutputURIResolver() {
        if (this.outputURIResolver == null) {
            this.outputURIResolver = StandardOutputResolver.getInstance();
        }
        return this.outputURIResolver;
    }

    public void setOutputURIResolver(OutputURIResolver outputURIResolver) {
        this.outputURIResolver = outputURIResolver;
    }

    public void setSerializerFactory(SerializerFactory factory) {
        this.serializerFactory = factory;
    }

    public SerializerFactory getSerializerFactory() {
        return this.serializerFactory;
    }

    public boolean isTiming() {
        return this.timing;
    }

    public void setTiming(boolean timing) {
        this.timing = timing;
    }

    public boolean isVersionWarning() {
        return this.versionWarning;
    }

    public void setVersionWarning(boolean warn) {
        this.versionWarning = warn;
    }

    public boolean isAllowExternalFunctions() {
        return this.allowExternalFunctions;
    }

    public void setAllowExternalFunctions(boolean allowExternalFunctions) {
        this.allowExternalFunctions = allowExternalFunctions;
    }

    public boolean isTraceExternalFunctions() {
        return this.traceExternalFunctions;
    }

    public void setRetainDTDAttributeTypes(boolean useTypes) throws TransformerFactoryConfigurationError {
        if (useTypes && !this.isSchemaAware(52)) {
            throw new TransformerFactoryConfigurationError("Retaining DTD attribute types requires the schema-aware product");
        }
        this.retainDTDattributeTypes = useTypes;
    }

    public boolean isRetainDTDAttributeTypes() {
        return this.retainDTDattributeTypes;
    }

    public void setTraceExternalFunctions(boolean traceExternalFunctions) {
        this.traceExternalFunctions = traceExternalFunctions;
    }

    public ExtensionFunctionFactory getExtensionFunctionFactory(String scheme) {
        if ("java".equals(scheme)) {
            return this.javaExtensionFunctionFactory;
        }
        if ("clitype".equals(scheme)) {
            return this.dotNetExtensionFunctionFactory;
        }
        throw new IllegalArgumentException("Unknown extension function scheme");
    }

    public void setExtensionFunctionFactory(String scheme, ExtensionFunctionFactory factory) {
        if ("java".equals(scheme)) {
            this.javaExtensionFunctionFactory = factory;
        } else if ("clitype".equals(scheme)) {
            this.dotNetExtensionFunctionFactory = factory;
        } else {
            throw new IllegalArgumentException("Unknown extension function scheme");
        }
    }

    public boolean isValidation() {
        return this.validation;
    }

    public void setValidation(boolean validation) {
        this.validation = validation;
    }

    public void setAllNodesUntyped(boolean allUntyped) {
        this.allNodesUntyped = allUntyped;
    }

    public boolean areAllNodesUntyped() {
        return this.allNodesUntyped;
    }

    public ProxyReceiver makeDocumentProjector(PathMap.PathMapRoot map) {
        throw new UnsupportedOperationException("Document projection requires a schema-aware Configuration");
    }

    public int getSchemaValidationMode() {
        return this.schemaValidationMode;
    }

    public void setSchemaValidationMode(int validationMode) {
        switch (validationMode) {
            case 3: 
            case 4: {
                break;
            }
            case 1: 
            case 2: {
                if (this.isSchemaAware(52)) break;
                this.needSchemaAwareVersion();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported validation mode " + validationMode);
            }
        }
        this.schemaValidationMode = validationMode;
    }

    public void setValidationWarnings(boolean warn) {
        this.validationWarnings = warn;
    }

    public boolean isValidationWarnings() {
        return this.validationWarnings;
    }

    public void setExpandAttributeDefaults(boolean expand) {
        this.expandDefaultAttributes = expand;
    }

    public boolean isExpandAttributeDefaults() {
        return this.expandDefaultAttributes;
    }

    public NamePool getNamePool() {
        return this.namePool;
    }

    public void setNamePool(NamePool targetNamePool) {
        this.namePool = targetNamePool;
    }

    public final TypeHierarchy getTypeHierarchy() {
        if (this.typeHierarchy == null) {
            this.typeHierarchy = new TypeHierarchy(this);
        }
        return this.typeHierarchy;
    }

    public DocumentNumberAllocator getDocumentNumberAllocator() {
        return this.documentNumberAllocator;
    }

    public void setDocumentNumberAllocator(DocumentNumberAllocator allocator) {
        this.documentNumberAllocator = allocator;
    }

    public boolean isCompatible(Configuration other) {
        return this.namePool == other.namePool && this.documentNumberAllocator == other.documentNumberAllocator;
    }

    public DocumentPool getGlobalDocumentPool() {
        return this.globalDocumentPool;
    }

    public boolean isStripsAllWhiteSpace() {
        return this.stripsWhiteSpace == 2;
    }

    public void setStripsAllWhiteSpace(boolean stripsAllWhiteSpace) {
        if (stripsAllWhiteSpace) {
            this.stripsWhiteSpace = 2;
        }
    }

    public void setStripsWhiteSpace(int kind) {
        this.stripsWhiteSpace = kind;
    }

    public int getStripsWhiteSpace() {
        return this.stripsWhiteSpace;
    }

    public synchronized XMLReader getSourceParser() throws TransformerFactoryConfigurationError {
        if (this.sourceParserPool == null) {
            this.sourceParserPool = new ArrayList(10);
        }
        if (!this.sourceParserPool.isEmpty()) {
            int n = this.sourceParserPool.size() - 1;
            XMLReader parser2 = (XMLReader)this.sourceParserPool.get(n);
            this.sourceParserPool.remove(n);
            return parser2;
        }
        XMLReader parser3 = this.getSourceParserClass() != null ? this.makeParser(this.getSourceParserClass()) : this.loadParser();
        try {
            Sender.configureParser(parser3);
        }
        catch (XPathException err) {
            throw new TransformerFactoryConfigurationError(err);
        }
        if (this.isValidation()) {
            try {
                parser3.setFeature("http://xml.org/sax/features/validation", true);
            }
            catch (SAXException err) {
                throw new TransformerFactoryConfigurationError("The XML parser does not support validation");
            }
        }
        return parser3;
    }

    public synchronized void reuseSourceParser(XMLReader parser2) {
        if (this.sourceParserPool == null) {
            this.sourceParserPool = new ArrayList(10);
        }
        try {
            parser2.setContentHandler(null);
            parser2.setEntityResolver(null);
            parser2.setDTDHandler(null);
            parser2.setErrorHandler(null);
            parser2.setProperty("http://xml.org/sax/properties/lexical-handler", dummyLexicalHandler);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.sourceParserPool.add(parser2);
    }

    private XMLReader loadParser() {
        XMLReader parser2;
        try {
            parser2 = SAXParserFactory.newInstance().newSAXParser().getXMLReader();
        }
        catch (ParserConfigurationException err) {
            throw new TransformerFactoryConfigurationError(err);
        }
        catch (SAXException err) {
            throw new TransformerFactoryConfigurationError(err);
        }
        return parser2;
    }

    public synchronized XMLReader getStyleParser() throws TransformerFactoryConfigurationError {
        if (this.styleParserPool == null) {
            this.styleParserPool = new ArrayList(10);
        }
        if (!this.styleParserPool.isEmpty()) {
            int n = this.styleParserPool.size() - 1;
            XMLReader parser2 = (XMLReader)this.styleParserPool.get(n);
            this.styleParserPool.remove(n);
            return parser2;
        }
        XMLReader parser3 = this.getStyleParserClass() != null ? this.makeParser(this.getStyleParserClass()) : this.loadParser();
        try {
            parser3.setFeature("http://xml.org/sax/features/namespaces", true);
            parser3.setFeature("http://xml.org/sax/features/namespace-prefixes", false);
        }
        catch (SAXNotRecognizedException e) {
            throw new TransformerFactoryConfigurationError(e);
        }
        catch (SAXNotSupportedException e) {
            throw new TransformerFactoryConfigurationError(e);
        }
        return parser3;
    }

    public synchronized void reuseStyleParser(XMLReader parser2) {
        if (this.styleParserPool == null) {
            this.styleParserPool = new ArrayList(10);
        }
        try {
            parser2.setContentHandler(null);
            parser2.setEntityResolver(null);
            parser2.setDTDHandler(null);
            parser2.setErrorHandler(null);
            parser2.setProperty("http://xml.org/sax/properties/lexical-handler", dummyLexicalHandler);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.styleParserPool.add(parser2);
    }

    public void loadSchema(String absoluteURI) throws SchemaException {
        this.readSchema(this.makePipelineConfiguration(), "", absoluteURI, null);
    }

    public String readSchema(PipelineConfiguration pipe, String baseURI, String schemaLocation, String expected) throws SchemaException {
        this.needSchemaAwareVersion();
        return null;
    }

    public void readMultipleSchemas(PipelineConfiguration pipe, String baseURI, Collection schemaLocations, String expected) throws SchemaException {
        this.needSchemaAwareVersion();
    }

    public String readInlineSchema(NodeInfo root, String expected, ErrorListener errorListener) throws SchemaException {
        this.needSchemaAwareVersion();
        return null;
    }

    private void needSchemaAwareVersion() {
        throw new UnsupportedOperationException("You need the schema-aware version of Saxon for this operation");
    }

    public void addSchemaSource(Source schemaSource) throws SchemaException {
        this.addSchemaSource(schemaSource, this.getErrorListener());
    }

    public void addSchemaSource(Source schemaSource, ErrorListener errorListener) throws SchemaException {
        this.needSchemaAwareVersion();
    }

    public boolean isSchemaAvailable(String targetNamespace) {
        return false;
    }

    public Set getImportedNamespaces() {
        return Collections.EMPTY_SET;
    }

    public void sealNamespace(String namespace) {
    }

    public Iterator getExtensionsOfType(SchemaType type) {
        return Collections.EMPTY_SET.iterator();
    }

    public void importComponents(Source source) throws XPathException {
        this.needSchemaAwareVersion();
    }

    public void exportComponents(Receiver out) throws XPathException {
        this.needSchemaAwareVersion();
    }

    public SchemaDeclaration getElementDeclaration(int fingerprint) {
        return null;
    }

    public SchemaDeclaration getAttributeDeclaration(int fingerprint) {
        return null;
    }

    public SchemaType getSchemaType(int fingerprint) {
        if (fingerprint < 1023) {
            return BuiltInType.getSchemaType(fingerprint);
        }
        if (this.getNamePool().getURI(fingerprint).equals("http://saxon.sf.net/java-type")) {
            try {
                Class namedClass = this.dynamicLoader.getClass(this.getNamePool().getLocalName(fingerprint), false, null);
                if (namedClass == null) {
                    return null;
                }
                return new ExternalObjectType(namedClass, this);
            }
            catch (XPathException err) {
                return null;
            }
        }
        return null;
    }

    public void checkTypeDerivationIsOK(SchemaType derived, SchemaType base, int block) throws SchemaException, ValidationException {
    }

    public Receiver getDocumentValidator(Receiver receiver, String systemId, int validationMode, int stripSpace, SchemaType schemaType, int topLevelElementName) {
        return receiver;
    }

    public SequenceReceiver getElementValidator(SequenceReceiver receiver, int nameCode, int locationId, SchemaType schemaType, int validation) throws XPathException {
        return receiver;
    }

    public int validateAttribute(int nameCode, CharSequence value, int validation) throws ValidationException {
        return 631;
    }

    public Receiver getAnnotationStripper(Receiver destination) {
        return destination;
    }

    public XMLReader makeParser(String className) throws TransformerFactoryConfigurationError {
        Object obj;
        try {
            obj = this.dynamicLoader.getInstance(className, null);
        }
        catch (XPathException err) {
            throw new TransformerFactoryConfigurationError(err);
        }
        if (obj instanceof XMLReader) {
            return (XMLReader)obj;
        }
        throw new TransformerFactoryConfigurationError("Class " + className + " is not a SAX2 XMLReader");
    }

    public static Locale getLocale(String lang) {
        String country;
        String language;
        int hyphen = lang.indexOf("-");
        if (hyphen < 1) {
            language = lang;
            country = "";
        } else {
            language = lang.substring(1, hyphen);
            country = lang.substring(hyphen + 1);
        }
        return new Locale(language, country);
    }

    public void setDebugger(Debugger debugger) {
        this.debugger = debugger;
    }

    public Debugger getDebugger() {
        return this.debugger;
    }

    public SlotManager makeSlotManager() {
        if (this.debugger == null) {
            return new SlotManager();
        }
        return this.debugger.makeSlotManager();
    }

    public Optimizer getOptimizer() {
        if (this.optimizer == null) {
            this.optimizer = new Optimizer(this);
        }
        return this.optimizer;
    }

    public StringCollator makeCollator(String className) throws XPathException {
        Object handler = this.dynamicLoader.getInstance(className, null);
        if (handler instanceof StringCollator) {
            return (StringCollator)handler;
        }
        throw new XPathException("Failed to load collation class " + className + ": it is not an instance of net.sf.saxon.sort.StringCollator");
    }

    public void setLazyConstructionMode(boolean lazy) {
        this.lazyConstructionMode = lazy;
    }

    public boolean isLazyConstructionMode() {
        return this.lazyConstructionMode;
    }

    private void registerStandardObjectModels() {
        String[] models = new String[]{"net.sf.saxon.dom.DOMEnvelope", "net.sf.saxon.dom.DOMObjectModel", "net.sf.saxon.jdom.JDOMObjectModel", "net.sf.saxon.xom.XOMObjectModel", "net.sf.saxon.dom4j.DOM4JObjectModel"};
        String[] nodes = new String[]{"net.sf.saxon.dom.NodeOverNodeInfo", "org.w3c.dom.Node", "org.jdom.Element", "nu.xom.Node", "org.dom4j.Element"};
        sharedExternalObjectModels = new ArrayList(4);
        for (int i = 0; i < models.length; ++i) {
            try {
                this.dynamicLoader.getClass(nodes[i], false, null);
                ExternalObjectModel model = (ExternalObjectModel)this.dynamicLoader.getInstance(models[i], null);
                sharedExternalObjectModels.add(model);
                continue;
            }
            catch (XPathException err) {
                continue;
            }
            catch (ClassCastException err) {
                System.err.println("Warning: external object model " + models[i] + " has been loaded, but is not an instance of net.sf.saxon.om.ExternalObjectModel");
                continue;
            }
            catch (Throwable err) {
                System.err.println("Warning: failed to load external object model: " + err.getMessage());
            }
        }
    }

    public void registerExternalObjectModel(ExternalObjectModel model) {
        if (this.externalObjectModels == null) {
            this.externalObjectModels = new ArrayList(5);
        }
        if (!this.externalObjectModels.contains(model)) {
            this.externalObjectModels.add(model);
        }
    }

    public ExternalObjectModel getExternalObjectModel(String uri) {
        for (int m = 0; m < this.externalObjectModels.size(); ++m) {
            ExternalObjectModel model = (ExternalObjectModel)this.externalObjectModels.get(m);
            if (!model.getIdentifyingURI().equals(uri)) continue;
            return model;
        }
        return null;
    }

    public List getExternalObjectModels() {
        return this.externalObjectModels;
    }

    public NodeInfo unravel(Source source) {
        List externalObjectModels = this.getExternalObjectModels();
        for (int m = 0; m < externalObjectModels.size(); ++m) {
            ExternalObjectModel model = (ExternalObjectModel)externalObjectModels.get(m);
            NodeInfo node = model.unravel(source, this);
            if (node == null) continue;
            if (node.getConfiguration() != this) {
                throw new IllegalArgumentException("Externally supplied Node belongs to the wrong Configuration");
            }
            return node;
        }
        if (source instanceof NodeInfo) {
            if (((NodeInfo)source).getConfiguration() != this) {
                throw new IllegalArgumentException("Externally supplied NodeInfo belongs to the wrong Configuration");
            }
            return (NodeInfo)source;
        }
        if (source instanceof DOMSource) {
            throw new IllegalArgumentException("When a DOMSource is used, saxon9-dom.jar must be on the classpath");
        }
        throw new IllegalArgumentException("A source of class " + source.getClass() + " is not recognized by any registered object model");
    }

    public void setDOMLevel(int level) {
        if (level != 2 && level != 3) {
            throw new IllegalArgumentException("DOM Level must be 2 or 3");
        }
        this.domLevel = level;
    }

    public int getDOMLevel() {
        return this.domLevel;
    }

    public QueryParser newQueryParser(boolean updating) {
        if (updating) {
            throw new UnsupportedOperationException("XQuery Update is supported only in Saxon-SA");
        }
        return new QueryParser();
    }

    public PendingUpdateList newPendingUpdateList() {
        throw new UnsupportedOperationException("XQuery update is supported only in Saxon-SA");
    }

    public PipelineConfiguration makePipelineConfiguration() {
        PipelineConfiguration pipe = new PipelineConfiguration();
        pipe.setConfiguration(this);
        pipe.setErrorListener(this.getErrorListener());
        pipe.setURIResolver(this.getURIResolver());
        pipe.setSchemaURIResolver(this.getSchemaURIResolver());
        pipe.setHostLanguage(this.getHostLanguage());
        pipe.setExpandAttributeDefaults(this.isExpandAttributeDefaults());
        pipe.setUseXsiSchemaLocation(this.useXsiSchemaLocation);
        return pipe;
    }

    public static Configuration getConfiguration(XPathContext context) {
        return context.getConfiguration();
    }

    public void setSourceResolver(SourceResolver resolver) {
        this.sourceResolver = resolver;
    }

    public SourceResolver getSourceResolver() {
        return this.sourceResolver;
    }

    public Source resolveSource(Source source, Configuration config) throws XPathException {
        if (source instanceof AugmentedSource) {
            return source;
        }
        if (source instanceof StreamSource) {
            return source;
        }
        if (source instanceof SAXSource) {
            return source;
        }
        if (source instanceof DOMSource) {
            return source;
        }
        if (source instanceof NodeInfo) {
            return source;
        }
        if (source instanceof PullProvider) {
            return source;
        }
        if (source instanceof PullSource) {
            return source;
        }
        if (source instanceof PullEventSource) {
            return source;
        }
        return null;
    }

    public DocumentInfo buildDocument(Source source) throws XPathException {
        boolean mustCopy;
        if (source == null) {
            throw new NullPointerException("source");
        }
        if ((source = this.resolveSource(source, this)) == null) {
            throw new XPathException("Unknown source class");
        }
        boolean bl = mustCopy = this.schemaValidationMode != 3 || this.stripsWhiteSpace == 2;
        if (!mustCopy) {
            AugmentedSource asource;
            Source underSource;
            if (source instanceof DocumentInfo) {
                return (DocumentInfo)source;
            }
            if (source instanceof AugmentedSource && ((underSource = (asource = (AugmentedSource)source).getContainedSource()) instanceof DocumentInfo || underSource instanceof DOMSource)) {
                boolean wrap;
                boolean bl2 = wrap = asource.getWrapDocument() == null || asource.getWrapDocument() != false;
                if (asource.getSchemaValidation() != 4) {
                    wrap = false;
                } else if (asource.getStripSpace() != 0) {
                    wrap = false;
                }
                if (wrap) {
                    NodeInfo node = this.unravel(underSource);
                    if (node instanceof DocumentInfo) {
                        return (DocumentInfo)node;
                    }
                    source = node;
                } else {
                    source = underSource;
                }
            }
            if (source instanceof DOMSource) {
                NodeInfo node = this.unravel(source);
                if (node instanceof DocumentInfo) {
                    return (DocumentInfo)node;
                }
                source = node;
            }
        }
        PipelineConfiguration pipe = this.makePipelineConfiguration();
        int treeModel = -1;
        if (source instanceof AugmentedSource) {
            treeModel = ((AugmentedSource)source).getTreeModel();
        }
        if (treeModel == -1) {
            treeModel = this.treeModel;
        }
        Builder b = treeModel == 1 ? new TinyBuilder() : new TreeBuilder();
        b.setPipelineConfiguration(pipe);
        b.setTiming(this.isTiming());
        boolean lineNumbering = this.lineNumbering;
        if (source instanceof AugmentedSource && ((AugmentedSource)source).isLineNumberingSet()) {
            lineNumbering = ((AugmentedSource)source).isLineNumbering();
        }
        b.setLineNumbering(lineNumbering);
        new Sender(pipe).send(source, b);
        DocumentInfo newdoc = (DocumentInfo)b.getCurrentRoot();
        b.reset();
        if (source instanceof AugmentedSource && ((AugmentedSource)source).isPleaseCloseAfterUse()) {
            ((AugmentedSource)source).close();
        }
        return newdoc;
    }

    public Receiver makeEmitter(String clarkName, Controller controller) throws XPathException {
        Object handler;
        int brace = clarkName.indexOf(125);
        String localName = clarkName.substring(brace + 1);
        int colon = localName.indexOf(58);
        String className = localName.substring(colon + 1);
        try {
            handler = this.dynamicLoader.getInstance(className, controller.getClassLoader());
        }
        catch (XPathException e) {
            throw new XPathException("Cannot load user-supplied output method " + className, "SXCH0004");
        }
        if (handler instanceof Receiver) {
            return (Receiver)handler;
        }
        if (handler instanceof ContentHandler) {
            ContentHandlerProxy emitter = new ContentHandlerProxy();
            emitter.setUnderlyingContentHandler((ContentHandler)handler);
            emitter.setOutputProperties(controller.getOutputProperties());
            return emitter;
        }
        throw new XPathException("Failed to load " + className + ": it is neither a Receiver nor a SAX2 ContentHandler");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setConfigurationProperty(String name, Object value) {
        if (name.equals("http://saxon.sf.net/feature/allow-external-functions")) {
            boolean b = this.requireBoolean("ALLOW_EXTERNAL_FUNCTIONS", value);
            this.setAllowExternalFunctions(b);
            return;
        } else if (name.equals("http://saxon.sf.net/feature/collation-uri-resolver")) {
            if (!(value instanceof CollationURIResolver)) {
                throw new IllegalArgumentException("COLLATION_URI_RESOLVER value must be an instance of net.sf.saxon.sort.CollationURIResolver");
            }
            this.setCollationURIResolver((CollationURIResolver)value);
            return;
        } else if (name.equals("http://saxon.sf.net/feature/collation-uri-resolver-class")) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("COLLATION_URI_RESOLVER_CLASS must be a String");
            }
            try {
                Object obj = this.getInstance((String)value, null);
                this.setCollationURIResolver((CollationURIResolver)obj);
                return;
            }
            catch (XPathException err) {
                throw new IllegalArgumentException("Cannot instantiate COLLATION_URI_RESOLVER_CLASS. " + err.getMessage());
            }
            catch (ClassCastException err) {
                throw new IllegalArgumentException("COLLATION_URI_RESOLVER_CLASS does not implement CollationURIResolver");
            }
        } else if (name.equals("http://saxon.sf.net/feature/collection-uri-resolver")) {
            if (!(value instanceof CollectionURIResolver)) {
                throw new IllegalArgumentException("COLLECTION_URI_RESOLVER value must be an instance of net.sf.saxon.CollectionURIResolver");
            }
            this.setCollectionURIResolver((CollectionURIResolver)value);
            return;
        } else if (name.equals("http://saxon.sf.net/feature/collection-uri-resolver-class")) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("COLLECTION_URI_RESOLVER_CLASS must be a String");
            }
            try {
                Object obj = this.getInstance((String)value, null);
                this.setCollectionURIResolver((CollectionURIResolver)obj);
                return;
            }
            catch (XPathException err) {
                throw new IllegalArgumentException("Cannot instantiate COLLECTION_URI_RESOLVER_CLASS. " + err.getMessage());
            }
            catch (ClassCastException err) {
                throw new IllegalArgumentException("COLLECTION_URI_RESOLVER_CLASS does not implement CollectionURIResolver");
            }
        } else if (name.equals("http://saxon.sf.net/feature/compile-with-tracing")) {
            boolean b = this.requireBoolean("COMPILE_WITH_TRACING", value);
            this.setCompileWithTracing(b);
            return;
        } else if (name.equals("http://saxon.sf.net/feature/validation")) {
            boolean b = this.requireBoolean("DTD_VALIDATION", value);
            this.setValidation(b);
            return;
        } else if (name.equals("http://saxon.sf.net/feature/expandAttributeDefaults")) {
            boolean b = this.requireBoolean("EXPAND_ATTRIBUTE_DEFAULTS", value);
            this.setExpandAttributeDefaults(b);
            return;
        } else if (name.equals("http://saxon.sf.net/feature/linenumbering")) {
            boolean b = this.requireBoolean("LINE_NUMBERING", value);
            this.setLineNumbering(b);
            return;
        } else if (name.equals("http://saxon.sf.net/feature/messageEmitterClass")) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("MESSAGE_EMITTER_CLASS class must be a String");
            }
            this.setMessageEmitterClass((String)value);
            return;
        } else if (name.equals("http://saxon.sf.net/feature/moduleURIResolver")) {
            if (!(value instanceof ModuleURIResolver)) {
                throw new IllegalArgumentException("MODULE_URI_RESOLVER value must be an instance of net.sf.saxon.query.ModuleURIResolver");
            }
            this.setModuleURIResolver((ModuleURIResolver)value);
            return;
        } else if (name.equals("http://saxon.sf.net/feature/moduleURIResolverClass")) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("MODULE_URI_RESOLVER_CLASS value must be a string");
            }
            try {
                Object obj = this.getInstance((String)value, null);
                this.setModuleURIResolver((ModuleURIResolver)obj);
                return;
            }
            catch (XPathException err) {
                throw new IllegalArgumentException("Cannot instantiate MODULE_URI_RESOLVER_CLASS. " + err.getMessage());
            }
            catch (ClassCastException err) {
                throw new IllegalArgumentException("MODULE_URI_RESOLVER_RESOLVER_CLASS does not implement ModuleURIResolver");
            }
        } else if (name.equals("http://saxon.sf.net/feature/namePool")) {
            if (!(value instanceof NamePool)) {
                throw new IllegalArgumentException("NAME_POOL value must be an instance of net.sf.saxon.om.NamePool");
            }
            this.setNamePool((NamePool)value);
            return;
        } else if (name.equals("http://saxon.sf.net/feature/outputURIResolver")) {
            if (!(value instanceof OutputURIResolver)) {
                throw new IllegalArgumentException("OUTPUT_URI_RESOLVER value must be an instance of net.sf.saxon.OutputURIResolver");
            }
            this.setOutputURIResolver((OutputURIResolver)value);
            return;
        } else if (name.equals("http://saxon.sf.net/feature/outputURIResolverClass")) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("OUTPUT_URI_RESOLVER_CLASS value must be a string");
            }
            try {
                Object obj = this.getInstance((String)value, null);
                this.setOutputURIResolver((OutputURIResolver)obj);
                return;
            }
            catch (XPathException err) {
                throw new IllegalArgumentException("Cannot instantiate OUTPUT_URI_RESOLVER_CLASS. " + err.getMessage());
            }
            catch (ClassCastException err) {
                throw new IllegalArgumentException("OUTPUT_URI_RESOLVER_RESOLVER_CLASS does not implement OutputURIResolver");
            }
        } else if (name.equals("http://saxon.sf.net/feature/preEvaluateDocFunction")) {
            this.preEvaluateDocFunction = this.requireBoolean("PRE_EVALUATE_DOC_FUNCTION", value);
            return;
        } else if (name.equals("http://saxon.sf.net/feature/preferJaxpParser")) {
            this.preferJaxpParser = this.requireBoolean("PREFER_JAXP_PARSER", value);
            return;
        } else if (name.equals("http://saxon.sf.net/feature/recognize-uri-query-parameters")) {
            if (!(value instanceof Boolean)) {
                throw new IllegalArgumentException("RECOGNIZE_QUERY_URI_PARAMETERS must be a boolean");
            }
            this.getSystemURIResolver().setRecognizeQueryParameters((Boolean)value);
            return;
        } else if (name.equals("http://saxon.sf.net/feature/recoveryPolicy")) {
            if (!(value instanceof Integer)) {
                throw new IllegalArgumentException("RECOVERY_POLICY value must be an Integer");
            }
            this.setRecoveryPolicy((Integer)value);
            return;
        } else if (name.equals("http://saxon.sf.net/feature/recoveryPolicyName")) {
            int rval;
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("RECOVERY_POLICY_NAME value must be a String");
            }
            if (value.equals("recoverSilently")) {
                rval = 0;
            } else if (value.equals("recoverWithWarnings")) {
                rval = 1;
            } else {
                if (!value.equals("doNotRecover")) throw new IllegalArgumentException("Unrecognized value of RECOVERY_POLICY_NAME = '" + value + "': must be 'recoverSilently', 'recoverWithWarnings', or 'doNotRecover'");
                rval = 2;
            }
            this.setRecoveryPolicy(rval);
            return;
        } else if (name.equals("http://saxon.sf.net/feature/schemaURIResolver")) {
            if (!(value instanceof SchemaURIResolver)) {
                throw new IllegalArgumentException("SCHEMA_URI_RESOLVER value must be an instance of net.sf.saxon.type.SchemaURIResolver");
            }
            this.setSchemaURIResolver((SchemaURIResolver)value);
            return;
        } else if (name.equals("http://saxon.sf.net/feature/schemaURIResolverClass")) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("SCHEMA_URI_RESOLVER_CLASS value must be a string");
            }
            try {
                Object obj = this.getInstance((String)value, null);
                this.setSchemaURIResolver((SchemaURIResolver)obj);
                return;
            }
            catch (XPathException err) {
                throw new IllegalArgumentException("Cannot instantiate SCHEMA_URI_RESOLVER_CLASS. " + err.getMessage());
            }
            catch (ClassCastException err) {
                throw new IllegalArgumentException("SCHEMA_URI_RESOLVER_RESOLVER_CLASS does not implement SchemaURIResolver");
            }
        } else if (name.equals("http://saxon.sf.net/feature/schema-validation")) {
            if (!(value instanceof Integer)) {
                throw new IllegalArgumentException("SCHEMA_VALIDATION must be an integer");
            }
            this.setSchemaValidationMode((Integer)value);
            return;
        } else if (name.equals("http://saxon.sf.net/feature/schema-validation-mode")) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("SCHEMA_VALIDATION_MODE must be a string");
            }
            this.setSchemaValidationMode(Validation.getCode((String)value));
            return;
        } else if (name.equals("http://saxon.sf.net/feature/sourceParserClass")) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("SOURCE_PARSER_CLASS class must be a String");
            }
            this.setSourceParserClass((String)value);
            return;
        } else if (name.equals("http://saxon.sf.net/feature/strip-whitespace")) {
            int ival;
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("STRIP_WHITESPACE must be a string");
            }
            if (value.equals("all")) {
                ival = 2;
            } else if (value.equals("none")) {
                ival = 0;
            } else {
                if (!value.equals("ignorable")) throw new IllegalArgumentException("Unrecognized value STRIP_WHITESPACE = '" + value + "': must be 'all', 'none', or 'ignorable'");
                ival = 1;
            }
            this.setStripsWhiteSpace(ival);
            return;
        } else if (name.equals("http://saxon.sf.net/feature/styleParserClass")) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("STYLE_PARSER_CLASS class must be a String");
            }
            this.setStyleParserClass((String)value);
            return;
        } else if (name.equals("http://saxon.sf.net/feature/timing")) {
            this.setTiming(this.requireBoolean("TIMING", value));
            return;
        } else if (name.equals("http://saxon.sf.net/feature/trace-external-functions")) {
            this.setTraceExternalFunctions(this.requireBoolean("TRACE_EXTERNAL_FUNCTIONS", value));
            return;
        } else if (name.equals("http://saxon.sf.net/feature/trace-optimizer-decisions")) {
            this.setOptimizerTracing(this.requireBoolean("TRACE_OPTIMIZER_DECISIONS", value));
            return;
        } else if (name.equals("http://saxon.sf.net/feature/traceListener")) {
            if (!(value instanceof TraceListener)) {
                throw new IllegalArgumentException("TRACE_LISTENER is of wrong class");
            }
            this.setTraceListener((TraceListener)value);
            return;
        } else if (name.equals("http://saxon.sf.net/feature/traceListenerClass")) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("TRACE_LISTENER_CLASS must be a string");
            }
            this.setTraceListenerClass((String)value);
            return;
        } else if (name.equals("http://saxon.sf.net/feature/treeModel")) {
            if (!(value instanceof Integer)) {
                throw new IllegalArgumentException("Tree model must be an Integer");
            }
            this.setTreeModel((Integer)value);
            return;
        } else if (name.equals("http://saxon.sf.net/feature/treeModelName")) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("TREE_MODEL_NAME must be a string");
            }
            if (value.equals("tinyTree")) {
                this.setTreeModel(1);
                return;
            } else {
                if (!value.equals("linkedTree")) throw new IllegalArgumentException("Unrecognized value TREE_MODEL_NAME = '" + value + "': must be 'linkedTree' or 'tinyTree'");
                this.setTreeModel(0);
            }
            return;
        } else if (name.equals("http://saxon.sf.net/feature/use-pi-disable-output-escaping")) {
            this.useDisableOutputEscaping = this.requireBoolean("USE_PI_DISABLE_OUTPUT_ESCAPING", value);
            return;
        } else if (name.equals("http://saxon.sf.net/feature/useXsiSchemaLocation")) {
            this.useXsiSchemaLocation = this.requireBoolean("USE_XSI_SCHEMA_LOCATION", value);
            return;
        } else if (name.equals("http://saxon.sf.net/feature/validation-warnings")) {
            this.setValidationWarnings(this.requireBoolean("VALIDATION_WARNINGS", value));
            return;
        } else if (name.equals("http://saxon.sf.net/feature/version-warning")) {
            this.setVersionWarning(this.requireBoolean("VERSION_WARNING", value));
            return;
        } else if (name.equals("http://saxon.sf.net/feature/xinclude-aware")) {
            this.setXIncludeAware(this.requireBoolean("XINCLUDE", value));
            return;
        } else if (name.equals("http://saxon.sf.net/feature/xml-version") || name.equals("http://saxon.sf.bet/feature/xml-version")) {
            if (!(value instanceof String) || !value.equals("1.0") && !value.equals("1.1")) {
                throw new IllegalArgumentException("XML_VERSION value must be \"1.0\" or \"1.1\" as a String");
            }
            this.setXMLVersion(value.equals("1.0") ? 10 : 11);
            return;
        } else {
            if (!name.equals("http://saxon.sf.net/feature/xsd-version")) throw new IllegalArgumentException("Unknown attribute " + name);
            if (!(value instanceof String) || !value.equals("1.0") && !value.equals("1.1")) {
                throw new IllegalArgumentException("XSD_VERSION value must be \"1.0\" or \"1.1\" as a String");
            }
            this.xsdlVersion = value.equals("1.0") ? XSD10 : XSD11;
        }
    }

    private boolean requireBoolean(String propertyName, Object value) {
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            if ("true".equals(value)) {
                return true;
            }
            if ("false".equals(value)) {
                return false;
            }
            throw new IllegalArgumentException(propertyName + " must be 'true' or 'false'");
        }
        throw new IllegalArgumentException(propertyName + " must be a boolean");
    }

    public Object getConfigurationProperty(String name) {
        if (name.equals("http://saxon.sf.net/feature/allow-external-functions")) {
            return this.isAllowExternalFunctions();
        }
        if (name.equals("http://saxon.sf.net/feature/collation-uri-resolver")) {
            return this.getCollationURIResolver();
        }
        if (name.equals("http://saxon.sf.net/feature/collation-uri-resolver-class")) {
            return this.getCollationURIResolver().getClass().getName();
        }
        if (name.equals("http://saxon.sf.net/feature/collection-uri-resolver")) {
            return this.getCollectionURIResolver();
        }
        if (name.equals("http://saxon.sf.net/feature/collection-uri-resolver-class")) {
            return this.getCollectionURIResolver().getClass().getName();
        }
        if (name.equals("http://saxon.sf.net/feature/compile-with-tracing")) {
            return this.isCompileWithTracing();
        }
        if (name.equals("http://saxon.sf.net/feature/validation")) {
            return this.isValidation();
        }
        if (name.equals("http://saxon.sf.net/feature/expandAttributeDefaults")) {
            return this.isExpandAttributeDefaults();
        }
        if (name.equals("http://saxon.sf.net/feature/linenumbering")) {
            return this.isLineNumbering();
        }
        if (name.equals("http://saxon.sf.net/feature/messageEmitterClass")) {
            return this.getMessageEmitterClass();
        }
        if (name.equals("http://saxon.sf.net/feature/moduleURIResolver")) {
            return this.getModuleURIResolver();
        }
        if (name.equals("http://saxon.sf.net/feature/moduleURIResolverClass")) {
            return this.getModuleURIResolver().getClass().getName();
        }
        if (name.equals("http://saxon.sf.net/feature/namePool")) {
            return this.getNamePool();
        }
        if (name.equals("http://saxon.sf.net/feature/outputURIResolver")) {
            return this.getOutputURIResolver();
        }
        if (name.equals("http://saxon.sf.net/feature/outputURIResolverClass")) {
            return this.getOutputURIResolver().getClass().getName();
        }
        if (name.equals("http://saxon.sf.net/feature/preEvaluateDocFunction")) {
            return this.preEvaluateDocFunction;
        }
        if (name.equals("http://saxon.sf.net/feature/preferJaxpParser")) {
            return this.preferJaxpParser;
        }
        if (name.equals("http://saxon.sf.net/feature/recognize-uri-query-parameters")) {
            return this.getSystemURIResolver().queryParametersAreRecognized();
        }
        if (name.equals("http://saxon.sf.net/feature/recoveryPolicy")) {
            return new Integer(this.getRecoveryPolicy());
        }
        if (name.equals("http://saxon.sf.net/feature/recoveryPolicyName")) {
            switch (this.getRecoveryPolicy()) {
                case 0: {
                    return "recoverSilently";
                }
                case 1: {
                    return "recoverWithWarnings";
                }
                case 2: {
                    return "doNotRecover";
                }
            }
            return null;
        }
        if (name.equals("http://saxon.sf.net/feature/schemaURIResolver")) {
            return this.getSchemaURIResolver();
        }
        if (name.equals("http://saxon.sf.net/feature/schemaURIResolverClass")) {
            return this.getSchemaURIResolver().getClass().getName();
        }
        if (name.equals("http://saxon.sf.net/feature/schema-validation")) {
            return new Integer(this.getSchemaValidationMode());
        }
        if (name.equals("http://saxon.sf.net/feature/schema-validation-mode")) {
            return Validation.toString(this.getSchemaValidationMode());
        }
        if (name.equals("http://saxon.sf.net/feature/sourceParserClass")) {
            return this.getSourceParserClass();
        }
        if (name.equals("http://saxon.sf.net/feature/strip-whitespace")) {
            int s = this.getStripsWhiteSpace();
            if (s == 2) {
                return "all";
            }
            if (s == 1) {
                return "ignorable";
            }
            return "none";
        }
        if (name.equals("http://saxon.sf.net/feature/styleParserClass")) {
            return this.getStyleParserClass();
        }
        if (name.equals("http://saxon.sf.net/feature/timing")) {
            return this.isTiming();
        }
        if (name.equals("http://saxon.sf.net/feature/traceListener")) {
            return this.traceListener;
        }
        if (name.equals("http://saxon.sf.net/feature/traceListenerClass")) {
            return this.traceListenerClass;
        }
        if (name.equals("http://saxon.sf.net/feature/trace-external-functions")) {
            return this.isTraceExternalFunctions();
        }
        if (name.equals("http://saxon.sf.net/feature/trace-optimizer-decisions")) {
            return this.isOptimizerTracing();
        }
        if (name.equals("http://saxon.sf.net/feature/treeModel")) {
            return new Integer(this.getTreeModel());
        }
        if (name.equals("http://saxon.sf.net/feature/treeModelName")) {
            return this.getTreeModel() == 1 ? "tinyTree" : "linkedTree";
        }
        if (name.equals("http://saxon.sf.net/feature/use-pi-disable-output-escaping")) {
            return this.useDisableOutputEscaping;
        }
        if (name.equals("http://saxon.sf.net/feature/useXsiSchemaLocation")) {
            return this.useXsiSchemaLocation;
        }
        if (name.equals("http://saxon.sf.net/feature/validation-warnings")) {
            return this.isValidationWarnings();
        }
        if (name.equals("http://saxon.sf.net/feature/version-warning")) {
            return this.isVersionWarning();
        }
        if (name.equals("http://saxon.sf.net/feature/xinclude-aware")) {
            return this.isXIncludeAware();
        }
        if (name.equals("http://saxon.sf.net/feature/xml-version")) {
            return this.getXMLVersion() == 10 ? "1.0" : "1.1";
        }
        if (name.equals("http://saxon.sf.net/feature/xsd-version")) {
            return this.xsdlVersion == XSD10 ? "1.0" : "1.1";
        }
        throw new IllegalArgumentException("Unknown attribute " + name);
    }

    static {
        sharedExternalObjectModels = null;
        XSD10 = 10;
        XSD11 = 11;
        platform = JavaPlatform.getInstance();
        dummyLexicalHandler = new DefaultHandler2();
    }
}

