/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.emohawk.agent.module.sensomotoric;

import cz.cuni.amis.pogamut.emohawk.agent.module.sensomotoric.AnimType;
import cz.cuni.amis.pogamut.emohawk.agent.module.sensomotoric.CharacterType;
import java.util.HashMap;
import java.util.HashSet;

public class AnimationCharacterMapping {
    static HashMap<AnimType, HashSet<CharacterType>> animCharMap = new HashMap();
    static HashMap<String, AnimType> stringAnimMap = new HashMap();
    static HashMap<CharacterType, HashSet<AnimType>> charAnimMap = new HashMap();

    public static boolean hasAnim(AnimType anim, CharacterType character) {
        if (animCharMap.containsKey((Object)anim) && character != null) {
            return animCharMap.get((Object)anim).contains((Object)character);
        }
        return false;
    }

    public static HashSet<AnimType> getAvailableAnimations(CharacterType charType) {
        if (charAnimMap.containsKey((Object)charType)) {
            return charAnimMap.get((Object)charType);
        }
        return new HashSet<AnimType>();
    }

    public static AnimType getAnimTypeFromString(String animStringId) {
        if (stringAnimMap.containsKey(animStringId)) {
            return stringAnimMap.get(animStringId);
        }
        return AnimType.NONE;
    }

    /*
     * Opcode count of 13415 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    private static void initializeCharacterAnimationMappingOne() {
        animCharMap.put(AnimType.CAMERA_ACTIVE, AnimationCharacterMapping.procCharIds(new int[]{0}));
        animCharMap.put(AnimType.AMBI_CANCAN, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.AMBI_IMPATIENT, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.AMBI_LOOKAROUND01, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.AMBI_LOOKAROUND02, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.AMBI_LOOKBACK, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.AMBI_LOOKLEFT, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.AMBI_LOOKRIGHT, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.AMBI_SCRATCH, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.AMBI_SMSREAD, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.AMBI_STAND_ANGRY01, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.AMBI_STAND_ANGRY02, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.AMBI_STAND_ANGRY03, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.AMBI_STAND_ANGRY03A, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.AMBI_STAND_ANGRY03B, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.AMBI_STAND_ANGRY04, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.AMBI_STAND_ANGRY04A, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.AMBI_STAND_ANGRY04B, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.AMBI_STAND_CONFIDENT, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.AMBI_STAND_DEPRESSED, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.AMBI_STAND_HAPPY, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.AMBI_STAND_NORMAL01, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.AMBI_STAND_NORMAL02, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.AMBI_STAND_SEXY, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.AMBI_STAND_SICK01, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.AMBI_STAND_SICK02, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.AMBI_STAND_WALL01, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.AMBI_STAND_WALL02, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.AMBI_THOUGHTFUL, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.AMBI_THOUGHTFULTURN, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.AMBI_YAWN, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.UDN_BCROUCH, AnimationCharacterMapping.procCharIds(new int[]{5, 6}));
        animCharMap.put(AnimType.UDN_BRUN, AnimationCharacterMapping.procCharIds(new int[]{5, 6}));
        animCharMap.put(AnimType.UDN_BWALK, AnimationCharacterMapping.procCharIds(new int[]{5, 6}));
        animCharMap.put(AnimType.UDN_CROUCHIDLE, AnimationCharacterMapping.procCharIds(new int[]{5, 6}));
        animCharMap.put(AnimType.EMOHAWK_DIE01, AnimationCharacterMapping.procCharIds(new int[]{4}));
        animCharMap.put(AnimType.EMOHAWK_DIE02, AnimationCharacterMapping.procCharIds(new int[]{4}));
        animCharMap.put(AnimType.EMOHAWK_DIZZY, AnimationCharacterMapping.procCharIds(new int[]{4}));
        animCharMap.put(AnimType.EMOHAWK_EEK, AnimationCharacterMapping.procCharIds(new int[]{4}));
        animCharMap.put(AnimType.EMOHAWK_EEKFLY, AnimationCharacterMapping.procCharIds(new int[]{4}));
        animCharMap.put(AnimType.EMOHAWK_EXPEL, AnimationCharacterMapping.procCharIds(new int[]{4}));
        animCharMap.put(AnimType.UDN_FCROUCH, AnimationCharacterMapping.procCharIds(new int[]{5, 6}));
        animCharMap.put(AnimType.FIGHT_AIMDOWN01, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.FIGHT_AIMDOWN02, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.FIGHT_AIMFRONT01, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.FIGHT_AIMFRONT02, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.FIGHT_BEATING, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.FIGHT_GUNACTIONDOWN, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.FIGHT_GUNACTIONDOWNA, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.FIGHT_GUNACTIONDOWNB, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.FIGHT_GUNACTIONDOWNC, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.FIGHT_GUNACTIONFRONT, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.FIGHT_GUNACTIONFRONTA, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.FIGHT_GUNACTIONFRONTB, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.FIGHT_GUNACTIONFRONTC, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.FIGHT_GUNREADYFRONT, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.FIGHT_GUNWILDWEST01, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.FIGHT_GUNWILDWEST02, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.FIGHT_KICKDOWN, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.FIGHT_KICKFRONT, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.FIGHT_RIFLESHOOT, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.FIGHT_RUNAIMDOWN01, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.FIGHT_RUNAIMDOWN02, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.FIGHT_RUNAIMDOWN03, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.FIGHT_RUNAIMFRONT01, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.FIGHT_RUNAIMFRONT02, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.FIGHT_RUNAIMFRONT03, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.FIGHT_RUNSHOOTDOWN01, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.FIGHT_RUNSHOOTDOWN02, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.FIGHT_RUNSHOOTDOWN03, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.FIGHT_RUNSHOOTDOWNSHORT01, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.FIGHT_RUNSHOOTDOWNSHORT02, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.FIGHT_RUNSHOOTDOWNSHORT03, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.FIGHT_RUNSHOOTFRONT01, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.FIGHT_RUNSHOOTFRONT02, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.FIGHT_RUNSHOOTFRONT03, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.FIGHT_RUNSHOOTFRONTSHORT01, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.FIGHT_RUNSHOOTFRONTSHORT02, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.FIGHT_RUNSHOOTFRONTSHORT03, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.FIGHT_SHOOTDOWN01, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.FIGHT_SHOOTDOWN02, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.FIGHT_SHOOTFRONT01, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.FIGHT_SHOOTFRONT02, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.FIGHT_SLAPS, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.FIGHT_WALKAIMDOWN01, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.FIGHT_WALKAIMDOWN02, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.FIGHT_WALKAIMFRONT01, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.FIGHT_WALKAIMFRONT02, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.FIGHT_WALKSHOOTDOWN01, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.FIGHT_WALKSHOOTDOWN02, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.FIGHT_WALKSHOOTDOWNSHORT01, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.FIGHT_WALKSHOOTDOWNSHORT02, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.FIGHT_WALKSHOOTFRONT01, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.FIGHT_WALKSHOOTFRONT02, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.FIGHT_WALKSHOOTFRONTSHORT01, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.FIGHT_WALKSHOOTFRONTSHORT02, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.FREEZE, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.UDN_FRUN, AnimationCharacterMapping.procCharIds(new int[]{5, 6}));
        animCharMap.put(AnimType.UDN_FSPRINT, AnimationCharacterMapping.procCharIds(new int[]{5}));
        animCharMap.put(AnimType.UDN_FWALK, AnimationCharacterMapping.procCharIds(new int[]{5, 6}));
        animCharMap.put(AnimType.EMOHAWK_GROWL, AnimationCharacterMapping.procCharIds(new int[]{4}));
        animCharMap.put(AnimType.EMOHAWK_GROWLKICK, AnimationCharacterMapping.procCharIds(new int[]{4}));
        animCharMap.put(AnimType.UDN_HOLDGUN, AnimationCharacterMapping.procCharIds(new int[]{5}));
    }

    /*
     * Opcode count of 26752 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    private static void initializeCharacterAnimationMappingTwo() {
        animCharMap.put(AnimType.IDLEANIM, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.UDN_IDLEBREATHE, AnimationCharacterMapping.procCharIds(new int[]{5, 6}));
        animCharMap.put(AnimType.UDN_IDLEEARRING, AnimationCharacterMapping.procCharIds(new int[]{6}));
        animCharMap.put(AnimType.UDN_IDLEGLOVES, AnimationCharacterMapping.procCharIds(new int[]{5}));
        animCharMap.put(AnimType.UDN_IDLEHIP, AnimationCharacterMapping.procCharIds(new int[]{6}));
        animCharMap.put(AnimType.UDN_IDLEISCRATCH, AnimationCharacterMapping.procCharIds(new int[]{5}));
        animCharMap.put(AnimType.UDN_IDLEKNUCKLES, AnimationCharacterMapping.procCharIds(new int[]{5}));
        animCharMap.put(AnimType.UDN_IDLENECK, AnimationCharacterMapping.procCharIds(new int[]{5}));
        animCharMap.put(AnimType.UDN_IDLENOSE, AnimationCharacterMapping.procCharIds(new int[]{5}));
        animCharMap.put(AnimType.UDN_IDLESTRETCH, AnimationCharacterMapping.procCharIds(new int[]{5}));
        animCharMap.put(AnimType.UDN_IDLETWIST, AnimationCharacterMapping.procCharIds(new int[]{6}));
        animCharMap.put(AnimType.CAMERA_INACTIVE, AnimationCharacterMapping.procCharIds(new int[]{0}));
        animCharMap.put(AnimType.INTERACT_AUTOMAT, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.INTERACT_CARESS, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.INTERACT_CARESS_BOY, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.INTERACT_CARESS_GIRL, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.INTERACT_FRONTHUG01, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.INTERACT_FRONTHUG01_END, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.INTERACT_FRONTHUG01_LOOP, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.INTERACT_FRONTHUG01_START, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.INTERACT_FRONTHUG02, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.INTERACT_FRONTHUG02_END, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.INTERACT_FRONTHUG02_LOOP, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.INTERACT_FRONTHUG02_START, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.INTERACT_GOAWAY, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.INTERACT_HANDONSHOULDER, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.INTERACT_HANDOVER01, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.INTERACT_HANDOVER02, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.INTERACT_HANDOVER03, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.INTERACT_HANDOVER04, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.INTERACT_KISSWITHHANDS01_BOY, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.INTERACT_KISSWITHHANDS02_BOY, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.INTERACT_KISSWITHHANDS_GIRL, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.INTERACT_KISS_BOY, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.INTERACT_KISS_GIRL, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.INTERACT_LISTENWALL, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.INTERACT_LISTENWALLHAND01, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.INTERACT_LISTENWALLHAND02, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.INTERACT_MANIPULATE01, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.INTERACT_MANIPULATE02, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.INTERACT_PICKUP01, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.INTERACT_PICKUP02, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.INTERACT_PUSHBACK, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.INTERACT_PUTDOWN01, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.INTERACT_PUTDOWN02, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.INTERACT_PUTFRONT01, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.INTERACT_PUTFRONT02, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.INTERACT_SHAKEHANDS, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.INTERACT_SHOULDERKNOCK, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.INTERACT_SIDEHUGLEFT, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.INTERACT_SIDEHUGLEFT_END, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.INTERACT_SIDEHUGLEFT_LOOP, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.INTERACT_SIDEHUGLEFT_START, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.INTERACT_SIDEHUGRIGHT, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.INTERACT_SIDEHUGRIGHT_END, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.INTERACT_SIDEHUGRIGHT_LOOP, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.INTERACT_SIDEHUGRIGHT_START, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.INTERACT_THROW01, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.INTERACT_THROW02, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.INTERACT_THROWFROMPOCKET01, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.INTERACT_THROWFROMPOCKET02, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.INTERACT_TOUCHHORRIFIED, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.INTERACT_WHATISTHIS, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.UDN_JUMP, AnimationCharacterMapping.procCharIds(new int[]{5}));
        animCharMap.put(AnimType.UDN_LCROUCH, AnimationCharacterMapping.procCharIds(new int[]{5, 6}));
        animCharMap.put(AnimType.EMOHAWK_LIE, AnimationCharacterMapping.procCharIds(new int[]{4}));
        animCharMap.put(AnimType.EMOHAWK_LOOKAROUND, AnimationCharacterMapping.procCharIds(new int[]{4}));
        animCharMap.put(AnimType.UDN_LRUN, AnimationCharacterMapping.procCharIds(new int[]{5, 6}));
        animCharMap.put(AnimType.UDN_LWALK, AnimationCharacterMapping.procCharIds(new int[]{5, 6}));
        animCharMap.put(AnimType.NAVI_BIGJUMP, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.NAVI_BLOWNBACK, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.NAVI_CRAWL, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.NAVI_IAMCHASED, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.NAVI_LIEONBACK01, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.NAVI_LIEONBACK02, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.NAVI_LIEONSTOMACH01, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.NAVI_LIEONSTOMACH02, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.NAVI_OPENDOOR_ANGRY, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.NAVI_OPENDOOR_CONFIDENT, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.NAVI_OPENDOOR_CONFIDENT02, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.NAVI_OPENDOOR_DEPRESSED, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.NAVI_OPENDOOR_HAPPY, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.NAVI_OPENDOOR_NORMAL, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.NAVI_PUSH, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.NAVI_RUNAWAY, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.NAVI_SIT01, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.NAVI_SIT02, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.NAVI_SITONGROUND01, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.NAVI_SITONGROUND02, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.NAVI_SLIP, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.NAVI_STAIRSDOWN01, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.NAVI_STAIRSDOWN02, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.NAVI_STAIRSUP01, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.NAVI_STAIRSUP02, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.NAVI_STANDUP, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.NAVI_STRAFELEFT01, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.NAVI_STRAFELEFT02, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.NAVI_STRAFELEFT03, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.NAVI_STRAFELEFT04, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.NAVI_STRAFERIGHT01, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.NAVI_STRAFERIGHT02, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.NAVI_STRAFERIGHT03, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.NAVI_STRAFERIGHT04, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.NAVI_STRAFESHORTLEFT, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.NAVI_STRAFESHORTRIGHT, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.NAVI_TURNPLACE01, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.NAVI_TURNPLACE02, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.UDN_PICKUP, AnimationCharacterMapping.procCharIds(new int[]{5, 6}));
        animCharMap.put(AnimType.EMOHAWK_PREEN, AnimationCharacterMapping.procCharIds(new int[]{4}));
        animCharMap.put(AnimType.EXT_PROPANIMATIONS_BABY_BUGGYIDLE_01, AnimationCharacterMapping.procCharIds(new int[]{34, 35, 2, 3, 38, 39, 37, 8, 9, 11, 12, 21, 23, 27, 29, 31}));
        animCharMap.put(AnimType.EXT_PROPANIMATIONS_BABY_BUGGYLISTEN_01, AnimationCharacterMapping.procCharIds(new int[]{34, 35, 2, 3, 38, 39, 37, 8, 9, 11, 12, 21, 23, 27, 29, 31}));
        animCharMap.put(AnimType.EXT_PROPANIMATIONS_BABY_BUGGYTALK_01, AnimationCharacterMapping.procCharIds(new int[]{34, 35, 2, 3, 38, 39, 37, 8, 9, 11, 12, 21, 23, 27, 29, 31}));
        animCharMap.put(AnimType.EXT_PROPANIMATIONS_CELLPHONE_LISTEN_01, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_PROPANIMATIONS_CELLPHONE_TALK_01, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_PROPANIMATIONS_CELLPHONE_TALK_02, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_PROPANIMATIONS_CELLPHONE_TEXTMESSAGE_01, AnimationCharacterMapping.procCharIds(new int[]{34, 35, 2, 3, 38, 39, 37, 8, 9, 11, 12, 21, 23, 27, 29, 31}));
        animCharMap.put(AnimType.EXT_PROPANIMATIONS_CELLPHONE_WALK_01, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_PROPANIMATIONS_DOCUMENTFILE_IDLE_01, AnimationCharacterMapping.procCharIds(new int[]{34, 35, 2, 3, 38, 39, 37, 8, 9, 11, 12, 21, 23, 27, 29, 31}));
        animCharMap.put(AnimType.EXT_PROPANIMATIONS_DRINK_DRINKING_01, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_PROPANIMATIONS_DRINK_IDLE_01, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_PROPANIMATIONS_DRINK_WALK_01, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_PROPANIMATIONS_HEADPHONES_IDLE_01, AnimationCharacterMapping.procCharIds(new int[]{34, 35, 2, 3, 38, 39, 37, 8, 9, 11, 12, 21, 23, 27, 29, 31}));
        animCharMap.put(AnimType.EXT_PROPANIMATIONS_HEADPHONES_WALK_01, AnimationCharacterMapping.procCharIds(new int[]{34, 35, 2, 3, 38, 39, 37, 8, 9, 11, 12, 21, 23, 27, 29, 31}));
        animCharMap.put(AnimType.EXT_PROPANIMATIONS_HOLDBAG_IDLE_01, AnimationCharacterMapping.procCharIds(new int[]{34, 35, 2, 3, 38, 39, 37, 8, 9, 11, 12, 21, 23, 27, 29, 31}));
        animCharMap.put(AnimType.EXT_PROPANIMATIONS_HOLDPISTOL_BREATHE_01, AnimationCharacterMapping.procCharIds(new int[]{34, 35, 2, 3, 38, 39, 37, 8, 9, 11, 12, 21, 23, 27, 29, 31}));
        animCharMap.put(AnimType.EXT_PROPANIMATIONS_HOLDPISTOL_IDLE_01, AnimationCharacterMapping.procCharIds(new int[]{34, 35, 2, 3, 38, 39, 37, 8, 9, 11, 12, 21, 23, 27, 29, 31}));
        animCharMap.put(AnimType.EXT_PROPANIMATIONS_HOLDPISTOL_IN_01, AnimationCharacterMapping.procCharIds(new int[]{34, 35, 2, 3, 38, 39, 37, 8, 9, 11, 12, 21, 23, 27, 29, 31}));
        animCharMap.put(AnimType.EXT_PROPANIMATIONS_HOLDPISTOL_OUT_01, AnimationCharacterMapping.procCharIds(new int[]{34, 35, 2, 3, 38, 39, 37, 8, 9, 11, 12, 21, 23, 27, 29, 31}));
        animCharMap.put(AnimType.EXT_PROPANIMATIONS_IDLE_DOCUMENTFILE_01, AnimationCharacterMapping.procCharIds(new int[]{1, 32, 33, 36, 7, 40, 10, 13, 14, 15, 17, 16, 19, 18, 20, 22, 25, 24, 26, 28, 30}));
        animCharMap.put(AnimType.EXT_PROPANIMATIONS_IDLE_HEADPHONES_01, AnimationCharacterMapping.procCharIds(new int[]{1, 32, 33, 36, 7, 40, 10, 13, 14, 15, 17, 16, 19, 18, 20, 22, 25, 24, 26, 28, 30}));
        animCharMap.put(AnimType.EXT_PROPANIMATIONS_IDLE_HOLDBAG_01, AnimationCharacterMapping.procCharIds(new int[]{1, 32, 33, 36, 7, 40, 10, 13, 14, 15, 17, 16, 19, 18, 20, 22, 25, 24, 26, 28, 30}));
        animCharMap.put(AnimType.EXT_PROPANIMATIONS_MODERATE_01, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_PROPANIMATIONS_MODERATE_02, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_PROPANIMATIONS_NEWSPAPER_ARMIDLE_01, AnimationCharacterMapping.procCharIds(new int[]{1, 32, 33, 36, 7, 40, 10, 13, 14, 15, 17, 16, 19, 18, 20, 22, 25, 24, 26, 28, 30}));
        animCharMap.put(AnimType.EXT_PROPANIMATIONS_NEWSPAPER_ARMWALK_01, AnimationCharacterMapping.procCharIds(new int[]{34, 35, 2, 3, 38, 39, 37, 8, 9, 11, 12, 21, 23, 27, 29, 31}));
        animCharMap.put(AnimType.EXT_PROPANIMATIONS_NEWSPAPER_HANDIDLE_01, AnimationCharacterMapping.procCharIds(new int[]{1, 32, 33, 36, 7, 40, 10, 13, 14, 15, 17, 16, 19, 18, 20, 22, 25, 24, 26, 28, 30}));
        animCharMap.put(AnimType.EXT_PROPANIMATIONS_NEWSPAPER_IDLEARM_01, AnimationCharacterMapping.procCharIds(new int[]{34, 35, 2, 3, 38, 39, 37, 8, 9, 11, 12, 21, 23, 27, 29, 31}));
        animCharMap.put(AnimType.EXT_PROPANIMATIONS_NEWSPAPER_IDLEHAND_01, AnimationCharacterMapping.procCharIds(new int[]{34, 35, 2, 3, 38, 39, 37, 8, 9, 11, 12, 21, 23, 27, 29, 31}));
        animCharMap.put(AnimType.EXT_PROPANIMATIONS_PISTOL_HOLDBREATHE_01, AnimationCharacterMapping.procCharIds(new int[]{1, 32, 33, 36, 7, 40, 10, 13, 14, 15, 17, 16, 19, 18, 20, 22, 25, 24, 26, 28, 30}));
        animCharMap.put(AnimType.EXT_PROPANIMATIONS_PISTOL_HOLDIN_01, AnimationCharacterMapping.procCharIds(new int[]{1, 32, 33, 36, 7, 40, 10, 13, 14, 15, 17, 16, 19, 18, 20, 22, 25, 24, 26, 28, 30}));
        animCharMap.put(AnimType.EXT_PROPANIMATIONS_PISTOL_HOLDOUT_01, AnimationCharacterMapping.procCharIds(new int[]{1, 32, 33, 36, 7, 40, 10, 13, 14, 15, 17, 16, 19, 18, 20, 22, 25, 24, 26, 28, 30}));
        animCharMap.put(AnimType.EXT_PROPANIMATIONS_PISTOL_IDLE_01, AnimationCharacterMapping.procCharIds(new int[]{1, 32, 33, 36, 7, 40, 10, 13, 14, 15, 17, 16, 19, 18, 20, 22, 25, 24, 26, 28, 30}));
        animCharMap.put(AnimType.EXT_PROPANIMATIONS_RIDE_BICYCLE_01, AnimationCharacterMapping.procCharIds(new int[]{1, 32, 33, 36, 7, 40, 10, 13, 14, 15, 17, 16, 19, 18, 20, 22, 25, 24, 26, 28, 30}));
        animCharMap.put(AnimType.EXT_PROPANIMATIONS_RIDE_BYCICLE_01, AnimationCharacterMapping.procCharIds(new int[]{34, 35, 2, 3, 38, 39, 37, 8, 9, 11, 12, 21, 23, 27, 29, 31}));
        animCharMap.put(AnimType.EXT_PROPANIMATIONS_TAKE_PICTURE_01, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_PROPANIMATIONS_TROLLEY_IDLE_01, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_PROPANIMATIONS_TROLLEY_WALK_01, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_PROPANIMATIONS_UMBRELLA_IDLE_01, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_PROPANIMATIONS_UMBRELLA_IDLE_02, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_PROPANIMATIONS_UMBRELLA_WALK_01, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.UDN_PUSH, AnimationCharacterMapping.procCharIds(new int[]{5, 6}));
        animCharMap.put(AnimType.UDN_RCROUCH, AnimationCharacterMapping.procCharIds(new int[]{5, 6}));
        animCharMap.put(AnimType.UDN_RIFLE, AnimationCharacterMapping.procCharIds(new int[]{5}));
        animCharMap.put(AnimType.UDN_RRUN, AnimationCharacterMapping.procCharIds(new int[]{5, 6}));
        animCharMap.put(AnimType.RUN_DUCKING, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.RUN_NORMAL, AnimationCharacterMapping.procCharIds(new int[]{4}));
        animCharMap.put(AnimType.RUN_NORMAL01, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.RUN_NORMAL02, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.RUN_SILLY, AnimationCharacterMapping.procCharIds(new int[]{4}));
        animCharMap.put(AnimType.RUN_SPRINT_LOOP, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.RUN_SPRINT_LOOPSTART, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.RUN_SPRINT_LOOPSTOP, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.UDN_RWALK, AnimationCharacterMapping.procCharIds(new int[]{5, 6}));
        animCharMap.put(AnimType.EMOHAWK_SHELTER, AnimationCharacterMapping.procCharIds(new int[]{4}));
        animCharMap.put(AnimType.UDN_SHOVE, AnimationCharacterMapping.procCharIds(new int[]{5, 6}));
        animCharMap.put(AnimType.EMOHAWK_SIPHON, AnimationCharacterMapping.procCharIds(new int[]{4}));
        animCharMap.put(AnimType.EMOHAWK_SIT01, AnimationCharacterMapping.procCharIds(new int[]{4}));
        animCharMap.put(AnimType.EMOHAWK_SIT02, AnimationCharacterMapping.procCharIds(new int[]{4}));
        animCharMap.put(AnimType.EMOHAWK_SITONGROUND, AnimationCharacterMapping.procCharIds(new int[]{4}));
        animCharMap.put(AnimType.EXT_SITTING_CHAIR_BREATHE_01, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_SITTING_CHAIR_COUGH_01, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_SITTING_CHAIR_DUST_01, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_SITTING_CHAIR_FINGERNAIL_01, AnimationCharacterMapping.procCharIds(new int[]{34, 35, 2, 3, 38, 39, 37, 8, 9, 11, 12, 21, 23, 27, 29, 31}));
        animCharMap.put(AnimType.EXT_SITTING_CHAIR_LOOKAROUND_01, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_SITTING_CHAIR_NERVOUS_01, AnimationCharacterMapping.procCharIds(new int[]{1, 32, 33, 36, 7, 40, 10, 13, 14, 15, 17, 16, 19, 18, 20, 22, 25, 24, 26, 28, 30}));
        animCharMap.put(AnimType.EXT_SITTING_CHAIR_NEUTRAL_01, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_SITTING_CHAIR_NEUTRAL_02, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_SITTING_CHAIR_RELAXED_01, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_SITTING_CHAIR_ROLLHEAD_01, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_SITTING_CHAIR_SCRATCHHEAD_01, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_SITTING_CHAIR_SHRUG_01, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_SITTING_CHAIR_SHRUG_02, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_SITTING_CHAIR_SITDOWNLEFT_01, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_SITTING_CHAIR_SITDOWNRIGHT_01, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_SITTING_CHAIR_SITDOWN_01, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_SITTING_CHAIR_SITDOWN_02, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_SITTING_CHAIR_STANDUPLEFT_01, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_SITTING_CHAIR_STANDUPRIGHT_01, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_SITTING_CHAIR_STANDUP_01, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_SITTING_CHAIR_THOUGHTFUL_01, AnimationCharacterMapping.procCharIds(new int[]{1, 32, 33, 36, 7, 40, 10, 13, 14, 15, 17, 16, 19, 18, 20, 22, 25, 24, 26, 28, 30}));
        animCharMap.put(AnimType.EXT_SITTING_CHAIR_TOUCHFACE_01, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_SITTING_CHAIR_TOUCHHAIR_01, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_SITTING_CHAIR_WAITING_01, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_SITTING_CHAIR_WAITING_02, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_SITTING_CHAIR_YAWN_01, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_SITTING_TABLE_BREATHE_01, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_SITTING_TABLE_COUGH_01, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_SITTING_TABLE_DUST_01, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_SITTING_TABLE_LOOKAROUND_01, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_SITTING_TABLE_NERVOUS_01, AnimationCharacterMapping.procCharIds(new int[]{1, 32, 33, 36, 7, 40, 10, 13, 14, 15, 17, 16, 19, 18, 20, 22, 25, 24, 26, 28, 30}));
        animCharMap.put(AnimType.EXT_SITTING_TABLE_NEUTRAL_01, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_SITTING_TABLE_NEUTRAL_02, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_SITTING_TABLE_RELAXED_01, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_SITTING_TABLE_ROLLHEAD_01, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_SITTING_TABLE_SCRATCHHEAD_01, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_SITTING_TABLE_SHRUG_01, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_SITTING_TABLE_SHRUG_02, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_SITTING_TABLE_SITDOWNLEFT_01, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_SITTING_TABLE_SITDOWNRIGHT_01, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_SITTING_TABLE_STANDUPLEFT_01, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_SITTING_TABLE_STANDUPRIGHT_01, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_SITTING_TABLE_STRETCHARMS_01, AnimationCharacterMapping.procCharIds(new int[]{34, 35, 2, 3, 38, 39, 37, 8, 9, 11, 12, 21, 23, 27, 29, 31}));
        animCharMap.put(AnimType.EXT_SITTING_TABLE_THOUGHTFUL_01, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_SITTING_TABLE_TOUCHFACE_01, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_SITTING_TABLE_TOUCHHAIR_01, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_SITTING_TABLE_WAITING_01, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_SITTING_TABLE_YAWN_01, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.UDN_SNOWBALL, AnimationCharacterMapping.procCharIds(new int[]{5, 6}));
    }

    /*
     * Opcode count of 37110 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    private static void initializeCharacterAnimationMappingThree() {
        animCharMap.put(AnimType.SOCIAL_AGREE01, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_AGREE02, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_ANGRYAGREE, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_ANGRYEXPLAIN, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_ANGRYLISTEN, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_ANGRYTALK01, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_ANGRYTALK02, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_APPLAUSE01, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_APPLAUSE02, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_BACK_HANDSCHEST, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_BIGLAUGH, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_BRAVISSA, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_BRAVISSB, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_CALMDOWN, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_CALMDOWN_LEFT, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_CALMDOWN_RIGHT, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_CANTBELIEVE, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_CHAMPIONS, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_CHEER, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_COMEHERE, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_COMETOME, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_COMETOME02, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_COMPLIMENT01, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_COMPLIMENT02, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_CONVERSE01, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_CONVERSE02, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_CONVERSE02A, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_CONVERSE02B, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_CONVERSE02C, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_CONVERSE02D, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_COOING01, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_COOING02, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_COOING03, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_COOING04, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_DESPAIR01, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_DESPAIR02, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_DISAGREE, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_ENTHUSE, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_EXPLAIN, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_FINALWORD, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_FUCKYOU, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_GESTUREFRONT01, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_GESTUREFRONT02, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_GESTURELEFT01, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_GESTURELEFT02, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_GESTURELEFT03, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_GESTURELEFT04, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_GESTURERIGHT01, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_GESTURERIGHT02, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_GESTURERIGHT03, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_GESTURERIGHT04, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_GOTHIM, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_HANDSFRONT, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_HANDSNEXTHEAD, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_HANDSONHIPS, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_HAPPYDANCE01, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_HAPPYDANCE02, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_HAPPYJUMP01, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_HAPPYJUMP02, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_HEADINPALMS, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_HEADKNOCK, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_HEYWATCHIT, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_HISSYFIT, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_IDIDNOTHING, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_IDONTTHINKSO, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_LISTEN, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_LOVEACCEPT, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_LOVECONFESS01, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_LOVECONFESS02, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_LOVEPROPOSAL, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_LOVEREFUSE, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_MEMEME, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_NOWAY, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_PERSUASION, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_PLEADING01, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_PLEADING02, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_POINTANGRY, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_POINTDOWN, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_POINTFRONT02, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_POINTHYSTERIC, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_POINTSIDEHEAD_LEFT, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_POINTSIDEHEAD_RIGHT, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_POINTSIDE_LEFT, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_POINTSIDE_RIGHT, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_PROTECT, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_PROTECT_SHORT, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_SHOCKED, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_SHOUTWAVE, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_SHOUTWAVEBIG, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_SHRUG, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_SIGH, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_SLAP, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_SPEAKLEFT01, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_SPEAKLEFT02, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_SPEAKRIGHT01, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_SPEAKRIGHT02, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_TALKIMPORTANT, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_THATSIT, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_THREATEN, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_TURNLEAVE, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_WAITHERE, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_WAVEFAR, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_WAVENEAR, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_WHATEVER, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_YOUKNOW, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_YOUSEE, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_SPECIALSTANDING_CHEER_01, AnimationCharacterMapping.procCharIds(new int[]{34, 35, 2, 3, 38, 39, 37, 8, 9, 11, 12, 21, 23, 27, 29, 31}));
        animCharMap.put(AnimType.EXT_SPECIALSTANDING_CHEER_02, AnimationCharacterMapping.procCharIds(new int[]{34, 35, 2, 3, 38, 39, 37, 8, 9, 11, 12, 21, 23, 27, 29, 31}));
        animCharMap.put(AnimType.EXT_SPECIALSTANDING_CHEER_03, AnimationCharacterMapping.procCharIds(new int[]{34, 35, 2, 3, 38, 39, 37, 8, 9, 11, 12, 21, 23, 27, 29, 31}));
        animCharMap.put(AnimType.EXT_SPECIALSTANDING_CHEER_04, AnimationCharacterMapping.procCharIds(new int[]{34, 35, 2, 3, 38, 39, 37, 8, 9, 11, 12, 21, 23, 27, 29, 31}));
        animCharMap.put(AnimType.EXT_SPECIALSTANDING_CHEER_05, AnimationCharacterMapping.procCharIds(new int[]{34, 35, 2, 3, 38, 39, 37, 8, 9, 11, 12, 21, 23, 27, 29, 31}));
        animCharMap.put(AnimType.EXT_SPECIALSTANDING_CLAPHANDS_01, AnimationCharacterMapping.procCharIds(new int[]{34, 35, 2, 3, 38, 39, 37, 8, 9, 11, 12, 21, 23, 27, 29, 31}));
        animCharMap.put(AnimType.EXT_SPECIALSTANDING_CLAPHANDS_02, AnimationCharacterMapping.procCharIds(new int[]{34, 35, 2, 3, 38, 39, 37, 8, 9, 11, 12, 21, 23, 27, 29, 31}));
        animCharMap.put(AnimType.EXT_SPECIALSTANDING_CROUCH_GESTIC_01, AnimationCharacterMapping.procCharIds(new int[]{34, 35, 2, 3, 38, 39, 37, 8, 9, 11, 12, 21, 23, 27, 29, 31}));
        animCharMap.put(AnimType.EXT_SPECIALSTANDING_CROUCH_IDLE_01, AnimationCharacterMapping.procCharIds(new int[]{34, 35, 2, 3, 38, 39, 37, 8, 9, 11, 12, 21, 23, 27, 29, 31}));
        animCharMap.put(AnimType.EXT_SPECIALSTANDING_CROUCH_IN_01, AnimationCharacterMapping.procCharIds(new int[]{34, 35, 2, 3, 38, 39, 37, 8, 9, 11, 12, 21, 23, 27, 29, 31}));
        animCharMap.put(AnimType.EXT_SPECIALSTANDING_CROUCH_OUT_01, AnimationCharacterMapping.procCharIds(new int[]{34, 35, 2, 3, 38, 39, 37, 8, 9, 11, 12, 21, 23, 27, 29, 31}));
        animCharMap.put(AnimType.EXT_SPECIALSTANDING_DANCING_AGGRESSIVE_01, AnimationCharacterMapping.procCharIds(new int[]{34, 35, 2, 3, 38, 39, 37, 8, 9, 11, 12, 21, 23, 27, 29, 31}));
        animCharMap.put(AnimType.EXT_SPECIALSTANDING_DANCING_COOL_01, AnimationCharacterMapping.procCharIds(new int[]{34, 35, 2, 3, 38, 39, 37, 8, 9, 11, 12, 21, 23, 27, 29, 31}));
        animCharMap.put(AnimType.EXT_SPECIALSTANDING_DANCING_NEUTRAL_01, AnimationCharacterMapping.procCharIds(new int[]{34, 35, 2, 3, 38, 39, 37, 8, 9, 11, 12, 21, 23, 27, 29, 31}));
        animCharMap.put(AnimType.EXT_SPECIALSTANDING_DANCING_SEXY_01, AnimationCharacterMapping.procCharIds(new int[]{34, 35, 2, 3, 38, 39, 37, 8, 9, 11, 12, 21, 23, 27, 29, 31}));
        animCharMap.put(AnimType.EXT_SPECIALSTANDING_DANCING_SILLY_01, AnimationCharacterMapping.procCharIds(new int[]{34, 35, 2, 3, 38, 39, 37, 8, 9, 11, 12, 21, 23, 27, 29, 31}));
        animCharMap.put(AnimType.EXT_SPECIALSTANDING_DOCUMENTS_CHECK_01, AnimationCharacterMapping.procCharIds(new int[]{34, 35, 2, 3, 38, 39, 37, 8, 9, 11, 12, 21, 23, 27, 29, 31}));
        animCharMap.put(AnimType.EXT_SPECIALSTANDING_DOCUMENTS_IN_01, AnimationCharacterMapping.procCharIds(new int[]{34, 35, 2, 3, 38, 39, 37, 8, 9, 11, 12, 21, 23, 27, 29, 31}));
        animCharMap.put(AnimType.EXT_SPECIALSTANDING_DOCUMENTS_NOTE_01, AnimationCharacterMapping.procCharIds(new int[]{34, 35, 2, 3, 38, 39, 37, 8, 9, 11, 12, 21, 23, 27, 29, 31}));
        animCharMap.put(AnimType.EXT_SPECIALSTANDING_DOCUMENTS_OUT_01, AnimationCharacterMapping.procCharIds(new int[]{34, 35, 2, 3, 38, 39, 37, 8, 9, 11, 12, 21, 23, 27, 29, 31}));
        animCharMap.put(AnimType.EXT_SPECIALSTANDING_DOCUMENTS_TAKE_01, AnimationCharacterMapping.procCharIds(new int[]{34, 35, 2, 3, 38, 39, 37, 8, 9, 11, 12, 21, 23, 27, 29, 31}));
        animCharMap.put(AnimType.EXT_SPECIALSTANDING_DOOR_KNOCK_01, AnimationCharacterMapping.procCharIds(new int[]{34, 35, 2, 3, 38, 39, 37, 8, 9, 11, 12, 21, 23, 27, 29, 31}));
        animCharMap.put(AnimType.EXT_SPECIALSTANDING_DOOR_LISTEN_01, AnimationCharacterMapping.procCharIds(new int[]{34, 35, 2, 3, 38, 39, 37, 8, 9, 11, 12, 21, 23, 27, 29, 31}));
        animCharMap.put(AnimType.EXT_SPECIALSTANDING_DOOR_TRYINWARDS_01, AnimationCharacterMapping.procCharIds(new int[]{34, 35, 2, 3, 38, 39, 37, 8, 9, 11, 12, 21, 23, 27, 29, 31}));
        animCharMap.put(AnimType.EXT_SPECIALSTANDING_DOOR_TRYOUTWARDS_01, AnimationCharacterMapping.procCharIds(new int[]{34, 35, 2, 3, 38, 39, 37, 8, 9, 11, 12, 21, 23, 27, 29, 31}));
        animCharMap.put(AnimType.EXT_SPECIALSTANDING_IDLE_CIGARETTE_01, AnimationCharacterMapping.procCharIds(new int[]{34, 35, 2, 3, 38, 39, 37, 8, 9, 11, 12, 21, 23, 27, 29, 31}));
        animCharMap.put(AnimType.EXT_SPECIALSTANDING_INVITE_SIT_01, AnimationCharacterMapping.procCharIds(new int[]{34, 35, 2, 3, 38, 39, 37, 8, 9, 11, 12, 21, 23, 27, 29, 31}));
        animCharMap.put(AnimType.EXT_SPECIALSTANDING_LAUGH_EXTREME_01, AnimationCharacterMapping.procCharIds(new int[]{34, 35, 2, 3, 38, 39, 37, 8, 9, 11, 12, 21, 23, 27, 29, 31}));
        animCharMap.put(AnimType.EXT_SPECIALSTANDING_LAUGH_LOUD_01, AnimationCharacterMapping.procCharIds(new int[]{34, 35, 2, 3, 38, 39, 37, 8, 9, 11, 12, 21, 23, 27, 29, 31}));
        animCharMap.put(AnimType.EXT_SPECIALSTANDING_LAUGH_LOW_01, AnimationCharacterMapping.procCharIds(new int[]{34, 35, 2, 3, 38, 39, 37, 8, 9, 11, 12, 21, 23, 27, 29, 31}));
        animCharMap.put(AnimType.EXT_SPECIALSTANDING_PRESENTATION_LEFT_01, AnimationCharacterMapping.procCharIds(new int[]{34, 35, 2, 3, 38, 39, 37, 8, 9, 11, 12, 21, 23, 27, 29, 31}));
        animCharMap.put(AnimType.EXT_SPECIALSTANDING_PRESENTATION_LEFT_02, AnimationCharacterMapping.procCharIds(new int[]{34, 35, 2, 3, 38, 39, 37, 8, 9, 11, 12, 21, 23, 27, 29, 31}));
        animCharMap.put(AnimType.EXT_SPECIALSTANDING_PRESENTATION_RIGHT_01, AnimationCharacterMapping.procCharIds(new int[]{34, 35, 2, 3, 38, 39, 37, 8, 9, 11, 12, 21, 23, 27, 29, 31}));
        animCharMap.put(AnimType.EXT_SPECIALSTANDING_PRESENTATION_RIGHT_02, AnimationCharacterMapping.procCharIds(new int[]{34, 35, 2, 3, 38, 39, 37, 8, 9, 11, 12, 21, 23, 27, 29, 31}));
        animCharMap.put(AnimType.EXT_SPECIALSTANDING_TURN_LEFT120_01, AnimationCharacterMapping.procCharIds(new int[]{34, 35, 2, 3, 38, 39, 37, 8, 9, 11, 12, 21, 23, 27, 29, 31}));
        animCharMap.put(AnimType.EXT_SPECIALSTANDING_TURN_LEFT180_01, AnimationCharacterMapping.procCharIds(new int[]{34, 35, 2, 3, 38, 39, 37, 8, 9, 11, 12, 21, 23, 27, 29, 31}));
        animCharMap.put(AnimType.EXT_SPECIALSTANDING_TURN_LEFT60_01, AnimationCharacterMapping.procCharIds(new int[]{34, 35, 2, 3, 38, 39, 37, 8, 9, 11, 12, 21, 23, 27, 29, 31}));
        animCharMap.put(AnimType.EXT_SPECIALSTANDING_TURN_LEFT90_01, AnimationCharacterMapping.procCharIds(new int[]{34, 35, 2, 3, 38, 39, 37, 8, 9, 11, 12, 21, 23, 27, 29, 31}));
        animCharMap.put(AnimType.EXT_SPECIALSTANDING_TURN_RIGHT120_01, AnimationCharacterMapping.procCharIds(new int[]{34, 35, 2, 3, 38, 39, 37, 8, 9, 11, 12, 21, 23, 27, 29, 31}));
        animCharMap.put(AnimType.EXT_SPECIALSTANDING_TURN_RIGHT180_01, AnimationCharacterMapping.procCharIds(new int[]{34, 35, 2, 3, 38, 39, 37, 8, 9, 11, 12, 21, 23, 27, 29, 31}));
        animCharMap.put(AnimType.EXT_SPECIALSTANDING_TURN_RIGHT60_01, AnimationCharacterMapping.procCharIds(new int[]{34, 35, 2, 3, 38, 39, 37, 8, 9, 11, 12, 21, 23, 27, 29, 31}));
        animCharMap.put(AnimType.EXT_SPECIALSTANDING_WALL_LEANONGESTIC_01, AnimationCharacterMapping.procCharIds(new int[]{34, 35, 2, 3, 38, 39, 37, 8, 9, 11, 12, 21, 23, 27, 29, 31}));
        animCharMap.put(AnimType.EXT_SPECIALSTANDING_WALL_LEANONIDLE_01, AnimationCharacterMapping.procCharIds(new int[]{34, 35, 2, 3, 38, 39, 37, 8, 9, 11, 12, 21, 23, 27, 29, 31}));
        animCharMap.put(AnimType.EXT_SPECIALSTANDING_WALL_LEANONIN_01, AnimationCharacterMapping.procCharIds(new int[]{34, 35, 2, 3, 38, 39, 37, 8, 9, 11, 12, 21, 23, 27, 29, 31}));
        animCharMap.put(AnimType.EXT_SPECIALSTANDING_WALL_LEANONLISTEN_01, AnimationCharacterMapping.procCharIds(new int[]{34, 35, 2, 3, 38, 39, 37, 8, 9, 11, 12, 21, 23, 27, 29, 31}));
        animCharMap.put(AnimType.EXT_SPECIALSTANDING_WALL_LEANONOUT_01, AnimationCharacterMapping.procCharIds(new int[]{34, 35, 2, 3, 38, 39, 37, 8, 9, 11, 12, 21, 23, 27, 29, 31}));
        animCharMap.put(AnimType.EXT_SPECIALSTANDING_WAVE_01, AnimationCharacterMapping.procCharIds(new int[]{34, 35, 2, 3, 38, 39, 37, 8, 9, 11, 12, 21, 23, 27, 29, 31}));
        animCharMap.put(AnimType.EXT_SPECIALSTANDING_WAVE_02, AnimationCharacterMapping.procCharIds(new int[]{34, 35, 2, 3, 38, 39, 37, 8, 9, 11, 12, 21, 23, 27, 29, 31}));
        animCharMap.put(AnimType.EXT_SPECIALSTANDING_WORK_MID_01, AnimationCharacterMapping.procCharIds(new int[]{34, 35, 2, 3, 38, 39, 37, 8, 9, 11, 12, 21, 23, 27, 29, 31}));
        animCharMap.put(AnimType.EXT_SPECIALSTANDING_WORK_TABLE_01, AnimationCharacterMapping.procCharIds(new int[]{34, 35, 2, 3, 38, 39, 37, 8, 9, 11, 12, 21, 23, 27, 29, 31}));
        animCharMap.put(AnimType.SPRINT_LOOP, AnimationCharacterMapping.procCharIds(new int[]{4}));
        animCharMap.put(AnimType.SPRINT_LOOPSTART, AnimationCharacterMapping.procCharIds(new int[]{4}));
        animCharMap.put(AnimType.SPRINT_LOOPSTOP, AnimationCharacterMapping.procCharIds(new int[]{4}));
        animCharMap.put(AnimType.EMOHAWK_STANDIDLE01, AnimationCharacterMapping.procCharIds(new int[]{4}));
        animCharMap.put(AnimType.EMOHAWK_STANDIDLE02, AnimationCharacterMapping.procCharIds(new int[]{4}));
        animCharMap.put(AnimType.EMOHAWK_STANDIDLE03, AnimationCharacterMapping.procCharIds(new int[]{4}));
        animCharMap.put(AnimType.EXT_STANDINGSPECIAL_CHEER_01, AnimationCharacterMapping.procCharIds(new int[]{1, 32, 33, 36, 7, 40, 10, 13, 14, 15, 17, 16, 19, 18, 20, 22, 25, 24, 26, 28, 30}));
        animCharMap.put(AnimType.EXT_STANDINGSPECIAL_CHEER_02, AnimationCharacterMapping.procCharIds(new int[]{1, 32, 33, 36, 7, 40, 10, 13, 14, 15, 17, 16, 19, 18, 20, 22, 25, 24, 26, 28, 30}));
        animCharMap.put(AnimType.EXT_STANDINGSPECIAL_CHEER_03, AnimationCharacterMapping.procCharIds(new int[]{1, 32, 33, 36, 7, 40, 10, 13, 14, 15, 17, 16, 19, 18, 20, 22, 25, 24, 26, 28, 30}));
        animCharMap.put(AnimType.EXT_STANDINGSPECIAL_CHEER_04, AnimationCharacterMapping.procCharIds(new int[]{1, 32, 33, 36, 7, 40, 10, 13, 14, 15, 17, 16, 19, 18, 20, 22, 25, 24, 26, 28, 30}));
        animCharMap.put(AnimType.EXT_STANDINGSPECIAL_CHEER_05, AnimationCharacterMapping.procCharIds(new int[]{1, 32, 33, 36, 7, 40, 10, 13, 14, 15, 17, 16, 19, 18, 20, 22, 25, 24, 26, 28, 30}));
        animCharMap.put(AnimType.EXT_STANDINGSPECIAL_CLAPHANDS_01, AnimationCharacterMapping.procCharIds(new int[]{1, 32, 33, 36, 7, 40, 10, 13, 14, 15, 17, 16, 19, 18, 20, 22, 25, 24, 26, 28, 30}));
        animCharMap.put(AnimType.EXT_STANDINGSPECIAL_CLAPHANDS_02, AnimationCharacterMapping.procCharIds(new int[]{1, 32, 33, 36, 7, 40, 10, 13, 14, 15, 17, 16, 19, 18, 20, 22, 25, 24, 26, 28, 30}));
        animCharMap.put(AnimType.EXT_STANDINGSPECIAL_CROUCH_GESTIC_01, AnimationCharacterMapping.procCharIds(new int[]{1, 32, 33, 36, 7, 40, 10, 13, 14, 15, 17, 16, 19, 18, 20, 22, 25, 24, 26, 28, 30}));
        animCharMap.put(AnimType.EXT_STANDINGSPECIAL_CROUCH_IDLE_01, AnimationCharacterMapping.procCharIds(new int[]{1, 32, 33, 36, 7, 40, 10, 13, 14, 15, 17, 16, 19, 18, 20, 22, 25, 24, 26, 28, 30}));
        animCharMap.put(AnimType.EXT_STANDINGSPECIAL_CROUCH_IN_01, AnimationCharacterMapping.procCharIds(new int[]{1, 32, 33, 36, 7, 40, 10, 13, 14, 15, 17, 16, 19, 18, 20, 22, 25, 24, 26, 28, 30}));
        animCharMap.put(AnimType.EXT_STANDINGSPECIAL_CROUCH_OUT_01, AnimationCharacterMapping.procCharIds(new int[]{1, 32, 33, 36, 7, 40, 10, 13, 14, 15, 17, 16, 19, 18, 20, 22, 25, 24, 26, 28, 30}));
        animCharMap.put(AnimType.EXT_STANDINGSPECIAL_DANCING_AGRESSIVE_01, AnimationCharacterMapping.procCharIds(new int[]{1, 32, 33, 36, 7, 40, 10, 13, 14, 15, 17, 16, 19, 18, 20, 22, 25, 24, 26, 28, 30}));
        animCharMap.put(AnimType.EXT_STANDINGSPECIAL_DANCING_COOL_01, AnimationCharacterMapping.procCharIds(new int[]{1, 32, 33, 36, 7, 40, 10, 13, 14, 15, 17, 16, 19, 18, 20, 22, 25, 24, 26, 28, 30}));
        animCharMap.put(AnimType.EXT_STANDINGSPECIAL_DANCING_NEUTRAL_01, AnimationCharacterMapping.procCharIds(new int[]{1, 32, 33, 36, 7, 40, 10, 13, 14, 15, 17, 16, 19, 18, 20, 22, 25, 24, 26, 28, 30}));
        animCharMap.put(AnimType.EXT_STANDINGSPECIAL_DANCING_SEXY_01, AnimationCharacterMapping.procCharIds(new int[]{1, 32, 33, 36, 7, 40, 10, 13, 14, 15, 17, 16, 19, 18, 20, 22, 25, 24, 26, 28, 30}));
        animCharMap.put(AnimType.EXT_STANDINGSPECIAL_DANCING_SILLY_01, AnimationCharacterMapping.procCharIds(new int[]{1, 32, 33, 36, 7, 40, 10, 13, 14, 15, 17, 16, 19, 18, 20, 22, 25, 24, 26, 28, 30}));
        animCharMap.put(AnimType.EXT_STANDINGSPECIAL_DOCUMENTS_CHECK_01, AnimationCharacterMapping.procCharIds(new int[]{1, 32, 33, 36, 7, 40, 10, 13, 14, 15, 17, 16, 19, 18, 20, 22, 25, 24, 26, 28, 30}));
        animCharMap.put(AnimType.EXT_STANDINGSPECIAL_DOCUMENTS_IDLE_01, AnimationCharacterMapping.procCharIds(new int[]{1, 32, 33, 36, 7, 40, 10, 13, 14, 15, 17, 16, 19, 18, 20, 22, 25, 24, 26, 28, 30}));
        animCharMap.put(AnimType.EXT_STANDINGSPECIAL_DOCUMENTS_IN_01, AnimationCharacterMapping.procCharIds(new int[]{1, 32, 33, 36, 7, 40, 10, 13, 14, 15, 17, 16, 19, 18, 20, 22, 25, 24, 26, 28, 30}));
        animCharMap.put(AnimType.EXT_STANDINGSPECIAL_DOCUMENTS_NOTE_01, AnimationCharacterMapping.procCharIds(new int[]{1, 32, 33, 36, 7, 40, 10, 13, 14, 15, 17, 16, 19, 18, 20, 22, 25, 24, 26, 28, 30}));
        animCharMap.put(AnimType.EXT_STANDINGSPECIAL_DOCUMENTS_OUT_01, AnimationCharacterMapping.procCharIds(new int[]{1, 32, 33, 36, 7, 40, 10, 13, 14, 15, 17, 16, 19, 18, 20, 22, 25, 24, 26, 28, 30}));
        animCharMap.put(AnimType.EXT_STANDINGSPECIAL_DOCUMENTS_TAKE_01, AnimationCharacterMapping.procCharIds(new int[]{1, 32, 33, 36, 7, 40, 10, 13, 14, 15, 17, 16, 19, 18, 20, 22, 25, 24, 26, 28, 30}));
        animCharMap.put(AnimType.EXT_STANDINGSPECIAL_DOOR_KNOCK_01, AnimationCharacterMapping.procCharIds(new int[]{1, 32, 33, 36, 7, 40, 10, 13, 14, 15, 17, 16, 19, 18, 20, 22, 25, 24, 26, 28, 30}));
        animCharMap.put(AnimType.EXT_STANDINGSPECIAL_DOOR_LISTEN_01, AnimationCharacterMapping.procCharIds(new int[]{1, 32, 33, 36, 7, 40, 10, 13, 14, 15, 17, 16, 19, 18, 20, 22, 25, 24, 26, 28, 30}));
        animCharMap.put(AnimType.EXT_STANDINGSPECIAL_DOOR_TRYINWARDS_01, AnimationCharacterMapping.procCharIds(new int[]{1, 32, 33, 36, 7, 40, 10, 13, 14, 15, 17, 16, 19, 18, 20, 22, 25, 24, 26, 28, 30}));
        animCharMap.put(AnimType.EXT_STANDINGSPECIAL_DOOR_TRYOUTWARDS_01, AnimationCharacterMapping.procCharIds(new int[]{1, 32, 33, 36, 7, 40, 10, 13, 14, 15, 17, 16, 19, 18, 20, 22, 25, 24, 26, 28, 30}));
        animCharMap.put(AnimType.EXT_STANDINGSPECIAL_IDLE_CIGARETTE_01, AnimationCharacterMapping.procCharIds(new int[]{1, 32, 33, 36, 7, 40, 10, 13, 14, 15, 17, 16, 19, 18, 20, 22, 25, 24, 26, 28, 30}));
        animCharMap.put(AnimType.EXT_STANDINGSPECIAL_INVITE_SIT_01, AnimationCharacterMapping.procCharIds(new int[]{1, 32, 33, 36, 7, 40, 10, 13, 14, 15, 17, 16, 19, 18, 20, 22, 25, 24, 26, 28, 30}));
        animCharMap.put(AnimType.EXT_STANDINGSPECIAL_LAUGH_EXTREME_01, AnimationCharacterMapping.procCharIds(new int[]{1, 32, 33, 36, 7, 40, 10, 13, 14, 15, 17, 16, 19, 18, 20, 22, 25, 24, 26, 28, 30}));
        animCharMap.put(AnimType.EXT_STANDINGSPECIAL_LAUGH_LOUD_01, AnimationCharacterMapping.procCharIds(new int[]{1, 32, 33, 36, 7, 40, 10, 13, 14, 15, 17, 16, 19, 18, 20, 22, 25, 24, 26, 28, 30}));
        animCharMap.put(AnimType.EXT_STANDINGSPECIAL_LAUGH_LOW_01, AnimationCharacterMapping.procCharIds(new int[]{1, 32, 33, 36, 7, 40, 10, 13, 14, 15, 17, 16, 19, 18, 20, 22, 25, 24, 26, 28, 30}));
        animCharMap.put(AnimType.EXT_STANDINGSPECIAL_PRESENTATION_LEFT_01, AnimationCharacterMapping.procCharIds(new int[]{1, 32, 33, 36, 7, 40, 10, 13, 14, 15, 17, 16, 19, 18, 20, 22, 25, 24, 26, 28, 30}));
        animCharMap.put(AnimType.EXT_STANDINGSPECIAL_PRESENTATION_LEFT_02, AnimationCharacterMapping.procCharIds(new int[]{1, 32, 33, 36, 7, 40, 10, 13, 14, 15, 17, 16, 19, 18, 20, 22, 25, 24, 26, 28, 30}));
        animCharMap.put(AnimType.EXT_STANDINGSPECIAL_PRESENTATION_RIGHT_01, AnimationCharacterMapping.procCharIds(new int[]{1, 32, 33, 36, 7, 40, 10, 13, 14, 15, 17, 16, 19, 18, 20, 22, 25, 24, 26, 28, 30}));
        animCharMap.put(AnimType.EXT_STANDINGSPECIAL_PRESENTATION_RIGHT_02, AnimationCharacterMapping.procCharIds(new int[]{1, 32, 33, 36, 7, 40, 10, 13, 14, 15, 17, 16, 19, 18, 20, 22, 25, 24, 26, 28, 30}));
        animCharMap.put(AnimType.EXT_STANDINGSPECIAL_TURN_LEFT120_01, AnimationCharacterMapping.procCharIds(new int[]{1, 32, 33, 36, 7, 40, 10, 13, 14, 15, 17, 16, 19, 18, 20, 22, 25, 24, 26, 28, 30}));
        animCharMap.put(AnimType.EXT_STANDINGSPECIAL_TURN_LEFT180_01, AnimationCharacterMapping.procCharIds(new int[]{1, 32, 33, 36, 7, 40, 10, 13, 14, 15, 17, 16, 19, 18, 20, 22, 25, 24, 26, 28, 30}));
        animCharMap.put(AnimType.EXT_STANDINGSPECIAL_TURN_LEFT60_01, AnimationCharacterMapping.procCharIds(new int[]{1, 32, 33, 36, 7, 40, 10, 13, 14, 15, 17, 16, 19, 18, 20, 22, 25, 24, 26, 28, 30}));
        animCharMap.put(AnimType.EXT_STANDINGSPECIAL_TURN_LEFT90_01, AnimationCharacterMapping.procCharIds(new int[]{1, 32, 33, 36, 7, 40, 10, 13, 14, 15, 17, 16, 19, 18, 20, 22, 25, 24, 26, 28, 30}));
        animCharMap.put(AnimType.EXT_STANDINGSPECIAL_TURN_RIGHT120_01, AnimationCharacterMapping.procCharIds(new int[]{1, 32, 33, 36, 7, 40, 10, 13, 14, 15, 17, 16, 19, 18, 20, 22, 25, 24, 26, 28, 30}));
        animCharMap.put(AnimType.EXT_STANDINGSPECIAL_TURN_RIGHT180_01, AnimationCharacterMapping.procCharIds(new int[]{1, 32, 33, 36, 7, 40, 10, 13, 14, 15, 17, 16, 19, 18, 20, 22, 25, 24, 26, 28, 30}));
        animCharMap.put(AnimType.EXT_STANDINGSPECIAL_TURN_RIGHT60_01, AnimationCharacterMapping.procCharIds(new int[]{1, 32, 33, 36, 7, 40, 10, 13, 14, 15, 17, 16, 19, 18, 20, 22, 25, 24, 26, 28, 30}));
        animCharMap.put(AnimType.EXT_STANDINGSPECIAL_TURN_RIGHT90_01, AnimationCharacterMapping.procCharIds(new int[]{1, 32, 33, 36, 7, 40, 10, 13, 14, 15, 17, 16, 19, 18, 20, 22, 25, 24, 26, 28, 30}));
        animCharMap.put(AnimType.EXT_STANDINGSPECIAL_WAVE_01, AnimationCharacterMapping.procCharIds(new int[]{1, 32, 33, 36, 7, 40, 10, 13, 14, 15, 17, 16, 19, 18, 20, 22, 25, 24, 26, 28, 30}));
        animCharMap.put(AnimType.EXT_STANDINGSPECIAL_WAVE_02, AnimationCharacterMapping.procCharIds(new int[]{1, 32, 33, 36, 7, 40, 10, 13, 14, 15, 17, 16, 19, 18, 20, 22, 25, 24, 26, 28, 30}));
        animCharMap.put(AnimType.EXT_STANDINGSPECIAL_WORK_MID, AnimationCharacterMapping.procCharIds(new int[]{1, 32, 33, 36, 7, 40, 10, 13, 14, 15, 17, 16, 19, 18, 20, 22, 25, 24, 26, 28, 30}));
        animCharMap.put(AnimType.EXT_STANDINGSPECIAL_WORK_TABLE, AnimationCharacterMapping.procCharIds(new int[]{1, 32, 33, 36, 7, 40, 10, 13, 14, 15, 17, 16, 19, 18, 20, 22, 25, 24, 26, 28, 30}));
        animCharMap.put(AnimType.EXT_STANDING_DRUNK_01, AnimationCharacterMapping.procCharIds(new int[]{1, 32, 33, 36, 7, 40, 10, 13, 14, 15, 17, 16, 19, 18, 20, 22, 25, 24, 26, 28, 30}));
        animCharMap.put(AnimType.EXT_STANDING_DRUNK_02, AnimationCharacterMapping.procCharIds(new int[]{1, 32, 33, 36, 7, 40, 10, 13, 14, 15, 17, 16, 19, 18, 20, 22, 25, 24, 26, 28, 30}));
        animCharMap.put(AnimType.EXT_STANDING_IDLE_ANGRY_01, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_STANDING_IDLE_ANGRY_02, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_STANDING_IDLE_BREATHE_01, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_STANDING_IDLE_BREATHE_02, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_STANDING_IDLE_BREATHE_03, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_STANDING_IDLE_COUGH_01, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_STANDING_IDLE_COUGH_02, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_STANDING_IDLE_DRUNK_01, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_STANDING_IDLE_DRUNK_02, AnimationCharacterMapping.procCharIds(new int[]{1, 32, 33, 36, 7, 40, 10, 13, 14, 15, 17, 16, 19, 18, 20, 22, 25, 24, 26, 28, 30}));
        animCharMap.put(AnimType.EXT_STANDING_IDLE_DUST_01, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_STANDING_IDLE_DUST_02, AnimationCharacterMapping.procCharIds(new int[]{1, 32, 33, 36, 7, 40, 10, 13, 14, 15, 17, 16, 19, 18, 20, 22, 25, 24, 26, 28, 30}));
        animCharMap.put(AnimType.EXT_STANDING_IDLE_FINGERNAIL_01, AnimationCharacterMapping.procCharIds(new int[]{34, 35, 2, 3, 38, 39, 37, 8, 9, 11, 12, 21, 23, 27, 29, 31}));
        animCharMap.put(AnimType.EXT_STANDING_IDLE_LOOKAROUND_01, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_STANDING_IDLE_LOOKAROUND_02, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_STANDING_IDLE_LOOKAROUND_03, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_STANDING_IDLE_MOVELEG_01, AnimationCharacterMapping.procCharIds(new int[]{34, 35, 2, 3, 38, 39, 37, 8, 9, 11, 12, 21, 23, 27, 29, 31}));
        animCharMap.put(AnimType.EXT_STANDING_IDLE_MOVE_01, AnimationCharacterMapping.procCharIds(new int[]{34, 35, 2, 3, 38, 39, 37, 8, 9, 11, 12, 21, 23, 27, 29, 31}));
        animCharMap.put(AnimType.EXT_STANDING_IDLE_NERVOUS_01, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_STANDING_IDLE_NERVOUS_02, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_STANDING_IDLE_NERVOUS_03, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_STANDING_IDLE_NEUTRAL_01, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_STANDING_IDLE_NEUTRAL_02, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_STANDING_IDLE_NEUTRAL_03, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_STANDING_IDLE_NEUTRAL_04, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_STANDING_IDLE_NEUTRAL_05, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_STANDING_IDLE_NEUTRAL_06, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_STANDING_IDLE_NEUTRAL_07, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_STANDING_IDLE_NEUTRAL_08, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_STANDING_IDLE_NEUTRAL_09, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_STANDING_IDLE_ROLLHEAD_01, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_STANDING_IDLE_ROLLHEAD_02, AnimationCharacterMapping.procCharIds(new int[]{34, 35, 2, 3, 38, 39, 37, 8, 9, 11, 12, 21, 23, 27, 29, 31}));
        animCharMap.put(AnimType.EXT_STANDING_IDLE_SCRATCHHEAD_01, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_STANDING_IDLE_SCRATCHHEAD_02, AnimationCharacterMapping.procCharIds(new int[]{1, 32, 33, 36, 7, 40, 10, 13, 14, 15, 17, 16, 19, 18, 20, 22, 25, 24, 26, 28, 30}));
        animCharMap.put(AnimType.EXT_STANDING_IDLE_SHAKEARMS_01, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_STANDING_IDLE_SHAKELEG_01, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_STANDING_IDLE_STRETCHARMS_01, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_STANDING_IDLE_TOUCHFACE_01, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_STANDING_IDLE_TOUCHFACE_02, AnimationCharacterMapping.procCharIds(new int[]{1, 32, 33, 36, 7, 40, 10, 13, 14, 15, 17, 16, 19, 18, 20, 22, 25, 24, 26, 28, 30}));
        animCharMap.put(AnimType.EXT_STANDING_IDLE_TOUCHHAIR_01, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_STANDING_IDLE_WAITING_01, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_STANDING_IDLE_WAITING_02, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_STANDING_IDLE_YAWN_01, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_STANDING_LISTEN_ACCEPT_01, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_STANDING_LISTEN_ACCEPT_02, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_STANDING_LISTEN_ACCEPT_03, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_STANDING_LISTEN_ACCEPT_04, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_STANDING_LISTEN_ACCEPT_05, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_STANDING_LISTEN_ANGRY_01, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_STANDING_LISTEN_DENY_01, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_STANDING_LISTEN_DENY_02, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_STANDING_LISTEN_DENY_03, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_STANDING_LISTEN_DENY_04, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_STANDING_LISTEN_DENY_05, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_STANDING_LISTEN_DENY_06, AnimationCharacterMapping.procCharIds(new int[]{1, 32, 33, 36, 7, 40, 10, 13, 14, 15, 17, 16, 19, 18, 20, 22, 25, 24, 26, 28, 30}));
        animCharMap.put(AnimType.EXT_STANDING_LISTEN_EXCITED_01, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_STANDING_LISTEN_LEFT_01, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_STANDING_LISTEN_NERVOUS_01, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_STANDING_LISTEN_NEUTRAL_01, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_STANDING_LISTEN_NEUTRAL_02, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_STANDING_LISTEN_NEUTRAL_03, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_STANDING_LISTEN_RELAXED_01, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_STANDING_LISTEN_RIGHT_01, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_STANDING_LISTEN_SAD_01, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_STANDING_LISTEN_SELFASSURED_01, AnimationCharacterMapping.procCharIds(new int[]{34, 35, 2, 3, 38, 39, 37, 8, 9, 11, 12, 21, 23, 27, 29, 31}));
        animCharMap.put(AnimType.EXT_STANDING_SHRUG_01, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_STANDING_SHRUG_02, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_STANDING_TALK_ANGRY_01, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_STANDING_TALK_ANGRY_02, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_STANDING_TALK_COOL_01, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_STANDING_TALK_EXCITED_01, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_STANDING_TALK_EXCITED_02, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_STANDING_TALK_FEMALESTRESSED_01, AnimationCharacterMapping.procCharIds(new int[]{34, 35, 2, 3, 38, 39, 37, 8, 9, 11, 12, 21, 23, 27, 29, 31}));
        animCharMap.put(AnimType.EXT_STANDING_TALK_LEFT_01, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_STANDING_TALK_NERVOUS_01, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_STANDING_TALK_NERVOUS_02, AnimationCharacterMapping.procCharIds(new int[]{34, 35, 2, 3, 38, 39, 37, 8, 9, 11, 12, 21, 23, 27, 29, 31}));
        animCharMap.put(AnimType.EXT_STANDING_TALK_NEUTRAL_01, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_STANDING_TALK_NEUTRAL_02, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_STANDING_TALK_NEUTRAL_03, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_STANDING_TALK_NEUTRAL_04, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_STANDING_TALK_NEUTRAL_05, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_STANDING_TALK_RELAXED_01, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_STANDING_TALK_RELAXED_02, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_STANDING_TALK_RIGHT_01, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_STANDING_TALK_SAD_01, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_STANDING_TALK_SELFASSURED_01, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_STANDING_TALK_SELFASSURED_02, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_STANDING_THOUGHTFUL_01, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.UDN_SWIM, AnimationCharacterMapping.procCharIds(new int[]{5, 6}));
        animCharMap.put(AnimType.UDN_THROW, AnimationCharacterMapping.procCharIds(new int[]{5}));
    }

    /*
     * Opcode count of 14317 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    private static void initializeCharacterAnimationMappingFour() {
        animCharMap.put(AnimType.EXT_WALKINGRUNNINGSYSTEM_ASCEND_STAIRSSTART_01, AnimationCharacterMapping.procCharIds(new int[]{1, 32, 33, 36, 7, 40, 10, 13, 14, 15, 17, 16, 19, 18, 20, 22, 25, 24, 26, 28, 30}));
        animCharMap.put(AnimType.EXT_WALKINGRUNNINGSYSTEM_ASCEND_STAIRS_01, AnimationCharacterMapping.procCharIds(new int[]{1, 32, 33, 36, 7, 40, 10, 13, 14, 15, 17, 16, 19, 18, 20, 22, 25, 24, 26, 28, 30}));
        animCharMap.put(AnimType.EXT_WALKINGRUNNINGSYSTEM_DESCEND_STAIRSSTART_01, AnimationCharacterMapping.procCharIds(new int[]{1, 32, 33, 36, 7, 40, 10, 13, 14, 15, 17, 16, 19, 18, 20, 22, 25, 24, 26, 28, 30}));
        animCharMap.put(AnimType.EXT_WALKINGRUNNINGSYSTEM_DESCEND_STAIRS_01, AnimationCharacterMapping.procCharIds(new int[]{1, 32, 33, 36, 7, 40, 10, 13, 14, 15, 17, 16, 19, 18, 20, 22, 25, 24, 26, 28, 30}));
        animCharMap.put(AnimType.EXT_WALKINGRUNNINGSYSTEM_RUN_NEUTRAL_01, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_WALKINGRUNNINGSYSTEM_RUN_START_01, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_WALKINGRUNNINGSYSTEM_RUN_STOP_01, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_WALKINGRUNNINGSYSTEM_RUN_TOWALK_01, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_WALKINGRUNNINGSYSTEM_STAIRS_ASCENDSTART_01, AnimationCharacterMapping.procCharIds(new int[]{34, 35, 2, 3, 38, 39, 37, 8, 9, 11, 12, 21, 23, 27, 29, 31}));
        animCharMap.put(AnimType.EXT_WALKINGRUNNINGSYSTEM_STAIRS_ASCEND_01, AnimationCharacterMapping.procCharIds(new int[]{34, 35, 2, 3, 38, 39, 37, 8, 9, 11, 12, 21, 23, 27, 29, 31}));
        animCharMap.put(AnimType.EXT_WALKINGRUNNINGSYSTEM_STAIRS_DESCENDSTART_01, AnimationCharacterMapping.procCharIds(new int[]{34, 35, 2, 3, 38, 39, 37, 8, 9, 11, 12, 21, 23, 27, 29, 31}));
        animCharMap.put(AnimType.EXT_WALKINGRUNNINGSYSTEM_STAIRS_DESCEND_01, AnimationCharacterMapping.procCharIds(new int[]{34, 35, 2, 3, 38, 39, 37, 8, 9, 11, 12, 21, 23, 27, 29, 31}));
        animCharMap.put(AnimType.EXT_WALKINGRUNNINGSYSTEM_TURN_LEFT120TOWALK_01, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_WALKINGRUNNINGSYSTEM_TURN_LEFT180TOWALK_01, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_WALKINGRUNNINGSYSTEM_TURN_LEFT60TOWALK_01, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_WALKINGRUNNINGSYSTEM_TURN_RIGHT120TOWALK_01, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_WALKINGRUNNINGSYSTEM_TURN_RIGHT180TOWALK_01, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_WALKINGRUNNINGSYSTEM_TURN_RIGHT60TOWALK_01, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_WALKINGRUNNINGSYSTEM_WALK_NEUTRAL_01, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_WALKINGRUNNINGSYSTEM_WALK_START_01, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_WALKINGRUNNINGSYSTEM_WALK_STOP_01, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_WALKINGRUNNINGSYSTEM_WALK_TORUN_01, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_WALKING_RUN_EXTREMEFEMALE_01, AnimationCharacterMapping.procCharIds(new int[]{34, 35, 2, 3, 38, 39, 37, 8, 9, 11, 12, 21, 23, 27, 29, 31}));
        animCharMap.put(AnimType.EXT_WALKING_RUN_FAST_01, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_WALKING_RUN_FAST_02, AnimationCharacterMapping.procCharIds(new int[]{1, 32, 33, 36, 7, 40, 10, 13, 14, 15, 17, 16, 19, 18, 20, 22, 25, 24, 26, 28, 30}));
        animCharMap.put(AnimType.EXT_WALKING_RUN_INJURED_01, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_WALKING_RUN_NEUTRAL_01, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_WALKING_RUN_NEUTRAL_02, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_WALKING_RUN_OBESE_01, AnimationCharacterMapping.procCharIds(new int[]{34, 35, 2, 3, 38, 39, 37, 8, 9, 11, 12, 21, 23, 27, 29, 31}));
        animCharMap.put(AnimType.EXT_WALKING_RUN_OBESE_02, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_WALKING_RUN_SLOW_01, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_WALKING_RUN_SLOW_02, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_WALKING_WALK_BRUISED_01, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_WALKING_WALK_COOL_01, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_WALKING_WALK_COOL_02, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_WALKING_WALK_DRUNK_01, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_WALKING_WALK_EXTREMEFEMALE_01, AnimationCharacterMapping.procCharIds(new int[]{34, 35, 2, 3, 38, 39, 37, 8, 9, 11, 12, 21, 23, 27, 29, 31}));
        animCharMap.put(AnimType.EXT_WALKING_WALK_FAST_01, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_WALKING_WALK_FAST_02, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_WALKING_WALK_FAST_03, AnimationCharacterMapping.procCharIds(new int[]{34, 35, 2, 3, 38, 39, 37, 8, 9, 11, 12, 21, 23, 27, 29, 31}));
        animCharMap.put(AnimType.EXT_WALKING_WALK_NEUTRAL_01, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_WALKING_WALK_NEUTRAL_02, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_WALKING_WALK_NEUTRAL_03, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_WALKING_WALK_OBESE_01, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_WALKING_WALK_OBESE_02, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_WALKING_WALK_SELFASSURED_01, AnimationCharacterMapping.procCharIds(new int[]{34, 35, 2, 3, 38, 39, 37, 8, 9, 11, 12, 21, 23, 27, 29, 31}));
        animCharMap.put(AnimType.EXT_WALKING_WALK_SLOW_01, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_WALKING_WALK_SLOW_02, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_WALKING_WALK_STROLL_01, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_WALKING_WALK_STROLL_02, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.WALK_ANGRY01, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.WALK_ANGRY02, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.WALK_BACK, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.WALK_BACKWALK, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 4, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.WALK_BACK_LOOP, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.WALK_BACK_REACTIONTOPUSH, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.WALK_CARRY01, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.WALK_CARRY02, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.WALK_CONFIDENT, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.WALK_CONFIDENTSHORT, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.WALK_COOING01, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.WALK_COOING01START, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.WALK_COOING02, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.WALK_COOING02START, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.WALK_COOING03, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.WALK_COOING04, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.WALK_COOING05, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.WALK_COOING06, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.WALK_COOING07, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.WALK_COOING08, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.WALK_DEPRESSED, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.WALK_DEPRESSEDSHORT, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.WALK_DIZZY, AnimationCharacterMapping.procCharIds(new int[]{4}));
        animCharMap.put(AnimType.WALK_DRUNK, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.WALK_ENTHUSE01, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.WALK_ENTHUSE02, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.WALK_HAPPY, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.WALK_HAPPYSHORT, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.WALK_HEADTURNING, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.WALK_INJURED, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.WALK_LOOP, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 4, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.WALK_LOOPSTART, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 4, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.WALK_LOOPSTOP, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 4, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.WALK_MONSTER01, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.WALK_MONSTER02, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.WALK_NORMAL, AnimationCharacterMapping.procCharIds(new int[]{4}));
        animCharMap.put(AnimType.WALK_NORMAL01, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.WALK_NORMAL02, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.WALK_SEXY, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 4, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.WALK_SEXYSHORT, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.WALK_SPEAKLEFT_FEMALE01, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.WALK_SPEAKLEFT_FEMALE02, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.WALK_SPEAKLEFT_MALE01, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.WALK_SPEAKLEFT_MALE02, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.WALK_SPEAKRIGHT_FEMALE01, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.WALK_SPEAKRIGHT_FEMALE02, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.WALK_SPEAKRIGHT_MALE01, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.WALK_SPEAKRIGHT_MALE02, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.WALK_TIRED, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 4, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.WALK_ZOMBIE01, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.WALK_ZOMBIE02, AnimationCharacterMapping.procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
    }

    private static HashSet<CharacterType> procCharIds(int[] charactersArray) {
        HashSet<CharacterType> characterSet = new HashSet<CharacterType>();
        for (int i = 0; i < charactersArray.length; ++i) {
            for (CharacterType charType : CharacterType.values()) {
                if (charType.getCharacterID() != charactersArray[i]) continue;
                characterSet.add(charType);
            }
        }
        return characterSet;
    }

    static {
        AnimationCharacterMapping.initializeCharacterAnimationMappingOne();
        AnimationCharacterMapping.initializeCharacterAnimationMappingTwo();
        AnimationCharacterMapping.initializeCharacterAnimationMappingThree();
        AnimationCharacterMapping.initializeCharacterAnimationMappingFour();
        for (AnimType at : animCharMap.keySet()) {
            stringAnimMap.put(at.unrealID, at);
            for (CharacterType charType : animCharMap.get((Object)at)) {
                if (!charAnimMap.containsKey((Object)charType)) {
                    charAnimMap.put(charType, new HashSet());
                }
                charAnimMap.get((Object)charType).add(at);
            }
        }
    }
}

