/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.sposh.engine;

import cz.cuni.amis.pogamut.sposh.elements.ActionPattern;
import cz.cuni.amis.pogamut.sposh.elements.Adopt;
import cz.cuni.amis.pogamut.sposh.elements.Competence;
import cz.cuni.amis.pogamut.sposh.elements.LapPath;
import cz.cuni.amis.pogamut.sposh.elements.LapType;
import cz.cuni.amis.pogamut.sposh.elements.PoshPlan;
import cz.cuni.amis.pogamut.sposh.elements.PrimitiveCall;
import cz.cuni.amis.pogamut.sposh.elements.TriggeredAction;
import cz.cuni.amis.pogamut.sposh.engine.ADExecutor;
import cz.cuni.amis.pogamut.sposh.engine.APExecutor;
import cz.cuni.amis.pogamut.sposh.engine.ActionExecutor;
import cz.cuni.amis.pogamut.sposh.engine.CExecutor;
import cz.cuni.amis.pogamut.sposh.engine.EngineLog;
import cz.cuni.amis.pogamut.sposh.engine.FireResult;
import cz.cuni.amis.pogamut.sposh.engine.StackElement;
import cz.cuni.amis.pogamut.sposh.engine.VariableContext;

abstract class AbstractExecutor {
    protected final LapPath path;
    protected final VariableContext ctx;
    protected final EngineLog engineLog;

    protected AbstractExecutor(LapPath path, VariableContext ctx, EngineLog engineLog) {
        this.path = path;
        this.ctx = ctx;
        this.engineLog = engineLog;
    }

    public final LapPath getPath() {
        return this.path;
    }

    private StackElement<ADExecutor> getElementAD(PoshPlan plan, PrimitiveCall adaptCall, LapPath referencePath) {
        String adoptName = adaptCall.getName();
        Adopt adopt = plan.getAD(adoptName);
        if (adopt == null) {
            return null;
        }
        int adoptId = plan.getAdoptId(adopt);
        assert (plan.getAdopts().get(adoptId) == adopt);
        LapPath adoptPath = referencePath.concat(LapType.ADOPT, adoptId);
        VariableContext adoptContext = new VariableContext(this.ctx, adaptCall.getParameters(), adopt.getParameters());
        ADExecutor adoptExecutor = new ADExecutor(plan, adopt, adoptPath, adoptContext, this.engineLog);
        return new StackElement<ADExecutor>(Adopt.class, adoptName, adoptExecutor);
    }

    private StackElement<APExecutor> getElementAP(PoshPlan plan, PrimitiveCall actionPatternCall, LapPath referencePath) {
        String actionPatternName = actionPatternCall.getName();
        ActionPattern actionPattern = plan.getAP(actionPatternName);
        if (actionPattern == null) {
            return null;
        }
        int actionPatternId = plan.getActionPatternId(actionPattern);
        assert (plan.getActionPatterns().get(actionPatternId) == actionPattern);
        LapPath actionPatternPath = referencePath.concat(LapType.ACTION_PATTERN, actionPatternId);
        VariableContext actionPatternContext = new VariableContext(this.ctx, actionPatternCall.getParameters(), actionPattern.getParameters());
        APExecutor actionPatternExecutor = new APExecutor(plan, actionPattern, FireResult.Type.SURFACE, actionPatternPath, actionPatternContext, this.engineLog);
        return new StackElement<APExecutor>(ActionPattern.class, actionPatternName, actionPatternExecutor);
    }

    private StackElement<CExecutor> getElementC(PoshPlan plan, PrimitiveCall competenceCall, LapPath referencePath) {
        String competenceName = competenceCall.getName();
        Competence competence = plan.getC(competenceName);
        if (competence == null) {
            return null;
        }
        int competenceId = plan.getCompetenceId(competence);
        assert (plan.getCompetences().get(competenceId) == competence);
        LapPath competencePath = referencePath.concat(LapType.COMPETENCE, competenceId);
        VariableContext competenceContext = new VariableContext(this.ctx, competenceCall.getParameters(), competence.getParameters());
        CExecutor competenceExecutor = new CExecutor(plan, competence, competencePath, competenceContext, this.engineLog);
        return new StackElement<CExecutor>(Competence.class, competenceName, competenceExecutor);
    }

    private StackElement<ActionExecutor> getElementAction(PoshPlan plan, PrimitiveCall actionCall, LapPath referencePath, Runnable finishedResultCallback, Runnable runningResultCallback, Runnable runningOnceResultCallback, Runnable failedResultCallback) {
        String actionName = actionCall.getName();
        ActionExecutor actionExecutor = new ActionExecutor(actionCall, finishedResultCallback, runningResultCallback, runningOnceResultCallback, failedResultCallback, referencePath, new VariableContext(this.ctx, actionCall.getParameters()), this.engineLog);
        return new StackElement<ActionExecutor>(TriggeredAction.class, actionName, actionExecutor);
    }

    protected StackElement getElement(PoshPlan plan, PrimitiveCall actionCall, LapPath referencePath) {
        return this.getElement(plan, actionCall, referencePath, null, null, null, null);
    }

    protected StackElement getElement(PoshPlan plan, PrimitiveCall actionCall, LapPath referencePath, Runnable finishedResultCallback, Runnable runningResultCallback, Runnable runningOnceCallback, Runnable failedResultCallback) {
        StackElement<AbstractExecutor> stackElement = this.getElementC(plan, actionCall, referencePath);
        if (stackElement == null && (stackElement = this.getElementAP(plan, actionCall, referencePath)) == null && (stackElement = this.getElementAD(plan, actionCall, referencePath)) == null) {
            stackElement = this.getElementAction(plan, actionCall, referencePath, finishedResultCallback, runningResultCallback, runningOnceCallback, failedResultCallback);
        }
        return stackElement;
    }
}

