/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.sposh.engine;

import cz.cuni.amis.pogamut.sposh.elements.Competence;
import cz.cuni.amis.pogamut.sposh.elements.CompetenceElement;
import cz.cuni.amis.pogamut.sposh.elements.LapPath;
import cz.cuni.amis.pogamut.sposh.elements.LapType;
import cz.cuni.amis.pogamut.sposh.elements.PoshPlan;
import cz.cuni.amis.pogamut.sposh.engine.AbstractExecutor;
import cz.cuni.amis.pogamut.sposh.engine.CEExecutor;
import cz.cuni.amis.pogamut.sposh.engine.ElementExecutor;
import cz.cuni.amis.pogamut.sposh.engine.EngineLog;
import cz.cuni.amis.pogamut.sposh.engine.FireResult;
import cz.cuni.amis.pogamut.sposh.engine.SenseListExecutor;
import cz.cuni.amis.pogamut.sposh.engine.StackElement;
import cz.cuni.amis.pogamut.sposh.engine.TriggerResult;
import cz.cuni.amis.pogamut.sposh.engine.VariableContext;
import cz.cuni.amis.pogamut.sposh.executor.IWorkExecutor;
import java.util.ArrayList;
import java.util.List;

final class CExecutor
extends AbstractExecutor
implements ElementExecutor {
    private final PoshPlan plan;
    private final Competence competence;
    @Deprecated
    private final SenseListExecutor goalExecutor;
    private final List<CEExecutor> ceExecutors = new ArrayList<CEExecutor>();

    public CExecutor(PoshPlan plan, Competence competence, LapPath competencePath, VariableContext ctx, EngineLog log) {
        super(competencePath, ctx, log);
        assert (competencePath.traversePath(plan) == competence);
        this.plan = plan;
        this.competence = competence;
        this.goalExecutor = new SenseListExecutor(competencePath, ctx, log);
        int choiceId = 0;
        for (CompetenceElement ce : competence.getChildDataNodes()) {
            LapPath choicePath = competencePath.concat(LapType.COMPETENCE_ELEMENT, choiceId++);
            CEExecutor choiceExecutor = new CEExecutor(plan, competence, ce, choicePath, ctx, log);
            this.ceExecutors.add(choiceExecutor);
        }
    }

    public boolean isGoalSatisfied(IWorkExecutor workExecutor) {
        if (this.goalExecutor == null) {
            return false;
        }
        return this.goalExecutor.fire(workExecutor, false).wasSuccess();
    }

    @Override
    public FireResult fire(IWorkExecutor workExecuter) {
        this.engineLog.pathReached(this.path);
        TriggerResult goalResult = this.goalExecutor.fire(workExecuter, false);
        if (goalResult.wasSuccess()) {
            return new FireResult(FireResult.Type.FULFILLED);
        }
        for (CEExecutor ceExecutor : this.ceExecutors) {
            TriggerResult triggerResult = ceExecutor.isReady(workExecuter);
            if (!triggerResult.wasSuccess()) continue;
            StackElement<CEExecutor> stackElement = new StackElement<CEExecutor>(CompetenceElement.class, ceExecutor.getName(), ceExecutor);
            return new FireResult(FireResult.Type.FOLLOW, stackElement);
        }
        return new FireResult(FireResult.Type.FAILED);
    }
}

