/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.sposh.engine;

import cz.cuni.amis.pogamut.sposh.elements.LapPath;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;

public class EngineLog {
    private final List<LapPath> paths = new LinkedList<LapPath>();
    private final List<LapPath> pathsUm = Collections.unmodifiableList(this.paths);
    private final Logger log;

    EngineLog(Logger log) {
        this.log = log;
    }

    public void pathReached(LapPath path) {
        this.finest("Reached path: " + path.toString());
        this.paths.add(path);
        this.pathReachedExit();
    }

    public void pathReachedExit() {
    }

    public String getLastReachedPath() {
        return this.paths.get(this.paths.size() - 1).toString();
    }

    List<LapPath> getPaths() {
        return this.pathsUm;
    }

    void clear() {
        this.paths.clear();
    }

    void finest(String msg) {
        if (this.log != null) {
            this.log.finest(msg);
        }
    }

    void fine(String msg) {
        if (this.log != null) {
            this.log.fine(msg);
        }
    }

    void info(String msg) {
        if (this.log != null) {
            this.log.info(msg);
        }
    }

    void warning(String msg) {
        if (this.log != null) {
            this.log.warning(msg);
        }
    }

    Logger getLogger() {
        return this.log;
    }
}

