/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.sposh.engine;

import cz.cuni.amis.pogamut.sposh.elements.Arguments;
import cz.cuni.amis.pogamut.sposh.elements.LapPath;
import cz.cuni.amis.pogamut.sposh.elements.PrimitiveCall;
import cz.cuni.amis.pogamut.sposh.elements.Result;
import cz.cuni.amis.pogamut.sposh.elements.Sense;
import cz.cuni.amis.pogamut.sposh.engine.AbstractExecutor;
import cz.cuni.amis.pogamut.sposh.engine.EngineLog;
import cz.cuni.amis.pogamut.sposh.engine.SenseResult;
import cz.cuni.amis.pogamut.sposh.engine.VariableContext;
import cz.cuni.amis.pogamut.sposh.executor.IWorkExecutor;

final class SenseExecutor
extends AbstractExecutor {
    private PrimitiveCall senseCall;
    private Sense.Predicate predicate;
    private final boolean compare = true;
    private Object operand;

    SenseExecutor(Sense sense, LapPath sensePath, VariableContext ctx, EngineLog log) {
        super(sensePath, ctx, log);
        assert (sensePath.traversePath(sense.getRootNode()) == sense);
        this.senseCall = sense.getSenseCall();
        this.predicate = sense.getPredicate();
        this.operand = sense.getOperand();
    }

    public SenseResult fire(IWorkExecutor workExecuter) {
        this.engineLog.fine("Fire: " + this.toString());
        this.engineLog.pathReached(this.path);
        String senseName = this.senseCall.getName();
        Object primitiveResult = workExecuter.executeSense(senseName, new VariableContext(this.ctx, this.senseCall.getParameters()));
        boolean res = SenseExecutor.evaluateComparison(primitiveResult, this.predicate, this.operand);
        return new SenseResult(senseName, res);
    }

    static boolean evaluateComparison(Object operand1, Sense.Predicate predicate, Object operand2) {
        String comparison = operand1 + " " + (Object)((Object)predicate) + " " + operand2;
        switch (predicate) {
            case DEFAULT: 
            case EQUAL: {
                return Result.equal(operand1, operand2);
            }
            case NOT_EQUAL: {
                return !Result.equal(operand1, operand2);
            }
            case LOWER: {
                return Result.compare(operand1, operand2) < 0;
            }
            case GREATER: {
                return Result.compare(operand1, operand2) > 0;
            }
            case LOWER_OR_EQUAL: {
                return Result.equal(operand1, operand2) || Result.compare(operand1, operand2) < 0;
            }
            case GREATER_OR_EQUAL: {
                return Result.equal(operand1, operand2) || Result.compare(operand1, operand2) > 0;
            }
        }
        throw new IllegalArgumentException("Predicate operation \"" + (Object)((Object)predicate) + "\" is implemented.");
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("SenseExecutor[(");
        sb.append(this.senseCall.getName());
        sb.append('(');
        boolean first = true;
        for (Arguments.Argument parameter : this.senseCall.getParameters()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append(parameter.getParameterName());
            first = false;
        }
        sb.append(')');
        sb.append(' ');
        sb.append((Object)this.predicate);
        sb.append(' ');
        sb.append(this.operand);
        sb.append(')');
        sb.append(']');
        return sb.toString();
    }
}

