/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.agent.navigation;

import cz.cuni.amis.pogamut.base.agent.navigation.IStuckDetector;
import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEventListener;
import cz.cuni.amis.pogamut.base.utils.logging.LogCategory;
import cz.cuni.amis.pogamut.base.utils.math.DistanceUtils;
import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.base3d.worldview.object.Rotation;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.AgentInfo;
import cz.cuni.amis.pogamut.ut2004.agent.module.utils.TabooSet;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.IUT2004GetBackToNavGraph;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.IUT2004PathRunner;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.loquenavigator.KefikRunner;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.stuckdetector.UT2004DistanceStuckDetector;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.stuckdetector.UT2004PositionStuckDetector;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.stuckdetector.UT2004TimeStuckDetector;
import cz.cuni.amis.pogamut.ut2004.bot.command.AdvancedLocomotion;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.EndMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPoint;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;

public class UT2004GetBackToNavGraph
implements IUT2004GetBackToNavGraph {
    public static final int CLOSE_ENOUGH = 50;
    public static final double MAX_ANGLE = 0.7853981633974483;
    protected UT2004Bot bot;
    protected AgentInfo info;
    protected IUT2004PathRunner runner;
    protected boolean executing;
    protected LogCategory log;
    protected int randomMoveDirection;
    protected IWorldEventListener<EndMessage> endListener = new IWorldEventListener<EndMessage>(){

        @Override
        public void notify(EndMessage event) {
            UT2004GetBackToNavGraph.this.getBackOnNavGraph();
        }
    };
    protected List<IStuckDetector> stuckDetectors = new ArrayList<IStuckDetector>();
    protected ILocated focus;
    protected TabooSet<NavPoint> tried;
    protected NavPoint tryingNav;
    protected Location initialLocation;

    public UT2004GetBackToNavGraph(UT2004Bot bot, AgentInfo info, AdvancedLocomotion move) {
        this.log = bot.getLogger().getCategory(this.getClass().getSimpleName());
        this.bot = bot;
        this.info = info;
        this.runner = new KefikRunner(bot, info, move, this.log);
        this.stuckDetectors.add(new UT2004TimeStuckDetector(bot, 3000.0, 10000.0));
        this.stuckDetectors.add(new UT2004PositionStuckDetector(bot));
        this.stuckDetectors.add(new UT2004DistanceStuckDetector(bot));
        bot.getWorldView().addEventListener(EndMessage.class, this.endListener);
    }

    @Override
    public void addStuckDetector(IStuckDetector stuckDetector) {
        this.stuckDetectors.add(stuckDetector);
    }

    @Override
    public void removeStuckDetector(IStuckDetector stuckDetector) {
        this.stuckDetectors.remove(stuckDetector);
    }

    @Override
    public void clearStuckDetectors() {
        this.stuckDetectors.clear();
    }

    @Override
    public NavPoint getNearestNavPoint() {
        return this.info.getNearestNavPoint();
    }

    @Override
    public boolean isOnNavGraph() {
        return this.info.isOnNavGraph();
    }

    @Override
    public boolean isExecuting() {
        return this.executing;
    }

    @Override
    public void setFocus(ILocated located) {
        this.focus = located;
    }

    @Override
    public void backToNavGraph() {
        if (this.executing) {
            return;
        }
        if (this.log != null && this.log.isLoggable(Level.INFO)) {
            this.log.info("STARTED");
        }
        this.reset();
        this.initialLocation = this.info.getLocation();
        for (IStuckDetector stuckDetector : this.stuckDetectors) {
            stuckDetector.reset();
            stuckDetector.setEnabled(true);
        }
        this.executing = true;
    }

    @Override
    public void stop() {
        if (!this.executing) {
            return;
        }
        if (this.log != null && this.log.isLoggable(Level.INFO)) {
            this.log.info("STOPPED");
        }
        this.executing = false;
        this.reset();
        for (IStuckDetector stuckDetector : this.stuckDetectors) {
            stuckDetector.setEnabled(false);
        }
    }

    protected void reset() {
        if (this.log != null && this.log.isLoggable(Level.FINER)) {
            this.log.finer("Reset");
        }
        if (this.tried == null) {
            this.tried = new TabooSet(this.bot);
        } else {
            this.tried.clear();
        }
        this.tryingNav = null;
    }

    protected void getBackOnNavGraph() {
        if (!this.executing) {
            return;
        }
        if (this.isOnNavGraph()) {
            if (this.log != null && this.log.isLoggable(Level.INFO)) {
                this.log.info("Got back to Navigation Graph.");
            }
            this.stop();
            return;
        }
        while (!this.runToNavPoint()) {
            while (this.tryingNav == null) {
                this.tryingNav = DistanceUtils.getNearest(this.tried.filter(this.bot.getWorldView().getAll(NavPoint.class).values()), this.info.getLocation());
                if (this.tryingNav != null && !(this.info.getLocation().getDistance(this.tryingNav.getLocation()) > 2000.0)) continue;
                if (this.tried.size() == 0) {
                    this.runSomewhere();
                    return;
                }
                this.tried.clear();
                this.tryingNav = null;
            }
            if (this.log != null && this.log.isLoggable(Level.FINE)) {
                this.log.fine("Trying to get to: " + this.tryingNav);
            }
            this.initialLocation = this.info.getLocation();
            for (IStuckDetector stuckDetector : this.stuckDetectors) {
                stuckDetector.reset();
                stuckDetector.setBotTarget(this.tryingNav);
            }
            this.runner.reset();
        }
        return;
    }

    protected void runSomewhere() {
        ++this.randomMoveDirection;
        if (this.randomMoveDirection >= 2) {
            this.randomMoveDirection = -1;
        }
        Location backwardsLoc = this.bot.getLocation();
        Rotation rot = this.bot.getRotation();
        rot.setYaw(rot.getYaw() + (double)(this.randomMoveDirection * 16000));
        backwardsLoc = backwardsLoc.sub(rot.toLocation().getNormalized().scale(200.0));
        double hDistance = this.bot.getLocation().getDistance2D(backwardsLoc);
        double vDistance = this.bot.getLocation().getDistanceZ(backwardsLoc);
        double angle = Math.atan(Math.abs(vDistance) / hDistance);
        this.runner.runToLocation(this.initialLocation, backwardsLoc, null, this.focus == null ? backwardsLoc : this.focus, null, angle < 0.7853981633974483);
    }

    protected boolean runToNavPoint() {
        if (this.tryingNav == null) {
            return false;
        }
        if (this.log != null && this.log.isLoggable(Level.FINE)) {
            this.log.fine("Running to: " + this.tryingNav);
        }
        double hDistance = this.bot.getLocation().getDistance2D(this.tryingNav.getLocation());
        double vDistance = this.bot.getLocation().getDistanceZ(this.tryingNav.getLocation());
        double angle = Math.atan(Math.abs(vDistance) / hDistance);
        if (this.runner.runToLocation(this.initialLocation, this.tryingNav.getLocation(), null, this.focus == null ? this.tryingNav.getLocation() : this.focus, null, angle < 0.7853981633974483)) {
            for (IStuckDetector stuckDetector : this.stuckDetectors) {
                if (!stuckDetector.isStuck()) continue;
                this.runFailed();
                return false;
            }
            return true;
        }
        this.runFailed();
        return false;
    }

    protected void runFailed() {
        this.tried.add(this.tryingNav);
        this.tryingNav = null;
    }
}

