/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.communication.messages.custom;

import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.unreal.communication.messages.UnrealId;
import cz.cuni.amis.pogamut.ut2004.communication.messages.custom.ControlMessageField;
import cz.cuni.amis.pogamut.ut2004.communication.messages.custom.ControlMessageSimType;
import cz.cuni.amis.pogamut.ut2004.communication.messages.custom.ControlMessageType;
import cz.cuni.amis.pogamut.ut2004.communication.messages.custom.ControlMessageTypeMapper;
import cz.cuni.amis.pogamut.ut2004.communication.messages.custom.ICustomControlMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.ControlMessage;
import cz.cuni.amis.utils.ClassUtils;
import cz.cuni.amis.utils.Tuple3;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;

public class ControlMessageMapper<T extends ICustomControlMessage> {
    public static final ControlMessageGetter<Integer>[] getterIntegers = new ControlMessageGetter[]{null, new ControlMessageGetter<Integer>(){

        @Override
        public Integer get(ControlMessage msg) {
            return msg.getPI1();
        }
    }, new ControlMessageGetter<Integer>(){

        @Override
        public Integer get(ControlMessage msg) {
            return msg.getPI2();
        }
    }, new ControlMessageGetter<Integer>(){

        @Override
        public Integer get(ControlMessage msg) {
            return msg.getPI3();
        }
    }};
    public static final ControlMessageGetter<Double>[] getterDoubles = new ControlMessageGetter[]{null, new ControlMessageGetter<Double>(){

        @Override
        public Double get(ControlMessage msg) {
            return msg.getPF1();
        }
    }, new ControlMessageGetter<Double>(){

        @Override
        public Double get(ControlMessage msg) {
            return msg.getPF2();
        }
    }, new ControlMessageGetter<Double>(){

        @Override
        public Double get(ControlMessage msg) {
            return msg.getPF3();
        }
    }};
    public static final ControlMessageGetter<Double>[] getterStrings = new ControlMessageGetter[]{null, new ControlMessageGetter<String>(){

        @Override
        public String get(ControlMessage msg) {
            return msg.getPS1();
        }
    }, new ControlMessageGetter<String>(){

        @Override
        public String get(ControlMessage msg) {
            return msg.getPS2();
        }
    }, new ControlMessageGetter<String>(){

        @Override
        public String get(ControlMessage msg) {
            return msg.getPS3();
        }
    }};
    public static final ControlMessageGetter<Double>[] getterBooleans = new ControlMessageGetter[]{null, new ControlMessageGetter<Boolean>(){

        @Override
        public Boolean get(ControlMessage msg) {
            return msg.isPB1();
        }
    }, new ControlMessageGetter<Boolean>(){

        @Override
        public Boolean get(ControlMessage msg) {
            return msg.isPB2();
        }
    }, new ControlMessageGetter<Boolean>(){

        @Override
        public Boolean get(ControlMessage msg) {
            return msg.isPB3();
        }
    }};
    private Class<T> descriptor;
    private String type;
    private Constructor<T> constructor;
    private List<Tuple3<Field, ControlMessageGetter, ControlMessageTypeMapper>> fields = new ArrayList<Tuple3<Field, ControlMessageGetter, ControlMessageTypeMapper>>();
    private Field simTimeField;

    public ControlMessageMapper(Class<T> customControlMessageClass) {
        HashMap<Integer, Field> integers = new HashMap<Integer, Field>();
        HashMap doubles = new HashMap();
        HashMap strings = new HashMap();
        HashMap booleans = new HashMap();
        this.descriptor = customControlMessageClass;
        if (!customControlMessageClass.isAnnotationPresent(ControlMessageType.class)) {
            throw new RuntimeException("Cannot create ControlMessageDeserializer for " + customControlMessageClass + " as it is not annotated with ControlMessageType!");
        }
        this.type = customControlMessageClass.getAnnotation(ControlMessageType.class).type();
        try {
            this.constructor = customControlMessageClass.getConstructor(new Class[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot create ControlMessageDeserializer as its parameter-less contructor is unavailable (either non-existent or Java security related).", e);
        }
        if (this.constructor == null) {
            throw new RuntimeException("Cannot create ControlMessageDeserializer as its parameter-less contructor is unavailable (either non-existent or Java security related).");
        }
        Collection<Class> classes = ClassUtils.getSubclasses(customControlMessageClass);
        for (Class cls : classes) {
            if (cls.isAnnotation() || cls.isInterface()) continue;
            for (Field field : cls.getDeclaredFields()) {
                HashMap<Integer, Field> map;
                if (field.isAnnotationPresent(ControlMessageSimType.class)) {
                    if (!field.getType().equals(Long.TYPE)) {
                        throw new RuntimeException("Cannot create ControlMessageDeserializer as its @ControlMessageSimType field " + field.getDeclaringClass() + "." + field.getName() + " is not of type 'long' but '" + field.getType() + "', invalid.");
                    }
                    if (this.simTimeField != null) {
                        throw new RuntimeException("Cannot create ControlMessageDeserializer as its @ControlMessageSimType field declared twice, first " + this.simTimeField.getDeclaringClass() + "." + this.simTimeField.getName() + ", second " + field.getDeclaringClass() + "." + field.getDeclaringClass() + "." + field.getName() + ".");
                    }
                    this.simTimeField = field;
                    continue;
                }
                if (!field.isAnnotationPresent(ControlMessageField.class)) continue;
                ControlMessageField info = field.getAnnotation(ControlMessageField.class);
                if (info.index() < 0 || info.index() > 3) {
                    throw new RuntimeException("Cannot create CustomMessageDeserializer for " + customControlMessageClass + " as field " + field.getDeclaringClass() + "." + field.getName() + " contains annotation ControlMessageParam(index=" + info.index() + "), unsupported. 1 <= index <= 3.");
                }
                if (field.getType() == Integer.class) {
                    map = integers;
                } else if (field.getType() == Double.class) {
                    map = doubles;
                } else if (field.getType() == String.class) {
                    map = strings;
                } else if (field.getType() == Boolean.class) {
                    map = booleans;
                } else if (field.getType() == UnrealId.class) {
                    map = strings;
                } else if (field.getType() == Location.class) {
                    map = strings;
                } else {
                    throw new RuntimeException("Cannot create CustomMessageDeserializer for " + customControlMessageClass + " as field " + field.getDeclaringClass() + "." + field.getName() + " is of invalid type " + field.getType() + ", only Integer, Double, String, Boolean, UnrealId, Location is supported.");
                }
                if (map.containsKey(info.index())) {
                    throw new RuntimeException("Cannot create CustomMessageDeserializer for " + customControlMessageClass + " as field " + field.getDeclaringClass() + "." + field.getName() + " is referencing index " + info.index() + " that has already been defined/taken by field " + ((Field)map.get(info.index())).getName() + ".");
                }
                map.put(info.index(), field);
                if (field.getType() == Integer.class) {
                    if (info.index() >= getterIntegers.length) {
                        throw new RuntimeException("Cannot create CustomMessageDeserializer for " + customControlMessageClass + " as field " + field.getDeclaringClass() + "." + field.getName() + " has unexpected index " + info.index() + " for ControlMessage Integer field, I do not have ControlMessageGetter for that!");
                    }
                    this.fields.add(new Tuple3<Field, ControlMessageGetter<Integer>, ControlMessageTypeMapper.DirectMapper>(field, getterIntegers[info.index()], ControlMessageTypeMapper.DIRECT_MAPPER));
                    continue;
                }
                if (field.getType() == Double.class) {
                    if (info.index() >= getterDoubles.length) {
                        throw new RuntimeException("Cannot create CustomMessageDeserializer for " + customControlMessageClass + " as field " + field.getDeclaringClass() + "." + field.getName() + " has unexpected index " + info.index() + " for ControlMessage Double field, I do not have ControlMessageGetter for that!");
                    }
                    this.fields.add(new Tuple3<Field, ControlMessageGetter<Double>, ControlMessageTypeMapper.DirectMapper>(field, getterDoubles[info.index()], ControlMessageTypeMapper.DIRECT_MAPPER));
                    continue;
                }
                if (field.getType() == String.class) {
                    if (info.index() >= getterStrings.length) {
                        throw new RuntimeException("Cannot create CustomMessageDeserializer for " + customControlMessageClass + " as field " + field.getDeclaringClass() + "." + field.getName() + " has unexpected index " + info.index() + " for ControlMessage String field, I do not have ControlMessageGetter for that!");
                    }
                    this.fields.add(new Tuple3<Field, ControlMessageGetter<Double>, ControlMessageTypeMapper.DirectMapper>(field, getterStrings[info.index()], ControlMessageTypeMapper.DIRECT_MAPPER));
                    continue;
                }
                if (field.getType() == Boolean.class) {
                    if (info.index() >= getterBooleans.length) {
                        throw new RuntimeException("Cannot create CustomMessageDeserializer for " + customControlMessageClass + " as field " + field.getDeclaringClass() + "." + field.getName() + " has unexpected index " + info.index() + " for ControlMessage Boolean field, I do not have ControlMessageGetter for that!");
                    }
                    this.fields.add(new Tuple3<Field, ControlMessageGetter<Double>, ControlMessageTypeMapper.DirectMapper>(field, getterBooleans[info.index()], ControlMessageTypeMapper.DIRECT_MAPPER));
                    continue;
                }
                if (field.getType() == UnrealId.class) {
                    if (info.index() >= getterStrings.length) {
                        throw new RuntimeException("Cannot create CustomMessageDeserializer for " + customControlMessageClass + " as field " + field.getDeclaringClass() + "." + field.getName() + " has unexpected index " + info.index() + " for ControlMessage String field, I do not have ControlMessageGetter for that!");
                    }
                    this.fields.add(new Tuple3<Field, ControlMessageGetter<Double>, ControlMessageTypeMapper.String2UnrealIdMapper>(field, getterStrings[info.index()], ControlMessageTypeMapper.STRING_2_UNREAL_ID_MAPPER));
                    continue;
                }
                if (field.getType() == Location.class) {
                    if (info.index() >= getterStrings.length) {
                        throw new RuntimeException("Cannot create CustomMessageDeserializer for " + customControlMessageClass + " as field " + field.getDeclaringClass() + "." + field.getName() + " has unexpected index " + info.index() + " for ControlMessage String field, I do not have ControlMessageGetter for that!");
                    }
                    this.fields.add(new Tuple3<Field, ControlMessageGetter<Double>, ControlMessageTypeMapper.String2LocationMapper>(field, getterStrings[info.index()], ControlMessageTypeMapper.STRING_2_LOCATION_MAPPER));
                    continue;
                }
                throw new RuntimeException("Cannot create CustomMessageDeserializer for " + customControlMessageClass + " as field " + field.getDeclaringClass() + "." + field.getName() + " is of invalid type " + field.getType() + ", only Integer, Double, String, Boolean, UnrealId, Location is supported.");
            }
        }
        if (this.simTimeField == null) {
            throw new RuntimeException("Cannot create CustomMessageDeserializer for " + customControlMessageClass + " as no long-typed field was annotated with @CustomMessageSimTime.");
        }
    }

    public Class<T> getDescriptor() {
        return this.descriptor;
    }

    public String getType() {
        return this.type;
    }

    public T deserialize(ControlMessage message) {
        ICustomControlMessage result;
        try {
            result = (ICustomControlMessage)this.constructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to instantiate new " + this.descriptor + ".", e);
        }
        for (Tuple3<Field, ControlMessageGetter, ControlMessageTypeMapper> field : this.fields) {
            Object baseValue = field.getSecond().get(message);
            Object value = field.getThird().map(baseValue);
            try {
                field.getFirst().setAccessible(true);
                field.getFirst().set(result, value);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to set " + this.descriptor + "." + field.getFirst().getName() + " with value '" + value + "' mapped from base value '" + baseValue + "'.", e);
            }
        }
        try {
            this.simTimeField.setAccessible(true);
            this.simTimeField.set(result, message.getSimTime());
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to set " + this.descriptor + "." + this.simTimeField.getName() + " with value '" + message.getSimTime() + "'", e);
        }
        return (T)result;
    }

    public static interface ControlMessageGetter<T> {
        public T get(ControlMessage var1);
    }
}

