/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.tools;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;

public class XMLDirectoryList {
    public static PrintWriter out = null;

    public static void printHelp() {
        System.out.println("");
        System.out.println("=====================");
        System.out.println("XML Directory Listing");
        System.out.println("=====================");
        System.out.println("");
        System.out.println("Simple program for creating list of all files from several directories.");
        System.out.println("");
        System.out.println("Usage:");
        System.out.println("");
        System.out.println("java XMLDirectoryList.jar [<directory>]+ <target_xml_file>");
        System.out.println("");
        System.out.println("Current directory is: " + new File(".").getAbsolutePath());
        System.out.println("");
    }

    public static String backslashes(String str) {
        StringBuffer sb = new StringBuffer(str.length() + str.length() / 4);
        int i = 0;
        while (i < str.length()) {
            if (str.charAt(i) == '\\') {
                sb.append("/");
            } else {
                sb.append(str.charAt(i));
            }
            ++i;
        }
        return sb.toString();
    }

    public static void openOut(File targetFile) {
        try {
            out = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(targetFile), "UTF8"));
        }
        catch (UnsupportedEncodingException e) {
            System.out.println("");
            System.out.println("ERROR: unsupported encoding UTF-8");
            System.out.println("");
            e.printStackTrace();
            System.exit(1);
        }
        catch (FileNotFoundException e) {
            System.out.println("");
            System.out.println("ERROR: can't create file " + targetFile.getAbsolutePath());
            System.out.println("");
            e.printStackTrace();
            System.exit(1);
        }
        out.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        out.println("<files>");
    }

    public static void closeOut() {
        out.println("</files>");
        out.close();
    }

    public static void main(String[] args) {
        if (args.length < 2) {
            XMLDirectoryList.printHelp();
            System.exit(1);
        }
        File[] directories = new File[args.length - 1];
        int i = 0;
        while (i < args.length - 1) {
            directories[i] = new File(args[i]);
            if (!directories[i].isDirectory()) {
                System.out.println("");
                System.out.println("ERROR: " + args[i]);
                System.out.println("ERROR: is not directory");
                System.out.println("ERROR: base directory is: " + new File(".").getAbsolutePath());
                System.out.println("");
                XMLDirectoryList.printHelp();
                System.exit(1);
            }
            ++i;
        }
        XMLDirectoryList.openOut(new File(args[args.length - 1]));
        File[] fileArray = directories;
        int n = directories.length;
        int n2 = 0;
        while (n2 < n) {
            File[] files;
            File dir = fileArray[n2];
            File[] fileArray2 = files = dir.listFiles();
            int n3 = files.length;
            int n4 = 0;
            while (n4 < n3) {
                File f = fileArray2[n4];
                if (f.isFile()) {
                    out.println("  <file name=\"file:///" + XMLDirectoryList.backslashes(f.getAbsolutePath()) + "\"/>");
                }
                ++n4;
            }
            ++n2;
        }
        XMLDirectoryList.closeOut();
        System.out.println("DONE!");
    }
}

