/*
 * Decompiled with CFR 0.152.
 */
package com.agilejava.docbkx.maven;

import com.agilejava.docbkx.maven.AbstractMojoBase;
import com.agilejava.docbkx.maven.Font;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamSource;
import org.antlr.stringtemplate.StringTemplate;
import org.antlr.stringtemplate.StringTemplateGroup;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.DefaultConfigurationBuilder;
import org.apache.commons.io.IOUtils;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.apps.Fop;
import org.apache.fop.apps.FopFactory;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.plexus.util.FileUtils;
import org.xml.sax.SAXException;

public abstract class AbstractFoMojo
extends AbstractMojoBase {
    private String baseUrl;
    private Font[] fonts;
    int targetResolution;
    int sourceResolution;
    File externalFOPConfiguration = null;
    private String currentFileExtension;

    public void preProcess() throws MojoExecutionException {
        super.preProcess();
        this.currentFileExtension = this.getTargetFileExtension();
        this.setTargetFileExtension(this.getType());
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void postProcessResult(File result) throws MojoExecutionException {
        super.postProcessResult(result);
        this.setTargetFileExtension(this.currentFileExtension);
        FopFactory fopFactory = FopFactory.newInstance();
        FOUserAgent userAgent = fopFactory.newFOUserAgent();
        userAgent.setBaseURL(this.baseUrl);
        Configuration configuration = this.loadFOPConfig();
        InputStream in = null;
        OutputStream out = null;
        try {
            in = this.openFileForInput(result);
            File outputFile = this.getOutputFile(result);
            out = this.openFileForOutput(outputFile);
            fopFactory.setUserConfig(configuration);
            Fop fop = fopFactory.newFop(this.getMimeType(), userAgent, out);
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer();
            StreamSource src = new StreamSource(in);
            SAXResult res = new SAXResult(fop.getDefaultHandler());
            transformer.transform(src, res);
            this.getLog().info((CharSequence)(outputFile.getAbsolutePath() + " has been generated."));
        }
        catch (FOPException e) {
            try {
                throw new MojoExecutionException("Failed to convert to " + this.getTargetFileExtension(), (Exception)((Object)e));
                catch (TransformerConfigurationException e2) {
                    throw new MojoExecutionException("Failed to load JAXP configuration", (Exception)e2);
                }
                catch (TransformerException e3) {
                    throw new MojoExecutionException("Failed to transform to " + this.getTargetFileExtension(), (Exception)e3);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(out);
                IOUtils.closeQuietly((InputStream)in);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)out);
        IOUtils.closeQuietly((InputStream)in);
    }

    private InputStream openFileForInput(File file) throws MojoExecutionException {
        try {
            return new FileInputStream(file);
        }
        catch (FileNotFoundException fnfe) {
            throw new MojoExecutionException("Failed to open " + file + " for input.");
        }
    }

    private File getOutputFile(File inputFile) {
        String basename = FileUtils.basename((String)inputFile.getAbsolutePath());
        return new File(this.getTargetDirectory(), basename + this.getTargetFileExtension());
    }

    private OutputStream openFileForOutput(File file) throws MojoExecutionException {
        try {
            return new BufferedOutputStream(new FileOutputStream(file));
        }
        catch (FileNotFoundException fnfe) {
            throw new MojoExecutionException("Failed to open " + file + " for output.");
        }
    }

    protected String getMimeType() {
        this.getLog().info((CharSequence)("targetFileExtension " + this.getTargetFileExtension()));
        this.getLog().info((CharSequence)("type " + this.getType()));
        if ("rtf".equals(this.getTargetFileExtension())) {
            return "application/rtf";
        }
        return "application/pdf";
    }

    protected Configuration loadFOPConfig() throws MojoExecutionException {
        if (this.externalFOPConfiguration != null) {
            DefaultConfigurationBuilder builder = new DefaultConfigurationBuilder();
            try {
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((CharSequence)("Using external FOP configuration file: " + this.externalFOPConfiguration.toString()));
                }
                this.getLog().info((CharSequence)"Ignoring pom inline FOP configuration");
                return builder.buildFromFile(this.externalFOPConfiguration);
            }
            catch (IOException ioe) {
                throw new MojoExecutionException("Failed to load external FOP config.", (Exception)ioe);
            }
            catch (SAXException saxe) {
                throw new MojoExecutionException("Failed to parse external FOP config.", (Exception)saxe);
            }
            catch (ConfigurationException e) {
                throw new MojoExecutionException("Failed to do something Avalon requires....", (Exception)((Object)e));
            }
        }
        ClassLoader loader = ((Object)((Object)this)).getClass().getClassLoader();
        InputStream in = loader.getResourceAsStream("fonts.stg");
        InputStreamReader reader = new InputStreamReader(in);
        StringTemplateGroup group = new StringTemplateGroup((Reader)reader);
        StringTemplate template = group.getInstanceOf("config");
        template.setAttribute("fonts", (Object)this.fonts);
        if (this.targetResolution != 0) {
            template.setAttribute("targetResolution", this.targetResolution);
        }
        if (this.sourceResolution != 0) {
            template.setAttribute("sourceResolution", this.sourceResolution);
        }
        DefaultConfigurationBuilder builder = new DefaultConfigurationBuilder();
        String config = template.toString();
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)config);
        }
        try {
            return builder.build(IOUtils.toInputStream((String)config));
        }
        catch (IOException ioe) {
            throw new MojoExecutionException("Failed to load FOP config.", (Exception)ioe);
        }
        catch (SAXException saxe) {
            throw new MojoExecutionException("Failed to parse FOP config.", (Exception)saxe);
        }
        catch (ConfigurationException e) {
            throw new MojoExecutionException("Failed to do something Avalon requires....", (Exception)((Object)e));
        }
    }

    public void adjustTransformer(Transformer transformer, String sourceFilename, File targetFile) {
        super.adjustTransformer(transformer, sourceFilename, targetFile);
        try {
            String str = new File(sourceFilename).getParentFile().toURL().toExternalForm();
            this.baseUrl = str.replace("file:/", "file:///");
        }
        catch (MalformedURLException e) {
            this.getLog().warn((CharSequence)"Failed to get FO basedir", (Throwable)e);
        }
    }
}

