/*
 * Decompiled with CFR 0.152.
 */
package com.agilejava.docbkx.maven;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class FileUtils {
    static final /* synthetic */ boolean $assertionsDisabled;

    public static boolean copyFile(File toCopy, File destFile) {
        try {
            return FileUtils.copyStream((InputStream)new FileInputStream(toCopy), new FileOutputStream(destFile));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean copyFilesRecusively(File toCopy, File destDir) {
        if (!$assertionsDisabled && !destDir.isDirectory()) {
            throw new AssertionError();
        }
        if (!toCopy.isDirectory()) {
            return FileUtils.copyFile(toCopy, new File(destDir, toCopy.getName()));
        }
        File newDestDir = new File(destDir, toCopy.getName());
        if (!newDestDir.exists() && !newDestDir.mkdir()) {
            return false;
        }
        File[] files = toCopy.listFiles();
        for (int i = 0; i < files.length; ++i) {
            File child = files[i];
            if (FileUtils.copyFilesRecusively(child, newDestDir)) continue;
            return false;
        }
        return true;
    }

    public static boolean copyJarResourcesRecursively(File destDir, JarURLConnection jarConnection) throws IOException {
        JarFile jarFile = jarConnection.getJarFile();
        Enumeration<JarEntry> e = jarFile.entries();
        while (e.hasMoreElements()) {
            JarEntry entry = e.nextElement();
            if (!entry.getName().startsWith(jarConnection.getEntryName())) continue;
            String filename = entry.getName().replace(jarConnection.getEntryName(), "");
            File f = new File(destDir, filename);
            if (!entry.isDirectory()) {
                InputStream entryInputStream = jarFile.getInputStream(entry);
                if (!FileUtils.copyStream(entryInputStream, f)) {
                    return false;
                }
                entryInputStream.close();
                continue;
            }
            if (FileUtils.ensureDirectoryExists(f)) continue;
            throw new IOException("Could not create directory: " + f.getAbsolutePath());
        }
        return true;
    }

    public static boolean copyResourcesRecursively(URL originUrl, File destination) {
        block5: {
            try {
                URLConnection urlConnection = originUrl.openConnection();
                if (urlConnection instanceof JarURLConnection) {
                    return FileUtils.copyJarResourcesRecursively(destination, (JarURLConnection)urlConnection);
                }
                File sourceFile = new File(originUrl.getPath());
                if (sourceFile.isDirectory()) {
                    File[] files = sourceFile.listFiles();
                    for (int i = 0; i < files.length; ++i) {
                        File child = files[i];
                        if (FileUtils.copyFilesRecusively(child, destination)) continue;
                        return false;
                    }
                    break block5;
                }
                return FileUtils.copyFilesRecusively(sourceFile, destination);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    private static boolean copyStream(InputStream is, File f) {
        try {
            return FileUtils.copyStream(is, new FileOutputStream(f));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return false;
        }
    }

    private static boolean copyStream(InputStream is, OutputStream os) {
        try {
            byte[] buf = new byte[1024];
            int len = 0;
            while ((len = is.read(buf)) > 0) {
                os.write(buf, 0, len);
            }
            is.close();
            os.close();
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    private static boolean ensureDirectoryExists(File f) {
        return f.exists() || f.mkdir();
    }

    static {
        $assertionsDisabled = !FileUtils.class.desiredAssertionStatus();
    }
}

