/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.pogamut.ut2004.agent.module.shooting;

import cz.cuni.amis.pogamut.base.agent.module.SensorModule;
import cz.cuni.amis.pogamut.base.communication.worldview.IWorldView;
import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEventListener;
import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensomotoric.Weaponry;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.AgentInfo;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.WeaponPref;
import cz.cuni.amis.pogamut.ut2004.bot.command.ImprovedShooting;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.ItemType;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.EndMessage;
import nl.tudelft.pogamut.ut2004.agent.module.shooting.WeaponShooting;
import nl.tudelft.pogamut.ut2004.agent.module.shooting.util.FocusProvider;

public abstract class AbstractWeaponShooting
extends SensorModule<UT2004Bot>
implements WeaponShooting {
    protected static final double FACING_ANGLE = 30.0;
    protected static final Location BELOW_PLAYER_OFFSET = new Location(0.0, 0.0, 44.0);
    protected static final Location ABOVE_PLAYER_OFFSET = new Location(0.0, 0.0, 88.0);
    protected ILocated target = null;
    protected WeaponPref weaponPref;
    protected ImprovedShooting shoot;
    protected Weaponry weaponry;
    protected AgentInfo info;
    protected boolean active = false;
    protected FocusProvider focus = new FocusProvider();
    protected EndMessageListener endMessageListener;

    public AbstractWeaponShooting(UT2004Bot<?, ?, ?> agent, AgentInfo info, ImprovedShooting shoot, Weaponry weaponry) {
        super(agent);
        this.shoot = shoot;
        this.info = info;
        this.weaponry = weaponry;
        this.endMessageListener = new EndMessageListener(this.worldView);
    }

    @Override
    public void shoot(WeaponPref weaponPref, ILocated target) {
        if (weaponPref == null || !weaponPref.getWeapon().equals((Object)this.getWeaponType())) {
            throw new IllegalArgumentException("Weapon pref must be correct for the weapon associated with this shooting");
        }
        this.active = true;
        this.target = target;
        this.focus.setFocus(target);
        this.weaponPref = weaponPref;
    }

    protected abstract WeaponPref getDefaultWeaponPref();

    @Override
    public void stopShoot() {
        this.active = false;
        this.target = null;
        this.focus.clearFocus();
        this.shoot.stopShooting();
    }

    protected void setFocus(ILocated focus) {
        this.focus.setFocus(focus);
    }

    @Override
    public ILocated getFocus() {
        return this.focus;
    }

    public boolean hasTarget() {
        return this.target != null;
    }

    @Override
    public ItemType getWeaponType() {
        return this.getDefaultWeaponPref().getWeapon();
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    protected boolean isWeaponReady() {
        if (this.weaponry.getCurrentWeapon() == null || !this.weaponry.getCurrentWeapon().getType().equals((Object)this.getWeaponType())) {
            this.weaponry.changeWeapon(this.getWeaponType());
            return false;
        }
        return true;
    }

    protected abstract void shoot();

    private class EndMessageListener
    implements IWorldEventListener<EndMessage> {
        public void notify(EndMessage event) {
            if (AbstractWeaponShooting.this.isActive()) {
                AbstractWeaponShooting.this.shoot();
            }
        }

        public EndMessageListener(IWorldView worldView) {
            worldView.addEventListener(EndMessage.class, (IWorldEventListener)this);
        }
    }
}

