package nl.tudelft.pogamut.ut2004.agent.module.shooting;

import cz.cuni.amis.pogamut.base.utils.math.DistanceUtils;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Player;
import cz.cuni.amis.utils.collections.MyCollections;

public class ShieldGunPrimaryWeaponShootingTestController extends WeaponShootingTestController{

	public void logicTestWeapon(){
		
		Player player = players.getNearestVisibleEnemy();

		if (player != null) {
			weaponShooting.shoot(player);
		}

		// Wait for navigation to be done.
		if (navigation.isNavigating()) {
			return;
		}

		// Run to player if we have shield gun on primary mode.
		if (player != null) {
			navigation.navigate(player);
			return;
		}

		// Move from point to point
		if (!info.atLocation(currentStation)) {
			navigation.navigate(currentStation);
			waitAtLocation.heat();
			return;
		}

		// Done waiting.
		if (waitAtLocation.isCool()) {
			visited.add(currentStation);
			currentStation = DistanceUtils.getNearest(visited.filter(firingRange), bot);
			if (currentStation == null) {
				visited.clear();
				currentStation = MyCollections.getRandom(visited.filter(firingRange));
			}
			return;
		}

		// Look for some target.
		move.turnHorizontal(30);
	}

}
