/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.tools.project.extras;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.mojo.tools.project.extras.ArtifactPathResolver;
import org.codehaus.mojo.tools.project.extras.PathResolutionException;
import org.codehaus.plexus.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DependencyPathResolver {
    private final Collection<Artifact> artifacts;
    private final Log log;
    private Map<String, Artifact> artifactMap;
    private final ArtifactPathResolver pathResolver;

    public DependencyPathResolver(Collection<Artifact> artifacts, ArtifactPathResolver pathResolver, Log log) {
        this.artifacts = artifacts;
        this.pathResolver = pathResolver;
        this.log = log;
    }

    public String resolveDependencyPaths(String src) throws IOException, PathResolutionException {
        String result = src;
        Pattern depPathPattern = Pattern.compile("@pathOf\\(([^:]+):([^)]+)\\)@");
        Matcher matcher = depPathPattern.matcher(result);
        while (matcher.find()) {
            result = this.addDependencyPath(matcher, result);
            matcher.reset(result);
        }
        return result;
    }

    private String addDependencyPath(Matcher matcher, String src) throws IOException, PathResolutionException {
        String groupId = matcher.group(1);
        String artifactId = matcher.group(2);
        String depKey = ArtifactUtils.versionlessKey((String)groupId, (String)artifactId);
        if (this.artifactMap == null) {
            this.artifactMap = ArtifactUtils.artifactMapByVersionlessId(this.artifacts);
        }
        this.log.debug((CharSequence)("Artifact Map for Resolving @pathOf expressions:\n\n" + this.artifactMap.toString().replace(',', '\n')));
        Artifact artifact = this.artifactMap.get(depKey);
        this.log.debug((CharSequence)("Resolving path for: " + artifact + " with key: " + depKey));
        File path = this.pathResolver.resolve(artifact);
        this.log.debug((CharSequence)("Artifact for key: " + depKey + " is: " + artifact));
        this.log.debug((CharSequence)("Dependency path for artifact: " + artifact + " is: " + path));
        return StringUtils.replace((String)src, (String)matcher.group(0), (String)path.getCanonicalPath());
    }
}

