/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jaffl.provider.jffi;

import com.kenai.jaffl.Address;
import com.kenai.jaffl.LibraryOption;
import com.kenai.jaffl.MemoryIO;
import com.kenai.jaffl.NativeLong;
import com.kenai.jaffl.Pointer;
import com.kenai.jaffl.annotations.StdCall;
import com.kenai.jaffl.byref.ByReference;
import com.kenai.jaffl.mapper.FromNativeContext;
import com.kenai.jaffl.mapper.FromNativeConverter;
import com.kenai.jaffl.mapper.FunctionMapper;
import com.kenai.jaffl.mapper.MethodParameterContext;
import com.kenai.jaffl.mapper.MethodResultContext;
import com.kenai.jaffl.mapper.ToNativeContext;
import com.kenai.jaffl.mapper.ToNativeConverter;
import com.kenai.jaffl.mapper.TypeMapper;
import com.kenai.jaffl.provider.InvocationSession;
import com.kenai.jaffl.provider.jffi.AsmClassLoader;
import com.kenai.jaffl.provider.jffi.AsmRuntime;
import com.kenai.jaffl.provider.jffi.AsmUtil;
import com.kenai.jaffl.provider.jffi.CodegenUtils;
import com.kenai.jaffl.provider.jffi.DefaultInvokerFactory;
import com.kenai.jaffl.provider.jffi.EnumResultConverter;
import com.kenai.jaffl.provider.jffi.IdentityFunctionMapper;
import com.kenai.jaffl.provider.jffi.InvokerUtil;
import com.kenai.jaffl.provider.jffi.Library;
import com.kenai.jaffl.provider.jffi.LibraryLoader;
import com.kenai.jaffl.provider.jffi.NullTypeMapper;
import com.kenai.jaffl.provider.jffi.NumberUtil;
import com.kenai.jaffl.provider.jffi.SkinnyMethodAdapter;
import com.kenai.jaffl.provider.jffi.StubCompiler;
import com.kenai.jaffl.provider.jffi.SymbolNotFoundError;
import com.kenai.jaffl.struct.Struct;
import com.kenai.jffi.CallingConvention;
import com.kenai.jffi.Function;
import com.kenai.jffi.HeapInvocationBuffer;
import com.kenai.jffi.InvocationBuffer;
import com.kenai.jffi.Invoker;
import com.kenai.jffi.Platform;
import com.kenai.jffi.Type;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.nio.Buffer;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.jruby.org.objectweb.asm.ClassVisitor;
import org.jruby.org.objectweb.asm.ClassWriter;
import org.jruby.org.objectweb.asm.Label;
import org.jruby.org.objectweb.asm.Opcodes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsmLibraryLoader
extends LibraryLoader
implements Opcodes {
    public static final boolean DEBUG = Boolean.getBoolean("jaffl.compile.dump");
    private static final boolean FAST_NUMERIC_AVAILABLE = AsmLibraryLoader.isFastNumericAvailable();
    private static final boolean FAST_LONG_AVAILABLE = AsmLibraryLoader.isFastLongAvailable();
    private final AtomicLong nextClassID = new AtomicLong(0L);
    private final AtomicLong nextIvarID = new AtomicLong(0L);
    private final AtomicLong nextMethodID = new AtomicLong(0L);

    static final LibraryLoader getInstance() {
        return SingletonHolder.INSTANCE;
    }

    @Override
    boolean isInterfaceSupported(Class interfaceClass, Map<LibraryOption, ?> options2) {
        TypeMapper typeMapper = options2.containsKey((Object)LibraryOption.TypeMapper) ? (TypeMapper)options2.get((Object)LibraryOption.TypeMapper) : NullTypeMapper.INSTANCE;
        for (Method m : interfaceClass.getDeclaredMethods()) {
            if (!this.isReturnTypeSupported(m.getReturnType()) && this.getResultConverter(m, typeMapper) == null) {
                System.err.println("Unsupported return type: " + m.getReturnType());
                return false;
            }
            for (Class<?> c : m.getParameterTypes()) {
                if (this.isParameterTypeSupported(c) || typeMapper.getToNativeConverter(c) != null) continue;
                System.err.println("Unsupported parameter type: " + c);
                return false;
            }
        }
        return true;
    }

    private boolean isReturnTypeSupported(Class type2) {
        return type2.isPrimitive() || Byte.class == type2 || Short.class == type2 || Integer.class == type2 || Long.class == type2 || Float.class == type2 || Double.class == type2 || NativeLong.class == type2 || Pointer.class == type2 || Address.class == type2 || String.class == type2 || Struct.class.isAssignableFrom(type2);
    }

    private boolean isParameterTypeSupported(Class type2) {
        return type2.isPrimitive() || Byte.class == type2 || Short.class == type2 || Integer.class == type2 || Long.class == type2 || Float.class == type2 || Double.class == type2 || NativeLong.class == type2 || Pointer.class.isAssignableFrom(type2) || Address.class.isAssignableFrom(type2) || Enum.class.isAssignableFrom(type2) || Buffer.class.isAssignableFrom(type2) || type2.isArray() && type2.getComponentType().isPrimitive() || Struct.class.isAssignableFrom(type2) || type2.isArray() && Struct.class.isAssignableFrom(type2.getComponentType()) || type2.isArray() && Pointer.class.isAssignableFrom(type2.getComponentType()) || type2.isArray() && CharSequence.class.isAssignableFrom(type2.getComponentType()) || CharSequence.class.isAssignableFrom(type2) || ByReference.class.isAssignableFrom(type2) || StringBuilder.class.isAssignableFrom(type2) || StringBuffer.class.isAssignableFrom(type2);
    }

    @Override
    <T> T loadLibrary(Library library2, Class<T> interfaceClass, Map<LibraryOption, ?> libraryOptions) {
        return this.generateInterfaceImpl(library2, interfaceClass, libraryOptions);
    }

    private final <T> T generateInterfaceImpl(Library library2, Class<T> interfaceClass, Map<LibraryOption, ?> libraryOptions) {
        ClassWriter cw = new ClassWriter(2);
        ClassWriter cv = DEBUG ? AsmUtil.newCheckClassAdapter(AsmUtil.newTraceClassVisitor((ClassVisitor)cw, System.err)) : cw;
        String className = CodegenUtils.p(interfaceClass) + "$jaffl$" + this.nextClassID.getAndIncrement();
        cv.visit(49, 17, className, null, CodegenUtils.p(AbstractNativeInterface.class), new String[]{CodegenUtils.p(interfaceClass)});
        SkinnyMethodAdapter init = new SkinnyMethodAdapter(cv.visitMethod(1, "<init>", CodegenUtils.sig(Void.TYPE, Library.class, Function[].class, FromNativeConverter[].class, ToNativeConverter[][].class), null, null));
        init.start();
        init.aload(0);
        init.aload(1);
        init.invokespecial(CodegenUtils.p(AbstractNativeInterface.class), "<init>", CodegenUtils.sig(Void.TYPE, Library.class));
        Method[] methods2 = interfaceClass.getMethods();
        Function[] functions = new Function[methods2.length];
        FromNativeConverter[] resultConverters = new FromNativeConverter[methods2.length];
        ToNativeConverter[][] parameterConverters = new ToNativeConverter[methods2.length][0];
        FunctionMapper functionMapper = libraryOptions.containsKey((Object)LibraryOption.FunctionMapper) ? (FunctionMapper)libraryOptions.get((Object)LibraryOption.FunctionMapper) : IdentityFunctionMapper.getInstance();
        TypeMapper typeMapper = libraryOptions.containsKey((Object)LibraryOption.TypeMapper) ? (TypeMapper)libraryOptions.get((Object)LibraryOption.TypeMapper) : NullTypeMapper.INSTANCE;
        CallingConvention libraryCallingConvention = AsmLibraryLoader.getCallingConvention(interfaceClass, libraryOptions);
        StubCompiler compiler = StubCompiler.newCompiler();
        for (int i2 = 0; i2 < methods2.length; ++i2) {
            boolean ignoreErrno;
            Method m = methods2[i2];
            Class<?> returnType = m.getReturnType();
            Class[] parameterTypes = m.getParameterTypes();
            Class<Object> nativeReturnType = returnType;
            Class[] nativeParameterTypes = new Class[parameterTypes.length];
            boolean conversionRequired = false;
            resultConverters[i2] = this.getResultConverter(m, typeMapper);
            if (resultConverters[i2] != null) {
                cv.visitField(18, this.getResultConverterFieldName(i2), CodegenUtils.ci(FromNativeConverter.class), null, null);
                nativeReturnType = resultConverters[i2].nativeType();
                conversionRequired = true;
            }
            parameterConverters[i2] = new ToNativeConverter[parameterTypes.length];
            for (int pidx = 0; pidx < parameterTypes.length; ++pidx) {
                ToNativeConverter converter = typeMapper.getToNativeConverter(parameterTypes[pidx]);
                if (converter != null) {
                    cv.visitField(18, this.getParameterConverterFieldName(i2, pidx), CodegenUtils.ci(ToNativeConverter.class), null, null);
                    nativeParameterTypes[pidx] = converter.nativeType();
                    parameterConverters[i2][pidx] = new ToNativeProxy(converter, new MethodParameterContext(m, pidx));
                    conversionRequired = true;
                    continue;
                }
                nativeParameterTypes[pidx] = parameterTypes[pidx];
            }
            String functionName = functionMapper.mapFunctionName(m.getName(), null);
            cv.visitField(26, "name_" + i2, CodegenUtils.ci(String.class), null, functionName);
            CallingConvention callingConvention = m.getAnnotation(StdCall.class) != null ? CallingConvention.STDCALL : libraryCallingConvention;
            try {
                functions[i2] = AsmLibraryLoader.getFunction(library2.findSymbolAddress(functionName), nativeReturnType, nativeParameterTypes, InvokerUtil.requiresErrno(m), callingConvention);
            }
            catch (SymbolNotFoundError ex) {
                cv.visitField(26, "error_" + i2, CodegenUtils.ci(String.class), null, ex.getMessage());
                this.generateFunctionNotFound(cv, className, i2, functionName, returnType, parameterTypes);
                continue;
            }
            String functionFieldName = "function_" + i2;
            cv.visitField(18, functionFieldName, CodegenUtils.ci(Function.class), null, null);
            boolean bl = ignoreErrno = !InvokerUtil.requiresErrno(m);
            if (this.canCompile(compiler, nativeReturnType, nativeParameterTypes, callingConvention)) {
                this.compile(compiler, functions[i2], cv, className, m.getName() + (conversionRequired ? "$raw" : ""), functionFieldName, nativeReturnType, nativeParameterTypes, m.getParameterAnnotations(), callingConvention, ignoreErrno);
            } else {
                this.generateMethod(cv, className, m.getName() + (conversionRequired ? "$raw" : ""), functionFieldName, nativeReturnType, nativeParameterTypes, m.getParameterAnnotations(), callingConvention, ignoreErrno);
            }
            if (conversionRequired) {
                this.generateConversionMethod(cv, className, m.getName(), i2, returnType, parameterTypes, nativeReturnType, nativeParameterTypes);
            }
            init.aload(0);
            init.aload(2);
            init.pushInt(i2);
            init.aaload();
            init.putfield(className, functionFieldName, CodegenUtils.ci(Function.class));
            if (resultConverters[i2] != null) {
                init.aload(0);
                init.aload(3);
                init.pushInt(i2);
                init.aaload();
                init.putfield(className, this.getResultConverterFieldName(i2), CodegenUtils.ci(FromNativeConverter.class));
            }
            for (int pidx = 0; pidx < parameterTypes.length; ++pidx) {
                if (parameterConverters[i2][pidx] == null) continue;
                init.aload(0);
                init.aload(4);
                init.pushInt(i2);
                init.aaload();
                init.pushInt(pidx);
                init.aaload();
                init.putfield(className, this.getParameterConverterFieldName(i2, pidx), CodegenUtils.ci(ToNativeConverter.class));
            }
        }
        init.voidreturn();
        init.visitMaxs(10, 10);
        init.visitEnd();
        cv.visitEnd();
        try {
            Class implClass = new AsmClassLoader(interfaceClass.getClassLoader()).defineClass(className.replace("/", "."), cw.toByteArray());
            Constructor cons = implClass.getDeclaredConstructor(Library.class, Function[].class, FromNativeConverter[].class, ToNativeConverter[][].class);
            Object result = cons.newInstance(new Object[]{library2, functions, resultConverters, parameterConverters});
            compiler.attach(implClass);
            return result;
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
    }

    private final FromNativeConverter getResultConverter(Method m, TypeMapper typeMapper) {
        Class<?> returnType = m.getReturnType();
        FromNativeConverter conv2 = typeMapper.getFromNativeConverter(returnType);
        if (conv2 != null) {
            return new FromNativeProxy(conv2, new MethodResultContext(m));
        }
        if (Enum.class.isAssignableFrom(returnType)) {
            return new EnumResultConverter(returnType);
        }
        return null;
    }

    private static final CallingConvention getCallingConvention(Class interfaceClass, Map<LibraryOption, ?> options2) {
        if (interfaceClass.getAnnotation(StdCall.class) != null) {
            return CallingConvention.STDCALL;
        }
        return InvokerUtil.getCallingConvention(options2);
    }

    private final String getFunctionFieldName(int idx) {
        return "function_" + idx;
    }

    private final String getResultConverterFieldName(int idx) {
        return "resultConverter_" + idx;
    }

    private final String getParameterConverterFieldName(int idx, int paramIndex) {
        return "parameterConverter_" + idx + "_" + paramIndex;
    }

    private final void generateFunctionNotFound(ClassVisitor cv, String className, int idx, String functionName, Class returnType, Class[] parameterTypes) {
        SkinnyMethodAdapter mv = new SkinnyMethodAdapter(cv.visitMethod(17, functionName, CodegenUtils.sig(returnType, parameterTypes), null, null));
        mv.start();
        mv.getstatic(className, "error_" + idx, CodegenUtils.ci(String.class));
        mv.invokestatic(AsmRuntime.class, "newUnsatisifiedLinkError", UnsatisfiedLinkError.class, String.class);
        mv.athrow();
        mv.visitMaxs(10, 10);
        mv.visitEnd();
    }

    private final void generateConversionMethod(ClassVisitor cv, String className, String functionName, int idx, Class returnType, Class[] parameterTypes, Class nativeReturnType, Class[] nativeParameterTypes) {
        SkinnyMethodAdapter mv = new SkinnyMethodAdapter(cv.visitMethod(17, functionName, CodegenUtils.sig(returnType, parameterTypes), null, null));
        mv.start();
        if (!returnType.equals(nativeReturnType)) {
            mv.aload(0);
            mv.getfield(className, this.getResultConverterFieldName(idx), CodegenUtils.ci(FromNativeConverter.class));
        }
        mv.aload(0);
        int lvar = 1;
        for (int pidx = 0; pidx < parameterTypes.length; ++pidx) {
            boolean convertParameter;
            boolean bl = convertParameter = !parameterTypes[pidx].equals(nativeParameterTypes[pidx]);
            if (convertParameter) {
                mv.aload(0);
                mv.getfield(className, this.getParameterConverterFieldName(idx, pidx), CodegenUtils.ci(ToNativeConverter.class));
            }
            lvar = this.loadParameter(mv, parameterTypes[pidx], lvar);
            if (!convertParameter) continue;
            if (parameterTypes[pidx].isPrimitive()) {
                this.boxPrimitive(mv, parameterTypes[pidx]);
            }
            mv.aconst_null();
            mv.invokeinterface(ToNativeConverter.class, "toNative", Object.class, Object.class, ToNativeContext.class);
            mv.checkcast(CodegenUtils.p(nativeParameterTypes[pidx]));
        }
        mv.invokevirtual(className, functionName + "$raw", CodegenUtils.sig(nativeReturnType, nativeParameterTypes));
        if (!returnType.equals(nativeReturnType)) {
            if (nativeReturnType.isPrimitive()) {
                this.boxPrimitive(mv, nativeReturnType);
            }
            mv.aconst_null();
            mv.invokeinterface(FromNativeConverter.class, "fromNative", Object.class, Object.class, FromNativeContext.class);
            mv.checkcast(CodegenUtils.p(returnType));
        }
        AsmUtil.emitReturnOp(mv, returnType);
        mv.visitMaxs(10, 10);
        mv.visitEnd();
    }

    private final boolean canCompile(StubCompiler compiler, Class returnType, Class[] parameterTypes, CallingConvention convention) {
        Class[] nativeParameterTypes = new Class[parameterTypes.length];
        for (int i2 = 0; i2 < nativeParameterTypes.length; ++i2) {
            nativeParameterTypes[i2] = AsmUtil.unboxedType(parameterTypes[i2]);
        }
        return compiler.canCompile(AsmUtil.unboxedReturnType(returnType), nativeParameterTypes, convention);
    }

    private final void compile(StubCompiler compiler, Function function, ClassVisitor cv, String className, String functionName, String functionFieldName, Class returnType, Class[] parameterTypes, Annotation[][] annotations2, CallingConvention convention, boolean ignoreErrno) {
        Class nativeReturnType;
        Class[] nativeParameterTypes = new Class[parameterTypes.length];
        boolean unboxing = false;
        boolean ptrCheck = false;
        for (int i2 = 0; i2 < nativeParameterTypes.length; ++i2) {
            nativeParameterTypes[i2] = AsmUtil.unboxedType(parameterTypes[i2]);
            unboxing |= nativeParameterTypes[i2] != parameterTypes[i2];
            ptrCheck |= Pointer.class.isAssignableFrom(parameterTypes[i2]) || Struct.class.isAssignableFrom(parameterTypes[i2]);
        }
        String stubName = functionName + ((unboxing |= (nativeReturnType = AsmUtil.unboxedReturnType(returnType)) != returnType) || ptrCheck ? "$jni$" + this.nextMethodID.getAndIncrement() : "");
        if (unboxing || ptrCheck) {
            SkinnyMethodAdapter mv = new SkinnyMethodAdapter(cv.visitMethod(17, functionName, CodegenUtils.sig(returnType, parameterTypes), null, null));
            mv.start();
            mv.aload(0);
            Label bufferInvocationLabel = AsmLibraryLoader.emitDirectCheck(mv, parameterTypes);
            int lvar = 1;
            for (int i3 = 0; i3 < parameterTypes.length; ++i3) {
                lvar = this.loadParameter(mv, parameterTypes[i3], lvar);
                if (parameterTypes[i3] == nativeParameterTypes[i3]) continue;
                if (Number.class.isAssignableFrom(parameterTypes[i3])) {
                    AsmUtil.unboxNumber(mv, parameterTypes[i3], nativeParameterTypes[i3]);
                    continue;
                }
                if (Pointer.class.isAssignableFrom(parameterTypes[i3])) {
                    AsmUtil.unboxPointer(mv, nativeParameterTypes[i3]);
                    continue;
                }
                if (!Struct.class.isAssignableFrom(parameterTypes[i3])) continue;
                AsmUtil.unboxStruct(mv, nativeParameterTypes[i3]);
            }
            mv.invokevirtual(className, stubName, CodegenUtils.sig(nativeReturnType, nativeParameterTypes));
            this.emitReturn(mv, returnType, nativeReturnType);
            String bufInvoke = null;
            if (bufferInvocationLabel != null) {
                mv.label(bufferInvocationLabel);
                bufInvoke = functionName + "$buf$" + this.nextMethodID.getAndIncrement();
                int lvar2 = 1;
                for (int i4 = 0; i4 < parameterTypes.length; ++i4) {
                    lvar2 = this.loadParameter(mv, parameterTypes[i4], lvar2);
                }
                mv.invokevirtual(className, bufInvoke, CodegenUtils.sig(returnType, parameterTypes));
                AsmUtil.emitReturnOp(mv, returnType);
            }
            mv.visitMaxs(100, AsmUtil.calculateLocalVariableSpace(parameterTypes) + 10);
            mv.visitEnd();
            if (bufInvoke != null) {
                SkinnyMethodAdapter bi = new SkinnyMethodAdapter(cv.visitMethod(17, bufInvoke, CodegenUtils.sig(returnType, parameterTypes), null, null));
                bi.start();
                bi.getstatic(CodegenUtils.p(AbstractNativeInterface.class), "ffi", CodegenUtils.ci(Invoker.class));
                bi.aload(0);
                bi.getfield(className, functionFieldName, CodegenUtils.ci(Function.class));
                this.generateBufferInvocation(bi, returnType, parameterTypes, annotations2);
                bi.visitMaxs(100, AsmUtil.calculateLocalVariableSpace(parameterTypes) + 10);
                bi.visitEnd();
            }
        }
        cv.visitMethod(273, stubName, CodegenUtils.sig(nativeReturnType, nativeParameterTypes), null, null);
        compiler.compile(function, stubName, nativeReturnType, nativeParameterTypes, convention, !ignoreErrno);
    }

    private final void generateMethod(ClassVisitor cv, String className, String functionName, String functionFieldName, Class returnType, Class[] parameterTypes, Annotation[][] parameterAnnotations, CallingConvention convention, boolean ignoreErrno) {
        SkinnyMethodAdapter mv = new SkinnyMethodAdapter(cv.visitMethod(17, functionName, CodegenUtils.sig(returnType, parameterTypes), null, null));
        mv.start();
        mv.getstatic(CodegenUtils.p(AbstractNativeInterface.class), "ffi", CodegenUtils.ci(Invoker.class));
        mv.aload(0);
        mv.getfield(className, functionFieldName, CodegenUtils.ci(Function.class));
        if (convention == CallingConvention.DEFAULT && AsmLibraryLoader.isFastIntegerMethod(returnType, parameterTypes)) {
            this.generateFastIntegerInvocation(mv, returnType, parameterTypes, parameterAnnotations, ignoreErrno);
        } else if (convention == CallingConvention.DEFAULT && FAST_NUMERIC_AVAILABLE && AsmLibraryLoader.isFastNumericMethod(returnType, parameterTypes)) {
            this.generateFastNumericInvocation(mv, returnType, parameterTypes, parameterAnnotations);
        } else {
            this.generateBufferInvocation(mv, returnType, parameterTypes, parameterAnnotations);
        }
        mv.visitMaxs(100, AsmUtil.calculateLocalVariableSpace(parameterTypes) + 10);
        mv.visitEnd();
    }

    private final void generateBufferInvocation(SkinnyMethodAdapter mv, Class returnType, Class[] parameterTypes, Annotation[][] annotations2) {
        int lvarSession;
        boolean sessionRequired = AsmLibraryLoader.isSessionRequired(parameterTypes);
        int n = lvarSession = sessionRequired ? AsmUtil.calculateLocalVariableSpace(parameterTypes) + 1 : -1;
        if (sessionRequired) {
            mv.newobj(CodegenUtils.p(InvocationSession.class));
            mv.dup();
            mv.invokespecial(InvocationSession.class, "<init>", Void.TYPE, new Class[0]);
            mv.astore(lvarSession);
        }
        mv.dup();
        mv.invokestatic(AsmRuntime.class, "newHeapInvocationBuffer", HeapInvocationBuffer.class, Function.class);
        int lvar = 1;
        for (int i2 = 0; i2 < parameterTypes.length; ++i2) {
            mv.dup();
            if (AsmLibraryLoader.isSessionRequired(parameterTypes[i2])) {
                mv.aload(lvarSession);
                mv.swap();
            }
            lvar = this.loadParameter(mv, parameterTypes[i2], lvar);
            int parameterFlags = DefaultInvokerFactory.getParameterFlags(annotations2[i2]);
            int nativeArrayFlags = DefaultInvokerFactory.getNativeArrayFlags(parameterFlags) | ((parameterFlags & 2) != 0 ? 4 : 0);
            if (parameterTypes[i2].isArray() && parameterTypes[i2].getComponentType().isPrimitive()) {
                mv.pushInt(nativeArrayFlags);
                this.marshal(mv, parameterTypes[i2], Integer.TYPE);
                continue;
            }
            if (Pointer.class.isAssignableFrom(parameterTypes[i2])) {
                mv.pushInt(nativeArrayFlags);
                this.marshal(mv, Pointer.class, Integer.TYPE);
                continue;
            }
            if (Address.class.isAssignableFrom(parameterTypes[i2])) {
                this.marshal(mv, Pointer.class);
                continue;
            }
            if (Enum.class.isAssignableFrom(parameterTypes[i2])) {
                this.marshal(mv, Enum.class);
                continue;
            }
            if (Buffer.class.isAssignableFrom(parameterTypes[i2])) {
                mv.pushInt(nativeArrayFlags);
                this.marshal(mv, parameterTypes[i2], Integer.TYPE);
                continue;
            }
            if (ByReference.class.isAssignableFrom(parameterTypes[i2])) {
                mv.pushInt(nativeArrayFlags);
                this.sessionmarshal(mv, ByReference.class, Integer.TYPE);
                continue;
            }
            if (StringBuilder.class.isAssignableFrom(parameterTypes[i2]) || StringBuffer.class.isAssignableFrom(parameterTypes[i2])) {
                mv.pushInt(parameterFlags);
                mv.pushInt(nativeArrayFlags);
                this.sessionmarshal(mv, parameterTypes[i2], Integer.TYPE, Integer.TYPE);
                continue;
            }
            if (CharSequence.class.isAssignableFrom(parameterTypes[i2])) {
                this.marshal(mv, CharSequence.class);
                continue;
            }
            if (parameterTypes[i2].isArray() && CharSequence.class.isAssignableFrom(parameterTypes[i2].getComponentType())) {
                mv.pushInt(parameterFlags);
                mv.pushInt(nativeArrayFlags);
                this.sessionmarshal(mv, CharSequence[].class, Integer.TYPE, Integer.TYPE);
                continue;
            }
            if (Struct.class.isAssignableFrom(parameterTypes[i2])) {
                mv.pushInt(parameterFlags);
                mv.pushInt(nativeArrayFlags);
                this.marshal(mv, Struct.class, Integer.TYPE, Integer.TYPE);
                continue;
            }
            if (parameterTypes[i2].isArray() && Struct.class.isAssignableFrom(parameterTypes[i2].getComponentType())) {
                mv.pushInt(parameterFlags);
                mv.pushInt(nativeArrayFlags);
                this.marshal(mv, Struct[].class, Integer.TYPE, Integer.TYPE);
                continue;
            }
            if (parameterTypes[i2].isArray() && Pointer.class.isAssignableFrom(parameterTypes[i2].getComponentType())) {
                mv.pushInt(parameterFlags);
                mv.pushInt(nativeArrayFlags);
                this.sessionmarshal(mv, Pointer[].class, Integer.TYPE, Integer.TYPE);
                continue;
            }
            if (parameterTypes[i2].isPrimitive() || Number.class.isAssignableFrom(parameterTypes[i2])) {
                this.emitInvocationBufferIntParameter(mv, parameterTypes[i2]);
                continue;
            }
            throw new IllegalArgumentException("unsupported parameter type " + parameterTypes[i2]);
        }
        String invokeMethod = null;
        Class<Number> nativeReturnType = null;
        if (NumberUtil.isPrimitiveInt(returnType) || Void.TYPE == returnType || Byte.class == returnType || Short.class == returnType || Integer.class == returnType) {
            invokeMethod = "invokeInt";
            nativeReturnType = Integer.TYPE;
        } else if (Long.class == returnType || Long.TYPE == returnType) {
            invokeMethod = "invokeLong";
            nativeReturnType = Long.TYPE;
        } else if (NativeLong.class == returnType) {
            invokeMethod = NativeLong.SIZE == 32 ? "invokeInt" : "invokeLong";
            nativeReturnType = NativeLong.SIZE == 32 ? Integer.TYPE : Long.TYPE;
        } else if (Pointer.class == returnType || Address.class == returnType || Struct.class.isAssignableFrom(returnType) || String.class.isAssignableFrom(returnType)) {
            invokeMethod = "invokeAddress";
            nativeReturnType = Long.TYPE;
        } else if (Float.class == returnType || Float.TYPE == returnType) {
            invokeMethod = "invokeFloat";
            nativeReturnType = Float.TYPE;
        } else if (Double.class == returnType || Double.TYPE == returnType) {
            invokeMethod = "invokeDouble";
            nativeReturnType = Double.TYPE;
        } else {
            throw new IllegalArgumentException("unsupported return type " + returnType);
        }
        mv.invokevirtual(Invoker.class, invokeMethod, nativeReturnType, Function.class, HeapInvocationBuffer.class);
        if (sessionRequired) {
            mv.aload(lvarSession);
            mv.invokevirtual(CodegenUtils.p(InvocationSession.class), "finish", "()V");
        }
        this.emitReturn(mv, returnType, nativeReturnType);
    }

    private final void generateFastIntegerInvocation(SkinnyMethodAdapter mv, Class returnType, Class[] parameterTypes, Annotation[][] annotations2, boolean ignoreErrno) {
        Label bufferInvocationLabel = AsmLibraryLoader.emitDirectCheck(mv, parameterTypes);
        Class<? extends Number> nativeIntType = AsmLibraryLoader.getNativeIntType(returnType, parameterTypes);
        int lvar = 1;
        for (int i2 = 0; i2 < parameterTypes.length; ++i2) {
            lvar = this.loadParameter(mv, parameterTypes[i2], lvar);
            if (parameterTypes[i2].isPrimitive()) {
                NumberUtil.widen(mv, parameterTypes[i2], nativeIntType);
                continue;
            }
            if (Number.class.isAssignableFrom(parameterTypes[i2])) {
                AsmUtil.unboxNumber(mv, parameterTypes[i2], nativeIntType);
                continue;
            }
            if (Pointer.class.isAssignableFrom(parameterTypes[i2])) {
                AsmUtil.unboxPointer(mv, nativeIntType);
                continue;
            }
            if (!Struct.class.isAssignableFrom(parameterTypes[i2])) continue;
            AsmUtil.unboxStruct(mv, nativeIntType);
        }
        mv.invokevirtual(CodegenUtils.p(Invoker.class), AsmLibraryLoader.getFastIntInvokerMethodName(parameterTypes.length, ignoreErrno, nativeIntType), AsmLibraryLoader.getFastIntInvokerSignature(parameterTypes.length, nativeIntType));
        this.emitReturn(mv, returnType, nativeIntType);
        if (bufferInvocationLabel != null) {
            mv.label(bufferInvocationLabel);
            this.generateBufferInvocation(mv, returnType, parameterTypes, annotations2);
        }
    }

    private final void generateFastNumericInvocation(SkinnyMethodAdapter mv, Class returnType, Class[] parameterTypes, Annotation[][] annotations2) {
        Label bufferInvocationLabel = AsmLibraryLoader.emitDirectCheck(mv, parameterTypes);
        int lvar = 1;
        for (int i2 = 0; i2 < parameterTypes.length; ++i2) {
            lvar = this.loadParameter(mv, parameterTypes[i2], lvar);
            if (Pointer.class.isAssignableFrom(parameterTypes[i2])) {
                AsmUtil.unboxPointer(mv, Long.TYPE);
                continue;
            }
            if (Struct.class.isAssignableFrom(parameterTypes[i2])) {
                AsmUtil.unboxStruct(mv, Long.TYPE);
                continue;
            }
            if (!parameterTypes[i2].isPrimitive() && Number.class.isAssignableFrom(parameterTypes[i2])) {
                AsmUtil.unboxNumber(mv, parameterTypes[i2], Long.TYPE);
            }
            if (Float.class == parameterTypes[i2] || Float.TYPE == parameterTypes[i2]) {
                mv.invokestatic(Float.class, "floatToRawIntBits", Integer.TYPE, Float.TYPE);
                mv.i2l();
                continue;
            }
            if (Double.class == parameterTypes[i2] || Double.TYPE == parameterTypes[i2]) {
                mv.invokestatic(Double.class, "doubleToRawLongBits", Long.TYPE, Double.TYPE);
                continue;
            }
            NumberUtil.widen(mv, parameterTypes[i2], Long.TYPE);
        }
        mv.invokevirtual(CodegenUtils.p(Invoker.class), AsmLibraryLoader.getFastNumericInvokerMethodName(parameterTypes.length, returnType), AsmLibraryLoader.getFastNumericInvokerSignature(parameterTypes.length));
        if (Float.class == returnType || Float.TYPE == returnType) {
            mv.l2i();
            mv.invokestatic(Float.class, "intBitsToFloat", Float.TYPE, Integer.TYPE);
        } else if (Double.class == returnType || Double.TYPE == returnType) {
            mv.invokestatic(Double.class, "longBitsToDouble", Double.TYPE, Long.TYPE);
        }
        this.emitReturn(mv, returnType, Long.TYPE);
        if (bufferInvocationLabel != null) {
            mv.label(bufferInvocationLabel);
            this.generateBufferInvocation(mv, returnType, parameterTypes, annotations2);
        }
    }

    private static final Label emitDirectCheck(SkinnyMethodAdapter mv, Class[] parameterTypes) {
        Label notFastInt = new Label();
        boolean needBufferInvocation = false;
        int lvar = 1;
        for (int i2 = 0; i2 < parameterTypes.length; ++i2) {
            if (Pointer.class.isAssignableFrom(parameterTypes[i2])) {
                mv.aload(lvar++);
                mv.invokestatic(AsmRuntime.class, "isDirect", Boolean.TYPE, Pointer.class);
                mv.iffalse(notFastInt);
                needBufferInvocation = true;
                continue;
            }
            if (Struct.class.isAssignableFrom(parameterTypes[i2])) {
                mv.aload(lvar++);
                mv.invokestatic(AsmRuntime.class, "isDirect", Boolean.TYPE, Struct.class);
                mv.iffalse(notFastInt);
                needBufferInvocation = true;
                continue;
            }
            lvar += AsmUtil.calculateLocalVariableSpace(parameterTypes[i2]);
        }
        return needBufferInvocation ? notFastInt : null;
    }

    private final void emitReturn(SkinnyMethodAdapter mv, Class returnType, Class nativeIntType) {
        if (returnType.isPrimitive()) {
            if (Long.TYPE == returnType) {
                NumberUtil.widen(mv, nativeIntType, returnType);
                mv.lreturn();
            } else if (Float.TYPE == returnType) {
                mv.freturn();
            } else if (Double.TYPE == returnType) {
                mv.dreturn();
            } else if (Void.TYPE == returnType) {
                mv.voidreturn();
            } else {
                NumberUtil.narrow(mv, nativeIntType, returnType);
                mv.ireturn();
            }
        } else {
            this.boxValue(mv, returnType, nativeIntType);
            mv.areturn();
        }
    }

    private final int loadParameter(SkinnyMethodAdapter mv, Class parameterType, int lvar) {
        if (!parameterType.isPrimitive()) {
            mv.aload(lvar++);
        } else if (Long.TYPE == parameterType) {
            mv.lload(lvar);
            lvar += 2;
        } else if (Float.TYPE == parameterType) {
            mv.fload(lvar++);
        } else if (Double.TYPE == parameterType) {
            mv.dload(lvar);
            lvar += 2;
        } else {
            mv.iload(lvar++);
        }
        return lvar;
    }

    private static final Class<? extends Number> getNativeIntType(Class returnType, Class[] parameterTypes) {
        for (int i2 = 0; i2 < parameterTypes.length; ++i2) {
            if (!AsmLibraryLoader.requiresLong(parameterTypes[i2])) continue;
            return Long.TYPE;
        }
        return AsmLibraryLoader.requiresLong(returnType) ? Long.TYPE : Integer.TYPE;
    }

    static final String getFastIntInvokerMethodName(int parameterCount, boolean ignoreErrno, Class nativeParamType) {
        String t;
        StringBuilder sb = new StringBuilder("invoke");
        if (ignoreErrno && Integer.TYPE == nativeParamType) {
            sb.append("NoErrno");
        }
        String string2 = t = Integer.TYPE == nativeParamType ? "I" : "L";
        if (parameterCount < 1) {
            sb.append("V");
        } else {
            for (int i2 = 0; i2 < parameterCount; ++i2) {
                sb.append(t);
            }
        }
        return sb.append("r").append(t).toString();
    }

    static final String getFastIntInvokerSignature(int parameterCount, Class nativeIntType) {
        String t = Integer.TYPE == nativeIntType ? "I" : "J";
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append(CodegenUtils.ci(Function.class));
        for (int i2 = 0; i2 < parameterCount; ++i2) {
            sb.append(t);
        }
        sb.append(")").append(t);
        return sb.toString();
    }

    static final String getFastNumericInvokerMethodName(int parameterCount, Class nativeParamType) {
        StringBuilder sb = new StringBuilder("invoke");
        if (parameterCount < 1) {
            sb.append("V");
        } else {
            for (int i2 = 0; i2 < parameterCount; ++i2) {
                sb.append("N");
            }
        }
        return sb.append("r").append("N").toString();
    }

    static final String getFastNumericInvokerSignature(int parameterCount) {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append(CodegenUtils.ci(Function.class));
        for (int i2 = 0; i2 < parameterCount; ++i2) {
            sb.append("J");
        }
        sb.append(")").append("J");
        return sb.toString();
    }

    private final void boxStruct(SkinnyMethodAdapter mv, Class returnType) {
        mv.dup2();
        Label nonnull = new Label();
        Label end2 = new Label();
        mv.lconst_0();
        mv.lcmp();
        mv.ifne(nonnull);
        mv.pop2();
        mv.aconst_null();
        mv.go_to(end2);
        mv.label(nonnull);
        mv.newobj(CodegenUtils.p(returnType));
        mv.dup();
        mv.invokespecial(returnType, "<init>", Void.TYPE, new Class[0]);
        mv.dup_x2();
        mv.invokestatic(AsmRuntime.class, "useMemory", Void.TYPE, Long.TYPE, Struct.class);
        mv.label(end2);
    }

    private final void boxPrimitive(SkinnyMethodAdapter mv, Class primitiveType) {
        Class objClass = NumberUtil.getBoxedClass(primitiveType);
        mv.invokestatic(objClass, "valueOf", objClass, primitiveType);
    }

    private final void boxNumber(SkinnyMethodAdapter mv, Class type2, Class nativeType) {
        Class<Long> primitiveClass = NumberUtil.getPrimitiveClass(type2);
        if (Byte.class.isAssignableFrom(type2)) {
            NumberUtil.narrow(mv, nativeType, Byte.TYPE);
        } else if (Character.class.isAssignableFrom(type2)) {
            NumberUtil.narrow(mv, nativeType, Character.TYPE);
        } else if (Short.class.isAssignableFrom(type2)) {
            NumberUtil.narrow(mv, nativeType, Short.TYPE);
        } else if (Integer.class.isAssignableFrom(type2)) {
            NumberUtil.narrow(mv, nativeType, Integer.TYPE);
        } else if (Long.class.isAssignableFrom(type2)) {
            NumberUtil.widen(mv, nativeType, Long.TYPE);
        } else if (NativeLong.class.isAssignableFrom(type2)) {
            NumberUtil.widen(mv, nativeType, Long.TYPE);
            primitiveClass = Long.TYPE;
        } else if (Boolean.class.isAssignableFrom(type2)) {
            NumberUtil.narrow(mv, nativeType, Boolean.TYPE);
        } else if (Float.class != type2 && Double.class != type2) {
            throw new IllegalArgumentException("invalid Number subclass");
        }
        mv.invokestatic(type2, "valueOf", type2, primitiveClass);
    }

    private final void boxValue(SkinnyMethodAdapter mv, Class returnType, Class nativeReturnType) {
        if (returnType == nativeReturnType) {
            return;
        }
        if (Boolean.class.isAssignableFrom(returnType)) {
            NumberUtil.narrow(mv, nativeReturnType, Boolean.TYPE);
            mv.invokestatic(Boolean.class, "valueOf", Boolean.class, Boolean.TYPE);
        } else if (Pointer.class.isAssignableFrom(returnType)) {
            mv.invokestatic(AsmRuntime.class, "pointerValue", Pointer.class, nativeReturnType);
        } else if (Address.class == returnType) {
            NumberUtil.widen(mv, nativeReturnType, Long.TYPE);
            mv.invokestatic(returnType, "valueOf", returnType, Long.TYPE);
        } else if (Struct.class.isAssignableFrom(returnType)) {
            NumberUtil.widen(mv, nativeReturnType, Long.TYPE);
            this.boxStruct(mv, returnType);
        } else if (Number.class.isAssignableFrom(returnType)) {
            this.boxNumber(mv, returnType, nativeReturnType);
        } else if (String.class == returnType) {
            NumberUtil.widen(mv, nativeReturnType, Long.TYPE);
            mv.invokestatic(AsmRuntime.class, "returnString", String.class, Long.TYPE);
        } else {
            throw new IllegalArgumentException("cannot box value of type " + nativeReturnType + " to " + returnType);
        }
    }

    private final void emitInvocationBufferIntParameter(SkinnyMethodAdapter mv, Class parameterType) {
        String paramMethod = null;
        Class<Number> paramClass = Integer.TYPE;
        if (!parameterType.isPrimitive()) {
            AsmUtil.unboxNumber(mv, parameterType, null);
        }
        if (Byte.TYPE == parameterType || Byte.class == parameterType) {
            paramMethod = "putByte";
        } else if (Short.TYPE == parameterType || Short.class == parameterType) {
            paramMethod = "putShort";
        } else if (Integer.TYPE == parameterType || Integer.class == parameterType || Boolean.TYPE == parameterType) {
            paramMethod = "putInt";
        } else if (Long.TYPE == parameterType || Long.class == parameterType) {
            paramMethod = "putLong";
            paramClass = Long.TYPE;
        } else if (Float.TYPE == parameterType || Float.class == parameterType) {
            paramMethod = "putFloat";
            paramClass = Float.TYPE;
        } else if (Double.TYPE == parameterType || Double.class == parameterType) {
            paramMethod = "putDouble";
            paramClass = Double.TYPE;
        } else if (NativeLong.class.isAssignableFrom(parameterType) && Platform.getPlatform().longSize() == 32) {
            paramMethod = "putInt";
            paramClass = Integer.TYPE;
        } else if (NativeLong.class.isAssignableFrom(parameterType) && Platform.getPlatform().longSize() == 64) {
            paramMethod = "putLong";
            paramClass = Long.TYPE;
        } else {
            throw new IllegalArgumentException("unsupported parameter type " + parameterType);
        }
        mv.invokevirtual(HeapInvocationBuffer.class, paramMethod, Void.TYPE, paramClass);
    }

    private final void marshal(SkinnyMethodAdapter mv, Class ... parameterTypes) {
        mv.invokestatic(CodegenUtils.p(AsmRuntime.class), "marshal", CodegenUtils.sig(Void.TYPE, CodegenUtils.ci(InvocationBuffer.class), parameterTypes));
    }

    private final void sessionmarshal(SkinnyMethodAdapter mv, Class ... parameterTypes) {
        mv.invokestatic(CodegenUtils.p(AsmRuntime.class), "marshal", CodegenUtils.sig(Void.TYPE, CodegenUtils.ci(InvocationSession.class) + CodegenUtils.ci(InvocationBuffer.class), parameterTypes));
    }

    private static final Function getFunction(long address2, Class returnType, Class[] paramTypes, boolean requiresErrno, CallingConvention convention) {
        Type[] nativeParamTypes = new Type[paramTypes.length];
        for (int i2 = 0; i2 < nativeParamTypes.length; ++i2) {
            nativeParamTypes[i2] = InvokerUtil.getNativeParameterType(paramTypes[i2]);
        }
        return new Function(address2, InvokerUtil.getNativeReturnType(returnType), nativeParamTypes, convention, requiresErrno);
    }

    private static boolean isSessionRequired(Class parameterType) {
        return StringBuilder.class.isAssignableFrom(parameterType) || StringBuffer.class.isAssignableFrom(parameterType) || ByReference.class.isAssignableFrom(parameterType) || parameterType.isArray() && Pointer.class.isAssignableFrom(parameterType.getComponentType()) || parameterType.isArray() && CharSequence.class.isAssignableFrom(parameterType.getComponentType());
    }

    private static boolean isSessionRequired(Class[] parameterTypes) {
        for (int i2 = 0; i2 < parameterTypes.length; ++i2) {
            if (!AsmLibraryLoader.isSessionRequired(parameterTypes[i2])) continue;
            return true;
        }
        return false;
    }

    static final boolean isFastNumericMethod(Class returnType, Class[] parameterTypes) {
        if (!FAST_NUMERIC_AVAILABLE || parameterTypes.length > 6) {
            return false;
        }
        if (!AsmLibraryLoader.isFastNumericResult(returnType)) {
            return false;
        }
        for (int i2 = 0; i2 < parameterTypes.length; ++i2) {
            if (AsmLibraryLoader.isFastNumericParam(parameterTypes[i2])) continue;
            return false;
        }
        return Platform.getPlatform().getCPU() == Platform.CPU.I386 || Platform.getPlatform().getCPU() == Platform.CPU.X86_64;
    }

    static final boolean isFastIntegerMethod(Class returnType, Class[] parameterTypes) {
        if (parameterTypes.length > 3) {
            return false;
        }
        if (!AsmLibraryLoader.isFastIntegerResult(returnType)) {
            return false;
        }
        for (int i2 = 0; i2 < parameterTypes.length; ++i2) {
            if (AsmLibraryLoader.isFastIntegerParam(parameterTypes[i2])) continue;
            return false;
        }
        return Platform.getPlatform().getCPU() == Platform.CPU.I386 || Platform.getPlatform().getCPU() == Platform.CPU.X86_64;
    }

    static final boolean isInt32(Class type2) {
        return Boolean.class.isAssignableFrom(type2) || Boolean.TYPE == type2 || Byte.class.isAssignableFrom(type2) || Byte.TYPE == type2 || Short.class.isAssignableFrom(type2) || Short.TYPE == type2 || Integer.class.isAssignableFrom(type2) || Integer.TYPE == type2;
    }

    static final boolean isInt32Result(Class type2) {
        return AsmLibraryLoader.isInt32(type2) || Void.class.isAssignableFrom(type2) || Void.TYPE == type2;
    }

    static final boolean isPointerResult(Class type2) {
        return Pointer.class.isAssignableFrom(type2) || Struct.class.isAssignableFrom(type2) || String.class.isAssignableFrom(type2);
    }

    static final boolean isPointerParam(Class type2) {
        return Pointer.class.isAssignableFrom(type2) || Struct.class.isAssignableFrom(type2);
    }

    private static final boolean isFastIntegerResult(Class type2) {
        if (AsmLibraryLoader.isInt32Result(type2)) {
            return true;
        }
        boolean isPointer = AsmLibraryLoader.isPointerResult(type2);
        if (isPointer && Platform.getPlatform().addressSize() == 32) {
            return true;
        }
        if (NativeLong.class.isAssignableFrom(type2) && Platform.getPlatform().longSize() == 32) {
            return true;
        }
        boolean isLong = Long.class == type2 || Long.TYPE == type2;
        return Platform.getPlatform().addressSize() == 64 && FAST_LONG_AVAILABLE && (isPointer || NativeLong.class.isAssignableFrom(type2) || isLong);
    }

    private static final boolean isFastIntegerParam(Class type2) {
        if (AsmLibraryLoader.isInt32(type2)) {
            return true;
        }
        boolean isPointer = AsmLibraryLoader.isPointerParam(type2);
        if (isPointer && Platform.getPlatform().addressSize() == 32) {
            return true;
        }
        if (NativeLong.class.isAssignableFrom(type2) && Platform.getPlatform().longSize() == 32) {
            return true;
        }
        boolean isLong = Long.class == type2 || Long.TYPE == type2;
        return Platform.getPlatform().addressSize() == 64 && FAST_LONG_AVAILABLE && (isPointer || NativeLong.class.isAssignableFrom(type2) || isLong);
    }

    static final boolean isFastNumericResult(Class type2) {
        return AsmLibraryLoader.isFastIntegerResult(type2) || Long.class.isAssignableFrom(type2) || Long.TYPE == type2 || NativeLong.class.isAssignableFrom(type2) || Pointer.class.isAssignableFrom(type2) || Struct.class.isAssignableFrom(type2) || String.class.isAssignableFrom(type2) || Float.TYPE == type2 || Float.class == type2 || Double.TYPE == type2 || Double.class == type2;
    }

    static final boolean isFastNumericParam(Class type2) {
        return AsmLibraryLoader.isFastIntegerParam(type2) || Long.class.isAssignableFrom(type2) || Long.TYPE == type2 || NativeLong.class.isAssignableFrom(type2) || Pointer.class.isAssignableFrom(type2) || Struct.class.isAssignableFrom(type2) || Float.TYPE == type2 || Float.class == type2 || Double.TYPE == type2 || Double.class == type2;
    }

    static final boolean isFastNumericAvailable() {
        try {
            Invoker.class.getDeclaredMethod("invokeNNNNNNrN", Function.class, Long.TYPE, Long.TYPE, Long.TYPE, Long.TYPE, Long.TYPE, Long.TYPE);
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    static final boolean isFastLongAvailable() {
        try {
            Invoker.class.getDeclaredMethod("invokeLLLLLLrL", Function.class, Long.TYPE, Long.TYPE, Long.TYPE, Long.TYPE, Long.TYPE, Long.TYPE);
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    private static final boolean requiresLong(Class type2) {
        return Long.class.isAssignableFrom(type2) || Long.TYPE == type2 || NativeLong.class.isAssignableFrom(type2) && Platform.getPlatform().longSize() == 64 || Pointer.class.isAssignableFrom(type2) && Platform.getPlatform().addressSize() == 64 || Struct.class.isAssignableFrom(type2) && Platform.getPlatform().addressSize() == 64 || String.class.isAssignableFrom(type2) && Platform.getPlatform().addressSize() == 64;
    }

    public static void main(String[] args2) {
        System.setProperty("jaffl.compile.dump", "true");
        System.out.println("cpu=" + (Object)((Object)Platform.getPlatform().getCPU()));
        HashMap options2 = new HashMap();
        TestLib lib = AsmLibraryLoader.getInstance().loadLibrary(new Library("test"), TestLib.class, options2);
        Integer result = lib.add_int32_t(1, 2);
        System.err.println("result=" + result);
        System.err.println("adding floats=" + lib.add_float(1.0f, 2.0f));
        System.err.println("adding doubles=" + lib.add_double(1.0, 2.0));
        MemoryIO p2 = MemoryIO.allocateDirect(1024);
        lib.ptr_ret_int8_t(p2, 0);
        lib.ptr_ret_int8_t(MemoryIO.allocate(1024), 0);
    }

    public static interface TestLib {
        public Integer add_int32_t(Integer var1, int var2);

        public Float add_float(float var1, float var2);

        public Double add_double(Double var1, double var2);

        public byte ptr_ret_int8_t(s8[] var1, int var2);

        public Byte ptr_ret_int8_t(Pointer var1, int var2);

        public byte ptr_ret_int8_t(s8 var1, int var2);

        public void not_found_function();

        public static final class s8
        extends Struct {
            public final Struct.Signed8 s8 = new Struct.Signed8(this);
        }
    }

    public static final class IntToLong
    implements FromNativeConverter,
    ToNativeConverter {
        public Object fromNative(Object nativeValue, FromNativeContext context) {
            return ((Number)nativeValue).longValue();
        }

        public Object toNative(Object value2, ToNativeContext context) {
            return ((Number)value2).intValue();
        }

        public Class nativeType() {
            return Integer.class;
        }
    }

    public static final class FromNativeProxy
    implements FromNativeConverter {
        private final FromNativeConverter converter;
        private final FromNativeContext ctx;

        public FromNativeProxy(FromNativeConverter converter, FromNativeContext ctx) {
            this.converter = converter;
            this.ctx = ctx;
        }

        public Object fromNative(Object value2, FromNativeContext unused2) {
            return this.converter.fromNative(value2, this.ctx);
        }

        public Class nativeType() {
            return this.converter.nativeType();
        }
    }

    public static final class ToNativeProxy
    implements ToNativeConverter {
        private final ToNativeConverter converter;
        private final ToNativeContext ctx;

        public ToNativeProxy(ToNativeConverter converter, ToNativeContext ctx) {
            this.converter = converter;
            this.ctx = ctx;
        }

        public Object toNative(Object value2, ToNativeContext unused2) {
            return this.converter.toNative(value2, this.ctx);
        }

        public Class nativeType() {
            return this.converter.nativeType();
        }
    }

    public static abstract class AbstractNativeInterface {
        public static final Invoker ffi = Invoker.getInstance();
        protected final Library library;

        public AbstractNativeInterface(Library library2) {
            this.library = library2;
        }

        protected static final HeapInvocationBuffer newInvocationBuffer(Function f) {
            return new HeapInvocationBuffer(f);
        }
    }

    private static final class SingletonHolder {
        static final LibraryLoader INSTANCE = new AsmLibraryLoader();

        private SingletonHolder() {
        }
    }
}

