/*
 * Decompiled with CFR 0.152.
 */
package sk.stuba.fiit.pogamut.iexplorer6;

import cz.cuni.amis.introspection.java.JProp;
import cz.cuni.amis.pogamut.base.agent.navigation.IPathExecutorState;
import cz.cuni.amis.pogamut.base.agent.navigation.IPathFuture;
import cz.cuni.amis.pogamut.base.agent.navigation.IPathPlanner;
import cz.cuni.amis.pogamut.base.agent.state.WaitForAgentStateChange;
import cz.cuni.amis.pogamut.base.agent.state.level2.IAgentStateStopped;
import cz.cuni.amis.pogamut.base.factory.IAgentFactory;
import cz.cuni.amis.pogamut.base.utils.Pogamut;
import cz.cuni.amis.pogamut.base.utils.math.DistanceUtils;
import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.ut2004.bot.IUT2004Bot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Initialize;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.BotKilled;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.ConfigChange;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.GameInfo;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.InitedMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPoint;
import cz.cuni.amis.pogamut.ut2004.factory.guice.remoteagent.UT2004BotFactory;
import cz.cuni.amis.pogamut.ut2004.factory.guice.remoteagent.UT2004BotModule;
import cz.cuni.amis.pogamut.ut2004.utils.UT2004BotRunner;
import cz.cuni.amis.utils.exception.PogamutException;
import cz.cuni.amis.utils.flag.Flag;
import cz.cuni.amis.utils.flag.FlagListener;
import edu.uci.ics.jung.graph.Graph;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;
import sk.stuba.fiit.pogamut.iexplorer6.BotStateEnum;
import sk.stuba.fiit.pogamut.jungigation.bot.AbstractBotWithJungigation;
import sk.stuba.fiit.pogamut.jungigation.objects.MyEdge;
import sk.stuba.fiit.pogamut.jungigation.objects.MyVertice;
import sk.stuba.fiit.pogamut.jungigation.objects.NavigationGraphProviderForMap;
import sk.stuba.fiit.pogamut.jungigation.pathPlanners.PathPlannerForDataAcquisition;
import sk.stuba.fiit.pogamut.jungigation.worldInfo.GameTime;

public class Iexplorer6
extends AbstractBotWithJungigation
implements FlagListener<IPathExecutorState> {
    private final Logger log = Logger.getLogger(Iexplorer6.class);
    @JProp
    public BotStateEnum state = BotStateEnum.RESPAWNED;
    public NavPoint lastNavPoint = null;
    @JProp
    private double lastCheckpointTime = -10.0;
    @JProp
    public double lastRespawnTime = -10.0;
    public static final double RESPAWNAFTERMINIMUMTIME = 10.0;
    private IPathPlanner<ILocated> pathPlanner;
    private int counterOfLogic = 0;
    private int someCounter = 50;
    private double lastLearningTimeSaved = Double.NaN;

    public void logic() throws PogamutException {
        try {
            if (this.state.equals((Object)BotStateEnum.DESTINATIONREACHED) || this.state.equals((Object)BotStateEnum.RESPAWNED)) {
                this.lastNavPoint = null;
                this.setLastCheckpointTime(GameTime.actualTime);
                this.planRandomTarget();
                this.state = BotStateEnum.RUNNINGTOSOMENAVPOINT;
            }
            if (++this.counterOfLogic % 40 == 0) {
                this.counterOfLogic = 0;
                ++this.someCounter;
                this.saveLearningTime();
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("Error in logic method! Error:" + ex.getMessage(), ex);
        }
    }

    private void saveLearningTime() {
        double actualTime = GameTime.actualTime;
        double diffTime = actualTime - this.lastLearningTimeSaved;
        if (!Double.isInfinite(diffTime) && !Double.isNaN(diffTime) && diffTime > 0.0 && diffTime < 40.0) {
            this.navigationGraph.addLearningTime(diffTime);
        } else {
            this.log.warn((Object)("Not adding learning time, because it is strange! It is " + diffTime));
        }
        this.lastLearningTimeSaved = actualTime;
    }

    public void botKilled(BotKilled event) {
        this.log.info((Object)"Bot killed. Changing state to RESPAWNED.");
        this.state = BotStateEnum.RESPAWNED;
        this.navigationGraph.increaseRespawnCount();
        this.saveLearningTime();
        try {
            NavigationGraphProviderForMap.getInstance().saveNavigationGraph(this.navigationGraph);
        }
        catch (IOException ex) {
            this.log.warn((Object)("Error while trying save graph uppon bot death! Error: " + ex.getMessage()), (Throwable)ex);
        }
    }

    public Initialize getInitializeCommand() {
        return new Initialize();
    }

    public void botInitialized(GameInfo info, ConfigChange config, InitedMessage init) {
        super.botInitialized(info, config, init);
        this.pathPlanner = new PathPlannerForDataAcquisition((Graph)this.navigationGraph, this.bot, this.navpoints);
        this.pathExecutor.getState().addListener((FlagListener)this);
    }

    private void planRandomTarget() {
        NavPoint target = this.goToRandomNavPoint();
        this.lastNavPoint = null;
        this.lastCheckpointTime = -10.0;
        this.state = BotStateEnum.RUNNINGTOSOMENAVPOINT;
    }

    protected NavPoint goToRandomNavPoint() {
        NavPoint navPoint = this.pickNewRandomNavTarget();
        final IPathFuture pathHandle = this.pathPlanner.computePath((Object)this.bot.getLocation(), (Object)navPoint);
        List path = pathHandle.get();
        this.log.info((Object)("Planned path is going to be set to: " + pathHandle.toString()));
        Thread vlakno = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Iexplorer6.this.pathExecutor.followPath(pathHandle);
                }
                catch (Exception ex) {
                    Iexplorer6.this.log.warn((Object)("Error while trying to execute path! Error:" + ex.getMessage() + ". Error stacktrace:" + ex.getStackTrace()));
                }
            }
        });
        vlakno.setDaemon(true);
        vlakno.setName("Path executor folow path thread");
        vlakno.start();
        return navPoint;
    }

    public static void main(String[] args) throws PogamutException {
        UT2004BotFactory factory = new UT2004BotFactory(new UT2004BotModule(Iexplorer6.class));
        UT2004BotRunner botRunner = new UT2004BotRunner((IAgentFactory)factory, "Iexplorer6", "localhost", 3000);
        IUT2004Bot agent = botRunner.startAgent();
        new WaitForAgentStateChange((Flag)agent.getState(), IAgentStateStopped.class).await();
        Pogamut.getPlatform().close();
    }

    public double getLastCheckpointTime() {
        return this.lastCheckpointTime;
    }

    public void setLastCheckpointTime(double time) {
        this.lastCheckpointTime = time;
    }

    public void flagChanged(IPathExecutorState event) {
        NavPoint nearestNavPoint = (NavPoint)DistanceUtils.getNearest((Collection)this.navpoints, (ILocated)this.bot.getLocation());
        switch (event.getState()) {
            case TARGET_REACHED: {
                this.log.info((Object)"Target reached, going to plan new random target.");
                this.state = BotStateEnum.DESTINATIONREACHED;
                break;
            }
            case STUCK: {
                this.log.info((Object)"Bot stucked, going to respawn if needed.");
                this.navigationGraph.increaseStucksCount();
                this.respawnIfNeeded();
                break;
            }
            case PATH_COMPUTATION_FAILED: {
                this.log.info((Object)"Path broken, going to respawn if needed.");
                this.respawnIfNeeded();
                break;
            }
            case SWITCHED_TO_ANOTHER_PATH_ELEMENT: {
                this.log.trace((Object)("PATH_ELEMENT_REACHED:" + nearestNavPoint.getId().getStringId()));
                if (this.lastNavPoint != null) {
                    MyVertice from = new MyVertice(this.lastNavPoint);
                    MyVertice to = new MyVertice(nearestNavPoint);
                    try {
                        MyEdge incidentEdge = (MyEdge)this.navigationGraph.findEdge((Object)from, (Object)to);
                        double travelTime = GameTime.actualTime - this.getLastCheckpointTime();
                        this.log.debug((Object)("Adding new travel time between vertices " + from + " and " + to + ". Time was " + travelTime + "."));
                        incidentEdge.addNewTravelTime(travelTime);
                    }
                    catch (Exception ex) {
                        this.log.warn((Object)"Edge not found!");
                    }
                }
                this.setLastCheckpointTime(GameTime.actualTime);
                this.lastNavPoint = nearestNavPoint;
                break;
            }
            default: {
                this.log.warn((Object)("Unexpected event! EventType=" + event));
            }
        }
    }

    private void respawnIfNeeded() {
        double actualTime = GameTime.actualTime;
        if (this.lastRespawnTime + 10.0 < actualTime && this.getLastCheckpointTime() < actualTime - 10.0) {
            if (this.lastNavPoint != null) {
                MyVertice from = new MyVertice(this.lastNavPoint);
                NavPoint pathExecutorNextTargerWas = (NavPoint)this.pathExecutor.getPath().get(this.pathExecutor.getPathElementIndex() + 1);
                MyVertice to = new MyVertice(pathExecutorNextTargerWas);
                try {
                    MyEdge incidentEdge = (MyEdge)this.navigationGraph.findEdge((Object)from, (Object)to);
                    double travelTime = 1000.0;
                    this.log.debug((Object)("Adding MAXIMUM time between vertices " + from + " and " + to + ". Bot stucked between vertices."));
                    incidentEdge.addNewTravelTime(travelTime);
                }
                catch (Exception ex) {
                    this.log.warn((Object)"Edge not found!");
                }
                this.log.info((Object)"respawning");
            } else {
                this.log.info((Object)"respawning (lastNavpoint == null)");
            }
            this.lastRespawnTime = GameTime.actualTime;
            this.log.info((Object)"Going to respawn.");
            this.pathExecutor.stop();
            this.bot.respawn();
        } else {
            this.log.trace((Object)("Not respawning. actualTime:" + GameTime.actualTime + ", lastRespawnTime:" + this.lastRespawnTime));
        }
    }
}

