/*
 * Decompiled with CFR 0.152.
 */
package EDU.oswego.cs.dl.util.concurrent;

import EDU.oswego.cs.dl.util.concurrent.Executor;
import EDU.oswego.cs.dl.util.concurrent.FJTask;
import EDU.oswego.cs.dl.util.concurrent.FJTaskRunner;
import EDU.oswego.cs.dl.util.concurrent.LinkedQueue;

public class FJTaskRunnerGroup
implements Executor {
    protected final FJTaskRunner[] threads;
    protected final LinkedQueue entryQueue = new LinkedQueue();
    protected int activeCount = 0;
    protected int nstarted = 0;
    static final boolean COLLECT_STATS = true;
    long initTime = 0L;
    int entries = 0;
    static final int DEFAULT_SCAN_PRIORITY = 2;
    static final long SCANS_PER_SLEEP = 15L;
    static final long MAX_SLEEP_TIME = 100L;

    public FJTaskRunnerGroup(int n) {
        this.threads = new FJTaskRunner[n];
        this.initializeThreads();
        this.initTime = System.currentTimeMillis();
    }

    public void execute(Runnable runnable) throws InterruptedException {
        if (runnable instanceof FJTask) {
            this.entryQueue.put((FJTask)runnable);
        } else {
            this.entryQueue.put(new FJTask.Wrap(runnable));
        }
        this.signalNewTask();
    }

    public void executeTask(FJTask fJTask) {
        try {
            this.entryQueue.put(fJTask);
            this.signalNewTask();
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
    }

    public void invoke(Runnable runnable) throws InterruptedException {
        InvokableFJTask invokableFJTask = new InvokableFJTask(runnable);
        this.entryQueue.put(invokableFJTask);
        this.signalNewTask();
        invokableFJTask.awaitTermination();
    }

    public void interruptAll() {
        Thread thread2 = Thread.currentThread();
        boolean bl = false;
        int n = 0;
        while (n < this.threads.length) {
            FJTaskRunner fJTaskRunner = this.threads[n];
            if (fJTaskRunner == thread2) {
                bl = true;
            } else {
                fJTaskRunner.interrupt();
            }
            ++n;
        }
        if (bl) {
            thread2.interrupt();
        }
    }

    public synchronized void setScanPriorities(int n) {
        int n2 = 0;
        while (n2 < this.threads.length) {
            FJTaskRunner fJTaskRunner = this.threads[n2];
            fJTaskRunner.setScanPriority(n);
            if (!fJTaskRunner.active) {
                fJTaskRunner.setPriority(n);
            }
            ++n2;
        }
    }

    public synchronized void setRunPriorities(int n) {
        int n2 = 0;
        while (n2 < this.threads.length) {
            FJTaskRunner fJTaskRunner = this.threads[n2];
            fJTaskRunner.setRunPriority(n);
            if (fJTaskRunner.active) {
                fJTaskRunner.setPriority(n);
            }
            ++n2;
        }
    }

    public int size() {
        return this.threads.length;
    }

    public synchronized int getActiveCount() {
        return this.activeCount;
    }

    public void stats() {
        long l = System.currentTimeMillis() - this.initTime;
        double d = (double)l / 1000.0;
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 0L;
        System.out.print("Thread\tQ Cap\tScans\tNew\tRuns\n");
        int n = 0;
        while (n < this.threads.length) {
            FJTaskRunner fJTaskRunner = this.threads[n];
            int n2 = fJTaskRunner.runs;
            l2 += (long)n2;
            int n3 = fJTaskRunner.scans;
            l3 += (long)n3;
            int n4 = fJTaskRunner.steals;
            l4 += (long)n4;
            String string = this.getActive(fJTaskRunner) ? "*" : " ";
            System.out.print("T" + n + string + "\t" + fJTaskRunner.deqSize() + "\t" + n3 + "\t" + n4 + "\t" + n2 + "\n");
            ++n;
        }
        System.out.print("Total\t    \t" + l3 + "\t" + l4 + "\t" + l2 + "\n");
        System.out.print("Execute: " + this.entries);
        System.out.print("\tTime: " + d);
        long l5 = 0L;
        if (d != 0.0) {
            l5 = Math.round((double)l2 / d);
        }
        System.out.println("\tRate: " + l5);
    }

    protected FJTaskRunner[] getArray() {
        return this.threads;
    }

    protected FJTask pollEntryQueue() {
        try {
            FJTask fJTask = (FJTask)this.entryQueue.poll(0L);
            return fJTask;
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            return null;
        }
    }

    protected synchronized boolean getActive(FJTaskRunner fJTaskRunner) {
        return fJTaskRunner.active;
    }

    protected synchronized void setActive(FJTaskRunner fJTaskRunner) {
        if (!fJTaskRunner.active) {
            fJTaskRunner.active = true;
            ++this.activeCount;
            if (this.nstarted < this.threads.length) {
                this.threads[this.nstarted++].start();
            } else {
                this.notifyAll();
            }
        }
    }

    protected synchronized void setInactive(FJTaskRunner fJTaskRunner) {
        if (fJTaskRunner.active) {
            fJTaskRunner.active = false;
            --this.activeCount;
        }
    }

    protected synchronized void checkActive(FJTaskRunner fJTaskRunner, long l) {
        this.setInactive(fJTaskRunner);
        try {
            if (this.activeCount == 0 && this.entryQueue.peek() == null) {
                this.wait();
            } else {
                long l2 = l / 15L;
                if (l2 > 100L) {
                    l2 = 100L;
                }
                int n = l2 == 0L ? 1 : 0;
                this.wait(l2, n);
            }
        }
        catch (InterruptedException interruptedException) {
            this.notify();
            Thread.currentThread().interrupt();
        }
    }

    protected synchronized void signalNewTask() {
        ++this.entries;
        if (this.nstarted < this.threads.length) {
            this.threads[this.nstarted++].start();
        } else {
            this.notify();
        }
    }

    protected void initializeThreads() {
        int n = 0;
        while (n < this.threads.length) {
            this.threads[n] = new FJTaskRunner(this);
            ++n;
        }
    }

    protected static final class InvokableFJTask
    extends FJTask {
        protected final Runnable wrapped;
        protected boolean terminated = false;

        protected InvokableFJTask(Runnable runnable) {
            this.wrapped = runnable;
        }

        public void run() {
            try {
                if (this.wrapped instanceof FJTask) {
                    FJTask.invoke((FJTask)this.wrapped);
                } else {
                    this.wrapped.run();
                }
                Object var2_1 = null;
                this.setTerminated();
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                this.setTerminated();
                throw throwable;
            }
        }

        protected synchronized void setTerminated() {
            this.terminated = true;
            this.notifyAll();
        }

        protected synchronized void awaitTermination() throws InterruptedException {
            while (!this.terminated) {
                this.wait();
            }
        }
    }
}

