/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base.agent.module;

import com.google.inject.Inject;
import cz.cuni.amis.pogamut.base.agent.IAgent;
import cz.cuni.amis.pogamut.base.agent.exceptions.AgentException;
import cz.cuni.amis.pogamut.base.agent.module.AgentModule;
import cz.cuni.amis.pogamut.base.agent.module.IAgentLogic;
import cz.cuni.amis.pogamut.base.agent.module.exception.LogicThreadAlteredException;
import cz.cuni.amis.pogamut.base.component.IComponent;
import cz.cuni.amis.pogamut.base.component.bus.event.EventFilter;
import cz.cuni.amis.pogamut.base.component.bus.event.IStartedEvent;
import cz.cuni.amis.pogamut.base.component.bus.event.WaitForEvent;
import cz.cuni.amis.pogamut.base.component.bus.exception.ComponentNotRunningException;
import cz.cuni.amis.pogamut.base.component.bus.exception.ComponentPausedException;
import cz.cuni.amis.pogamut.base.component.controller.ComponentDependencies;
import cz.cuni.amis.pogamut.base.component.controller.ComponentDependencyType;
import cz.cuni.amis.pogamut.base.component.controller.ComponentState;
import cz.cuni.amis.pogamut.base.component.exception.ComponentCantPauseException;
import cz.cuni.amis.pogamut.base.component.exception.ComponentCantResumeException;
import cz.cuni.amis.pogamut.base.component.exception.ComponentCantStartException;
import cz.cuni.amis.pogamut.base.component.exception.ComponentCantStopException;
import cz.cuni.amis.pogamut.base.utils.guice.AgentScoped;
import cz.cuni.amis.utils.Const;
import cz.cuni.amis.utils.ExceptionToString;
import cz.cuni.amis.utils.StopWatch;
import cz.cuni.amis.utils.exception.PogamutInterruptedException;
import cz.cuni.amis.utils.flag.Flag;
import java.util.logging.Level;
import java.util.logging.Logger;

@AgentScoped
public class LogicModule<AGENT extends IAgent>
extends AgentModule<AGENT> {
    private static long THREAD_COUNTER = 0L;
    private static final long LOGIC_WAIT_TIME_PLUS_MILLIS = 1000L;
    public static final long MIN_LOGIC_PERIOD_MILLIS = 1L;
    public static final double MAX_LOGIC_FREQUENCY = 1000.0;
    public static final long MAX_LOGIC_PERIOD_MILLIS = 100000000L;
    public static final double MIN_LOGIC_FREQUENCY = 0.0;
    protected Object mutex = new Object();
    protected IAgentLogic logic;
    protected Thread logicThread = null;
    protected boolean logicShouldRun = true;
    protected Flag<Boolean> logicRunning = new Flag<Boolean>(false);
    protected Flag<Boolean> logicShouldPause = new Flag<Boolean>(false);
    protected Flag<Boolean> logicPaused = new Flag<Boolean>(false);
    protected double logicFrequency = 10.0;
    protected double logicPeriod = 100.0;
    protected long lastLogicRun = 0L;
    protected Throwable logicException;

    @Inject
    public LogicModule(AGENT agent, IAgentLogic logic) {
        this(agent, logic, null, new ComponentDependencies(ComponentDependencyType.STARTS_WITH).add((IComponent)agent));
    }

    public LogicModule(AGENT agent, IAgentLogic logic, Logger log) {
        this(agent, logic, log, new ComponentDependencies(ComponentDependencyType.STARTS_WITH).add((IComponent)agent));
    }

    public LogicModule(AGENT agent, IAgentLogic logic, Logger log, ComponentDependencies dependencies) {
        super(agent, log, dependencies);
        this.logic = logic;
    }

    private void clearLogicRunningVars() {
        this.logicShouldPause.setFlag(false);
        this.logicPaused.setFlag(false);
        this.logicRunning.setFlag(false);
        this.logicShouldRun = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void start(boolean startPaused) throws AgentException {
        super.start(startPaused);
        Object object = this.mutex;
        synchronized (object) {
            if (this.logicThread != null) {
                if (this.log.isLoggable(Level.WARNING)) {
                    this.log.warning("Logic thread is not null! Sending interrupt and dropping the reference, possibly leaking resources.");
                }
                this.logicThread.interrupt();
                this.logicThread = null;
            }
            long counter = THREAD_COUNTER++;
            String name = this.agent.getName() + "'s logic (" + counter + ")";
            this.clearLogicRunningVars();
            this.logicThread = new Thread((Runnable)new LogicRunner("Thread " + counter), this.agent.getName() + " logic");
        }
        if (startPaused && this.log.isLoggable(Level.WARNING)) {
            this.log.fine("Starting logic thread in paused state (start paused requested).");
        }
        this.logicShouldPause.setFlag(startPaused);
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Starting logic thread.");
        }
        this.logicThread.start();
        long waitTime = this.logic.getLogicInitializeTime() + 1000L;
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("Waiting for the logic to initialize (" + waitTime + " ms).");
        }
        Boolean result = this.logicRunning.waitFor(waitTime, (T[])new Boolean[]{true});
        if (!this.controller.inState(ComponentState.STARTING)) {
            throw new ComponentCantStartException("Woke up, module state differs. It is not " + (Object)((Object)ComponentState.STARTING) + " but " + (Object)((Object)this.controller.getState().getFlag()) + ".", this.log, (IComponent)this);
        }
        if (result == null) {
            throw new ComponentCantStartException("Logic initialization is taking too long, did you correctly specified initialize time via getInitializeTime() method?", this.log, (IComponent)this);
        }
    }

    @Override
    public void stop() {
        super.stop();
        if (Thread.currentThread() == this.logicThread) {
            this.inThreadStopping();
        } else {
            Boolean result;
            this.logicShouldRun = false;
            this.logicShouldPause.setFlag(false);
            long waitTime = (long)this.logicPeriod + 1000L;
            if (this.log.isLoggable(Level.INFO)) {
                this.log.info("Waiting for the logic to stop (" + waitTime + " ms).");
            }
            if ((result = this.logicRunning.waitFor(waitTime, (T[])new Boolean[]{false})) == null) {
                throw new ComponentCantStopException("Logic thread is still running! Is your logic too cpu-demanding?", this.log, (Object)this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void kill() {
        super.kill();
        if (Thread.currentThread() == this.logicThread) {
            this.inThreadKilling();
        } else {
            this.logicShouldRun = false;
            this.logicShouldPause.setFlag(false);
            Object object = this.mutex;
            synchronized (object) {
                if (this.logicThread == null) {
                    return;
                }
            }
            long waitTime = (long)this.logicPeriod + 1000L;
            if (this.log.isLoggable(Level.INFO)) {
                this.log.info("Waiting for the logic to stop (" + waitTime + " ms).");
            }
            Boolean result = this.logicRunning.waitFor(waitTime, (T[])new Boolean[]{false});
            Object object2 = this.mutex;
            synchronized (object2) {
                if (this.logicThread == null) {
                    return;
                }
                if (result == null) {
                    if (this.log.isLoggable(Level.WARNING)) {
                        this.log.warning("Logic thread is still running, sending interrupt.");
                    } else {
                        return;
                    }
                }
                this.logicThread.interrupt();
            }
            if (this.log.isLoggable(Level.INFO)) {
                this.log.info("Waiting for the logic to stop (" + waitTime + " ms).");
            }
            result = this.logicRunning.waitFor(waitTime, (T[])new Boolean[]{false});
            object2 = this.mutex;
            synchronized (object2) {
                if (this.logicThread == null) {
                    return;
                }
                if (result == null && this.log.isLoggable(Level.WARNING)) {
                    this.log.warning("Logic thread is still running, is your logic too much cpu demanding?");
                }
            }
        }
    }

    @Override
    protected void pause() {
        super.pause();
        if (Thread.currentThread() == this.logicThread) {
            this.inThreadPausing();
        } else {
            Boolean result;
            this.logicShouldPause.setFlag(true);
            long waitTime = (long)this.logicPeriod + 1000L;
            if (this.log.isLoggable(Level.INFO)) {
                this.log.info("Waiting for the logic to pause (" + waitTime + " ms).");
            }
            if ((result = this.logicPaused.waitFor(waitTime, (T[])new Boolean[]{true})) == null) {
                throw new ComponentCantPauseException("Logic is still running, is your logic cpu demanding too much?", this.log, (Object)this);
            }
        }
    }

    @Override
    protected void resume() {
        super.resume();
        if (Thread.currentThread() == this.logicThread) {
            this.inThreadResuming();
        } else {
            Boolean result;
            this.logicShouldPause.setFlag(false);
            long waitTime = (long)this.logicPeriod + 1000L;
            if (this.log.isLoggable(Level.INFO)) {
                this.log.info("Waiting for the logic to resume (" + waitTime + " ms).");
            }
            if ((result = this.logicPaused.waitFor(waitTime, (T[])new Boolean[]{false})) == null) {
                throw new ComponentCantResumeException("Logic did not resumed.", this.log, (Object)this);
            }
        }
    }

    protected void inThreadStopping() {
        this.inThreadWarning("Stopping", "stopped", "stop");
        this.logicShouldRun = false;
        this.logicShouldPause.setFlag(false);
    }

    protected void inThreadKilling() {
        this.inThreadWarning("Killing", "killed", "kill");
        this.logicShouldRun = false;
        this.logicShouldPause.setFlag(false);
        this.logicThread.interrupt();
    }

    protected void inThreadPausing() {
        this.inThreadWarning("Pausing", "paused", "pause");
        this.logicShouldPause.setFlag(true);
    }

    protected void inThreadResuming() {
        this.inThreadWarning("Resuming", "resumed", "resume");
        this.logicShouldPause.setFlag(false);
    }

    private void inThreadWarning(String str1, String str2, String str3) {
        String warning = "In-Logic-Thread " + str1 + " happens. This occurs whenever the LogicModule is being " + str2 + " from within its own thread. While this may proceed as you have expected, it is unsupported operation with uncertain result." + Const.NEW_LINE + "It is adviced to perform the troubling operation in different thread, e.g.:" + Const.NEW_LINE + "    new Thread(new Runnable() {" + Const.NEW_LINE + "        @Override" + Const.NEW_LINE + "        public void run() {" + Const.NEW_LINE + "            // do something that happens to " + str3 + " the logic module //" + Const.NEW_LINE + "        }" + Const.NEW_LINE + "    }).start();";
        if (this.log.isLoggable(Level.WARNING)) {
            this.log.warning(warning);
        } else if (this.log.isLoggable(Level.SEVERE)) {
            this.log.severe(warning);
        }
    }

    protected void beforeLogic(String threadName) {
    }

    protected void afterLogic(String threadName) {
    }

    protected void afterLogicException(String threadName, Throwable e) {
        this.logicException = e;
    }

    protected boolean shouldExecuteLogic() {
        return true;
    }

    protected void logicLatch(String threadName) {
    }

    public double getLogicPeriod() {
        return this.logicPeriod;
    }

    public Throwable getLogicException() {
        return this.logicException;
    }

    public double getLogicFrequency() {
        return this.logicFrequency;
    }

    public void setMinLogicFrequency() {
        this.logicPeriod = 1.0E8;
        this.logicFrequency = 0.0;
    }

    public void setMaxLogicFrequency() {
        this.logicPeriod = 1.0;
        this.logicFrequency = 1000.0;
    }

    public void setLogicFrequency(double frequency) {
        this.logicFrequency = frequency;
        if (this.logicFrequency <= 0.0) {
            this.logicPeriod = 1.0E8;
            this.logicFrequency = 0.0;
        } else if (this.logicFrequency > 1000.0) {
            this.logicPeriod = 1.0;
            this.logicFrequency = 1000.0;
        } else {
            this.logicPeriod = 1000.0 / frequency;
            this.logicFrequency = frequency;
        }
    }

    static /* synthetic */ void access$000(LogicModule x0) {
        x0.clearLogicRunningVars();
    }

    private class LogicRunner
    implements Runnable {
        private String name;
        private WaitForEvent startedEvent;

        public LogicRunner(String name) {
            this.startedEvent = new WaitForEvent(LogicModule.this.eventBus, new EventFilter<IStartedEvent>(IStartedEvent.class, LogicModule.this.getComponentId()));
            if (name == null) {
                name = "unnamed";
            }
            this.name = name;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            if (LogicModule.this.log.isLoggable(Level.WARNING)) {
                LogicModule.this.log.warning(this.name + ": Thread started.");
            }
            if (LogicModule.this.log.isLoggable(Level.FINE)) {
                LogicModule.this.log.fine(this.name + ": Initializing logic.");
            }
            logicWatch = new StopWatch();
            LogicModule.this.logic.logicInitialize(LogicModule.this);
            if (LogicModule.this.log.isLoggable(Level.INFO)) {
                LogicModule.this.log.info(this.name + ": Logic initialized (" + logicWatch.stopStr() + ").");
            }
            var2_2 = LogicModule.this.mutex;
            synchronized (var2_2) {
                if (LogicModule.this.logicThread != Thread.currentThread()) {
                    if (LogicModule.this.log.isLoggable(Level.SEVERE) == false) return;
                    LogicModule.this.log.severe(this.name + ": Logic thread altered! Shutdown not called!");
                    return;
                }
                LogicModule.this.logicRunning.setFlag(true);
            }
            sleepTime = 0L;
            try {
                if (LogicModule.this.log.isLoggable(Level.FINER)) {
                    LogicModule.this.log.finer(this.name + ": waiting for the logic module started event.");
                }
                this.startedEvent.await();
                if (LogicModule.this.log.isLoggable(Level.FINER)) {
                    LogicModule.this.log.finer(this.name + ": logic module started event received.");
                }
                var4_4 = LogicModule.this.mutex;
                synchronized (var4_4) {
                    if (LogicModule.this.logicThread != Thread.currentThread()) {
                        throw new LogicThreadAlteredException(this.name, LogicModule.this.log, LogicModule.this);
                    }
                }
                LogicModule.this.logicLatch(this.name);
                var4_4 = LogicModule.this.mutex;
                synchronized (var4_4) {
                    if (LogicModule.this.logicThread != Thread.currentThread()) {
                        throw new LogicThreadAlteredException(this.name, LogicModule.this.log, LogicModule.this);
                    }
                }
                while (Thread.currentThread().isInterrupted() == false) {
                    if (LogicModule.this.logicShouldRun == false) return;
                    if (LogicModule.this.logicThread != Thread.currentThread()) {
                        throw new LogicThreadAlteredException(this.name, LogicModule.this.log, LogicModule.this);
                    }
                    if (LogicModule.this.logicShouldPause.getFlag().booleanValue()) {
                        var4_4 = LogicModule.this.mutex;
                        synchronized (var4_4) {
                            if (LogicModule.this.logicThread != Thread.currentThread()) {
                                throw new LogicThreadAlteredException(this.name, LogicModule.this.log, LogicModule.this);
                            }
                            LogicModule.this.logicPaused.setFlag(true);
                            ** if (!LogicModule.this.log.isLoggable((Level)Level.WARNING)) goto lbl45
                        }
lbl-1000:
                        // 1 sources

                        {
                            LogicModule.this.log.warning(this.name + ": Logic paused.");
                        }
lbl45:
                        // 2 sources

                        LogicModule.this.logicShouldPause.waitFor((Boolean[])new Boolean[]{false});
                        var4_4 = LogicModule.this.mutex;
                        synchronized (var4_4) {
                            if (LogicModule.this.logicThread != Thread.currentThread()) {
                                throw new LogicThreadAlteredException(this.name, LogicModule.this.log, LogicModule.this);
                            }
                            LogicModule.this.logicPaused.setFlag(false);
                            ** if (!LogicModule.this.log.isLoggable((Level)Level.WARNING)) goto lbl54
                        }
lbl-1000:
                        // 1 sources

                        {
                            LogicModule.this.log.warning(this.name + ": Logic resumed.");
                        }
                    }
lbl54:
                    // 4 sources

                    if ((sleepTime = (long)LogicModule.this.logicPeriod - (System.currentTimeMillis() - LogicModule.this.lastLogicRun)) > 0L) {
                        if (LogicModule.this.log.isLoggable(Level.FINER)) {
                            LogicModule.this.log.finer(this.name + ": Sleeping for " + sleepTime + " ms.");
                        }
                        Thread.sleep(sleepTime);
                    }
                    if (LogicModule.this.logicThread != Thread.currentThread()) {
                        throw new LogicThreadAlteredException(this.name, LogicModule.this.log, LogicModule.this);
                    }
                    try {
                        block99: {
                            if (LogicModule.this.log.isLoggable(Level.FINER)) {
                                LogicModule.this.log.finer(this.name + ": Logic iteration.");
                            }
                            logicWatch.start();
                            LogicModule.this.beforeLogic(this.name);
                            try {
                                LogicModule.this.lastLogicRun = System.currentTimeMillis();
                                if (LogicModule.this.shouldExecuteLogic()) {
                                    LogicModule.this.logic.logic();
                                    break block99;
                                }
                                if (LogicModule.this.log.isLoggable(Level.INFO)) {
                                    LogicModule.this.log.info(this.name + ": Logic should not run now...");
                                }
                            }
                            catch (Exception e1) {
                                try {
                                    LogicModule.this.afterLogicException(this.name, e1);
                                    throw e1;
                                }
                                catch (Exception e2) {
                                    if (LogicModule.this.log.isLoggable(Level.SEVERE) == false) throw e1;
                                    LogicModule.this.log.severe(ExceptionToString.process(this.name + ": afterLogicException() exception.", e2));
                                }
                                throw e1;
                            }
                        }
                        LogicModule.this.afterLogic(this.name);
                        if (!LogicModule.this.log.isLoggable(Level.FINE)) continue;
                        LogicModule.this.log.fine(this.name + ": Logic iteration finished (" + logicWatch.stopStr() + ").");
                    }
                    catch (ComponentPausedException e) {
                        if (LogicModule.this.log.isLoggable(Level.INFO)) {
                            LogicModule.this.log.info(this.name + ": pausing the thread, received ComponentPausedException from " + e.getOrigin() + ".");
                        }
                        LogicModule.this.logicShouldPause.setFlag(true);
                    }
                }
                return;
            }
            catch (LogicThreadAlteredException e1) {
                if (LogicModule.this.log.isLoggable(Level.WARNING) == false) return;
                LogicModule.this.log.warning(this.name + ": Logic thread has been altered, this one is not executed anymore.");
                return;
            }
            catch (InterruptedException e2) {
                if (LogicModule.this.log.isLoggable(Level.WARNING) == false) return;
                LogicModule.this.log.warning(this.name + ": Interrupted!");
                return;
            }
            catch (PogamutInterruptedException e3) {
                if (LogicModule.this.log.isLoggable(Level.WARNING) == false) return;
                LogicModule.this.log.warning(this.name + ": Interrupted!");
                return;
            }
            catch (ComponentNotRunningException e5) {
                LogicModule.this.log.log(LogicModule.this.log.getLevel(), this.name + ": stopping the thread, received ComponentNotRunningException from " + e5.getOrigin() + ".");
                return;
            }
            catch (Exception e4) {
                LogicModule.this.controller.fatalError(this.name + ": Logic iteration exception.", e4);
                return;
            }
            finally {
                e = LogicModule.this.mutex;
                synchronized (e) {
                    if (LogicModule.this.logicThread != Thread.currentThread()) {
                        return;
                    }
                    try {
                        if (LogicModule.this.log.isLoggable(Level.FINE)) {
                            LogicModule.this.log.fine(this.name + ": Shutting down the logic.");
                        }
                        logicWatch.start();
                        LogicModule.this.logic.logicShutdown();
                        if (LogicModule.this.log.isLoggable(Level.INFO)) {
                            LogicModule.this.log.info(this.name + ": Logic shutdown (" + logicWatch.stopStr() + ").");
                        }
                    }
                    catch (Exception e) {
                        LogicModule.this.controller.fatalError(this.name + ": Logic shutdown exception.", e);
                    }
                    finally {
                        if (LogicModule.this.logicThread == Thread.currentThread()) {
                            LogicModule.access$000(LogicModule.this);
                            LogicModule.this.logicThread = null;
                        }
                        if (LogicModule.this.log.isLoggable(Level.WARNING)) {
                            LogicModule.this.log.warning(this.name + ": Logic thread stopped.");
                        }
                    }
                }
            }
        }
    }
}

