/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.multi.communication.worldview.impl;

import cz.cuni.amis.pogamut.base.agent.IAgentId;
import cz.cuni.amis.pogamut.base.communication.translator.event.IWorldChangeEvent;
import cz.cuni.amis.pogamut.multi.communication.messages.SharedBatchBeginEvent;
import cz.cuni.amis.pogamut.multi.communication.messages.SharedBatchFinishedEvent;
import cz.cuni.amis.pogamut.multi.communication.worldview.ILocalWorldView;
import cz.cuni.amis.pogamut.multi.communication.worldview.impl.EventDrivenSharedWorldView;
import cz.cuni.amis.utils.exception.PogamutException;
import cz.cuni.amis.utils.maps.HashMapSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public abstract class BatchAwareSharedWorldView
extends EventDrivenSharedWorldView {
    private Map<Long, Integer> timeLocks = Collections.synchronizedMap(new HashMap());
    private HashMapSet<Long, IAgentId> waitingLocalWorldViews = new HashMapSet();
    private Object objectMutex = new Object();

    public BatchAwareSharedWorldView(Logger logger) {
        super(logger);
    }

    protected abstract boolean isBatchEndEvent(IWorldChangeEvent var1);

    protected void notifyLocalWorldViews(Set<IAgentId> waiting, long time2) {
        if (waiting != null) {
            for (IAgentId id : waiting) {
                ((ILocalWorldView)this.localWorldViews.get(id)).notify(new SharedBatchFinishedEvent(time2));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processBeginEvent(SharedBatchBeginEvent event) {
        this.log.fine("Processing: " + event);
        Map<Long, Integer> map = this.timeLocks;
        synchronized (map) {
            Integer n = this.timeLocks.get(event.getSimTime());
            if (n == null) {
                this.timeLocks.put(event.getSimTime(), 1);
            } else {
                n = n + 1;
                this.timeLocks.put(event.getSimTime(), n);
            }
            this.waitingLocalWorldViews.add(event.getSimTime(), event.getAgentId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processEndEvent(IWorldChangeEvent event) {
        this.log.fine("Processing:" + event);
        Object waiting = null;
        Map<Long, Integer> map = this.timeLocks;
        synchronized (map) {
            Integer locks = this.timeLocks.remove(event.getSimTime());
            if (locks == null) {
                throw new PogamutException("BatchEndEvent came for time that has no locks == no previous BatchBeginEvent came!", (Object)this);
            }
            if (locks <= 0) {
                throw new PogamutException("BatchEndEvent came for time that " + locks + " <= 0 locks! INVALID STATE!", (Object)this);
            }
            if ((locks = Integer.valueOf(locks - 1)) == 0) {
                waiting = this.waitingLocalWorldViews.remove(event.getSimTime());
            } else {
                this.timeLocks.put(event.getSimTime(), locks);
            }
        }
        this.notifyLocalWorldViews((Set<IAgentId>)waiting, event.getSimTime());
    }

    @Override
    public void notify(IWorldChangeEvent event) {
        this.log.finest("BatchAwareSharedWorldView notify : " + event);
        if (event instanceof SharedBatchBeginEvent) {
            this.log.fine("SharedWorldView : SharedBatchBeginEvent for time : " + event.getSimTime());
            this.processBeginEvent((SharedBatchBeginEvent)event);
        } else if (this.isBatchEndEvent(event)) {
            this.log.fine("SharedWorldView : SharedBatchEndEvent for time : " + event.getSimTime());
            this.processEndEvent(event);
        } else {
            super.notify(event);
        }
    }
}

