/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.multi.communication.worldview.impl;

import cz.cuni.amis.pogamut.base.communication.translator.event.IWorldChangeEvent;
import cz.cuni.amis.pogamut.base.communication.translator.event.IWorldObjectUpdateResult;
import cz.cuni.amis.pogamut.base.communication.worldview.object.WorldObjectId;
import cz.cuni.amis.pogamut.base.component.controller.ComponentDependencies;
import cz.cuni.amis.pogamut.base.component.lifecyclebus.ILifecycleBus;
import cz.cuni.amis.pogamut.base.utils.guice.AgentScoped;
import cz.cuni.amis.pogamut.base.utils.logging.IAgentLogger;
import cz.cuni.amis.pogamut.base3d.worldview.object.IViewable;
import cz.cuni.amis.pogamut.multi.agent.ITeamedAgentId;
import cz.cuni.amis.pogamut.multi.communication.translator.event.ICompositeWorldObjectUpdatedEvent;
import cz.cuni.amis.pogamut.multi.communication.translator.event.ILocalWorldObjectUpdatedEvent;
import cz.cuni.amis.pogamut.multi.communication.worldview.ISharedWorldView;
import cz.cuni.amis.pogamut.multi.communication.worldview.IVisionLocalWorldView;
import cz.cuni.amis.pogamut.multi.communication.worldview.impl.AbstractLocalWorldView;
import cz.cuni.amis.pogamut.multi.communication.worldview.impl.EventDrivenLocalWorldView;
import cz.cuni.amis.pogamut.multi.communication.worldview.object.ILocalViewable;
import cz.cuni.amis.pogamut.multi.communication.worldview.object.ILocalWorldObject;
import cz.cuni.amis.pogamut.multi.utils.timekey.TimeKey;
import cz.cuni.amis.utils.ClassUtils;
import cz.cuni.amis.utils.exception.PogamutException;
import cz.cuni.amis.utils.maps.WeakHashMapMap;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;

@AgentScoped
public abstract class VisionLocalWorldView
extends EventDrivenLocalWorldView
implements IVisionLocalWorldView {
    protected Map<TimeKey, Map<WorldObjectId, IViewable>> visibleMap = new WeakHashMap<TimeKey, Map<WorldObjectId, IViewable>>();
    protected Map<TimeKey, Map<WorldObjectId, IViewable>> syncVisibleMap = Collections.synchronizedMap(this.visibleMap);
    protected Map<TimeKey, Map<Class, Map<WorldObjectId, IViewable>>> visibleClassMap = new WeakHashMapMap<TimeKey, Class, Map<WorldObjectId, IViewable>>();
    protected Map<TimeKey, Map<Class, Map<WorldObjectId, IViewable>>> syncVisibleClassMap = Collections.synchronizedMap(this.visibleClassMap);

    public VisionLocalWorldView(ComponentDependencies dependencies, ILifecycleBus bus, IAgentLogger logger, ISharedWorldView parentWorldView, ITeamedAgentId agentId) {
        super(dependencies, bus, logger, parentWorldView, agentId);
    }

    @Override
    public void notify(IWorldChangeEvent event) {
        if (event instanceof ILocalWorldObjectUpdatedEvent) {
            this.objectUpdatedEvent((ILocalWorldObjectUpdatedEvent)event);
        } else if (event instanceof ICompositeWorldObjectUpdatedEvent) {
            this.objectUpdatedEvent(((ICompositeWorldObjectUpdatedEvent)event).getLocalEvent());
        } else {
            super.notify(event);
        }
    }

    @Override
    protected void objectUpdatedEvent(ILocalWorldObjectUpdatedEvent updateEvent) {
        ILocalWorldObject obj = this.getMostRecentLocalWorldObject(updateEvent.getId());
        boolean oldVisible = false;
        boolean isViewable = false;
        ILocalWorldObject copy = null;
        if (obj != null) {
            if (obj instanceof ILocalViewable) {
                oldVisible = ((ILocalViewable)obj).isVisible();
                isViewable = true;
            }
            copy = obj.clone();
        } else {
            copy = null;
        }
        IWorldObjectUpdateResult<ILocalWorldObject> updateResult = updateEvent.update(copy);
        switch (updateResult.getResult()) {
            case CREATED: {
                this.objectCreated(updateResult.getObject(), updateEvent.getSimTime());
                return;
            }
            case UPDATED: {
                if (updateResult.getObject() != copy) {
                    throw new PogamutException("Update event " + updateEvent + " does not returned the same instance of the object (result UPDATED).", (Object)this);
                }
                super.addOldLocalWorldObject(obj, updateEvent.getSimTime());
                if (isViewable) {
                    boolean visible = ((ILocalViewable)copy).isVisible();
                    if (visible != oldVisible) {
                        if (visible) {
                            this.objectAppeared((ILocalViewable)copy, updateEvent.getSimTime());
                        } else {
                            this.objectDisappeared((ILocalViewable)copy, updateEvent.getSimTime());
                        }
                    } else if (visible) {
                        this.addVisible((ILocalViewable)obj, updateEvent.getSimTime());
                    }
                }
                this.actLocalWorldObjects.put(copy.getId(), copy);
                this.objectUpdated(copy, updateEvent.getSimTime());
                return;
            }
            case SAME: {
                return;
            }
            case DESTROYED: {
                super.addOldLocalWorldObject(obj, updateEvent.getSimTime());
                this.objectDestroyed(copy, updateEvent.getSimTime());
                return;
            }
        }
        throw new PogamutException("Unhandled object update result " + (Object)((Object)updateResult.getResult()) + " for the object " + obj + ".", (Object)this);
    }

    @Override
    protected void objectCreated(ILocalWorldObject obj, long time2) {
        if (obj instanceof ILocalViewable && ((ILocalViewable)obj).isVisible()) {
            this.objectAppeared((ILocalViewable)obj, time2);
        }
        super.objectCreated(obj, time2);
    }

    @Override
    protected void objectDestroyed(ILocalWorldObject obj, long time2) {
        super.objectDestroyed(obj, time2);
    }

    protected void objectAppeared(ILocalViewable obj, long time2) {
        this.addVisible(obj, time2);
    }

    protected void objectDisappeared(ILocalViewable obj, long time2) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void addVisible(ILocalViewable obj, long time2) {
        Map<TimeKey, Map<Serializable, Object>> map = this.visibleMap;
        synchronized (map) {
            Map<WorldObjectId, IViewable> map2 = this.visibleMap.get(TimeKey.get(time2));
            if (map2 == null) {
                map2 = new AbstractLocalWorldView.LazyCompositeObjectMap<IViewable>(this, time2);
                this.visibleMap.put(TimeKey.get(time2), map2);
            }
            ((AbstractLocalWorldView.LazyCompositeObjectMap)this.visibleMap.get(TimeKey.get(time2))).addKey(obj.getId());
        }
        map = this.visibleClassMap;
        synchronized (map) {
            Map<Class, Map<WorldObjectId, IViewable>> clsMap = this.visibleClassMap.get(time2);
            if (clsMap == null) {
                clsMap = new HashMap<Class, Map<WorldObjectId, IViewable>>();
                this.visibleClassMap.put(TimeKey.get(time2), clsMap);
            }
            for (Class cls : ClassUtils.getSubclasses(obj.getCompositeClass())) {
                AbstractLocalWorldView.LazyCompositeObjectMap map3 = (AbstractLocalWorldView.LazyCompositeObjectMap)this.visibleClassMap.get(TimeKey.get(time2)).get(cls);
                if (map3 == null) {
                    map3 = new AbstractLocalWorldView.LazyCompositeObjectMap(this, this.getCurrentTimeKey().getTime());
                    this.visibleClassMap.get(TimeKey.get(time2)).put(cls, map3);
                }
                map3.addKey(obj.getId());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void removeVisible(ILocalViewable obj, long time2) {
        Map<TimeKey, Map<Serializable, Object>> map = this.visibleMap;
        synchronized (map) {
            ((AbstractLocalWorldView.LazyCompositeObjectMap)this.visibleMap.get(TimeKey.get(time2))).remove(obj.getId());
        }
        map = this.visibleClassMap;
        synchronized (map) {
            for (Class cls : ClassUtils.getSubclasses(obj.getCompositeClass())) {
                AbstractLocalWorldView.LazyCompositeObjectMap map2 = (AbstractLocalWorldView.LazyCompositeObjectMap)this.visibleClassMap.get(TimeKey.get(time2)).get(cls);
                if (map2 == null) {
                    map2 = new AbstractLocalWorldView.LazyCompositeObjectMap(this, this.getCurrentTimeKey().getTime());
                    this.visibleClassMap.get(TimeKey.get(time2)).put(cls, map2);
                }
                map2.remove(obj.getId());
            }
        }
    }

    @Override
    public Map<Class, Map<WorldObjectId, IViewable>> getAllVisible() {
        return this.syncVisibleClassMap.get(this.currentTimeKey);
    }

    @Override
    public <T extends IViewable> Map<WorldObjectId, T> getAllVisible(Class<T> type) {
        Map<WorldObjectId, IViewable> map = this.syncVisibleClassMap.get(this.currentTimeKey).get(type);
        if (map == null) {
            map = new AbstractLocalWorldView.LazyCompositeObjectMap<IViewable>(this, this.currentTimeKey.getTime());
        }
        return map;
    }

    @Override
    public Map<WorldObjectId, IViewable> getVisible() {
        return this.syncVisibleMap.get(this.currentTimeKey);
    }

    @Override
    public IViewable getVisible(WorldObjectId id) {
        return this.syncVisibleMap.get(this.currentTimeKey).get(id);
    }
}

