/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.agent.module.logic;

import com.google.inject.Inject;
import cz.cuni.amis.pogamut.base.agent.exceptions.AgentException;
import cz.cuni.amis.pogamut.base.agent.module.IAgentLogic;
import cz.cuni.amis.pogamut.base.agent.module.LogicModule;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.react.EventReact;
import cz.cuni.amis.pogamut.base.communication.worldview.react.EventReactOnce;
import cz.cuni.amis.pogamut.base.communication.worldview.react.ObjectEventReactOnce;
import cz.cuni.amis.pogamut.base.component.bus.event.BusAwareCountDownLatch;
import cz.cuni.amis.pogamut.base.component.controller.ComponentDependencies;
import cz.cuni.amis.pogamut.base.component.controller.ComponentDependencyType;
import cz.cuni.amis.pogamut.base.component.exception.ComponentCantStartException;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.EndMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.GameInfo;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.GamePaused;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.GameResumed;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Self;
import cz.cuni.amis.utils.flag.Flag;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class UT2004BotLogic<BOT extends UT2004Bot>
extends LogicModule<BOT> {
    private EventReact<GamePaused> pauseReaction;
    private EventReact<GameResumed> resumeReaction;
    private ObjectEventReactOnce<Self, ?> selfReaction;
    private ObjectEventReactOnce<GameInfo, ?> gameInfoReaction;
    private EventReact<EndMessage> endReaction;
    private BusAwareCountDownLatch latch;
    private Flag<Boolean> gameInfoCame = new Flag<Boolean>(false);
    private Flag<Boolean> selfCame = new Flag<Boolean>(false);
    private Flag<Boolean> endCame = new Flag<Boolean>(false);

    @Inject
    public UT2004BotLogic(BOT agent, IAgentLogic logic) {
        this(agent, logic, (Logger)null, new ComponentDependencies(ComponentDependencyType.STARTS_WITH).add(((UT2004Bot)agent).getWorldView()));
    }

    public UT2004BotLogic(BOT agent, IAgentLogic logic, Logger log) {
        this(agent, logic, log, new ComponentDependencies(ComponentDependencyType.STARTS_WITH).add(((UT2004Bot)agent).getWorldView()));
    }

    public UT2004BotLogic(BOT agent, IAgentLogic logic, Logger log, ComponentDependencies dependencies) {
        super(agent, logic, log, dependencies);
        this.pauseReaction = new EventReact<GamePaused>(GamePaused.class, ((UT2004Bot)agent).getWorldView()){

            @Override
            protected void react(GamePaused event) {
                UT2004BotLogic.this.controller.manualPause("Game paused.");
            }
        };
        this.resumeReaction = new EventReact<GameResumed>(GameResumed.class, ((UT2004Bot)agent).getWorldView()){

            @Override
            protected void react(GameResumed event) {
                UT2004BotLogic.this.controller.manualResume("Game resumed.");
            }
        };
        this.gameInfoReaction = new ObjectEventReactOnce<GameInfo, IWorldObjectEvent<GameInfo>>(GameInfo.class, ((UT2004Bot)agent).getWorldView()){

            @Override
            protected void react(IWorldObjectEvent<GameInfo> event) {
                if (event.getObject().isBotsPaused() || event.getObject().isGamePaused()) {
                    UT2004BotLogic.this.controller.manualPause("Bot launched into paused game.");
                }
                UT2004BotLogic.this.gameInfoCame.setFlag(true);
            }
        };
        this.selfReaction = new ObjectEventReactOnce<Self, IWorldObjectEvent<Self>>(Self.class, ((UT2004Bot)agent).getWorldView()){

            @Override
            protected void react(IWorldObjectEvent<Self> event) {
                UT2004BotLogic.this.selfCame.setFlag(true);
            }
        };
        this.endReaction = new EventReactOnce<EndMessage>(EndMessage.class, ((UT2004Bot)agent).getWorldView()){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void react(EndMessage event) {
                Flag flag = UT2004BotLogic.this.endCame;
                synchronized (flag) {
                    UT2004BotLogic.this.endCame.setFlag(true);
                    UT2004BotLogic.this.latch.countDown();
                }
            }
        };
        this.cleanUp();
    }

    @Override
    protected void logicLatch(String threadName) {
        boolean came;
        super.logicLatch(threadName);
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine(threadName + ": Waiting for the first End message.");
        }
        if (!this.latch.await(60L, TimeUnit.SECONDS)) {
            throw new ComponentCantStartException("End message was not received in 60secs.", this);
        }
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(threadName + ": First END message received, starting logic cycles.");
        }
        if (!(came = this.selfCame.waitFor(60000L, (T[])new Boolean[]{true}).booleanValue())) {
            throw new ComponentCantStartException(threadName + ": SELF message DID NOT COME in 60secs! Even though End message has been received.", this);
        }
        if (!this.gameInfoCame.getFlag().booleanValue() && this.log.isLoggable(Level.WARNING)) {
            this.log.warning(threadName + ": GAMEINFO message DID NOT COME! Even though End message has been received. Was it disabled in GameBot2004.ini? Or is it a bug... ?");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void start(boolean startPaused) throws AgentException {
        super.start(startPaused);
        Flag<Boolean> flag = this.endCame;
        synchronized (flag) {
            this.latch = new BusAwareCountDownLatch(1, ((UT2004Bot)this.agent).getEventBus(), ((UT2004Bot)this.agent).getWorldView().getComponentId());
            if (this.endCame.getFlag().booleanValue()) {
                this.latch.countDown();
            }
        }
    }

    @Override
    protected void cleanUp() throws AgentException {
        super.cleanUp();
        this.gameInfoCame.setFlag(false);
        this.selfCame.setFlag(false);
        this.gameInfoReaction.enable();
        this.selfReaction.enable();
        this.endReaction.enable();
        this.endCame.setFlag(false);
    }
}

