/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.agent.navigation;

import cz.cuni.amis.pogamut.base.agent.navigation.impl.PathFuture;
import cz.cuni.amis.pogamut.base.communication.worldview.react.EventReact;
import cz.cuni.amis.pogamut.base.communication.worldview.react.EventReactOnce;
import cz.cuni.amis.pogamut.base3d.worldview.IVisionWorldView;
import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.unreal.communication.messages.UnrealId;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.UT2004AStarPathTimeoutException;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.GetPath;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.EndMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPoint;
import cz.cuni.amis.pogamut.ut2004.communication.translator.shared.events.Path;
import cz.cuni.amis.utils.future.FutureStatus;
import java.util.ArrayList;
import java.util.logging.Logger;

public class UT2004AStarPathFuture
extends PathFuture<ILocated> {
    private static final int PATH_TIMEOUT = 10;
    private static Object idMutex = new Object();
    private static long lastId = 0L;
    private String pathId;
    private EventReactOnce<Path> pathReaction;
    private EventReact<EndMessage> endReaction;
    private IVisionWorldView worldView;
    private Logger log;
    private Double startTime;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UT2004AStarPathFuture(UT2004Bot bot, ILocated pathFrom, ILocated pathTo) {
        super(pathFrom, pathTo, bot.getEventBus(), bot.getWorldView());
        this.log = bot.getLogger().getCategory(this.getClass().getSimpleName());
        Object object = idMutex;
        synchronized (object) {
            this.pathId = "UT2004AStarPathFuture_" + ++lastId;
        }
        this.pathReaction = new EventReactOnce<Path>(Path.class, bot.getWorldView()){

            @Override
            protected void react(Path event) {
                if (UT2004AStarPathFuture.this.pathId.equals(event.getPathId())) {
                    UT2004AStarPathFuture.this.eventPath(event);
                }
            }
        };
        this.endReaction = new EventReact<EndMessage>(EndMessage.class, bot.getWorldView()){

            @Override
            protected void react(EndMessage event) {
                UT2004AStarPathFuture.this.eventEndMessage(event);
            }
        };
        this.log.finer("Requesting path from '" + pathFrom + "' to '" + pathTo + "' under id '" + this.pathId + "'.");
        bot.getAct().act(new GetPath().setLocation(pathTo.getLocation()).setId(this.pathId));
        this.log.fine("Path requested, listening for the result (timeout 10s)");
        this.worldView = bot.getWorldView();
    }

    @Override
    protected boolean cancelComputation(boolean mayInterruptIfRunning) {
        this.pathReaction.disable();
        this.endReaction.disable();
        return this.getStatus() == FutureStatus.FUTURE_IS_BEING_COMPUTED;
    }

    protected void eventEndMessage(EndMessage event) {
        if (this.startTime == null) {
            this.startTime = event.getTime();
        }
        if (event.getTime() - this.startTime > 10.0) {
            this.pathReaction.disable();
            this.endReaction.disable();
            if (this.getStatus() == FutureStatus.FUTURE_IS_BEING_COMPUTED) {
                this.computationException(new UT2004AStarPathTimeoutException("Path did not came from GB2004 in 10s.", this.log, (Object)this));
            }
        }
    }

    protected void eventPath(Path event) {
        this.endReaction.disable();
        ArrayList<ILocated> result = new ArrayList<ILocated>(event.getPath().size());
        for (int i = 0; i < event.getPath().size(); ++i) {
            UnrealId routeId = event.getPath().get(i).getRouteId();
            NavPoint nav = (NavPoint)this.worldView.get(routeId);
            if (nav == null) {
                result.add(event.getPath().get(i).getLocation());
                continue;
            }
            result.add(nav);
        }
        this.setResult(result);
    }
}

