/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.agent.navigation.loquenavigator;

import cz.cuni.amis.pogamut.base.utils.math.DistanceUtils;
import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.AgentInfo;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.AbstractUT2004PathNavigator;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.IUT2004PathRunner;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.loquenavigator.LoqueRunner;
import cz.cuni.amis.pogamut.ut2004.bot.command.AdvancedLocomotion;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPoint;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPointNeighbourLink;
import cz.cuni.amis.pogamut.ut2004.utils.LinkFlag;
import cz.cuni.amis.utils.NullCheck;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LoqueNavigator<PATH_ELEMENT extends ILocated>
extends AbstractUT2004PathNavigator<PATH_ELEMENT> {
    private Location navigDestination = null;
    private Stage navigStage = Stage.COMPLETED;
    private ILocated focus = null;
    public static final int CLOSE_ENOUGH = 60;
    private Iterator<PATH_ELEMENT> navigIterator = null;
    private int navigNextLocationOffset = 0;
    private Location navigLastLocation = null;
    private NavPoint navigLastNode = null;
    private Location navigCurrentLocation = null;
    private NavPoint navigCurrentNode = null;
    private NavPointNeighbourLink navigCurrentLink = null;
    private Location navigNextLocation = null;
    private NavPoint navigNextNode = null;
    private IUT2004PathRunner runner;
    protected UT2004Bot main;
    protected AgentInfo memory;
    protected AdvancedLocomotion body;
    protected Logger log;

    @Override
    protected void navigate(ILocated focus, int pathElementIndex) {
        this.focus = focus;
        this.navigStage = this.keepNavigating();
        switch (this.navigStage) {
            case AWAITING_MOVER: 
            case RIDING_MOVER: {
                this.setBotWaiting(true);
                return;
            }
            case TELEPORT: 
            case NAVIGATING: 
            case REACHING: {
                this.setBotWaiting(false);
                return;
            }
            case TIMEOUT: 
            case CRASHED: 
            case CANCELED: {
                this.executor.stuck();
                return;
            }
            case COMPLETED: {
                this.executor.targetReached();
                return;
            }
        }
    }

    @Override
    public void reset() {
        this.navigCurrentLocation = null;
        this.navigCurrentNode = null;
        this.navigCurrentLink = null;
        this.navigDestination = null;
        this.navigIterator = null;
        this.navigLastLocation = null;
        this.navigLastNode = null;
        this.navigNextLocation = null;
        this.navigNextNode = null;
        this.navigNextLocationOffset = 0;
        this.navigStage = Stage.COMPLETED;
        this.setBotWaiting(false);
    }

    @Override
    public void newPath(List<PATH_ELEMENT> path) {
        Location dest = ((ILocated)path.get(path.size() - 1)).getLocation();
        this.initPathNavigation(dest, path);
    }

    protected void initDirectNavigation(Location dest) {
        int distance = (int)this.memory.getLocation().getDistance(dest);
        if (this.log != null && this.log.isLoggable(Level.FINE)) {
            this.log.fine("LoqueNavigator.initDirectNavigation(): initializing direct navigation, distance " + distance);
        }
        this.initDirectly(dest);
    }

    protected void initPathNavigation(Location dest, List<PATH_ELEMENT> path) {
        if (this.log != null && this.log.isLoggable(Level.FINE)) {
            this.log.fine("LoqueNavigator.initPathNavigation(): initializing path navigation, nodes " + path.size());
        }
        if (!this.initAlongPath(dest, path)) {
            this.initDirectNavigation(dest);
        }
    }

    protected Stage keepNavigating() {
        if (this.navigStage.terminated) {
            return this.navigStage;
        }
        if (this.log != null && this.log.isLoggable(Level.FINE)) {
            if (this.navigLastNode != null) {
                this.log.fine("LoqueNavigator.keepNavigating(): navigating from " + this.navigLastNode.getId().getStringId() + this.navigLastNode.getLocation());
            } else if (this.navigLastLocation != null) {
                this.log.fine("LoqueNavigator.keepNavigating(): navigating from " + this.navigLastLocation + " (navpoint is unknown)");
            }
            if (this.navigCurrentNode != null) {
                this.log.fine("LoqueNavigator.keepNavigating(): navigating to   " + this.navigCurrentNode.getId().getStringId() + this.navigCurrentNode.getLocation());
            } else if (this.navigCurrentLocation != null) {
                this.log.fine("LoqueNavigator.keepNavigating(): navigating to   " + this.navigCurrentLocation + " (navpoint is unknown)");
            }
        }
        switch (this.navigStage) {
            case REACHING: {
                this.navigStage = this.navigDirectly();
                break;
            }
            default: {
                this.navigStage = this.navigAlongPath();
            }
        }
        if (this.log != null && this.log.isLoggable(Level.FINEST)) {
            this.log.finest("Navigator.keepNavigating(): navigation stage " + (Object)((Object)this.navigStage));
        }
        return this.navigStage;
    }

    private Stage initDirectly(Location dest) {
        this.navigDestination = dest;
        this.runner.reset();
        this.navigStage = Stage.REACHING;
        return this.navigStage;
    }

    private Stage navigDirectly() {
        int distance = (int)this.memory.getLocation().getDistance(this.navigDestination);
        if (distance <= 60) {
            if (this.log != null && this.log.isLoggable(Level.FINE)) {
                this.log.fine("LoqueNavigator.navigDirectly(): destination close enough: " + distance);
            }
            return Stage.COMPLETED;
        }
        if (!this.runner.runToLocation(this.navigLastLocation, this.navigDestination, null, this.focus == null ? this.navigDestination : this.focus, null, true)) {
            if (this.log != null && this.log.isLoggable(Level.FINE)) {
                this.log.fine("LoqueNavigator.navigDirectly(): direct navigation failed");
            }
            return Stage.CRASHED;
        }
        if (this.log != null && this.log.isLoggable(Level.FINEST)) {
            this.log.finest("LoqueNavigator.navigDirectly(): traveling directly, distance = " + distance);
        }
        return this.navigStage;
    }

    protected NavPoint getNavPoint(ILocated location) {
        if (location instanceof NavPoint) {
            return (NavPoint)location;
        }
        NavPoint np = DistanceUtils.getNearest(this.main.getWorldView().getAll(NavPoint.class).values(), location);
        if (np.getLocation().getDistance(location.getLocation()) < 60.0) {
            return np;
        }
        return null;
    }

    private boolean initAlongPath(Location dest, List<PATH_ELEMENT> path) {
        this.navigDestination = dest;
        this.navigIterator = path.iterator();
        this.navigCurrentLocation = null;
        this.navigCurrentNode = null;
        this.prepareNextNode();
        this.navigStage = Stage.NAVIGATING;
        return this.switchToNextNode();
    }

    private Stage navigAlongPath() {
        int totalDistance = (int)this.memory.getLocation().getDistance(this.navigDestination);
        if (totalDistance <= 60) {
            this.log.finest("Navigator.navigAlongPath(): destination close enough: " + totalDistance);
            return Stage.COMPLETED;
        }
        if (this.navigStage.mover) {
            return this.navigThroughMover();
        }
        if (this.navigStage.teleport) {
            return this.navigThroughTeleport();
        }
        return this.navigToCurrentNode(true);
    }

    private void prepareNextNode() {
        if (this.navigCurrentNode != null && this.navigCurrentNode.isTeleporter()) {
            this.prepareNextNodeTeleporter();
            return;
        }
        ILocated located = null;
        this.navigNextLocation = null;
        this.navigNextLocationOffset = 0;
        while (located == null && this.navigIterator.hasNext()) {
            located = (ILocated)this.navigIterator.next();
            ++this.navigNextLocationOffset;
            if (located != null) continue;
        }
        if (located == null) {
            this.navigNextLocationOffset = 0;
            return;
        }
        if (this.executor.getPathElementIndex() + this.navigNextLocationOffset >= this.executor.getPath().size()) {
            this.navigNextLocationOffset = 0;
        }
        this.navigNextLocation = located.getLocation();
        this.navigNextNode = this.getNavPoint(located);
    }

    private void prepareNextNodeTeleporter() {
        ILocated located = null;
        this.navigNextLocation = null;
        this.navigNextLocationOffset = 0;
        boolean nextTeleporterFound = false;
        while (located == null && this.navigIterator.hasNext()) {
            located = (ILocated)this.navigIterator.next();
            ++this.navigNextLocationOffset;
            if (located == null) continue;
            this.navigNextNode = this.getNavPoint(located);
            if (this.navigNextNode == null || !this.navigNextNode.isTeleporter()) break;
            if (!nextTeleporterFound) {
                located = null;
            }
            nextTeleporterFound = true;
        }
        if (located == null) {
            this.navigNextLocationOffset = 0;
            return;
        }
        if (this.executor.getPathElementIndex() + this.navigNextLocationOffset >= this.executor.getPath().size()) {
            this.navigNextLocationOffset = 0;
        }
        this.navigNextLocation = located.getLocation();
        this.navigNextNode = this.getNavPoint(located);
    }

    private boolean switchToNextNode() {
        if (this.log != null && this.log.isLoggable(Level.FINER)) {
            this.log.finer("Navigator.switchToNextNode(): switching!");
        }
        this.navigLastLocation = this.navigCurrentLocation;
        this.navigLastNode = this.navigCurrentNode;
        this.navigCurrentLocation = this.navigNextLocation;
        if (null == this.navigCurrentLocation) {
            if (this.log != null && this.log.isLoggable(Level.FINER)) {
                this.log.finer("Navigator.switchToNextNode(): no nodes left");
            }
            this.navigCurrentNode = null;
            return false;
        }
        this.navigCurrentNode = this.navigNextNode;
        this.navigCurrentLink = this.getNavPointsLink(this.navigLastNode, this.navigCurrentNode);
        if (this.navigCurrentLink == null) {
            this.getNavPointsLink(this.navigLastNode, this.navigCurrentNode);
            if (this.log.isLoggable(Level.INFO)) {
                this.log.info("No link information...");
            }
        }
        if (this.navigLastLocation == null) {
            this.navigLastLocation = this.navigCurrentLocation;
            this.navigLastNode = this.navigCurrentNode;
        }
        int localDistance = (int)this.memory.getLocation().getDistance(this.navigCurrentLocation.getLocation());
        if (this.navigCurrentNode == null) {
            this.runner.reset();
            if (this.log != null && this.log.isLoggable(Level.FINE)) {
                this.log.fine("LoqueNavigator.switchToNextNode(): switch to next location " + this.navigCurrentLocation + ", distance " + localDistance + ", mover " + this.navigStage.mover);
            }
        } else {
            if (this.navigCurrentNode.isTeleporter()) {
                this.navigStage = Stage.TeleporterStage();
            } else if (this.navigCurrentNode.isLiftCenter()) {
                this.navigStage = Stage.FirstMoverStage();
            } else if (this.navigStage.mover) {
                this.navigStage = this.navigStage.next();
                this.runner.reset();
            } else if (this.navigStage.teleport) {
                this.navigStage = this.navigStage.next();
                this.runner.reset();
            } else {
                this.runner.reset();
            }
            if (this.log != null && this.log.isLoggable(Level.FINE)) {
                this.log.fine("LoqueNavigator.switchToNextNode(): switch to next node " + this.navigCurrentNode.getId().getStringId() + ", distance " + localDistance + ", reachable " + this.navigCurrentNode.isReachable() + ", mover " + this.navigStage.mover);
            }
        }
        if (this.executor.getPathElementIndex() < 0) {
            this.executor.switchToAnotherPathElement(0);
        } else if (this.navigNextLocationOffset > 0) {
            this.executor.switchToAnotherPathElement(this.executor.getPathElementIndex() + this.navigNextLocationOffset);
        } else {
            this.executor.switchToAnotherPathElement(this.executor.getPathElementIndex());
        }
        this.navigNextLocationOffset = 0;
        return true;
    }

    private NavPointNeighbourLink getNavPointsLink(NavPoint start, NavPoint end) {
        if (start == null) {
            NavPoint tmp = this.getNavPoint(this.memory.getLocation());
            if (tmp != null) {
                start = tmp;
            } else {
                return null;
            }
        }
        if (end == null) {
            return null;
        }
        if (end.getIncomingEdges().containsKey(start.getId())) {
            return end.getIncomingEdges().get(start.getId());
        }
        return null;
    }

    private Stage navigToCurrentNode(boolean useFocus) {
        ILocated focus;
        Location secondLocation;
        if (this.navigCurrentNode != null) {
            this.navigCurrentLocation = this.navigCurrentNode.getLocation();
        }
        int localDistance = (int)this.memory.getLocation().getDistance(this.navigCurrentLocation.getLocation());
        int localDistance2 = (int)this.memory.getLocation().getDistance(Location.add(this.navigCurrentLocation.getLocation(), new Location(0.0, 0.0, 100.0)));
        int distanceZ = (int)this.memory.getLocation().getDistanceZ(this.navigCurrentLocation);
        Location firstLocation = this.navigCurrentLocation.getLocation();
        Location location = secondLocation = this.navigNextNode != null && !this.navigNextNode.isLiftCenter() && !this.navigNextNode.isLiftCenter() ? this.navigNextNode.getLocation() : this.navigNextLocation;
        ILocated iLocated = this.focus == null || !useFocus ? (this.navigNextLocation == null ? firstLocation : this.navigNextLocation.getLocation()) : (focus = this.focus);
        if (!this.runner.runToLocation(this.navigLastLocation, firstLocation, secondLocation, focus, this.navigCurrentLink, this.navigCurrentNode == null ? true : this.navigCurrentNode.isReachable())) {
            if (this.log != null && this.log.isLoggable(Level.FINE)) {
                this.log.fine("LoqueNavigator.navigToCurrentNode(): navigation to current node failed");
            }
            return Stage.CRASHED;
        }
        if (this.log != null && this.log.isLoggable(Level.FINEST)) {
            this.log.finest("LoqueNavigator.navigToCurrentNode(): traveling to current node, distance = " + localDistance);
        }
        if (this.navigCurrentNode != null && this.navigCurrentNode == this.navigNextNode || this.navigCurrentLocation.equals(this.navigNextLocation)) {
            this.prepareNextNode();
        }
        int testDistance = 200;
        if (this.navigCurrentNode != null && (this.navigCurrentNode.isLiftCenter() || this.navigCurrentNode.isLiftExit())) {
            testDistance = 150;
        }
        if (this.navigCurrentLink != null && (this.navigCurrentLink.getFlags() & LinkFlag.JUMP.get()) != 0) {
            localDistance2 = 10000;
        }
        if (this.navigCurrentLocation != null && this.navigCurrentLocation.equals(this.executor.getPath().get(this.executor.getPath().size() - 1)) || !this.navigIterator.hasNext() && (this.navigNextLocation == null || this.navigCurrentLocation == this.navigNextLocation)) {
            testDistance = 50;
        }
        if (!(distanceZ >= 40 || localDistance >= testDistance && localDistance2 >= testDistance || this.switchToNextNode())) {
            if (this.log != null && this.log.isLoggable(Level.FINE)) {
                this.log.fine("Navigator.navigToCurrentNode(): switch to direct navigation");
            }
            return this.initDirectly(this.navigDestination);
        }
        return this.navigStage;
    }

    private Stage navigThroughMover() {
        Stage stage = this.navigStage;
        if (this.navigCurrentNode == null) {
            if (this.log != null && this.log.isLoggable(Level.WARNING)) {
                this.log.warning("LoqueNavigator.navigThroughMover(" + (Object)((Object)stage) + "): can't navigate through the mover without the navpoint instance (navigCurrentNode == null)");
            }
            return Stage.CRASHED;
        }
        this.navigCurrentLocation = this.navigCurrentNode.getLocation();
        int hDistance = (int)this.memory.getLocation().getDistance2D(this.navigCurrentLocation.getLocation());
        int vDistance = (int)this.navigCurrentLocation.getLocation().getDistanceZ(this.memory.getLocation());
        if (this.navigStage == Stage.AWAITING_MOVER) {
            if (vDistance > 50 || hDistance > 400) {
                if (!this.runner.runToLocation(this.navigLastLocation, this.navigLastLocation, null, this.navigCurrentLocation, this.navigCurrentLink, this.navigLastNode == null ? true : this.navigLastNode.isReachable())) {
                    if (this.log != null && this.log.isLoggable(Level.FINE)) {
                        this.log.fine("LoqueNavigator.navigThroughMover(" + (Object)((Object)stage) + "): navigation to last node failed");
                    }
                    return Stage.CRASHED;
                }
                if (this.log != null && this.log.isLoggable(Level.FINER)) {
                    this.log.finer("LoqueNavigator.navigThroughMover(" + (Object)((Object)stage) + "): waiting for mover" + ", node " + this.navigCurrentNode.getId().getStringId() + ", vDistance " + vDistance + ", hDistance " + hDistance);
                }
                return this.navigStage;
            }
            if (this.log != null && this.log.isLoggable(Level.FINER)) {
                this.log.finer("Navigator.navigThroughMover(" + (Object)((Object)stage) + "): mover arrived" + ", node " + this.navigCurrentNode.getId().getStringId() + ", vDistance " + vDistance + ", hDistance " + hDistance);
            }
            return this.navigToCurrentNode(false);
        }
        if (this.navigStage == Stage.RIDING_MOVER) {
            if (Math.abs(vDistance) > 50 || hDistance > 400) {
                if (!this.runner.runToLocation(this.navigLastLocation, this.navigLastLocation, null, this.navigCurrentLocation, this.navigCurrentLink, this.navigLastNode == null ? true : this.navigLastNode.isReachable())) {
                    if (this.log != null && this.log.isLoggable(Level.FINE)) {
                        this.log.fine("LoqueNavigator.navigThroughMover(" + (Object)((Object)stage) + "): navigation to last node failed");
                    }
                    return Stage.CRASHED;
                }
                if (this.log != null && this.log.isLoggable(Level.FINER)) {
                    this.log.finer("LoqueNavigator.navigThroughMover(" + (Object)((Object)stage) + "): riding the mover" + ", node " + this.navigCurrentNode.getId().getStringId() + ", vDistance " + vDistance + ", hDistance " + hDistance);
                }
                return this.navigStage;
            }
            if (this.log != null && this.log.isLoggable(Level.FINER)) {
                this.log.finer("Navigator.navigThroughMover(" + (Object)((Object)stage) + "): exiting the mover" + ", node " + this.navigCurrentNode.getId().getStringId() + ", vDistance " + vDistance + ", hDistance " + hDistance);
            }
            return this.navigToCurrentNode(false);
        }
        if (this.log != null && this.log.isLoggable(Level.WARNING)) {
            this.log.warning("Navigator.navigThroughMover(" + (Object)((Object)stage) + "): invalid stage, neither AWAITING_MOVER nor RIDING MOVER");
        }
        return Stage.CRASHED;
    }

    private Stage navigThroughTeleport() {
        ILocated focus;
        Location secondLocation;
        if (this.navigCurrentNode != null) {
            this.navigCurrentLocation = this.navigCurrentNode.getLocation();
        }
        if (this.navigCurrentNode != null && this.navigCurrentNode == this.navigNextNode || this.navigCurrentLocation.equals(this.navigNextLocation)) {
            this.prepareNextNode();
        }
        int localDistance1_1 = (int)this.memory.getLocation().getDistance(this.navigCurrentLocation.getLocation());
        int localDistance1_2 = (int)this.memory.getLocation().getDistance(Location.add(this.navigCurrentLocation.getLocation(), new Location(0.0, 0.0, 100.0)));
        int localDistance2_1 = Integer.MAX_VALUE;
        int localDistance2_2 = Integer.MAX_VALUE;
        for (NavPointNeighbourLink link : this.navigCurrentNode.getOutgoingEdges().values()) {
            if (!link.getToNavPoint().isTeleporter()) continue;
            localDistance2_1 = (int)this.memory.getLocation().getDistance(link.getToNavPoint().getLocation());
            localDistance2_2 = (int)this.memory.getLocation().getDistance(Location.add(link.getToNavPoint().getLocation(), new Location(0.0, 0.0, 100.0)));
            break;
        }
        boolean switchedToNextNode = false;
        if (localDistance2_1 < 200 || localDistance2_2 < 200) {
            if (!this.switchToNextNode()) {
                if (this.log != null && this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Navigator.navigToCurrentNode(): switch to direct navigation");
                }
                return this.initDirectly(this.navigDestination);
            }
            switchedToNextNode = true;
        }
        Location firstLocation = this.navigCurrentLocation.getLocation();
        Location location = secondLocation = this.navigNextNode != null && !this.navigNextNode.isLiftCenter() && !this.navigNextNode.isLiftCenter() ? this.navigNextNode.getLocation() : this.navigNextLocation;
        ILocated iLocated = this.focus == null ? (this.navigNextLocation == null ? firstLocation : this.navigNextLocation.getLocation()) : (focus = this.focus);
        if (!this.runner.runToLocation(this.navigLastLocation, firstLocation, secondLocation, focus, this.navigCurrentLink, this.navigCurrentNode == null ? true : this.navigCurrentNode.isReachable())) {
            if (this.log != null && this.log.isLoggable(Level.FINE)) {
                this.log.fine("LoqueNavigator.navigToCurrentNode(): navigation to current node failed");
            }
            return Stage.CRASHED;
        }
        if (this.log != null && this.log.isLoggable(Level.FINEST)) {
            this.log.finest("LoqueNavigator.navigToCurrentNode(): traveling to current node");
        }
        if (!(switchedToNextNode || localDistance1_1 >= 200 && localDistance1_2 >= 200 || this.switchToNextNode())) {
            if (this.log != null && this.log.isLoggable(Level.FINE)) {
                this.log.fine("Navigator.navigToCurrentNode(): switch to direct navigation");
            }
            return this.initDirectly(this.navigDestination);
        }
        return this.navigStage;
    }

    public LoqueNavigator(UT2004Bot bot, Logger log) {
        this.main = bot;
        this.memory = new AgentInfo(bot);
        this.body = new AdvancedLocomotion(bot, log);
        this.log = log;
        this.runner = new LoqueRunner(bot, this.memory, this.body, log);
    }

    public LoqueNavigator(UT2004Bot bot, IUT2004PathRunner runner, Logger log) {
        this.main = bot;
        this.memory = new AgentInfo(bot);
        this.body = new AdvancedLocomotion(bot, log);
        this.log = log;
        this.runner = runner;
        NullCheck.check(this.runner, "runner");
    }

    public static enum Stage {
        REACHING{

            @Override
            protected Stage next() {
                return this;
            }
        }
        ,
        NAVIGATING{

            @Override
            protected Stage next() {
                return this;
            }
        }
        ,
        AWAITING_MOVER(MoverStageType.WAITING){

            @Override
            protected Stage next() {
                return RIDING_MOVER;
            }
        }
        ,
        RIDING_MOVER(MoverStageType.RIDING){

            @Override
            protected Stage next() {
                return NAVIGATING;
            }
        }
        ,
        CANCELED(TerminatingStageType.FAILURE){

            @Override
            protected Stage next() {
                return this;
            }
        }
        ,
        TIMEOUT(TerminatingStageType.FAILURE){

            @Override
            protected Stage next() {
                return this;
            }
        }
        ,
        CRASHED(TerminatingStageType.FAILURE){

            @Override
            protected Stage next() {
                return this;
            }
        }
        ,
        COMPLETED(TerminatingStageType.SUCCESS){

            @Override
            protected Stage next() {
                return this;
            }
        }
        ,
        TELEPORT(TeleportStageType.GOING_THROUGH){

            @Override
            protected Stage next() {
                return NAVIGATING;
            }
        };

        private boolean mover;
        public boolean terminated;
        public boolean failure;
        public boolean teleport;

        private Stage() {
            this.mover = false;
            this.teleport = false;
            this.terminated = false;
            this.failure = false;
        }

        private Stage(TeleportStageType type) {
            this.mover = false;
            this.teleport = true;
            this.failure = false;
            this.terminated = false;
        }

        private Stage(MoverStageType type) {
            this.mover = true;
            this.teleport = false;
            this.terminated = false;
            this.failure = false;
        }

        private Stage(TerminatingStageType type) {
            this.mover = false;
            this.teleport = false;
            this.terminated = true;
            this.failure = type.failure;
        }

        protected abstract Stage next();

        protected static Stage FirstMoverStage() {
            return AWAITING_MOVER;
        }

        protected static Stage TeleporterStage() {
            return TELEPORT;
        }
    }

    private static enum TeleportStageType {
        GOING_THROUGH;

    }

    private static enum MoverStageType {
        WAITING,
        RIDING;

    }

    private static enum TerminatingStageType {
        SUCCESS(false),
        FAILURE(true);

        public boolean failure;

        private TerminatingStageType(boolean failure) {
            this.failure = failure;
        }
    }
}

