/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004multi.communication.worldview;

import cz.cuni.amis.pogamut.base.communication.translator.event.IWorldChangeEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.object.WorldObjectId;
import cz.cuni.amis.pogamut.base.component.controller.ComponentDependencies;
import cz.cuni.amis.pogamut.base.component.lifecyclebus.ILifecycleBus;
import cz.cuni.amis.pogamut.base.utils.logging.IAgentLogger;
import cz.cuni.amis.pogamut.multi.agent.ITeamedAgentId;
import cz.cuni.amis.pogamut.multi.communication.translator.event.ICompositeWorldObjectUpdatedEvent;
import cz.cuni.amis.pogamut.multi.communication.translator.event.ILocalWorldObjectUpdatedEvent;
import cz.cuni.amis.pogamut.multi.communication.worldview.ISharedWorldView;
import cz.cuni.amis.pogamut.multi.communication.worldview.impl.BatchAwareLocalWorldView;
import cz.cuni.amis.pogamut.multi.communication.worldview.object.ICompositeWorldObject;
import cz.cuni.amis.pogamut.multi.communication.worldview.object.ILocalWorldObject;
import cz.cuni.amis.pogamut.multi.communication.worldview.object.ISharedWorldObject;
import cz.cuni.amis.pogamut.multi.communication.worldview.object.IStaticWorldObject;
import cz.cuni.amis.pogamut.multi.communication.worldview.object.event.DummyObjectEvent;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.UT2004CompositeObjectCreator;
import cz.cuni.amis.pogamut.ut2004multi.communication.worldview.objects.ILocalGBViewable;
import java.util.ArrayList;
import java.util.Collection;

public abstract class UT2004VisionLocalWorldView
extends BatchAwareLocalWorldView {
    protected Collection<WorldObjectId> lastBatch = new ArrayList<WorldObjectId>();
    protected Collection<WorldObjectId> currentBatch = new ArrayList<WorldObjectId>();
    private long currentBatchTime = -1L;

    public UT2004VisionLocalWorldView(ComponentDependencies dependencies, ILifecycleBus bus, IAgentLogger logger, ISharedWorldView parentWorldView, ITeamedAgentId agentId) {
        super(dependencies, bus, logger, parentWorldView, agentId);
    }

    @Override
    protected ICompositeWorldObject createCompositeObject(ILocalWorldObject localObject, ISharedWorldObject sharedObject, IStaticWorldObject staticObject) {
        return UT2004CompositeObjectCreator.createObject(localObject, sharedObject, staticObject);
    }

    @Override
    public synchronized void notify(IWorldChangeEvent event) {
        if (this.currentBatchTime < event.getSimTime()) {
            this.currentBatchTime = event.getSimTime();
        }
        if (event instanceof ILocalWorldObjectUpdatedEvent) {
            this.localEventNotify((ILocalWorldObjectUpdatedEvent)event);
        } else if (event instanceof ICompositeWorldObjectUpdatedEvent) {
            ILocalWorldObjectUpdatedEvent locEvent = ((ICompositeWorldObjectUpdatedEvent)event).getLocalEvent();
            if (locEvent != null) {
                this.localEventNotify(locEvent);
            }
        } else if (this.isBatchEndEvent(event)) {
            this.processBatches();
        }
        super.notify(event);
    }

    private void processBatches() {
        this.log.fine("Processing Batches, lastBatchSize : " + this.lastBatch.size());
        if (!this.lastBatch.isEmpty()) {
            this.lastBatch.removeAll(this.currentBatch);
            for (WorldObjectId id : this.lastBatch) {
                this.log.fine("Disappearing object : " + id);
                super.bufferObjectEvent(id, DummyObjectEvent.EventType.DISAPPEARED, this.currentBatchTime);
            }
        }
        this.log.fine("Swapping batches : Curr : " + this.currentBatch.size() + " ; last : " + this.lastBatch.size());
        this.lastBatch = this.currentBatch;
        this.currentBatch = new ArrayList<WorldObjectId>(this.lastBatch.size() + 10);
        this.log.fine("Swapping finished : Curr : " + this.currentBatch.size() + " ; last : " + this.lastBatch.size());
    }

    protected void localEventNotify(ILocalWorldObjectUpdatedEvent event) {
        this.log.fine("LocalEvent recieved in batch :" + event.getSimTime() + " ; " + event.getId());
        Object obj = ((IWorldObjectEvent)((Object)event)).getObject();
        if (obj != null && obj instanceof ILocalGBViewable) {
            this.currentBatch.add(obj.getId());
        }
    }
}

