/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.utils;

import cz.cuni.amis.utils.NullCheck;
import cz.cuni.amis.utils.exception.PogamutException;
import cz.cuni.amis.utils.exception.PogamutIOException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class IniFile {
    private Map<String, Section> sections = new TreeMap<String, Section>(new Comparator<String>(){

        @Override
        public int compare(String o1, String o2) {
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            return o1.toLowerCase().compareTo(o2.toLowerCase());
        }
    });

    public IniFile() {
    }

    public IniFile(File source) {
        if (!source.exists()) {
            throw new PogamutException("File with defaults does not exist at: " + source.getAbsolutePath() + ".", (Object)this);
        }
        this.load(source);
    }

    public IniFile(IniFile ini) {
        for (Section section : ini.getSections()) {
            this.addSection(new Section(section));
        }
    }

    public void load(File source) {
        try {
            this.load(new FileInputStream(source));
        }
        catch (Exception e) {
            throw new PogamutException("Could not load defaults for GameBots2004.ini from file: " + source.getAbsolutePath() + ", caused by: " + e.getMessage(), e);
        }
    }

    public void load(InputStream source) {
        BufferedReader reader = null;
        reader = new BufferedReader(new InputStreamReader(source));
        Section currSection = null;
        try {
            while (reader.ready()) {
                String line = reader.readLine().trim();
                if (line.length() == 0 || line.trim().startsWith(";")) continue;
                if (line.startsWith("[") && line.endsWith("]")) {
                    String sectionName;
                    if (currSection != null && this.getSection(currSection.getName()) == null) {
                        this.addSection(currSection);
                    }
                    if ((currSection = this.getSection(sectionName = line.substring(1, line.length() - 1))) != null) continue;
                    currSection = new Section(sectionName);
                    continue;
                }
                int separ = line.indexOf("=");
                if (separ < 0) continue;
                if (currSection == null) {
                    throw new PogamutException("There is an entry '" + line + "' inside ini file that does not belong to any section.", (Object)this);
                }
                String key = line.substring(0, separ);
                String value = separ + 1 < line.length() ? line.substring(separ + 1, line.length()) : "";
                currSection.put(key, value);
            }
        }
        catch (IOException e) {
            throw new PogamutIOException("Could not completely read file with defaults from stream, caused by: " + e.getMessage(), e, (Object)this);
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException e) {}
        }
        if (currSection != null && this.getSection(currSection.getName()) == null) {
            this.addSection(currSection);
        }
    }

    public IniFile addIniFile(IniFile iniFile) {
        for (Section section : iniFile.sections.values()) {
            this.addSection(section);
        }
        return this;
    }

    public Section addSection(String sectionName) {
        return this.addSection(new Section(sectionName));
    }

    public Section addSection(Section section) {
        Section oldSection = this.sections.get(section.getName());
        if (oldSection != null) {
            oldSection.add(section);
            return oldSection;
        }
        this.sections.put(section.getName(), section);
        return section;
    }

    public Section copySection(Section section) {
        Section oldSection = this.sections.get(section.getName());
        if (oldSection != null) {
            oldSection.add(new Section(section));
            return oldSection;
        }
        this.sections.put(section.getName(), section);
        return section;
    }

    public boolean hasSection(String name) {
        return this.sections.containsKey(name);
    }

    public Section getSection(String name) {
        return this.sections.get(name);
    }

    public Set<String> getSectionNames() {
        return this.sections.keySet();
    }

    public Collection<Section> getSections() {
        return this.sections.values();
    }

    public String get(String section, String key) {
        Section sec = this.sections.get(section);
        if (sec == null) {
            return null;
        }
        return sec.get(key);
    }

    public Section set(String section, String key, String value) {
        Section sec = this.sections.get(section);
        if (sec == null) {
            sec = this.addSection(section);
        }
        sec.set(key, value);
        return sec;
    }

    public void output(String pathToFileToBeCreated) {
        NullCheck.check(pathToFileToBeCreated, "pathToFileToBeCreated");
        this.output(new File(pathToFileToBeCreated));
    }

    public void output(File file) {
        NullCheck.check(file, "file");
        PrintWriter writer = null;
        try {
            writer = new PrintWriter(new FileWriter(file));
            this.output(writer);
        }
        catch (IOException e) {
            throw new PogamutIOException("Could not write ini file into '" + file.getAbsolutePath() + "', caused by: " + e.getMessage(), e, (Object)this);
        }
        finally {
            writer.close();
        }
    }

    public void output(PrintWriter writer) {
        NullCheck.check(writer, "writer");
        boolean first = true;
        for (Section section : this.sections.values()) {
            if (first) {
                first = false;
            } else {
                writer.println();
            }
            section.output(writer);
        }
    }

    public String output() {
        StringWriter stringWriter = new StringWriter();
        this.output(new PrintWriter(stringWriter));
        return stringWriter.toString();
    }

    public static class Section {
        private String name;
        private Map<String, String> props = new TreeMap<String, String>(new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                if (o1 == null) {
                    return -1;
                }
                if (o2 == null) {
                    return 1;
                }
                return o1.toLowerCase().compareTo(o2.toLowerCase());
            }
        });

        public Section(String name) {
            this.name = name;
            NullCheck.check(this.name, "name");
        }

        public Section(Section section) {
            this.name = section.getName();
            this.add(section);
        }

        public String getName() {
            return this.name;
        }

        public Section put(String key, String value) {
            NullCheck.check(key, "key");
            this.props.put(key, value);
            return this;
        }

        public String get(String key) {
            return this.props.get(key);
        }

        public boolean containsKey(String key) {
            return this.props.containsKey(key);
        }

        public Set<String> getKeys() {
            return this.props.keySet();
        }

        public Set<String> keySet() {
            return this.getKeys();
        }

        public Section remove(String key) {
            this.props.remove(key);
            return this;
        }

        public Section clear() {
            this.props.clear();
            return this;
        }

        public Section set(String key, String value) {
            return this.put(key, value);
        }

        public Section add(Section section) {
            for (Map.Entry<String, String> entry : section.props.entrySet()) {
                this.props.put(entry.getKey(), entry.getValue());
            }
            return this;
        }

        public void output(PrintWriter writer) {
            writer.print("[");
            writer.print(this.name);
            writer.println("]");
            for (Map.Entry<String, String> entry : this.props.entrySet()) {
                writer.print(entry.getKey());
                writer.print("=");
                writer.println(entry.getValue());
            }
        }

        public String toString() {
            return "IniFile.Section[name=" + this.name + ", entries=" + this.props.size() + "]";
        }
    }
}

