/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.utils.listener;

import cz.cuni.amis.utils.ExceptionToString;
import cz.cuni.amis.utils.NullCheck;
import cz.cuni.amis.utils.listener.IListener;
import java.lang.ref.WeakReference;
import java.util.EventListener;
import java.util.Iterator;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Listeners<Listener extends EventListener> {
    private Logger log;
    private String name;
    private ConcurrentLinkedQueue<ListenerStore<Listener>> listeners = new ConcurrentLinkedQueue();
    private boolean listenersIteration = false;

    public Logger getLog() {
        return this.log;
    }

    public void setLog(Logger log, String name) {
        this.log = log;
        this.name = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStrongListener(Listener listener) {
        NullCheck.check(listener, "listener");
        ConcurrentLinkedQueue<ListenerStore<Listener>> concurrentLinkedQueue = this.listeners;
        synchronized (concurrentLinkedQueue) {
            this.listeners.add(new StrongListenerStore<Listener>(listener));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWeakListener(Listener listener) {
        NullCheck.check(listener, "listener");
        ConcurrentLinkedQueue<ListenerStore<Listener>> concurrentLinkedQueue = this.listeners;
        synchronized (concurrentLinkedQueue) {
            this.listeners.add(new WeakListenerStore<Listener>(listener));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int removeEqualListener(EventListener listener) {
        if (listener == null) {
            return 0;
        }
        int removed = 0;
        ConcurrentLinkedQueue<ListenerStore<Listener>> concurrentLinkedQueue = this.listeners;
        synchronized (concurrentLinkedQueue) {
            boolean listenersIterationOriginal = this.listenersIteration;
            this.listenersIteration = true;
            try {
                Iterator<ListenerStore<Listener>> iterator = this.listeners.iterator();
                while (iterator.hasNext()) {
                    ListenerStore<Listener> store = iterator.next();
                    Listener storedListener = store.getListener();
                    if (storedListener == null) {
                        if (listenersIterationOriginal) continue;
                        if (store instanceof WeakListenerStore && this.log != null && this.log.isLoggable(Level.WARNING)) {
                            this.log.warning((this.name == null ? "" : this.name + ": ") + "Weakly referenced listener was GC()ed.");
                        }
                        iterator.remove();
                        continue;
                    }
                    if (!listener.equals(storedListener)) continue;
                    store.clearListener();
                    ++removed;
                }
            }
            finally {
                this.listenersIteration = listenersIterationOriginal;
            }
        }
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int removeListener(EventListener listener) {
        if (listener == null) {
            return 0;
        }
        int removed = 0;
        ConcurrentLinkedQueue<ListenerStore<Listener>> concurrentLinkedQueue = this.listeners;
        synchronized (concurrentLinkedQueue) {
            boolean listenersIterationOriginal = this.listenersIteration;
            this.listenersIteration = true;
            try {
                Iterator<ListenerStore<Listener>> iterator = this.listeners.iterator();
                while (iterator.hasNext()) {
                    ListenerStore<Listener> store = iterator.next();
                    Listener storedListener = store.getListener();
                    if (storedListener == null) {
                        if (listenersIterationOriginal) continue;
                        if (store instanceof WeakListenerStore && this.log != null && this.log.isLoggable(Level.WARNING)) {
                            this.log.warning((this.name == null ? "" : this.name + ": ") + "Weakly referenced listener was GC()ed.");
                        }
                        iterator.remove();
                        continue;
                    }
                    if (listener != storedListener) continue;
                    store.clearListener();
                    ++removed;
                }
            }
            finally {
                this.listenersIteration = listenersIterationOriginal;
            }
        }
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notify(ListenerNotifier<Listener> notifier) {
        ConcurrentLinkedQueue<ListenerStore<Listener>> concurrentLinkedQueue = this.listeners;
        synchronized (concurrentLinkedQueue) {
            boolean listenersIterationOriginal = this.listenersIteration;
            this.listenersIteration = true;
            try {
                Iterator<ListenerStore<Listener>> iterator = this.listeners.iterator();
                while (iterator.hasNext()) {
                    ListenerStore<Listener> store = iterator.next();
                    Listener storedListener = store.getListener();
                    if (storedListener == null) {
                        if (listenersIterationOriginal) continue;
                        if (store instanceof WeakListenerStore && this.log != null && this.log.isLoggable(Level.WARNING)) {
                            this.log.warning((this.name == null ? "" : this.name + ": ") + "Weakly referenced listener was GC()ed.");
                        }
                        iterator.remove();
                        continue;
                    }
                    notifier.notify(storedListener);
                }
            }
            finally {
                this.listenersIteration = listenersIterationOriginal;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean notifySafe(ListenerNotifier<Listener> notifier, Logger exceptionLog) {
        boolean noException = true;
        ConcurrentLinkedQueue<ListenerStore<Listener>> concurrentLinkedQueue = this.listeners;
        synchronized (concurrentLinkedQueue) {
            boolean listenersIterationOriginal = this.listenersIteration;
            this.listenersIteration = true;
            try {
                Iterator<ListenerStore<Listener>> iterator = this.listeners.iterator();
                while (iterator.hasNext()) {
                    ListenerStore<Listener> store = iterator.next();
                    Listener storedListener = store.getListener();
                    if (storedListener == null) {
                        if (listenersIterationOriginal) continue;
                        if (store instanceof WeakListenerStore && this.log != null && this.log.isLoggable(Level.WARNING)) {
                            this.log.warning((this.name == null ? "" : this.name + ": ") + "Weakly referenced listener was GC()ed.");
                        }
                        iterator.remove();
                        continue;
                    }
                    try {
                        notifier.notify(storedListener);
                    }
                    catch (Exception e) {
                        noException = false;
                        if (exceptionLog == null || !exceptionLog.isLoggable(Level.SEVERE)) continue;
                        exceptionLog.severe(ExceptionToString.process("Exception during event processing (" + notifier.getEvent() + ").", e));
                    }
                }
            }
            finally {
                this.listenersIteration = listenersIterationOriginal;
            }
        }
        return noException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isEqualListening(EventListener listener) {
        if (listener == null) {
            return false;
        }
        ConcurrentLinkedQueue<ListenerStore<Listener>> concurrentLinkedQueue = this.listeners;
        synchronized (concurrentLinkedQueue) {
            boolean listenersIterationOriginal = this.listenersIteration;
            this.listenersIteration = true;
            try {
                block11: {
                    Iterator<ListenerStore<Listener>> iterator = this.listeners.iterator();
                    while (iterator.hasNext()) {
                        ListenerStore<Listener> store = iterator.next();
                        Listener storedListener = store.getListener();
                        if (storedListener == null) {
                            if (listenersIterationOriginal) continue;
                            if (store instanceof WeakListenerStore && this.log != null && this.log.isLoggable(Level.WARNING)) {
                                this.log.warning((this.name == null ? "" : this.name + ": ") + "Weakly referenced listener was GC()ed.");
                            }
                            iterator.remove();
                            continue;
                        }
                        if (!listener.equals(storedListener)) {
                            continue;
                        }
                        break block11;
                    }
                    return false;
                }
                boolean bl = true;
                return bl;
            }
            finally {
                this.listenersIteration = listenersIterationOriginal;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isListening(EventListener listener) {
        if (listener == null) {
            return false;
        }
        ConcurrentLinkedQueue<ListenerStore<Listener>> concurrentLinkedQueue = this.listeners;
        synchronized (concurrentLinkedQueue) {
            boolean listenersIterationOriginal = this.listenersIteration;
            this.listenersIteration = true;
            try {
                block11: {
                    Iterator<ListenerStore<Listener>> iterator = this.listeners.iterator();
                    while (iterator.hasNext()) {
                        ListenerStore<Listener> store = iterator.next();
                        Listener storedListener = store.getListener();
                        if (storedListener == null) {
                            if (listenersIterationOriginal) continue;
                            if (store instanceof WeakListenerStore && this.log != null && this.log.isLoggable(Level.WARNING)) {
                                this.log.warning((this.name == null ? "" : this.name + ": ") + "Weakly referenced listener was GC()ed.");
                            }
                            iterator.remove();
                            continue;
                        }
                        if (listener != storedListener) {
                            continue;
                        }
                        break block11;
                    }
                    return false;
                }
                boolean bl = true;
                return bl;
            }
            finally {
                this.listenersIteration = listenersIterationOriginal;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearListeners() {
        ConcurrentLinkedQueue<ListenerStore<Listener>> concurrentLinkedQueue = this.listeners;
        synchronized (concurrentLinkedQueue) {
            if (!this.listenersIteration) {
                this.listeners.clear();
            } else {
                for (ListenerStore<Listener> store : this.listeners) {
                    store.clearListener();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int count() {
        ConcurrentLinkedQueue<ListenerStore<Listener>> concurrentLinkedQueue = this.listeners;
        synchronized (concurrentLinkedQueue) {
            int count = 0;
            for (ListenerStore<Listener> store : this.listeners) {
                if (store.getListener() == null) continue;
                ++count;
            }
            return count;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(ListenerRemover remover) {
        ConcurrentLinkedQueue<ListenerStore<Listener>> concurrentLinkedQueue = this.listeners;
        synchronized (concurrentLinkedQueue) {
            boolean listenersIterationOriginal = this.listenersIteration;
            this.listenersIteration = true;
            try {
                Iterator<ListenerStore<Listener>> iterator = this.listeners.iterator();
                while (iterator.hasNext()) {
                    ListenerStore<Listener> store = iterator.next();
                    Listener storedListener = store.getListener();
                    if (storedListener == null) {
                        if (listenersIterationOriginal) continue;
                        if (store instanceof WeakListenerStore && this.log != null && this.log.isLoggable(Level.WARNING)) {
                            this.log.warning((this.name == null ? "" : this.name + ": ") + "Weakly referenced listener was GC()ed.");
                        }
                        iterator.remove();
                        continue;
                    }
                    if (!remover.remove((EventListener)storedListener)) continue;
                    if (!listenersIterationOriginal) {
                        iterator.remove();
                        continue;
                    }
                    store.clearListener();
                }
            }
            finally {
                this.listenersIteration = listenersIterationOriginal;
            }
        }
    }

    private static class WeakListenerStore<Listener extends EventListener>
    extends ListenerStore<Listener> {
        private WeakReference<Listener> listenerReference = null;

        public WeakListenerStore(Listener listener) {
            this.listenerReference = new WeakReference<Listener>(listener);
        }

        @Override
        public Listener getListener() {
            return (Listener)((EventListener)this.listenerReference.get());
        }

        @Override
        public void clearListener() {
            this.listenerReference.clear();
        }
    }

    private static class StrongListenerStore<Listener extends EventListener>
    extends ListenerStore<Listener> {
        private Listener listener;

        public StrongListenerStore(Listener listener) {
            this.listener = listener;
        }

        @Override
        public Listener getListener() {
            return this.listener;
        }

        @Override
        public void clearListener() {
            this.listener = null;
        }
    }

    private static abstract class ListenerStore<Listener extends EventListener> {
        private ListenerStore() {
        }

        public abstract Listener getListener();

        public abstract void clearListener();
    }

    public static interface ListenerRemover {
        public boolean remove(EventListener var1);
    }

    public static class AdaptableListenerNotifier<LISTENER extends IListener>
    implements ListenerNotifier<LISTENER> {
        private Object event;

        public AdaptableListenerNotifier<LISTENER> setEvent(Object event) {
            this.event = event;
            return this;
        }

        @Override
        public Object getEvent() {
            return this.event;
        }

        @Override
        public void notify(LISTENER listener) {
            listener.notify((Object)this.event);
        }
    }

    public static interface ListenerNotifier<Listener extends EventListener> {
        public Object getEvent();

        public void notify(Listener var1);
    }
}

