/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.utils.maps;

import cz.cuni.amis.utils.collections.LazyMapValuesCollection;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public abstract class AbstractLazyMap<KEY, VALUE>
implements Map<KEY, VALUE> {
    private Map<KEY, VALUE> cachedObjects = new HashMap<KEY, VALUE>();
    private Set<KEY> keySet = null;

    protected abstract VALUE create(Object var1);

    public AbstractLazyMap() {
        this.cachedObjects = new HashMap<KEY, VALUE>();
        this.keySet = new HashSet<KEY>();
    }

    public AbstractLazyMap(Set<KEY> entryKeySet) {
        this.keySet = entryKeySet;
    }

    public AbstractLazyMap(Map<KEY, VALUE> baseMap) {
        this.cachedObjects = baseMap;
        this.keySet = baseMap.keySet();
    }

    public void addKey(KEY key) {
        this.keySet.add(key);
    }

    @Override
    public void clear() {
        this.keySet.clear();
        this.cachedObjects.clear();
    }

    public void clearCache() {
        this.cachedObjects.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.keySet.contains(key);
    }

    public void setKeySet(Set<KEY> newKeySet) {
        this.clear();
        this.keySet = newKeySet;
    }

    @Override
    public boolean containsValue(Object value) {
        for (KEY key : this.keySet) {
            if (!this.get(key).equals(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<Map.Entry<KEY, VALUE>> entrySet() {
        return this.cachedObjects.entrySet();
    }

    @Override
    public synchronized VALUE get(Object key) {
        VALUE value = this.cachedObjects.get(key);
        if (value != null) {
            return value;
        }
        if (this.keySet.contains(key)) {
            value = this.create(key);
            this.cachedObjects.put(key, value);
        }
        return value;
    }

    @Override
    public boolean isEmpty() {
        return this.keySet.isEmpty();
    }

    @Override
    public Set<KEY> keySet() {
        return this.keySet;
    }

    @Override
    public VALUE put(KEY key, VALUE value) {
        this.keySet.add(key);
        return this.cachedObjects.put(key, value);
    }

    @Override
    public void putAll(Map<? extends KEY, ? extends VALUE> m) {
        this.keySet.addAll(m.keySet());
        this.cachedObjects.putAll(m);
    }

    @Override
    public VALUE remove(Object key) {
        this.keySet.remove(key);
        return this.cachedObjects.remove(key);
    }

    @Override
    public int size() {
        return this.keySet.size();
    }

    @Override
    public Collection<VALUE> values() {
        return new LazyMapValuesCollection(this);
    }
}

