/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization.control;

import edu.uci.ics.jung.algorithms.layout.GraphElementAccessor;
import edu.uci.ics.jung.algorithms.layout.Layout;
import edu.uci.ics.jung.visualization.Layer;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.control.AbstractGraphMousePlugin;
import edu.uci.ics.jung.visualization.picking.PickedState;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Point2D;
import javax.swing.JComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnimatedPickingGraphMousePlugin<V, E>
extends AbstractGraphMousePlugin
implements MouseListener,
MouseMotionListener {
    protected V vertex;

    public AnimatedPickingGraphMousePlugin() {
        this(18);
    }

    public AnimatedPickingGraphMousePlugin(int selectionModifiers) {
        super(selectionModifiers);
        this.cursor = Cursor.getPredefinedCursor(12);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.getModifiers() == this.modifiers) {
            VisualizationViewer vv = (VisualizationViewer)e.getSource();
            GraphElementAccessor pickSupport = vv.getPickSupport();
            PickedState pickedVertexState = vv.getPickedVertexState();
            Layout layout = vv.getGraphLayout();
            if (pickSupport != null && pickedVertexState != null) {
                Point p = e.getPoint();
                this.vertex = pickSupport.getVertex(layout, ((Point2D)p).getX(), ((Point2D)p).getY());
                if (this.vertex != null && !pickedVertexState.isPicked(this.vertex)) {
                    pickedVertexState.clear();
                    pickedVertexState.pick(this.vertex, true);
                }
            }
            e.consume();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.getModifiers() == this.modifiers) {
            final VisualizationViewer vv = (VisualizationViewer)e.getSource();
            if (this.vertex != null) {
                Layout layout = vv.getGraphLayout();
                Point2D q = (Point2D)layout.transform(this.vertex);
                Point2D lvc = vv.getRenderContext().getMultiLayerTransformer().inverseTransform(vv.getCenter());
                final double dx = (lvc.getX() - q.getX()) / 10.0;
                final double dy = (lvc.getY() - q.getY()) / 10.0;
                Runnable animator = new Runnable(){

                    public void run() {
                        for (int i = 0; i < 10; ++i) {
                            vv.getRenderContext().getMultiLayerTransformer().getTransformer(Layer.LAYOUT).translate(dx, dy);
                            try {
                                Thread.sleep(100L);
                                continue;
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                    }
                };
                Thread thread2 = new Thread(animator);
                thread2.start();
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        JComponent c = (JComponent)e.getSource();
        c.setCursor(this.cursor);
    }

    @Override
    public void mouseExited(MouseEvent e) {
        JComponent c = (JComponent)e.getSource();
        c.setCursor(Cursor.getPredefinedCursor(0));
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent arg0) {
    }
}

