/*
 * Decompiled with CFR 0.152.
 */
package jung.myalghoritm;

import edu.uci.ics.jung.graph.Graph;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jung.myalghoritm.MyShortestPath;
import org.apache.commons.collections15.Transformer;
import org.apache.log4j.Logger;

public class FloydWarshallShortestPath<V, E>
implements MyShortestPath<V, E> {
    private static final Logger log = Logger.getLogger(FloydWarshallShortestPath.class);
    protected PathMatrixNode<V, E>[][] pathMatrix;
    protected final Transformer<E, ? extends Number> transformer;
    protected final Graph<V, E> g;
    private final Map<V, Integer> verticeToInteger = new HashMap<V, Integer>();
    private final Map<Integer, V> integerToVertice = new HashMap<Integer, V>();

    public FloydWarshallShortestPath(Graph<V, E> g, Transformer<E, ? extends Number> transformer, boolean precomputePaths) {
        this.transformer = transformer;
        this.g = g;
        this.performFloydWarshall(precomputePaths);
    }

    protected void performFloydWarshall(boolean precomputePaths) {
        int i;
        ArrayList vertices = new ArrayList(this.g.getVertices());
        int size = vertices.size();
        log.debug("Floyd-Warshall algorithm starting on " + size + " vertices.");
        long start = System.currentTimeMillis();
        this.pathMatrix = new PathMatrixNode[size][size];
        for (i = 0; i < vertices.size(); ++i) {
            this.verticeToInteger.put((Integer)vertices.get(i), i);
            this.integerToVertice.put(i, vertices.get(i));
        }
        for (i = 0; i < size; ++i) {
            for (int j = 0; j < size; ++j) {
                this.pathMatrix[i][j] = new PathMatrixNode(i == j ? 0.0f : Float.POSITIVE_INFINITY);
            }
        }
        long initEnd = System.currentTimeMillis();
        log.debug("Floyd-Warshall init done in " + (initEnd - start) + " ms.");
        for (int i2 = 0; i2 < size; ++i2) {
            Object v = vertices.get(i2);
            for (E edge : this.g.getOutEdges(v)) {
                int index2 = this.verticeToInteger.get(this.g.getOpposite(v, edge));
                this.pathMatrix[i2][index2].setDistance(this.transformer.transform(edge).floatValue());
            }
        }
        long settingLengthsEnd = System.currentTimeMillis();
        log.debug("Floyd-Warshall setting lengths done in " + (settingLengthsEnd - initEnd) + " ms.");
        for (int k = 0; k < size; ++k) {
            for (int i3 = 0; i3 < size; ++i3) {
                for (int j = 0; j < size; ++j) {
                    float newLen = this.pathMatrix[i3][k].getDistance() + this.pathMatrix[k][j].getDistance();
                    if (!(this.pathMatrix[i3][j].getDistance() > newLen)) continue;
                    this.pathMatrix[i3][j].setDistance(newLen);
                    this.pathMatrix[i3][j].setViaNode(k);
                }
            }
        }
        long floydWarshallEnd = System.currentTimeMillis();
        log.debug("Floyd-Warshall floyd warshall core done in " + (floydWarshallEnd - settingLengthsEnd) + " ms.");
        if (precomputePaths) {
            int count = 0;
            for (int i4 = 0; i4 < size; ++i4) {
                for (int j = 0; j < size; ++j) {
                    if (this.pathMatrix[i4][j].getDistance() == Float.POSITIVE_INFINITY) {
                        log.trace("Unreachable path from " + vertices.get(i4) + " -> " + vertices.get(j));
                        ++count;
                        continue;
                    }
                    this.pathMatrix[i4][j].setPath(this.retrievePath(i4, j), this.g);
                }
            }
            log.info(this + ": There are " + count + " unreachable nav point pairs.");
            long constructsPathsEnd = System.currentTimeMillis();
            log.debug("Floyd-Warshall constructing paths done in " + (constructsPathsEnd - floydWarshallEnd) + " ms.");
        } else {
            log.info("Not precomputing paths. Paths will be constructed on the fly.");
        }
        long endTime = System.currentTimeMillis();
        log.info(this + ": computation for " + size + " navpoints took " + (endTime - start) + " millis");
    }

    private List<V> retrievePathInner(Integer from, Integer to) {
        PathMatrixNode<V, E> node = this.pathMatrix[from][to];
        if (node.getDistance() == Float.POSITIVE_INFINITY) {
            throw new RuntimeException("Unreachanable target path planning. (" + this.integerToVertice.get(from) + "," + this.integerToVertice.get(to) + ") " + node);
        }
        if (node.getViaNode() == null) {
            return new ArrayList(0);
        }
        ArrayList<V> path = new ArrayList<V>();
        path.addAll(this.retrievePathInner(from, node.getViaNode()));
        path.add(this.integerToVertice.get(node.getViaNode()));
        path.addAll(this.retrievePathInner(node.getViaNode(), to));
        return path;
    }

    private List<V> retrievePath(Integer from, Integer to) {
        ArrayList<V> path = new ArrayList<V>();
        path.add(this.integerToVertice.get(from));
        path.addAll(this.retrievePathInner(from, to));
        path.add(this.integerToVertice.get(to));
        return path;
    }

    protected PathMatrixNode getPathMatrixNode(V np1, V np2) {
        int j;
        int i = this.verticeToInteger.get(np1);
        if (((PathMatrixNode)this.pathMatrix[i][j = this.verticeToInteger.get(np2).intValue()]).path == null) {
            this.pathMatrix[i][j].setPath(this.retrievePath(i, j), this.g);
        }
        return this.pathMatrix[i][j];
    }

    public boolean reachable(V from, V to) {
        if (from == null || to == null) {
            return false;
        }
        return this.getPathMatrixNode(from, to).getDistance() != Float.POSITIVE_INFINITY;
    }

    public float getDistance(V from, V to) {
        if (from == null || to == null) {
            return Float.POSITIVE_INFINITY;
        }
        return this.getPathMatrixNode(from, to).getDistance();
    }

    public String toString() {
        return "FloydWarshallMap";
    }

    @Override
    public List<E> getPath(V source, V target) {
        if (source == null || target == null) {
            throw new InvalidParameterException("Source, nor target can be null!");
        }
        return this.getPathMatrixNode(source, target).getPath();
    }

    public class PathMatrixNode<Vv, Ee> {
        private float distance = Float.POSITIVE_INFINITY;
        private Integer viaNode = null;
        private List<Ee> path = null;

        public PathMatrixNode() {
        }

        public PathMatrixNode(float distance) {
            this.distance = distance;
        }

        public float getDistance() {
            return this.distance;
        }

        public void setDistance(float distance) {
            this.distance = distance;
        }

        public Integer getViaNode() {
            return this.viaNode;
        }

        public void setViaNode(Integer indice) {
            this.viaNode = indice;
        }

        public List<Ee> getPath() {
            return this.path;
        }

        public void setPath(List<Vv> path, Graph<Vv, Ee> g) {
            ArrayList<Ee> convertedPath = new ArrayList<Ee>(path.size() - 1);
            Vv fromV = path.get(0);
            for (int i = 1; i < path.size(); ++i) {
                Vv toV = path.get(i);
                Object e = g.findEdge(fromV, toV);
                convertedPath.add(e);
                fromV = toV;
            }
            this.path = convertedPath;
        }

        public String toString() {
            String navrat = "Node:" + FloydWarshallShortestPath.this.integerToVertice.get(this.viaNode);
            return navrat;
        }
    }
}

